@extends('layouts.app')
@section('style')
<link href="{{url('/assets/global/plugins/jstree/dist/themes/default/style.min.css')}}" rel="stylesheet" type="text/css" />

<style type="text/css">
    @media print{
        a[href]:after{
            content: none !important;
        }
    }
    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th, #main td {
        padding: 5px 0px 5px 0px;
    }


    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
        text-underline-position: under;
    }

    .modal-mask {
        position: fixed;
        z-index: 9998;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .5);
        display: table;
        transition: opacity .3s ease;
    }

    .modal-wrapper {
        display: table-cell;
        vertical-align: middle;
    }

    .modal-container {
        width: 80%;
        max-width: 90%;
        margin: 0px auto;
        padding: 20px 30px;
        background-color: #fff;
        border-radius: 2px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
        transition: all .3s ease;
        font-family: Helvetica, Arial, sans-serif;
    }

    .modal-header h3 {
        margin-top: 0;
        color: #42b983;
    }

    .modal-body {
        margin: 20px 0;
    }

    .modal-default-button {
        float: right;
    }

    .modal-enter {
        opacity: 0;
    }

    .modal-leave-active {
        opacity: 0;
    }

    .modal-enter .modal-container,
    .modal-leave-active .modal-container {
        -webkit-transform: scale(1.1);
        transform: scale(1.1);
    }



    ul, #treeUL {
      list-style-type: none;
    }
    
    #treeUL {
        margin: 0;
        padding: 0;
    }
  
    .rt1 {
        font-size: 20px;
        font-weight: bold;
        /* color: green; */
    }     
    
    .rt1a {
        font-size: 20px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: green; */
    }    
    .rt2 {
        font-size: 18px;
        font-weight: bold;
        /* color: purple; */
    }    
    .rt2a {
        font-size: 18px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: purple; */
    }    
    .rt3 {
        font-size: 16px;
        font-weight: bold;
        /* color: red; */
    }    
    
    .rt3a {
        font-size: 16px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: red; */
    }
    .rt4{
        font-size: 16px;
        text-align:{{(session()->get("system_direction") == "rtl")?"left":"right"}} ; 
        /* color: white; */
    }    
    .rt4n{
        font-size: 14px;
        font-weight: bold;
        
        text-align: {{(session()->get("system_direction") == "rtl")?"right":"left"}}; 
        /* color: white; */
    }

    .mparent{
    /* padding: 4px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 30px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }          
    
    .fchild{
    /* padding: 8px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 60px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }          
    
    .schild{
    /* padding: 12px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 85px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }  

    .tchild{
    /* padding: 12px !important; */
    padding: 2px !important;
    {{(session()->get("system_direction") == "rtl")?' padding-right':' padding-left'}}: 100px !important;
    text-align: {{(session()->get("system_direction") == "rtl")?'right':'left'}};
    }

    a{
        color: black;
    }  
    a:hover{
        /* color: white; */
        text-decoration: none;
    }
    .asset{
        
    }     
    .currentasset{
        
    } 

    .assetOther{
        
    }     
    .assetBank{
        
    }    
    .assetReceiv{
        
    }     
    
    .fixasset{
        
    }     
    .otherasset{
        
    }    
    .lib{
        
    }    
    
    .libPay{
        
    }    
    
    .equity{
        
    }

    hr {
        margin: 0px 0;
        border-top: 2px solid #eee;
    }

    /*
    li {
        font-size: 16px;
        color: crimson;
        font-weight: 500;
    }
    .rootTree::before {
        content: "\25B6";
        color: black;
        display: inline-block;
        margin-right: 6px;
    }
    .rootTree-down::before {
        transform: rotate(90deg);
    }
    .children {
        display: none;
    }
    .active {
        display: block;
    }   */


</style>
@stop
@section('content')


<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'blanceSheet1'" @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<!-- BEGIN EXAMPLE TABLE PORTLET-->
<div class="portlet light bordered">
    <div class="portlet-title hidden-print">
        <div class="caption font-dark">
            @lang('menu.BalanceSheet')
        </div>
        <div class="tools"> </div>
        <div class="btn-group pull-right hidden-print" style="display: flex; gap: 3px;">
            @permission(['balancesheet-list'])
            <a href="{{route('blanceSheet.index')}}">
                <button class="btn btn-success">
                    <i class="fa fa-file"></i> @lang('layout.Default')
                </button>
            </a>
            @endpermission

            @permission('balancesheet-export')
            <a onclick="window.print()" class="hidden-print btn btn-success">
                <i class="fa fa-print"></i>
            </a>
            <!-- <span id="anchore-modal">
                <button type="submit" @click.prevent="showModal" class="btn btn-success">
                    <i class="fa fa-print"></i>
                </button>
            </span> -->
            @endpermission
        </div>
    </div>
    <div class="portlet-body">
        <div class="hidden-print">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12" style="border: 1px solid rgba(198, 198, 198, 0.907);padding: 25px 25px 0px 25px;border-radius: 5px;margin-bottom: 10px;">
                <table style="width: 100%;" class="table table-striped  table-advance" style="width: 100%;">
                    <tr>
                        <td colspan="5" style="text-align: center; font-size:16px;font-weight:bold;color:black">
                            {!!company()['name']!!}
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5" style="text-align: center;">
                            @lang('menu.BalanceSheetByClass')
                        </td>
                    </tr>
                    <tr>
                        <td colspan="5" style="text-align: center;">
                            {{$date}}
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="row">
            <div>

            </div>
            <div style="border: 1px solid rgba(198, 198, 198, 0.907); padding: 25px;border-radius: 5px;">
                <ul id="treeUL">
                    <div class="asset">
                        <li>
                            <table style="width: 100%;" class="" id="main">
                                <tr style="background-color: rgb(207, 207, 207);">
                                    <td style="width: 25%;" class="rt1 text-center">@lang('layout.Account')</td> 
                                    @foreach($classes as $keyTi => $valueTi)
                                    <td class="rt1a doubleLine" style="width: {{$pers}}%;">{{$keyTi}}</td>
                                    @endforeach
                                    <td class="rt1a doubleLine" style="width: 20%;">@lang('layout.Total')</b></td>
                                </tr>

                            </table>
                        </li>
                        <li>
                            <table style="width: 100%;" id="main">
                                <tr>
                                    <td style="width: 50%;" class="rt1">@lang('layout.Assets') </td>
                                </tr>
                            </table>
                            <ul class="children">
                                <div class="currentasset">
                                    <li>
                                        <table style="width: 100%;" id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.CurrentAssets') </td>
                                            </tr>
                                        </table>

                                        <ul class="children">
                                            <div class="assetOther">
                                                <li>
                                                    <table style="width: 100%;" id="main" class="rt3">
                                                        <tr>
                                                            <td colspan="2">@lang('layout.OtherCurrentAssets') </td>
                                                        </tr>
                                                    </table>
                                                    <ul class="children">
                                                        <table style="width: 100%;" id="main" class=" main-table">
                                                            @foreach($otherCurrentAsset as $accountRow)
                                                            @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                            <tr>
                                                                <td class="mparent" style="width: 25%;">
                                                                    <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            <!-- begin first chiled -->
                                                            @if(!empty($accountRow['children']) && getShowSubAccount() != "false")
                                                            @foreach($accountRow['children'] as $key=>$fc)
                                                            @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                            <tr>
                                                                <td class="fchild" style="width: 25%;">
                                                                    <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($fc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            <!-- begin second chiled -->
                                                            @if(!empty($fc['children']))
                                                            @foreach($fc['children'] as $key1=>$sc)
                                                            @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                            <tr>
                                                                <td class="schild" style="width: 25%;">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($sc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            @endif
                                                            <!-- begin therd chiled -->
                                                            @if(!empty($sc['children']))
                                                            @foreach($sc['children'] as $key2=>$tc)
                                                            @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                            <tr>
                                                                <td class="tchild" style="width: 25%;">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($tc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            <!-- end therd child -->
                                                            @endforeach
                                                            @endif
                                                            <!-- end second child -->
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            <!-- end first chiled -->
                                                            @endif
                                                            @endforeach

                                                            <tr>
                                                                <td class="rt3" style="width: 25%;">
                                                                    @lang('layout.TotalOtherCurrentAssets') </td>
                                                                <?php $TotalOtherCurrentAsset = 0 ?>
                                                                @foreach($classes as $keyTOCA => $valueTOCA)
                                                                <?php $TotalOtherCurrentAsset += $valueTOCA['data']['TotalOtherCurrentAsset']; ?>
                                                                <td class="rt3a doubleLine" style="width: {{$pers}}%;">
                                                                    {{myRound($valueTOCA['data']['TotalOtherCurrentAsset'])}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                                @endforeach
                                                                <td class="rt3a doubleLine" style="width: 20%;">
                                                                    {{myRound($TotalOtherCurrentAsset)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                        </table>
                                                    </ul>
                                                </li>
                                                <hr>
                                            </div>
                                            <div class="assetBank">
                                                <li>
                                                    <table style="width: 100%;" id="main" class="rt3">
                                                        <tr>
                                                            <td colspan="2">@lang('layout.Checking/Savings') </td>
                                                        </tr>
                                                    </table>

                                                    <ul class="children">
                                                        <table style="width: 100%;" id="main" class=" main-table">
                                                            @foreach($banks as $accountRow)
                                                            @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                            <tr>
                                                                <td class="mparent" style="width: 25%;">
                                                                    <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            <!-- begin first chiled -->
                                                            @if(!empty($accountRow['children']) && getShowSubAccount()
                                                            != "false")
                                                            @foreach($accountRow['children'] as $key=>$fc)
                                                            @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                            <tr>
                                                                <td class="fchild" style="width: 25%;">
                                                                    <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($fc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            <!-- begin second chiled -->
                                                            @if(!empty($fc['children']))
                                                            @foreach($fc['children'] as $key1=>$sc)
                                                            @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                            <tr>
                                                                <td class="schild" style="width: 25%;">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($sc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            @endif
                                                            <!-- begin therd chiled -->
                                                            @if(!empty($sc['children']))
                                                            @foreach($sc['children'] as $key2=>$tc)
                                                            @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                            <tr>
                                                                <td class="tchild" style="width: 25%;">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($tc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            <!-- end therd child -->
                                                            @endforeach
                                                            @endif
                                                            <!-- end second child -->
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            <!-- end first chiled -->
                                                            @endif
                                                            @endforeach

                                                            <tr>
                                                                <td class="rt3" style="width: 25%;">
                                                                    @lang('layout.TotalChecking/Savings') </td>
                                                                <?php $TotalBanks = 0 ?>
                                                                @foreach($classes as $keyTB => $valueTB)
                                                                <?php $TotalBanks += $valueTB['data']['TotalBanks']; ?>
                                                                <td class="rt3a doubleLine" style="width: {{$pers}}%;">
                                                                    {{myRound($valueTB['data']['TotalBanks'])}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                                @endforeach
                                                                <td class="rt3a doubleLine" style="width: 20%;">
                                                                    {{myRound($TotalBanks)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                        </table>
                                                    </ul>
                                                </li>
                                                <hr>
                                            </div>
                                            <div class="assetReceiv">
                                                <li>
                                                    <table style="width: 100%;" id="main" class="rt3">
                                                        <tr>
                                                            <td colspan="2">@lang('layout.AccountsReceivable') </td>
                                                        </tr>
                                                    </table>
                                                    <ul class="children">
                                                        <table style="width: 100%;" id="main" class=" main-table">
                                                            @foreach($accountReceivable as $accountRow)
                                                            @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                            <tr>
                                                                <td class="mparent" style="width: 25%;">
                                                                    <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            <!-- begin first chiled -->
                                                            @if(!empty($accountRow['children']) && getShowSubAccount()
                                                            != "false")
                                                            @foreach($accountRow['children'] as $key=>$fc)
                                                            @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                            <tr>
                                                                <td class="fchild" style="width: 25%;">
                                                                    <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($fc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            <!-- begin second chiled -->
                                                            @if(!empty($fc['children']))
                                                            @foreach($fc['children'] as $key1=>$sc)
                                                            @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                            <tr>
                                                                <td class="schild" style="width: 25%;">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($sc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            @endif
                                                            <!-- begin therd chiled -->
                                                            @if(!empty($sc['children']))
                                                            @foreach($sc['children'] as $key2=>$tc)
                                                            @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                            <tr>
                                                                <td class="tchild" style="width: 25%;">
                                                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                    <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                    @endif
                                                                    @if(App::isLocale('en'))
                                                                    <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                    @endif
                                                                    <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                </td>
                                                                @php $amountRow = 0; @endphp
                                                                @foreach($tc['Amount'] as $keyA => $valueA)
                                                                @php $amountRow += $valueA['amount']; @endphp
                                                                <td class="rt4" style="width: {{$pers}}%;">
                                                                    {{myRound($valueA['amount'])}}</td>
                                                                @endforeach
                                                                <td class="rt4" style="width: 20%;">
                                                                    {{myRound($amountRow)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            <!-- end therd child -->
                                                            @endforeach
                                                            @endif
                                                            <!-- end second child -->
                                                            @endif
                                                            @endforeach
                                                            @endif
                                                            <!-- end first chiled -->
                                                            @endif
                                                            @endforeach

                                                            <tr>
                                                                <td class="rt3" style="width: 25%;">
                                                                    @lang('layout.TotalAccountsReceivable') </td>
                                                                <?php $TotalaccountReceivable = 0 ?>
                                                                @foreach($classes as $keyTB => $valueTB)
                                                                <?php $TotalaccountReceivable += $valueTB['data']['TotalaccountReceivable']; ?>
                                                                <td class="rt3a doubleLine" style="width: {{$pers}}%;">
                                                                    {{myRound($valueTB['data']['TotalaccountReceivable'])}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                                @endforeach
                                                                <td class="rt3a doubleLine" style="width: 20%;">
                                                                    {{myRound($TotalaccountReceivable)}}
                                                                    {{getHomeCurrency()['symbol']}}</td>
                                                            </tr>
                                                        </table>
                                                    </ul>
                                                </li>
                                                <hr>
                                            </div>
                                        </ul>
                                    </li>
                                    <hr>
                                    <li>
                                        <table style="width: 100%;" id="main">
                                            <tr>
                                                <td class="rt2" style="width: 25%;">@lang('layout.TotalCurrentAssets')
                                                </td>
                                                <?php $TotalCurrentAsset = 0 ?>
                                                @foreach($classes as $keyTCA => $valueTCA)
                                                <?php $TotalCurrentAsset += $valueTCA['data']['TotalCurrentAsset']; ?>
                                                <td class="rt2a doubleLine" style="width: {{$pers}}%;">
                                                    {{myRound($valueTCA['data']['TotalCurrentAsset'])}}
                                                    {{getHomeCurrency()['symbol']}}</td>
                                                @endforeach
                                                <td class="rt2a doubleLine" style="width: 20%;">
                                                    {{myRound($TotalCurrentAsset)}} {{getHomeCurrency()['symbol']}}</td>

                                            </tr>
                                        </table>
                                    </li>
                                </div>
                                <div class="fixasset">
                                    <li class="">
                                        <table style="width: 100%;" id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.FixAsset') </td>
                                            </tr>
                                        </table>
                                        <ul class="children">
                                            <table style="width: 100%;" id="main" class=" main-table">
                                                @foreach($fixedAssets as $accountRow)
                                                @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 25%;">
                                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount()
                                                != "false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 25%;">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($fc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($sc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($tc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach

                                                <tr>
                                                    <td class="rt2" style="width: 25%;">@lang('layout.TotalFixedAssets')
                                                    </td>
                                                    <?php $TotalfixedAssets = 0 ?>
                                                    @foreach($classes as $keyTFA => $valueTFA)
                                                    <?php $TotalfixedAssets += $valueTFA['data']['TotalfixedAssets']; ?>
                                                    <td class="rt2a doubleLine" style="width: {{$pers}}%;">
                                                        {{myRound($valueTFA['data']['TotalfixedAssets'])}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                    @endforeach
                                                    <td class="rt2a doubleLine" style="width: 20%;">
                                                        {{myRound($TotalfixedAssets)}} {{getHomeCurrency()['symbol']}} </td>
                                                </tr>
                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                </div>
                                <div class="otherasset">
                                    <li class="">
                                        <table style="width: 100%;" id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.OtherAssets') </td>
                                            </tr>
                                        </table>
                                        <ul class="children">
                                            <table style="width: 100%;" id="main" class=" main-table">
                                                
                                                @foreach($otherAssets as $accountRow)
                                                @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 25%;">
                                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount()
                                                != "false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 25%;">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($fc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($sc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($tc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach

                                                <tr>
                                                    <td class="rt2" style="width: 25%;">@lang('layout.TotalOtherAssets')
                                                    </td>
                                                    <?php $TotalotherAssets = 0 ?>
                                                    @foreach($classes as $keyTFA => $valueTFA)
                                                    <?php $TotalotherAssets += $valueTFA['data']['TotalotherAssets']; ?>
                                                    <td class="rt2a doubleLine" style="width: {{$pers}}%;">
                                                        {{myRound($valueTFA['data']['TotalotherAssets'])}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                    @endforeach
                                                    <td class="rt2a doubleLine" style="width: 20%;">
                                                        {{myRound($TotalotherAssets)}} {{getHomeCurrency()['symbol']}} </td>
                                                </tr>

                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                </div>
                            </ul>
                        </li>
                        <hr>
                        <li>
                            <table style="width: 100%;" id="main">
                                <tr>
                                    <td style="width: 25%;" class="rt1"> @lang('layout.TotalAssets')</td>
                                    <?php $totalAsset = 0 ?>
                                    @foreach($classes as $keyTA => $valueTA)
                                    <?php $totalAsset += $valueTA['data']['totalAsset']; ?>
                                    <td class="rt1a doubleLine" style="width: {{$pers}}%;">
                                        {{myRound($valueTA['data']['totalAsset'])}} {{getHomeCurrency()['symbol']}}</td>
                                    @endforeach
                                    <td class="rt1a doubleLine" style="width: 20%;">{{myRound($totalAsset)}}
                                        {{getHomeCurrency()['symbol']}}</td>
                                </tr>
                            </table>
                        </li>
                    </div>
                    <div class="lib">
                        <li>
                            <table style="width: 100%;" id="main" class="rt1">
                                <tr>
                                    <td colspan="2">@lang('layout.LiabilitiesAndEquity') </td>
                                </tr>
                            </table>

                            <ul class="children">
                                <div class="libPay">
                                    <li>
                                        <table style="width: 100%;" id="main" class=" rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.Liabilities') </td>
                                            </tr>
                                        </table>

                                        <ul class="children">
                                            <table style="width: 100%;" id="main" class=" main-table">
                                                @foreach($liability as $accountRow)
                                                @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 25%;">
                                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount()
                                                != "false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 25%;">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($fc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($sc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($tc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach

                                                <tr>
                                                    <td class="rt2" style="width: 25%;">@lang('layout.TotalLiabilities')
                                                    </td>
                                                    <?php $TotalLiability = 0 ?>
                                                    @foreach($classes as $keyTFA => $valueTFA)
                                                    <?php $TotalLiability += $valueTFA['data']['TotalLiability']; ?>
                                                    <td class="rt2a doubleLine" style="width: {{$pers}}%;">
                                                        {{myRound($valueTFA['data']['TotalLiability'])}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                    @endforeach
                                                    <td class="rt2a doubleLine" style="width: 20%;">
                                                        {{myRound($TotalLiability)}} {{getHomeCurrency()['symbol']}} </td>
                                                </tr>
                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                </div>
                            </ul>

                            <ul class="children">
                                <div class="equity">
                                    <li>
                                        <table style="width: 100%;" id="main" class="rt2">
                                            <tr>
                                                <td colspan="2">@lang('layout.Equity') </td>
                                            </tr>
                                        </table>
                                        <ul class="children">
                                            <table style="width: 100%;" id="main" class=" main-table">
                                                @foreach($equity as $accountRow)
                                                @if(!empty($accountRow['Amount']) || !empty($accountRow['children']))
                                                <tr>
                                                    <td class="mparent" style="width: 25%;">
                                                        <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($accountRow['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin first chiled -->
                                                @if(!empty($accountRow['children']) && getShowSubAccount()
                                                != "false")
                                                @foreach($accountRow['children'] as $key=>$fc)
                                                @if(!empty($fc['Amount']) || !empty($fc['children']))
                                                <tr>
                                                    <td class="fchild" style="width: 25%;">
                                                        <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($fc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                <!-- begin second chiled -->
                                                @if(!empty($fc['children']))
                                                @foreach($fc['children'] as $key1=>$sc)
                                                @if(!empty($sc['Amount']) || !empty($sc['children']))
                                                <tr>
                                                    <td class="schild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($sc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                <!-- begin therd chiled -->
                                                @if(!empty($sc['children']))
                                                @foreach($sc['children'] as $key2=>$tc)
                                                @if(!empty($tc['Amount']) || !empty($tc['children']))
                                                <tr>
                                                    <td class="tchild" style="width: 25%;">
                                                        @if(App::isLocale('fa') || App::isLocale('pa'))
                                                        <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                        @endif
                                                        @if(App::isLocale('en'))
                                                        <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                        @endif
                                                        <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                    </td>
                                                    @php $amountRow = 0; @endphp
                                                    @foreach($tc['Amount'] as $keyA => $valueA)
                                                    @php $amountRow += $valueA['amount']; @endphp
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueA['amount'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">
                                                        {{myRound($amountRow)}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                </tr>
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end therd child -->
                                                @endforeach
                                                @endif
                                                <!-- end second child -->
                                                @endif
                                                @endforeach
                                                @endif
                                                <!-- end first chiled -->
                                                @endif
                                                @endforeach

                                                <tr>
                                                    <td class="rt4n" style="width: 25%;">
                                                        @lang('layout.NetProfit/NetIncome')</td>
                                                    <?php $netProfit = 0 ?>
                                                    @foreach($classes as $keyTEQ => $valueTEQ)
                                                    <?php $netProfit += $valueTEQ['data']['netProfit']; ?>
                                                    <td class="rt4" style="width: {{$pers}}%;">
                                                        {{myRound($valueTEQ['data']['netProfit'])}}</td>
                                                    @endforeach
                                                    <td class="rt4" style="width: 20%;">{{myRound($netProfit)}}
                                                        {{getHomeCurrency()['symbol']}} </td>
                                                </tr>

                                                <tr>
                                                    <td class="rt2" style="width: 25%;">@lang('layout.TotalEquity') </td>
                                                    <?php $TotalEquities = 0 ?>
                                                    @foreach($classes as $keyTEQ => $valueTEQ)
                                                    <?php $TotalEquities += $valueTEQ['data']['TotalEquities']; ?>
                                                    <td class="rt2a doubleLine" style="width: {{$pers}}%;">
                                                        {{myRound($valueTEQ['data']['TotalEquities'])}}
                                                        {{getHomeCurrency()['symbol']}}</td>
                                                    @endforeach
                                                    <td class="rt2a doubleLine" style="width: 20%;">
                                                        {{myRound($TotalEquities)}} {{getHomeCurrency()['symbol']}} </td>
                                                </tr>

                                            </table>
                                        </ul>
                                    </li>
                                    <hr>
                                </div>

                            </ul>

                        </li>
                        <li>
                            <table style="width: 100%;" id="main">
                                <tr>
                                    <td class="rt1" style="width: 25%;">@lang('layout.TotalLibilities&Equity') </td>
                                    <?php $totalLiabilityAndEquity = 0 ?>
                                    @foreach($classes as $keyTEQ => $valueTEQ)
                                    <?php $totalLiabilityAndEquity += $valueTEQ['data']['totalLiabilityAndEquity']; ?>
                                    <td class="rt1a doubleLine" style="width: {{$pers}}%;">
                                        {{myRound($valueTEQ['data']['totalLiabilityAndEquity'])}}
                                        {{getHomeCurrency()['symbol']}}</td>
                                    @endforeach
                                    <td class="rt1a doubleLine" style="width: 20%;">
                                        {{myRound($totalLiabilityAndEquity)}} {{getHomeCurrency()['symbol']}} </td>

                                </tr>
                            </table>
                        </li>
                    </div>

                </ul>
            </div>
            <div>

            </div>
        </div>
    </div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->


@endsection
@include('groupCompanyFilter.select')
@include('print.modal')

@push('scripts')
<script src="{{url('/assets/pages/scripts/ui-tree.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/global/plugins/jstree/dist/jstree.min.js')}}" type="text/javascript"></script>




<script type="text/javascript">
    var toggler = document.querySelectorAll(".rootTree");
    Array.from(toggler).forEach(item => {
        item.addEventListener("click", () => {
            item.parentElement.querySelector(".children").classList.toggle("active");
            item.classList.toggle("rootTree-down");
        });
    });


    var vm = new Vue({
        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            items: null,


        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },

        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true
            }
        }
    });

    // start app
    Vue.component('v-select', VueSelect.VueSelect)

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload();
            }
        }
    });
</script>
@endpush