@extends('layouts.app')
@section('style')

    <style type="text/css">
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
        #main tr:hover {
            background-color: #ddd;
        }

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }

    </style>
@stop
@section('content')


<?php

$totalPayableAmount=0;
if ($totalPayableReport<0) {
    $totalReceivableReport+=ABS($totalPayableReport);
    $totalPayableAmount = ABS($totalPayableReport);
    $totalPayableReport = 0;
    
}

$totalReceivableAmount=0;
if ($totalReceivableReport<0) {

    $totalPayableReport+=ABS($totalReceivableReport);
    $totalReceivableAmount = ABS($totalReceivableReport);
    $totalReceivableReport = 0;
    // dd($totalReceivableAmount);


}
// dd($totalReceivableReport,$totalPayableReport);

?>


    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'blanceSheet'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">
                                    <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                    <span class="input-group-addon"> @lang('layout.To')</span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                </div>
                <div class="tools"> </div>
                <div class="btn-group pull-right">
                    @permission('build-export')
                        <span id="anchore-modal">
                            <button type="submit" @click.prevent="showModal" class="btn btn-success">
                                <i class="fa fa-print"></i>
                            </button>
                        </span>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table id="main" class="main-table">
                    <tr>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AccountName')</th>
                        <th>@lang('layout.AccountType')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>
                    <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Assets'):</th>
                    </tr>
                    @foreach($currentAsset as $currentAsset)
                        <tr>
                            <td></td>
                            <td><a href="{{url('/account/'.$currentAsset['id'])}}">{{$currentAsset->name}}</a></td>
                            <td>{{__('layout.'.ucfirst($currentAsset->type))}}</td>
                            <td>{{myRound($currentAsset->amount)}}</td>
                        </tr>
                    @endforeach
                    <tr title="{{__('message.ReceivableMessage')}}">
                        <td colspan="3"
                            style="background-color: green; color:white; font-size: 12px"> @lang('layout.TotalAR'):
                        </td>
                        <td style="background-color: green; color:white;">{{myRound($totalReceivableReport)}}</td>
                    </tr>
                    <tr>
                        <td colspan="3"
                            style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalCurrentAssets'):
                        </td>
                        <td style="background-color: #e8edff; color:#669;">{{myRound($TotalCurrentAsset)}}</td>
                    </tr>






                    @foreach($noneCurrentAsset as $noneCurrentAsset)
                        <tr>
                            <td></td>
                            <td><a href="{{url('/account/'.$noneCurrentAsset['id'])}}">{{$noneCurrentAsset->name}}</a></td>
                            <td>{{__('layout.'.ucfirst($noneCurrentAsset->type))}}</td>
                            <td>{{myRound($noneCurrentAsset->amount)}}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td colspan="3"
                            style="background-color: #e8edff; color:#669; font-size: 12px"> @lang('layout.TotalNoneCurrentAssets'):
                        </td>
                        <td style="background-color: #e8edff; color:#669">{{myRound($TotalNoneCurrentAsset)}}</td>
                    </tr>
                    <tr>
                        <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalAssets'):
                            {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
                        </th>
                        {{--<td style="background-color: #e8edff; color:#669;" class="doubleLine">{{myRound($totalAsset)}}</td>--}}

                        

                        @if($totalReceivableReport<0)
                        
                        <td style="background-color: blue; color:white;" class="doubleLine">{{myRound($totalAsset+$totalReceivableAmount)}}</td>
                       @elseif($totalPayableReport<0)
                       <td style="background-color: blue; color:white;" class="doubleLine">{{myRound($totalAsset+$totalPayableAmount)}}</td>
                       @else
                       <td style="background-color: blue; color:white;" class="doubleLine">{{myRound($totalAsset)}}</td>
                       @endif


                    </tr>
                    <tr>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AccountName')</th>
                        <th>@lang('layout.AccountType')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>
                    <tr>
                    <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Liabilities'):</th>
                    </tr>
                    @foreach($liability as $liability)
                        <tr>
                            <td></td>
                            <td><a href="{{url('/account/'.$liability['id'])}}">{{$liability->name}}</a></td>
                            <td>{{__('layout.'.ucfirst($liability->type))}}</td>
                            <td>{{myRound($liability->amount)}}</td>
                        </tr>
                    @endforeach
                    <tr title="{{__('message.PayableMessage')}}">
                        <th colspan="3"
                            style="background-color: green; color:white; font-size: 12px">@lang('layout.TotalAP'):
                        </th>
                        <td style="background-color: green; color:white;">{{myRound($totalPayableReport)}}</td>

                    </tr>
                    <tr>
                        <th colspan="3"
                            style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalLiabilities'):
                            {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
                        </th>
                        <td style="background-color: #e8edff; color:#669;">{{myRound($TotalLiability)}}</td>

                    </tr>    


                    <tr>
                        <th colspan="4" style="background-color: #e8edff; color:#669;">@lang('layout.Equity'):</th>
                    </tr>
                    @foreach($equity as $equities)
                        <tr>
                            <td></td>
                            <td><a href="{{url('/account/'.$equities['id'])}}">{{$equities->name}}</a></td>
                            <td>{{__('layout.'.ucfirst($equities->type))}}</td>
                            <td>{{myRound($equities->amount)}}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td>@lang('layout.NetProfit/NetIncome')</td>
                        <td></td>
                        <td></td>
                        <td>{{myRound($netProfit)}}</td>
                    </tr>
                    <tr>
                        <th colspan="3" style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalEquity'):
                            {{-- <span style="margin-left: 90%;">{{$TotalEquities}}</span> --}}
                        </th>
                        <td style="background-color: #e8edff; color:#669;">{{myRound($TotalEquities)}}</td>

                    </tr>
                    <tr>
                        <th colspan="3"
                            style="background-color: #e8edff; color:#669; font-size: 12px">@lang('layout.TotalLibilities&Equity'):
                            {{-- <span style="margin-left: 90%;">{{$totalLiabilityAndEquity}}</span> --}}
                        </th>
                        {{--<td style="background-color: #e8edff; color:#669;"
                            class="doubleLine">{{myRound($totalLiabilityAndEquity)}}</td>--}}


                        @if($totalReceivableReport<0)
                        <td style="background-color: blue; color:white;"
                            class="doubleLine">{{myRound($totalLiabilityAndEquity+$totalReceivableAmount)}}</td>
                       @elseif($totalPayableReport<0)
                       <td style="background-color: blue; color:white;"
                            class="doubleLine">{{myRound($totalLiabilityAndEquity+$totalPayableAmount)}}</td>
                        @else
                         <td style="background-color: blue; color:white;"
                            class="doubleLine">{{myRound($totalLiabilityAndEquity)}}</td>
                       @endif


                      




                    </tr>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- BEGIN TAB PORTLET-->
    <!-- BEGIN TAB PORTLET-->
    <div class=" pull-right">


    </div>
    <br>
    <br>





@endsection
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script type="text/javascript">

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>
@endpush