@extends('layouts.app')
@section('style')
<link href="{{url('/assets/global/plugins/jstree/dist/themes/default/style.min.css')}}" rel="stylesheet" type="text/css" />

    <style type="text/css">
        @media print{
            a[href]:after{
                content: none !important;
            }
        }
        #main {
            font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        #main th, #main td {
            /* border: 1px solid #ddd; */
            padding: 8px;
            
            {{(session()->get("system_direction") == "rtl")?"padding-left: 20px":"padding-right:20px"}}
        }

        /* #main tr:hover {
            background-color: #ddd;
        } */

        #main th {
            padding-top: 12px;
            padding-bottom: 12px;

            background-color: #768585;
            color: white;
        }

        .doubleLine {
            text-decoration-line: underline;
            text-decoration-style: double;
            text-underline-position: under;
        }

        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-container {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }



    ul, #treeUL {
      list-style-type: none;
    }
    
    #treeUL {
        margin: 0;
        padding: 0;
    }
  
    .rt1 {
        font-size: 20px;
        font-weight: bold;
        /* color: green; */
    }     
    
    .rt1a {
        font-size: 20px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: green; */
    }    
    .rt2 {
        font-size: 18px;
        font-weight: bold;
        /* color: purple; */
    }    
    .rt2a {
        font-size: 18px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: purple; */
    }    
    .rt3 {
        font-size: 16px;
        font-weight: bold;
        /* color: red; */
    }    
    
    .rt3a {
        font-size: 16px;
        font-weight: bold;
        text-align: {{(session()->get("system_direction") == "rtl")?"left":"right"}}; 
        /* color: red; */
    }
    .rt4{
        font-size: 14px;
        font-weight: bold;
        text-align:{{(session()->get("system_direction") == "rtl")?"left":"right"}} ; 
        /* color: white; */
    }    
    .rt4n{
        font-size: 14px;
        font-weight: bold;
        
        text-align: {{(session()->get("system_direction") == "rtl")?"right":"left"}}; 
        /* color: white; */
    }
    a{
        color: black;
    }  
    a:hover{
        /* color: white; */
        text-decoration: none;
    }
    .asset{
        background-color: #eaefec;
        /* color: white; */
    }     
    .currentasset{
        background-color: #eaefec;
        /* color: white; */
    } 

    .assetOther{
        background-color: #eaefec;
        /* color: white; */
    }     
    .assetBank{
        background-color: #eaefec;
        /* color: white; */
    }    
    .assetReceiv{
        background-color: #eaefec;
        /* color: white; */
    }     
    
    .fixasset{
        background-color: #eaefec;
        /* color: white; */
    }     
    .otherasset{
        background-color: #eaefec;
        /* color: white; */
    }    
    .lib{
        background-color: #eaefec;
        /* color: white; */
    }    
    
    .libPay{
        background-color: #eaefec;
        /* color: white; */
    }    
    
    .equity{
        background-color: #eaefec;
        /* color: white; */
    }

    hr {
        margin: 0px 0;
        border-top: 2px solid #eee;
    }

    /*
    li {
        font-size: 16px;
        color: crimson;
        font-weight: 500;
    }
    .rootTree::before {
        content: "\25B6";
        color: black;
        display: inline-block;
        margin-right: 6px;
    }
    .rootTree-down::before {
        transform: rotate(90deg);
    }
    .children {
        display: none;
    }
    .active {
        display: block;
    }   */


    </style>
@stop
@section('content')

<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'blanceSheet1'"
        @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <input type="hidden" name="style_type" value="2">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.Date')</label>
                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                            <option value="CustomDates">@lang('type.CustomDates')</option>
                            <option value="Today">@lang('type.Today')</option>
                            <option value="Yesterday">@lang('type.Yesterday')</option>
                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                            <option value="LastWeek">@lang('type.LastWeek')</option>
                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                            <option value="ThisYear">@lang('type.ThisYear')</option>
                            <option value="YearToDate">@lang('type.YearToDate')</option>
                        </select>
                    </div>
                    <div class="col-md-12" v-show="period == 'CustomDates'">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off"
                                    v-model="from_date" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off"
                                    v-model="to_date" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                @lang('menu.BalanceSheet')
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right hidden-print">
                @permission(['balancesheet-list'])
                <a href="{{route('blanceSheet.index')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-file"></i> @lang('layout.Default')
                    </button>
                </a>
                <a href="{{route('blanceSheet1.index')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-file"></i> @lang('layout.BalanceSheet1')
                    </button>
                </a>
                @endpermission

                @permission('balancesheet-export')
                <span id="anchore-modal">
                    <button type="submit" @click.prevent="showModal" class="btn btn-success">
                        <i class="fa fa-print"></i>
                    </button>
                </span>
                @endpermission



            </div>
        </div>
        <div class="portlet-body">
            <div class="hidden-print">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
            </div>
            <div style="border: 1px solid rgba(85, 85, 85, 0.169);padding: 33px 0px;border-radius: 5px;">
                <div class="row" style="display: flex;justify-content: center;margin-bottom: 5px;">
                
                    <div class="col-lg-4 col-md-3" style="border: 1px solid black; background-color:#18181a; font-weight:bold;font-size:16px; color:white">
                        @lang('layout.TotalAssets')  {{myRound($totalAsset)}} {{getHomeCurrency()['symbol']}}
                    </div>
                    <div class="col-lg-3 col-md-2" style="border: 1px solid black; background-color:#18181a;text-align:center; font-weight:bold;font-size:16px; color:white">
                        =
                    </div>
                    <div class="col-lg-4 col-md-3" style="border: 1px solid black; background-color:#18181a; font-weight:bold;font-size:16px; color:white">
                        @lang('layout.TotalLibilities&Equity')  {{myRound($totalLiabilityAndEquity)}} {{getHomeCurrency()['symbol']}}
                    </div>
    
                </div>
                <div class="row" style="display: flex; justify-content: center;">
                    <div class="col-lg-11 col-md-12" style="border: 1px solid rgba(85, 85, 85, 0.169); background-color:#eaefec">
                        <ul id="treeUL">
                            <div class="asset">
                                <li>
                                    <table id="main" class="rt1">
                                        <tr>
                                            <td colspan="2" class="text-center">@lang('layout.Assets') </td>
                                        </tr>
                                    </table>
    
                                    <ul class="children">
                                        <div class="currentasset">
                                            <li>
                                                <table id="main" class="rt2">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.CurrentAssets') </td>
                                                    </tr>
                                                </table>
    
                                                <ul class="children">
                                                    <div class="assetOther">
                                                        <li>
                                                            <table id="main" class="rt3">
                                                                <tr>
                                                                    <td colspan="2">@lang('layout.OtherCurrentAssets') </td>
                                                                </tr>
                                                            </table>
                                                            <ul class="children">
                                                                <table id="main" class=" main-table">
                                                                    @foreach($otherCurrentAsset as $accountRow)
                                                                    @if($accountRow['Amount'] != 0 ||
                                                                    !empty($accountRow['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            <a
                                                                                href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                        </td>
                                                                        {{-- <td>
                                                                            {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                                        </td> --}}
                                                                        <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                            @if(!empty($accountRow['children']))
                                                                            <br>@lang('layout.Total')
                                                                            {{$accountRow['AccountName']}}
                                                                            :{{myRound($accountRow['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin first chiled -->
                                                                    @if(!empty($accountRow['children']) &&
                                                                    getShowSubAccount() !="false")
                                                                    @foreach($accountRow['children'] as $key=>$fc)
                                                                    @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            <b>{{$key+1}}</b> <a
                                                                                href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($fc['Amount']) }}
                                                                            @if(!empty($fc['children']))
                                                                            <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                            :{{myRound($fc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin second chiled -->
                                                                    @if(!empty($fc['children']))
                                                                    @foreach($fc['children'] as $key1=>$sc)
                                                                    @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                            <b>{{$key1+1}}-{{$key+1}}</b>
                                                                            @endif
                                                                            @if(App::isLocale('en'))
                                                                            <b>{{$key+1}}-{{$key1+1}}</b>
                                                                            @endif
                                                                            <a
                                                                                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                            <br>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($sc['Amount']) }}
                                                                            @if(!empty($sc['children']))
                                                                            <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                            :{{myRound($sc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin therd chiled -->
                                                                    @if(!empty($sc['children']))
                                                                    @foreach($sc['children'] as $key2=>$tc)
                                                                    @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                            @endif
                                                                            @if(App::isLocale('en'))
                                                                            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                            @endif
                                                                            <a
                                                                                href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                            <br>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($tc['Amount']) }}
                                                                            @if(!empty($tc['children']))
                                                                            <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                            :{{myRound($tc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end therd child -->
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end second child -->
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end first chiled -->
                                                                    @endforeach
                                                                </table>
                                                            </ul>
                                                        </li>
                                                        <hr>
                                                        <li>
                                                            <table id="main">
                                                                <tr>
                                                                    <td class="rt3">@lang('layout.TotalOtherCurrentAssets')
                                                                    </td>
                                                                    <td class="rt3a doubleLine">
                                                                        {{myRound($TotalOtherCurrentAsset)}}
                                                                        {{getHomeCurrency()['symbol']}}</td>
    
    
                                                                </tr>
                                                            </table>
                                                        </li>
                                                    </div>
                                                    <div class="assetBank">
                                                        <li>
                                                            <table id="main" class="rt3">
                                                                <tr>
                                                                    <td colspan="2">@lang('layout.Checking/Savings') </td>
                                                                </tr>
                                                            </table>
    
                                                            <ul class="children">
                                                                <table id="main" class=" main-table">
                                                                    @foreach($banks as $accountRow)
                                                                    @if($accountRow['Amount'] != 0 ||
                                                                    !empty($accountRow['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            <a
                                                                                href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                        </td>
                                                                        {{-- <td>
                                                                            {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                                        </td> --}}
                                                                        <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                            @if(!empty($accountRow['children']))
                                                                            <br>@lang('layout.Total')
                                                                            {{$accountRow['AccountName']}}
                                                                            :{{myRound($accountRow['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin first chiled -->
                                                                    @if(!empty($accountRow['children']) &&
                                                                    getShowSubAccount() !="false")
                                                                    @foreach($accountRow['children'] as $key=>$fc)
                                                                    @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            <b>{{$key+1}}</b> <a
                                                                                href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($fc['Amount']) }}
                                                                            @if(!empty($fc['children']))
                                                                            <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                            :{{myRound($fc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin second chiled -->
                                                                    @if(!empty($fc['children']))
                                                                    @foreach($fc['children'] as $key1=>$sc)
                                                                    @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                            <b>{{$key1+1}}-{{$key+1}}</b>
                                                                            @endif
                                                                            @if(App::isLocale('en'))
                                                                            <b>{{$key+1}}-{{$key1+1}}</b>
                                                                            @endif
                                                                            <a
                                                                                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                            <br>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($sc['Amount']) }}
                                                                            @if(!empty($sc['children']))
                                                                            <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                            :{{myRound($sc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin therd chiled -->
                                                                    @if(!empty($sc['children']))
                                                                    @foreach($sc['children'] as $key2=>$tc)
                                                                    @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                            @endif
                                                                            @if(App::isLocale('en'))
                                                                            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                            @endif
                                                                            <a
                                                                                href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                            <br>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($tc['Amount']) }}
                                                                            @if(!empty($tc['children']))
                                                                            <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                            :{{myRound($tc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end therd child -->
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end second child -->
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end first chiled -->
                                                                    @endforeach
                                                                </table>
                                                            </ul>
                                                        </li>
                                                        <hr>
                                                        <li>
                                                            <table id="main">
                                                                <tr>
                                                                    <td class="rt3">@lang('layout.TotalChecking/Savings')
                                                                    </td>
                                                                    <td class="rt3a doubleLine">{{myRound($TotalBanks)}}
                                                                        {{getHomeCurrency()['symbol']}}</td>
                                                                </tr>
                                                            </table>
                                                        </li>
                                                    </div>
                                                    <div class="assetReceiv">
    
                                                        <li>
                                                            <table id="main" class="rt3">
                                                                <tr>
                                                                    <td colspan="2">@lang('layout.AccountsReceivable') </td>
                                                                </tr>
                                                            </table>
                                                            <ul class="children">
                                                                <table id="main" class=" main-table">
                                                                    @foreach($accountReceivable as $accountRow)
                                                                    @if($accountRow['Amount'] != 0 ||
                                                                    !empty($accountRow['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            <a
                                                                                href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                                        </td>
                                                                        {{-- <td>
                                                                            {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                                        </td> --}}
                                                                        <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                            @if(!empty($accountRow['children']))
                                                                            <br>@lang('layout.Total')
                                                                            {{$accountRow['AccountName']}}
                                                                            :{{myRound($accountRow['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin first chiled -->
                                                                    @if(!empty($accountRow['children']) &&
                                                                    getShowSubAccount() !="false")
                                                                    @foreach($accountRow['children'] as $key=>$fc)
                                                                    @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            <b>{{$key+1}}</b> <a
                                                                                href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($fc['Amount']) }}
                                                                            @if(!empty($fc['children']))
                                                                            <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                            :{{myRound($fc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin second chiled -->
                                                                    @if(!empty($fc['children']))
                                                                    @foreach($fc['children'] as $key1=>$sc)
                                                                    @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                            <b>{{$key1+1}}-{{$key+1}}</b>
                                                                            @endif
                                                                            @if(App::isLocale('en'))
                                                                            <b>{{$key+1}}-{{$key1+1}}</b>
                                                                            @endif
                                                                            <a
                                                                                href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                            <br>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($sc['Amount']) }}
                                                                            @if(!empty($sc['children']))
                                                                            <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                            :{{myRound($sc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    <!-- begin therd chiled -->
                                                                    @if(!empty($sc['children']))
                                                                    @foreach($sc['children'] as $key2=>$tc)
                                                                    @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                                    <tr>
                                                                        <td class="rt4n">
                                                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                            <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                            @endif
                                                                            @if(App::isLocale('en'))
                                                                            <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                            @endif
                                                                            <a
                                                                                href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                            <br>
                                                                        </td>
                                                                        {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                                        --}}
                                                                        <td class="rt4">{{myRound($tc['Amount']) }}
                                                                            @if(!empty($tc['children']))
                                                                            <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                            :{{myRound($tc['total'])}}
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    @endif
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end therd child -->
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end second child -->
                                                                    @endforeach
                                                                    @endif
                                                                    <!-- end first chiled -->
                                                                    @endforeach
                                                                </table>
                                                            </ul>
                                                        </li>
                                                        <hr>
                                                        <li>
                                                            <table id="main">
                                                                <tr>
                                                                    <td class="rt3">@lang('layout.TotalAccountsReceivable')
                                                                    </td>
                                                                    <td class="rt3a doubleLine">
                                                                        {{myRound($TotalaccountReceivable)}}
                                                                        {{getHomeCurrency()['symbol']}}</td>
    
    
                                                                </tr>
                                                            </table>
                                                        </li>
                                                    </div>
                                                </ul>
                                            </li>
                                            <hr>
                                            <li>
                                                <table id="main">
                                                    <tr>
                                                        <td class="rt2">@lang('layout.TotalCurrentAssets') </td>
                                                        <td class="rt2a doubleLine">{{myRound($TotalCurrentAsset)}}</td>
    
    
                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                        <div class="fixasset">
                                            <li class="">
                                                <table id="main" class="rt2">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.FixAsset') </td>
                                                    </tr>
                                                </table>
                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($fixedAssets as $accountRow)
                                                        @if($accountRow['Amount'] != 0 ||
                                                        !empty($accountRow['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                <a
                                                                    href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>
                                                                {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                            </td> --}}
                                                            <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                @if(!empty($accountRow['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$accountRow['AccountName']}}
                                                                :{{myRound($accountRow['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin first chiled -->
                                                        @if(!empty($accountRow['children']) &&
                                                        getShowSubAccount() !="false")
                                                        @foreach($accountRow['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end first chiled -->
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <hr>
                                            <li>
                                                <table id="main">
                                                    <tr>
                                                        <td class="rt2">@lang('layout.TotalFixedAssets') </td>
                                                        <td class="rt2a doubleLine">{{myRound($TotalfixedAssets)}}
                                                            {{getHomeCurrency()['symbol']}}</td>
    
    
                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                        <div class="otherasset">
                                            <li class="">
                                                <table id="main" class="rt2">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.OtherAssets') </td>
                                                    </tr>
                                                </table>
                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($otherAssets as $accountRow)
                                                        @if($accountRow['Amount'] != 0 ||
                                                        !empty($accountRow['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                <a
                                                                    href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>
                                                                {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                            </td> --}}
                                                            <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                @if(!empty($accountRow['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$accountRow['AccountName']}}
                                                                :{{myRound($accountRow['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin first chiled -->
                                                        @if(!empty($accountRow['children']) &&
                                                        getShowSubAccount() !="false")
                                                        @foreach($accountRow['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end first chiled -->
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <hr>
                                            <li>
                                                <table id="main">
                                                    <tr>
                                                        <td class="rt2">@lang('layout.TotalOtherAssets') </td>
                                                        <td class="rt2a doubleLine">{{myRound($TotalotherAssets)}}
                                                            {{getHomeCurrency()['symbol']}}</td>
    
    
                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
                                    </ul>
                                </li>
                                <hr>
                                <li>
                                    <table id="main">
                                        <tr>
                                            <td class="rt1">@lang('layout.TotalAssets') </td>
                                            <td class="rt1a doubleLine">{{myRound($totalAsset)}}
                                                {{getHomeCurrency()['symbol']}}</td>
    
    
                                        </tr>
                                    </table>
                                </li>
                            </div>
                            <div class="lib">
                                <li>
                                    <table id="main" class="rt1">
                                        <tr>
                                            <td colspan="2">@lang('layout.LiabilitiesAndEquity') </td>
                                        </tr>
                                    </table>
    
                                    <ul class="children">
                                        <div class="libPay">
                                            <li>
                                                <table id="main" class=" rt2">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.Liabilities') </td>
                                                    </tr>
                                                </table>
    
                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($liability as $accountRow)
                                                        @if($accountRow['Amount'] != 0 ||
                                                        !empty($accountRow['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                <a
                                                                    href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>
                                                                {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                            </td> --}}
                                                            <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                @if(!empty($accountRow['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$accountRow['AccountName']}}
                                                                :{{myRound($accountRow['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin first chiled -->
                                                        @if(!empty($accountRow['children']) &&
                                                        getShowSubAccount() !="false")
                                                        @foreach($accountRow['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end first chiled -->
                                                        @endforeach
                                                    </table>
                                                </ul>
                                            </li>
                                            <hr>
                                            <li>
                                                <table id="main">
                                                    <tr>
                                                        <td class="rt2">@lang('layout.TotalLiabilities') </td>
                                                        <td class="rt2a doubleLine">{{myRound($TotalLiability)}}
                                                            {{getHomeCurrency()['symbol']}}</td>
    
    
                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
    
    
                                    </ul>
    
                                    <ul class="children">
                                        <div class="equity">
                                            <li>
                                                <table id="main" class="rt2">
                                                    <tr>
                                                        <td colspan="2">@lang('layout.Equity') </td>
                                                    </tr>
                                                </table>
                                                <ul class="children">
                                                    <table id="main" class=" main-table">
                                                        @foreach($equity as $accountRow)
                                                        @if($accountRow['Amount'] != 0 ||
                                                        !empty($accountRow['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                <a
                                                                    href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>
                                                                {{__('layout.'.ucfirst($accountRow['Type']))}}
                                                            </td> --}}
                                                            <td class="rt4">{{myRound($accountRow['Amount']) }}
                                                                @if(!empty($accountRow['children']))
                                                                <br>@lang('layout.Total')
                                                                {{$accountRow['AccountName']}}
                                                                :{{myRound($accountRow['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin first chiled -->
                                                        @if(!empty($accountRow['children']) &&
                                                        getShowSubAccount() !="false")
                                                        @foreach($accountRow['children'] as $key=>$fc)
                                                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                                                        <tr>
                                                            <td class="rt4n">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                <b>{{$key+1}}</b> <a
                                                                    href="{{url('/account/'.$fc['id'])}}">{{$fc['AccountName']}}</a>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($fc['Amount']) }}
                                                                @if(!empty($fc['children']))
                                                                <br>@lang('layout.Total') {{$fc['AccountName']}}
                                                                :{{myRound($fc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin second chiled -->
                                                        @if(!empty($fc['children']))
                                                        @foreach($fc['children'] as $key1=>$sc)
                                                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($sc['Amount']) }}
                                                                @if(!empty($sc['children']))
                                                                <br>@lang('layout.Total') {{$sc['AccountName']}}
                                                                :{{myRound($sc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <!-- begin therd chiled -->
                                                        @if(!empty($sc['children']))
                                                        @foreach($sc['children'] as $key2=>$tc)
                                                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                                                        <tr>
                                                            <td class="rt4n">
                                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                                                @endif
                                                                @if(App::isLocale('en'))
                                                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                                                @endif
                                                                <a
                                                                    href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                                                <br>
                                                            </td>
                                                            {{-- <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                                                            --}}
                                                            <td class="rt4">{{myRound($tc['Amount']) }}
                                                                @if(!empty($tc['children']))
                                                                <br>@lang('layout.Total') {{$tc['AccountName']}}
                                                                :{{myRound($tc['total'])}}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @endforeach
                                                        @endif
                                                        <!-- end therd child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end second child -->
                                                        @endforeach
                                                        @endif
                                                        <!-- end first chiled -->
                                                        @endforeach
                                                        <tr>
                                                            <td class="rt4n">@lang('layout.NetProfit/NetIncome')</td>
                                                            <td class="rt4">{{myRound($netProfit)}}
                                                                {{getHomeCurrency()['symbol']}}</td>
                                                        </tr>
                                                    </table>
                                                </ul>
                                            </li>
                                            <hr>
                                            <li>
                                                <table id="main">
                                                    <tr>
                                                        <td class="rt2">@lang('layout.TotalEquity') </td>
                                                        <td class="rt2a doubleLine">{{myRound($TotalEquities)}}
                                                            {{getHomeCurrency()['symbol']}}</td>
    
    
    
                                                    </tr>
                                                </table>
                                            </li>
                                        </div>
    
    
                                    </ul>
    
                                    <!--  -->
    
    
                                </li>
                                <li>
                                    <table id="main">
                                        <tr>
                                            <td class="rt1">@lang('layout.TotalLibilities&Equity') </td>
                                            <td class="rt1a doubleLine">{{myRound($totalLiabilityAndEquity)}}
                                                {{getHomeCurrency()['symbol']}}</td>
    
    
    
                                        </tr>
                                    </table>
                                </li>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- <div class="row">
        <div class="col-md-6">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-social-dribbble font-blue-sharp"></i>
                        <span class="caption-subject font-blue-sharp bold uppercase">Default Tree</span>
                    </div>
                    <div class="actions">
                        <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
                            <i class="icon-cloud-upload"></i>
                        </a>
                        <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
                            <i class="icon-wrench"></i>
                        </a>
                        <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
                            <i class="icon-trash"></i>
                        </a>
                    </div>
                </div>
                <div class="portlet-body">
                    <div id="tree_1" class="tree-demo jstree jstree-1 jstree-default" role="tree" aria-multiselectable="true" tabindex="0" aria-activedescendant="j1_8" aria-busy="false">
                        <ul class="jstree-container-ul jstree-children" role="group">
                            <li role="treeitem" aria-selected="false" aria-level="1" aria-labelledby="j1_1_anchor" aria-expanded="true" id="j1_1" class="jstree-node jstree-open">
                                <i class="jstree-icon jstree-ocl" role="presentation">

                                </i>
                                <a class="jstree-anchor" href="#" tabindex="-1" id="j1_1_anchor">
                                    <i class="jstree-icon jstree-themeicon fa fa-folder icon-state-warning icon-lg jstree-themeicon-custom" role="presentation">

                                    </i> Root node 1
                                </a>
                                <ul role="group" class="jstree-children" style="">
                                    <li role="treeitem" data-jstree="{ &quot;selected&quot; : true }" aria-selected="true" aria-level="2" aria-labelledby="j1_2_anchor" id="j1_2" class="jstree-node  jstree-leaf">
                                        <i class="jstree-icon jstree-ocl" role="presentation">

                                        </i>
                                        <a class="jstree-anchor  jstree-clicked" href="javascript:;" tabindex="-1" id="j1_2_anchor">
                                            <i class="jstree-icon jstree-themeicon fa fa-folder icon-state-warning icon-lg jstree-themeicon-custom" role="presentation">

                                            </i>
                                                Initially selected 
                                            </a>
                                        </li>
                                        <li role="treeitem" data-jstree="{ &quot;icon&quot; : &quot;fa fa-briefcase icon-state-success &quot; }" aria-selected="false" aria-level="2" aria-labelledby="j1_3_anchor" id="j1_3" class="jstree-node  jstree-leaf">
                                            <i class="jstree-icon jstree-ocl" role="presentation">

                                            </i>
                                            <a class="jstree-anchor" href="#" tabindex="-1" id="j1_3_anchor">
                                                <i class="jstree-icon jstree-themeicon fa fa-briefcase icon-state-success  jstree-themeicon-custom" role="presentation">

                                                </i>
                                                    custom icon URL 
                                                </a>
                                            </li>
                                            <li role="treeitem" data-jstree="{ &quot;opened&quot; : true }" aria-selected="false" aria-level="2" aria-labelledby="j1_4_anchor" aria-expanded="true" id="j1_4" class="jstree-node jstree-open">
                                                <i class="jstree-icon jstree-ocl" role="presentation">

                                                </i>
                                                <a class="jstree-anchor" href="#" tabindex="-1" id="j1_4_anchor">
                                                    <i class="jstree-icon jstree-themeicon fa fa-folder icon-state-warning icon-lg jstree-themeicon-custom" role="presentation">

                                                    </i> initially open
                                        </a>
                                        <ul role="group" class="jstree-children" style="">
                                            <li role="treeitem" data-jstree="{ &quot;disabled&quot; : true }" aria-selected="false" aria-level="3" aria-labelledby="j1_5_anchor" aria-disabled="true" id="j1_5" class="jstree-node  jstree-leaf">
                                                <i class="jstree-icon jstree-ocl" role="presentation">

                                                </i>
                                                <a class="jstree-anchor  jstree-disabled" href="#" tabindex="-1" id="j1_5_anchor">
                                                    <i class="jstree-icon jstree-themeicon fa fa-folder icon-state-warning icon-lg jstree-themeicon-custom" role="presentation">

                                                    </i> 
                                                    Disabled Node
                                                    </a>
                                                </li>
                                                <li role="treeitem" data-jstree="{ &quot;type&quot; : &quot;file&quot; }" aria-selected="false" aria-level="3" aria-labelledby="j1_6_anchor" id="j1_6" class="jstree-node  jstree-leaf jstree-last">
                                                    <i class="jstree-icon jstree-ocl" role="presentation">

                                                    </i>
                                                    <a class="jstree-anchor" href="#" tabindex="-1" id="j1_6_anchor">
                                                        <i class="jstree-icon jstree-themeicon fa fa-file icon-state-warning icon-lg jstree-themeicon-custom" role="presentation">

                                                        </i>
                                                            Another node
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </li>
                                                <li role="treeitem" data-jstree="{ &quot;icon&quot; : &quot;fa fa-warning icon-state-danger&quot; }" aria-selected="false" aria-level="2" aria-labelledby="j1_7_anchor" id="j1_7" class="jstree-node  jstree-leaf jstree-last">
                                                    <i class="jstree-icon jstree-ocl" role="presentation">

                                                    </i>
                                                    <a class="jstree-anchor" href="#" tabindex="-1" id="j1_7_anchor">
                                                        <i class="jstree-icon jstree-themeicon fa fa-warning icon-state-danger jstree-themeicon-custom" role="presentation">

                                                        </i> 
                                                        Custom icon class (bootstrap) 
                                                    </a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li role="treeitem" data-jstree="{ &quot;type&quot; : &quot;file&quot; }" aria-selected="false" aria-level="1" aria-labelledby="j1_8_anchor" id="j1_8" class="jstree-node  jstree-leaf jstree-last">
                                            <i class="jstree-icon jstree-ocl" role="presentation">

                                            </i>
                                            <a class="jstree-anchor" href="http://www.jstree.com" tabindex="-1" id="j1_8_anchor"><i class="jstree-icon jstree-themeicon fa fa-file icon-state-warning icon-lg jstree-themeicon-custom" role="presentation">

                                            </i>
                                                Clickanle link node
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                </div>
            </div>
        </div>
        
    </div> -->


<!-- BEGIN TAB PORTLET-->
<!-- BEGIN TAB PORTLET-->
<div class=" pull-right">


</div>
<br>
<br>







@endsection
@include('groupCompanyFilter.select')
@include('print.modal')

@push('scripts')
<script src="{{url('/assets/pages/scripts/ui-tree.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/global/plugins/jstree/dist/jstree.min.js')}}" type="text/javascript"></script>

<script type="text/javascript">
    var toggler = document.querySelectorAll(".rootTree");
            Array.from(toggler).forEach(item => {
                item.addEventListener("click", () => {
                    item.parentElement .querySelector(".children") .classList.toggle("active");
                    item.classList.toggle("rootTree-down");
                });
            });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

</script>
@endpush