@extends('layouts.app')
@section('style')

<style type="text/css">
    @media print {
        a[href]:after {
            content: none !important;
        }
    }

    #main {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #main th,
    #main td {
        border: 1px solid #ddd;
        padding: 0px 8px;
    }

    /*#main tr:nth-child(even){background-color: #f2f2f2;}*/
    #main tr:hover {
        /* background-color: #ddd; */
    }

    #main th {
        /* padding-top: 12px;
        padding-bottom: 12px; */

        background-color: #768585;
        color: white;
    }

    .doubleLine {
        text-decoration-line: underline;
        text-decoration-style: double;
        text-underline-position: under;
    }
    
    .modal-mask {
        position: fixed;
        z-index: 9998;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .5);
        display: table;
        transition: opacity .3s ease;
    }

    .modal-wrapper {
        display: table-cell;
        vertical-align: middle;
    }

    .modal-container {
        width: 80%;
        max-width: 90%;
        margin: 0px auto;
        padding: 20px 30px;
        background-color: #fff;
        border-radius: 2px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
        transition: all .3s ease;
        font-family: Helvetica, Arial, sans-serif;
    }

    .modal-header h3 {
        margin-top: 0;
        color: #42b983;
    }

    .modal-body {
        margin: 20px 0;
    }

    .modal-default-button {
        float: right;
    }

    .modal-enter {
        opacity: 0;
    }

    .modal-leave-active {
        opacity: 0;
    }

    .modal-enter .modal-container,
    .modal-leave-active .modal-container {
        -webkit-transform: scale(1.1);
        transform: scale(1.1);
    }

    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }

    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }

    .report_a_title {
        color: #393a3d;
    }

    a.report_a_title:hover {
        color: #393a3d;
        text-decoration: none;
    }
    .table-advance {
        text-align: center !important;
    }
    .firstCard{
        border: 1px solid rgba(189, 189, 189, 0.169);
        display: flex;
        flex-direction: column;
        align-items: center; 
        justify-content: center;
        padding: 5px 0px;
        border-radius: 10px;
        background: rgba(189, 189, 189, 0.169);
        outline: none;
        transition: .5s;
        margin-bottom: 0px;
    }
    .firstCard:hover{
        background: transparent;
        scale: 1.03;
        border: 1px solid rgba(170, 170, 170, 0.203);
    }
    a{
        color: #000;
        font-size: 14px;
        font-weight: normal;
        padding: 0px 25px 0px 0px;
    }
    a:hover{
        color: #000;
        text-decoration: none;
    }
</style>
@stop
@section('content')

<div id="print-modal" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'blanceSheet'"
        @closed="closeModal">
        <div slot="body">
            <div class="row">
                <input type="hidden" name="first_style" value="{{$first_style}}">
                <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.Date')</label>
                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                            <option value="CustomDates">@lang('type.CustomDates')</option>
                            <option value="Today">@lang('type.Today')</option>
                            <option value="Yesterday">@lang('type.Yesterday')</option>
                            <option value="ThisWeek">@lang('type.ThisWeek')</option>
                            <option value="LastWeek">@lang('type.LastWeek')</option>
                            <option value="WeekToDate">@lang('type.WeekToDate')</option>
                            <option value="ThisMonth">@lang('type.ThisMonth')</option>
                            <option value="MonthToDate">@lang('type.MonthToDate')</option>
                            <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                            <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                            <option value="ThisYear">@lang('type.ThisYear')</option>
                            <option value="YearToDate">@lang('type.YearToDate')</option>
                        </select>
                    </div>
                    <div class="col-md-12" v-show="period == 'CustomDates'">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" autocomplete="off"
                                    v-model="from_date" name="from_date">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <span class="input-group-addon"> @lang('layout.To')</span>
                                <input class="form-control date" id="range-to-example" autocomplete="off"
                                    v-model="to_date" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<div id="date_model" v-cloak>
    {{Form::open(['route' => 'blanceSheet.DateComparison','method' => 'Get','class' => 'inline'])}}
    <button id="show-modal-date" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.FirstDate')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                    autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                    autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.SecondDate')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date1" autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date1" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>

<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                @lang('menu.BalanceSheet') &nbsp;&nbsp;
                {{-- <span class="text-primary">(
                    <i class="fa fa-money"></i> &nbsp;
                    <b> {{getHomeCurrency()['name']}}) </b>
                </span> --}}
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right hidden-print">
                @permission('balancesheet-export')
                <span id="anchore-modal">
                    <button type="submit" @click.prevent="showModal" class="btn btn-success">
                        <i class="fa fa-print"></i>
                    </button>
                </span>
                @endpermission

            </div>
        </div>
        <div class="row">
            <div id="tab_6" class="tab-pane active">
                <div id="accordion1" class="panel-group">
                    <div class="panel panel-default">
                        @permission(['balancesheet-list'])
                            <div class="panel-body">
                                <a href="{{route('blanceSheet1.index')}}" class="report_a_title" style="padding: 0px !important;">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <div class="firstCard">
                                            <div>
                                                <span style="font-size: 16px;">@lang('layout.BalanceSheet1')</span>
                                            </div>
                                            <div style="margin-top: 1em;">
                                                {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                            </div>
                                        </div>
                                        {{-- <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BalanceSheet1')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table> --}}
                                    </div>
                                </a>
                                <a href="{{route('blanceSheet2.index')}}" class="report_a_title" style="padding: 0px !important;">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <div class="firstCard">
                                            <div>
                                                <span style="font-size: 16px;">@lang('layout.BalanceSheet2')</span>
                                            </div>
                                            <div style="margin-top: 1em;">
                                                {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                            </div>
                                        </div>
                                        {{-- <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BalanceSheet2')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table> --}}
                                    </div>
                                </a>
                                <a href="{{route('blanceSheet3.index')}}" class="report_a_title" style="padding: 0px !important;">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <div class="firstCard">
                                            <div>
                                                <span style="font-size: 16px;">@lang('layout.BalanceSheet3')</span>
                                            </div>
                                            <div style="margin-top: 1em;">
                                                {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                            </div>
                                        </div>

                                        {{-- <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BalanceSheet3')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table> --}}
                                    </div>
                                </a>
                                <a id="select_date_report" class="report_a_title" style="padding: 0px !important;">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <div class="firstCard">
                                            <div>
                                                <span style="font-size: 16px;">@lang('layout.BSheetYTDComparison')</span>
                                            </div>
                                            <div style="margin-top: 1em;">
                                                {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                            </div>
                                        </div>

                                        {{-- <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BSheetYTDComparison')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table> --}}
                                    </div>
                                </a>
                                @if(systemConfig()[24] == 1)
                                <a href="{{route('blanceSheet.ClassComparison')}}" class="report_a_title" style="padding: 0px !important;">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <div class="firstCard">
                                            <div>
                                                <span style="font-size: 16px;">@lang('layout.BSheetByClass')</span>
                                            </div>
                                            <div style="margin-top: 1em;">
                                                {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                            </div>
                                        </div>

                                        {{-- <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BSheetByClass')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table> --}}
                                    </div>
                                </a>
                                @endif
                                <a href="{{route('blanceSheet.YearComparison')}}" class="report_a_title" style="padding: 0px !important;">
                                    <div class="col-md-2 col-sm-12 col-xs-12">
                                        <div class="firstCard">
                                            <div>
                                                <span style="font-size: 16px;">@lang('layout.BSheetByPrevYearComparison')</span>
                                            </div>
                                            <div style="margin-top: 1em;">
                                                {{-- <i class="fa fa-file-text-o" style="font-size: 38px;"></i> --}}
                                                <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                            </div>
                                        </div>

                                        {{-- <table class="table table-striped table-bordered table-advance ">
                                            <tr>
                                                <td class="t_head" style="font-weight: bold;">
                                                    @lang('layout.BSheetByPrevYearComparison')
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="t_body">
                                                    <i class="fa fa-file-text-o" style="font-size: 38px;"></i>
                                                    <img src="{{asset('menu_img/balance-sheet.png')}}" style="height: 70px; width:70px">
                                                </td>
                                            </tr>
                                        </table> --}}
                                    </div>
                                </a>
                            </div>
                        @endpermission
                    </div>
                </div>
            </div>
        </div>

        <div class="portlet-body">
            <div class="hidden-print">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
            </div>
            <div class="row">
                <div class="col-lg-1 col-md-1">     
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <table id="main" class="main-table">
                        
                        <tr style="background: rgba(82, 82, 82, 0.169);">
                            {{-- <th class="text-center" style="background: rgba(82, 82, 82, 0.169);color: #000000;">@lang('layout.Category')</th> --}}
                            <th style="background: rgba(82, 82, 82, 0.169);color: #000000;font-weight: bolder;font-size: 20px;">@lang('layout.AccountName')</th>
                            <th style="background: rgba(82, 82, 82, 0.169);color: #000000;font-weight: bolder;font-size: 20px;">@lang('layout.AccountType')</th>
                            <th style="background: rgba(82, 82, 82, 0.169);color: #000000;font-weight: bolder;font-size: 20px;">@lang('layout.Amount') {{ getHomeCurrency()['code'] }} </th>
                        </tr>
                        <tr>
                            <th colspan="3" style="background-color: rgba(189, 189, 189, 0.169); color:#000;font-size: 25px; font-weight: bolder;">@lang('layout.Assets')</th>
                        </tr>
                        @foreach($currentAsset as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: black; font-size: 16px;">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            <td>{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #000; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                    style="color: #000">{{$fc['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                            <td>{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #000; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a style="color: #000;"
                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                            <td>{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                            <td>{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach
                        @if($totalReceivableReport > 0)
                        <tr>
                            <th colspan="2" style="background-color: #9eda9e96; color:#000000; font-size: 25px; font-weight: bolder;"> 
                                @lang('layout.TotalAR')
                            </th>
                            <th style="background-color: #9eda9e96; color:#000;">{{myRound($totalReceivableReport)}}</th>
                        </tr>
                        @endif
                        <tr>
                            <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#000; font-size: 25px; font-weight: bolder;">
                                @lang('layout.TotalCurrentAssets')
                            </th>
                            <th style="background-color: rgba(189, 189, 189, 0.169); color:#000;">{{myRound($TotalCurrentAsset)}}</th>
                        </tr>

                        @foreach($noneCurrentAsset as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #29B4B6; font-size: 20px">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            <td>{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #29B4B6; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                    style="color: #29B4B6">{{$fc['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                            <td>{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a style="color: #8e29b6;"
                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                            <td>{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                            <td>{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach

                        <tr style="background: rgba(189, 189, 189, 0.169);">
                            <td colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#000; font-size: 20px; font-weight: bolder;">
                                @lang('layout.TotalNoneCurrentAssets')
                            </td>
                            <td style="background-color: rgba(189, 189, 189, 0.169); color:#000">{{myRound($TotalNoneCurrentAsset)}}</td>
                        </tr>
                        <tr>
                            <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#000; font-size: 25px; font-weight: bolder;">
                                @lang('layout.TotalAssets')
                                {{-- <span style="margin-left: 78.5%;font-size: 15px">{{$totalAsset}}</span> --}}
                            </th>
                            <td style="background-color: rgba(189, 189, 189, 0.169); color:#000;" class="doubleLine">
                                {{myRound($totalAsset)}}
                                {{-- <br>
                                <span style="display: flex;flex-direction: column;justify-content: space-around;">
                                    <span class="doubleUnderLine" style="border: 1px solid black;margin-bottom: 1px;width: 50%;"></span>
                                    <span class="doubleUnderLine" style="border: 1px solid black;width: 50%;"></span>
                                </span> --}}
                            </td>
                        </tr>
                        <tr style="background: rgba(82, 82, 82, 0.169);">
                            {{-- <th style="background: rgba(82, 82, 82, 0.169);color: #000;" class="text-center">@lang('layout.Category')</th> --}}
                            <th style="background: rgba(82, 82, 82, 0.169);color: #000; font-size: 20px;">@lang('layout.AccountName')</th>
                            <th style="background: rgba(82, 82, 82, 0.169);color: #000; font-size: 20px;">@lang('layout.AccountType')</th>
                            <th style="background: rgba(82, 82, 82, 0.169);color: #000; font-size: 20px;">@lang('layout.Amount')</th>
                        </tr>
                        <tr>
                            <th colspan="3" style="background-color: rgba(189, 189, 189, 0.169); color:#000;font-size: 25px; font-weight: bolder;">@lang('layout.Liabilities')
                            </th>
                        </tr>
                        <tr>
                        

                        @foreach($liability as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #29B4B6; font-size: 20px">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            <td>{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #29B4B6; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                    style="color: #29B4B6">{{$fc['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                            <td>{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a style="color: #8e29b6;"
                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                            <td>{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                            <td>{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach

                        @if($totalPayableReport > 0)
                        <tr>
                            <th colspan="2" style="background-color: #9eda9e96; color:#000000; font-size: 25px; font-weight: bolder;">
                                @lang('layout.TotalAP'):
                            </th>
                            <td style="background-color: #9eda9e96; color:#669;">{{myRound($totalPayableReport)}}</td>
    
                        </tr>
                        @endif
                        <tr>
                            <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#000; font-size: 25px; font-weight: bolder;">
                                @lang('layout.TotalLiabilities')
                                {{-- <span style="margin-left: 70%;">{{$TotalLiability}}</span> --}}
                            </th>
                            <td style="background-color: rgba(189, 189, 189, 0.169); color:#000;">{{myRound($TotalLiability)}}</td>

                        </tr>


                        <tr style="background: rgba(189, 189, 189, 0.169);">
                            <th colspan="3" style="background-color: rgba(189, 189, 189, 0.169); color:#000;font-size: 25px; font-weight: bolder;">@lang('layout.Equity')</th>
                        </tr>

                        @foreach($equity as $accountRow)
                        @if($accountRow['Amount'] != 0 || !empty($accountRow['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #29B4B6; font-size: 20px">
                                <a href="{{url('/account/'.$accountRow['id'])}}">{{$accountRow['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($accountRow['Type']))}}</td>
                            <td>{{myRound($accountRow['Amount']) }}
                                @if(!empty($accountRow['children']))
                                <br>@lang('layout.Total') {{$accountRow['AccountName']}}
                                :{{myRound($accountRow['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin first chiled -->
                        @if(!empty($accountRow['children']) && getShowSubAccount() !="false")
                        @foreach($accountRow['children'] as $key=>$fc)
                        @if($fc['Amount'] != 0 || !empty($fc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #29B4B6; font-size: 17px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                <b>{{$key+1}}</b> <a href="{{url('/account/'.$fc['id'])}}"
                                    style="color: #29B4B6">{{$fc['AccountName']}}</a>
                            </td>
                            <td>{{__('layout.'.ucfirst($fc['Type']))}}</td>
                            <td>{{myRound($fc['Amount']) }}
                                @if(!empty($fc['children']))
                                <br>@lang('layout.Total') {{$fc['AccountName']}} :{{myRound($fc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin second chiled -->
                        @if(!empty($fc['children']))
                        @foreach($fc['children'] as $key1=>$sc)
                        @if($sc['Amount'] != 0 || !empty($sc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td style="color: #8e29b6; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}</b>
                                @endif
                                <a style="color: #8e29b6;"
                                    href="{{url('/account/'.$sc['id'])}}">{{$sc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($sc['Type']))}}</td>
                            <td>{{myRound($sc['Amount']) }}
                                @if(!empty($sc['children']))
                                <br>@lang('layout.Total') {{$sc['AccountName']}} :{{myRound($sc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        <!-- begin therd chiled -->
                        @if(!empty($sc['children']))
                        @foreach($sc['children'] as $key2=>$tc)
                        @if($tc['Amount'] != 0 || !empty($tc['children']))
                        <tr>
                            {{-- <td></td> --}}
                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                <b>{{$key2+1}}-{{$key1+1}}-{{$key+1}}</b>
                                @endif
                                @if(App::isLocale('en'))
                                <b>{{$key+1}}-{{$key1+1}}-{{$key2+1}}</b>
                                @endif
                                <a href="{{url('/account/'.$tc['id'])}}">{{$tc['AccountName']}}</a>
                                <br>
                            </td>
                            <td>{{__('layout.'.ucfirst($tc['Type']))}}</td>
                            <td>{{myRound($tc['Amount']) }}
                                @if(!empty($tc['children']))
                                <br>@lang('layout.Total') {{$tc['AccountName']}} :{{myRound($tc['total'])}}
                                @endif
                            </td>
                        </tr>
                        @endif
                        @endforeach
                        @endif
                        <!-- end therd child -->
                        @endforeach
                        @endif
                        <!-- end second child -->
                        @endforeach
                        @endif
                        <!-- end first chiled -->
                        @endforeach

                        @if(systemConfig()[29] == 1)
                        <tr>
                            <td style="font-size: 20px; font-weight: bolder;">@lang('layout.ChangeRateProfit')</td>
                            <td></td>
                            {{-- <td></td> --}}
                            <td>{{myRound($TodayNetProfit)}}</td>
                        </tr>
                        @endif
                        <tr>
                            <td style="font-size: 20px; font-weight: bolder;">@lang('layout.NetProfit/NetIncome')</td>
                            <td></td>
                            {{-- <td></td> --}}
                            <td>{{myRound($netProfit)}}</td>
                        </tr>
                        <tr>
                            <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color: black; font-size: 25px; font-weight: bolder;">
                                @lang('layout.TotalEquity')
                                {{-- <span style="margin-left: 90%;">{{$TotalEquities}}</span> --}}
                            </th>
                            <td style="background-color: rgba(189, 189, 189, 0.169); color: black;">{{myRound($TotalEquities)}}</td>

                        </tr>
                        <tr>
                            <th colspan="2" style="background-color: rgba(189, 189, 189, 0.169); color:#000; font-size: 25px; font-weight: bolder;">
                                @lang('layout.TotalLibilities&Equity')
                                {{-- <span style="margin-left: 90%;">{{$totalLiabilityAndEquity}}</span> --}}
                            </th>
                            <td style="background-color: rgba(189, 189, 189, 0.169); color:#000;" class="doubleLine">
                                {{myRound($totalLiabilityAndEquity)}}
                                {{-- <br>
                                <span style="display: flex;flex-direction: column;justify-content: space-around;">
                                    <span class="doubleUnderLine" style="border: 1px solid black;margin-bottom: 1px;width: 50%;"></span>
                                    <span class="doubleUnderLine" style="border: 1px solid black;width: 50%;"></span>
                                </span> --}}
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-lg-1 col-md-1"></div>
            </div>

        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- BEGIN TAB PORTLET-->
<!-- BEGIN TAB PORTLET-->
<div class=" pull-right">


</div>
<br>
<br>

@endsection
@include('groupCompanyFilter.select')
@include('print.modal')
@include('invoices.modal')
@push('scripts')
<script type="text/javascript">
    var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                items: null,


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        // start app
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start date_model
        new Vue({
            el: '#date_model',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });

        $('#select_date_report').on('click', function (e) {
            $('#show-modal-date').click();
            e.preventDefault();
        });

</script>
@endpush