@extends('layouts.factor-master')
@section('style')
<style>
  .t1 {
    font-size: 14px;
    font-weight: bold;

  }
</style>
@stop
@section('content')
<!--Table 2 For Customer Information-->
<h3 class="table-caption" style="text-align: center;margin-bottom: -0px;"><b>@lang('layout.BillInvoice')</b></h3>
<table style="width: 100%;  border:1px solid">
  <tr>
    <td class="t1">@lang('layout.VendorCode'): &nbsp;&nbsp;{{$info->member_code}}</td>
    <td class="t1">@lang('layout.BillNumber'):&nbsp;&nbsp;{{$info->number}}</td>
  </tr>
  @if($purchase_order_info)  
  <tr>
    <td class="t1">@lang('layout.PONumber'): &nbsp;&nbsp;{{$purchase_order_info->number}}</td>
    <td class="t1"></td>
  </tr>
  @endif
  <tr>
    <td class="t1">@lang('layout.VendorName'): &nbsp;&nbsp;{{$info->vendor}}</td>
    <?php
    $str_date = convertdate($info->dateFactor);
    $date_string = substr($str_date, 0, 10);
    ?>
    <td class="t1">@lang('layout.Date'):&nbsp;&nbsp;
      @if(getInvoiceDateFormat() == "shamsi")
      <?php
      $str_date = convertdate($info->dateFactor, 0, 'jalali');
      $date_string = substr($str_date, 0, 10)
      ?>
      {{$date_string}}
      @elseif(getInvoiceDateFormat() =='both')
      <?php
      $str_date = convertdate($info->dateFactor, 0, 'jalali');
      $date_string = substr($str_date, 0, 10);
      echo $date_string;
      ?>
      &nbsp;/&nbsp;
      {{substr($info->dateFactor,0,10)}}
      @elseif(getInvoiceDateFormat() =="meladi")
      {{substr($info->dateFactor,0,10)}}
      @else
      {{$str_date}}
      @endif
    </td>
  </tr>
  <tr>
    <td class="t1">@lang('layout.Address'): &nbsp;&nbsp;{{$info->member_address.' '.$info->member_city}}</td>
    <td class="t1">@lang('layout.Hour'): &nbsp;&nbsp;<?php echo Date('h:i A', strtotime($info->dateFactor)); ?></td>
  </tr>
  <tr>
    <td class="t1">@lang('layout.Phone'): &nbsp;&nbsp;{{$info->member_phone}}</td>
    <td class="t1">@lang('layout.User'): &nbsp;&nbsp;{{$username}}</td>
  </tr>
</table>
<!--End Table 2 For Invoice Information-->
<!--Table 3 For Data  Information-->
<table class="main-table" style="margin-top: 5px;" cellpadding="5px">
  <tr style="font-weight: bold; font-size: 17px">
    <td class="mt center">
      <div class="center">@lang('layout.Number')</div>
    </td>
    <td class="mt center">
      <div class="center">@lang('layout.Item')</div>
    </td>
    @if(getInventoryBrand()=="true")
    <td class="mt center">
      <div class="center">@lang('layout.Brand')</div>
    </td>
    @endif
    @if(getOtherMeasure()=="true")
    <td class="mt center">
      <div class="center">@lang('layout.OtherMeasure')</div>
    </td>
    @endif
    @if(getOtherMeasure2()=="true")
    <td class="mt center">
      <div class="center">@lang('layout.OtherMeasure2')</div>
    </td>
    @endif
    <td class="mt center">
      <div class="center">@lang('layout.Quantity')</div>
    </td>
    <td class="mt center">
      <div class="center">@lang('layout.Unit/M')</div>
    </td>
    @if(getM2()!="")
    @if(getFactorMeasure2()=="true")
    <td class="mt center">
      <div class="center">@lang('layout.Measure2')</div>
    </td>
    @endif
    @endif
    <td class="mt center">
      <div class="center">@lang('layout.PurchaseCost')</div>
    </td>
    <td class="mt center">
      <div class="center">@lang('layout.Total')</div>
    </td>
  </tr>
  <?php
  $totalQty = 0;
  $measure_total = [];
  $count = 0;
  $empty = 0;
  $fullCount = count($data);
  if ($fullCount < 15) {
    $empty = 15 - $fullCount;
  }
  ?>
  @foreach($data AS $key1=>$record)
  <?php
  //Total Items
  if (array_key_exists($record['purchaseMeasure'], $measure_total)) {
    $measure_total[$record['purchaseMeasure']] = $measure_total[$record['purchaseMeasure']] + $record['qty'];
  } else {
    $measure_total[$record['purchaseMeasure']] = $record['qty'];
  }
  $totalQty += $record['qty'];
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record['items']}}</td>
    @if(getInventoryBrand()=="true")
    <td class="center">{{$record['inventoryBrand']}}</td>
    @endif
    @if(getOtherMeasure()=="true")
    <td class="center">{{$record['other_measure']}}</td>
    @endif
    @if(getOtherMeasure2()=="true")
    <td class="center">{{$record['other_measure2']}}</td>
    @endif
    <td class="center">{{$record['qty']}}</td>
    <td class="center">{{$record['purchaseMeasure']}}</td>
    @if(getM2()!="")
    @if(getFactorMeasure2()=="true")
    <td class="center">{{$record['qty1']}}</td>
    @endif
    @endif
    <td class="center">{{myRound($record['price'])}}</td>
    <td class="center">{{myRound($record['Total'])}} @lang('currency.'.($info->currency))</td>
  </tr>
  @endforeach
</table>
<!--Begin Total Item Quantity-->
@if(getTotalItemQuantity()!='' ||getTotalItemQuantity()!="defualt")
@if(getTotalItemQuantity() == "per_unit")
<table class="main-table">
  <tr>
    <td align="right" colspan="2"><b>@lang('layout.TotalQuantity')</b></td>
  </tr>
  @foreach($measure_total AS $key=>$measure)
  <tr>
    <td align="right"><b>{{$measure}}</b></td>
    <td align="right"><b>{{$key}}</b></td>
  </tr>
  @endforeach
</table>
@endif
@if(getTotalItemQuantity() == "all_unit")
<table class="main-table">
  <tr>
    <td align="right"><b>@lang('layout.TotalQuantity')</b></td>
    <td align="right"><b>{{$totalQty}}</b></td>
  </tr>
</table>
@endif
@endif
<!--End Total Item Quantity-->
<!--Table 4 For Total  Information-->
<table class="main-table" style="margin-top: 4px;" cellpadding="5px">
  <tr>
    <td colspan="5">
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters'):&nbsp; {{notowo(abs(round($total)),'fa')}} @lang('currency.'.($purchase->currency))</b></div>
    </td>
    <td colspan="3">
      <div class="center" style="font-size: bold;"><b>@lang('layout.Total'):&nbsp; {{myRound($total)}} @lang('currency.'.($purchase->currency))<br>
        </b></div>
    </td>
  </tr>
  <tr>
    <td colspan="3">
      <div>@lang('layout.Discount'):&nbsp;
        <span>
          @if($purchase->discount_type=="currency")
          {{round(($discountToShow))}} @lang('currency.'.($purchase->currency))
          @else
          {{round($discount)}}
          <span>%</span>
          ({{round(($discountToShow))}} @lang('currency.'.($purchase->currency)))
          @endif
        </span>
      </div>
    </td>
    @if($info->type != 'WriteCheck')
    <td colspan="3">
      <div>@lang('layout.Payment'):&nbsp;
        {{ simpleRound($paid)}} @lang('currency.'.($purchase->currency))
      </div>
    </td>
    <td colspan="2">
      <div>@lang('layout.Remined'):&nbsp; {{myRound($remaind)}} @lang('currency.'.($purchase->currency))
      </div>
    </td>
    @endif
    @if($info->type == 'WriteCheck')
    <td colspan="2">
      <div> </div>
    </td>
    <td colspan="3">
      <div>@lang('layout.AmountPayable'):&nbsp; {{myRound($remaind)}} @lang('currency.'.($purchase->currency))
      </div>
    </td>
    @endif
  </tr>
  <tr>
    <!-------------------- ----------------------------------------------------------------------------------
    ---------------Begin Hesab Sabeqah-----------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------->
    @if($purchase->type == "Bill")
    @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null)
    <td colspan="5">
      @if(getHesabSabeqa() =='true')
      <b>
        <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
          @if($purchase->type == "Bill")
          {{myRound($balance - ($total/$purchase->rate) + (($discountToShow+$paid)/$purchase->rate))}} {{getHomeCurrency()["code"]}}
          @endif
        </div>
      </b>
    </td>
    <td colspan="3">
      <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
          @if($purchase->type == "Bill")
          @if(systemConfig()[30] == 1)
          {{myRound(((($balance * $purchase->static_rate / $purchase->rate)-$total+$discountToShow)+$paid)+($total - ($discountToShow)-$paid))}} @lang('currency.'.($purchase->currency))
          @else 
          {{myRound(((($balance * $purchase->rate)-$total+$discountToShow)+$paid)+($total - ($discountToShow)-$paid))}} @lang('currency.'.($purchase->currency))
          @endif
          @endif
        </b></div>
    </td>
    @endif
    @endif
    @endif
    @if($purchase->type == "Bill")
    @if(getHesabSabeqahType()=="currency")
    <td colspan="5">
      @if(getHesabSabeqa() =='true')
      <b>
        <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
          @if($purchase->type == "Bill")
          {{myRound(($balance-$total+$discountToShow)+$paid)}} @lang('currency.'.($purchase->currency))
          @endif
        </div>
      </b>
    </td>
    <td colspan="3">
      <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
          @if($purchase->type == "Bill")
          {{myRound((($balance-$total+$discountToShow)+$paid)+($total - ($discountToShow)-$paid))}} @lang('currency.'.($purchase->currency))
          @endif
        </b></div>
    </td>
    @endif
    @endif
    @endif
    <!-------------------- ----------------------------------------------------------------------------------
    ---------------End  Hesab Sabeqah-----------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------->
  </tr>
  <tr>
    <td colspan="8">
      <div class="center"><b>@lang('layout.Description')</b><br>
        <?php
        $des = wordwrap($purchase->description, 100, "<br/>\n", false);
        echo $des;
        ?>
      </div>
    </td>
  </tr>
</table>
@if(getDriverInfo()=="true")
@if(getFactorDriverInfo()=="true")
<!--Driver Info-->
@if(systemConfig()[7] == 0)
<table style="width: 100%; margin-top: 10px;">
  <tr>
    <td style="text-align: left; width:40%">
      <table class="main-table">
        <tr style="font-weight: bold; font-size: 17px">
          <td align="right"><b>@lang('layout.TransferCode')</b></td>
          <td align="right"><b>{{$info->transferCode}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.Transporter_name')</b></td>
          <td align="right"><b>{{$info->driver}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.Transporter_phone')</b></td>
          <td align="right"><b>{{$info->driverPhone}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.PlaceOfWeight')</b></td>
          <td align="right"><b>{{$info->PlaceOfWeight}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.SourcePlace')</b></td>
          <td align="right"><b>{{$info->sourcePlace}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.PlateNumber')</b></td>
          <td align="right"><b>{{$info->plateNumber}}</b></td>
        </tr>
      </table>
    </td>
    <td style="text-align: right; width:40%">
      <table class="main-table">
        <tr style="font-weight: bold; font-size: 17px">
          <td align="right"><b>@lang('layout.WayBillNumber')</b></td>
          <td align="right"><b>{{$info->wayBillNumber}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.TotalWeight')</b></td>
          <td align="right"><b>{{$info->totalWeight}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.EmptyCarWeight')</b></td>
          <td align="right"><b>{{$info->emptyCarWeight}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.TotalBori')</b></td>
          <td align="right"><b>{{$info->bori}}</b></td>
        </tr>
        <tr>
          <td align="right"><b>@lang('layout.Description')</b></td>
          <td align="right"><b>{{$info->trDesription}}</b></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
@endif
@if(systemConfig()[7] != 0)
@if($loadDriver)
<!--Table 3 For Data  Information-->
{{-- here for  معلومات راننده/انتقال دهنده در فاکتور --}}
<table class="main-table" style="margin-top: 20px;" cellpadding="5px">
  <tr style="font-weight: bold; font-size: 17px">
    <td class="mt" style="text-align: center;">
      <div class="center">@lang('layout.Driver')</div>
    </td>
    <td class="mt" style="text-align: center;">
      <div class="center">@lang('layout.PaletNumber')</div>
    </td>
    <td class="mt" style="text-align: center;">
      <div class="center">@lang('layout.WayBillNumber')</div>
    </td>
    <td class="mt" style="text-align: center;">
      <div class="center">@lang('layout.SourcePlace')</div>
    </td>
    <td class="mt" style="text-align: center;">
      <div class="center">@lang('layout.Quantity')</div>
    </td>
    <td class="mt" style="text-align: center;">
      <div class="center">@lang('layout.Unit/M')</div>
    </td>
  </tr>
  @foreach($loadDriver AS $key1=>$record)
  <tr>
    @if($record->driver_type == 'OwnDriver')
    <td class="center">{{$record->name}}</td>
    <td class="center">{{$record->palet_number}}</td>
    @else
    <td class="center">{{$record->other_driver_name}}</td>
    <td class="center">{{$record->other_vehicle_name}}</td>
    @endif
    <td class="center">{{$record['cmr_number']}}</td>
    <td class="center">{{$record['source']}}</td>
    <td class="center">{{$record['item_quantity']}}</td>
    <td class="center">{{$record['measure_name']}}</td>
  </tr>
  @endforeach
</table>
@endif
@endif
<!--End Driver Info-->
@endif
@endif
<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','invoice') AS $info)
    <td style="text-align: left; width:40%">
      <table>
        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>
      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
<script type="text/javascript">
  window.print();
</script>
@endsection