@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
<style>
    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    } 
    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
</style>
@section('content')
@include("layouts.Cmodal")
@include("layouts.Invmodal")
@include("layouts.MMmodal")
@include("bills.modal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Enterbill') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
			<div id="measure">
                <modal v-if="showInfoModal" @close="showInfoModal = false">
                    <div slot="body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row col-md-12">
                                    <h4 class=" col-md-3">
                                    @lang('menu.InventoryBrand') :</h4>
                                    <h4 class="col-md-8">
                                    @{{ brand }}
                                    </h4>
                                </div>
                                <div class="row col-md-12">
                                    <h4 class=" col-md-3">
                                    @lang('layout.Location') :</h4>
                                    <h4 class="col-md-8">
                                    @{{ location }}
                                    </h4>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row col-md-12">
                                    <h4 class=" col-md-3">
                                    @lang('layout.SerialNum') :</h4>
                                    <h4 class="col-md-8">
                                    @{{ SNumber }}
                                    </h4>
                                </div>
                            </div>
                            

                        </div>

                    </div>
                    <h3 slot="header">
                        <div class="col-md-4">
                            <h3>
                                @lang('layout.OtherInformations') @lang('layout.Item')
                            </h3>
                        </div>
                    </h3>
                    <div slot="footer">
                        <button type=button class="modal-default-button"
                        v-on:click="showInfoModal = false ,measure = null , type=null">
                        @lang('layout.Cancel')
                        </button>
                    </div>
                </modal>
            </div>
            <!-- BEGIN Margin And Markup  Modal--> 
            @if(getMarginAndMarkup()=="true")
                <modal v-if="showMarginMarkupModal" @close="showMarginMarkupModal = false">
                    <div slot="body">
                        <div class="row">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0"
                            width="100%">
                            <thead>
                            <tr>
                                <th style="text-align: center;">@lang('layout.Item')</th>
                                <th style="text-align: center;">@lang('layout.CurrentCost')</th>
                                <th style="text-align: center;">@lang('layout.CurrentSalePrice')</th>
                                <th style="text-align: center;">@lang('layout.CurrentMarkup')</th>
                                <!-- <th style="text-align: center;">@lang('layout.CurrentMargin')</th> -->

                                <th style="text-align: center;">@lang('layout.NewSalePrice')</th>

                                <th style="text-align: center;">@lang('layout.NewMarkup')</th>
                                <!-- <th style="text-align: center;">@lang('layout.NewMargin')</th> -->
                            </tr>
                            </thead>
                            <tr>
                                <td style="text-align: center;">@{{item_name}} </td>
                                <td style="text-align: center;">@{{myRound(current_cost)}} @{{selected_currency.symbol}}</td>
                                <td style="text-align: center;">@{{myRound(current_rate)}} @{{selected_currency.symbol}}</td>
                                <td style="text-align: center;">@{{myRound(markup_c)}} %</td>
                                <!-- <td style="text-align: center;">@{{myRound(margin_c)}} %</td> -->

                                <td style="text-align: center;">@{{myRound(sale_rate_new)}} @{{selected_currency.symbol}}</td>

                                <td style="text-align: center;">@{{myRound(markup_new)}} %</td>
                                <!-- <td style="text-align: center;">@{{myRound(margin_new)}} %</td> -->
                            </tr>
                        </table>
                        <div class="col-md-12 form-group" >
                            <label class=" control-label" style="font-weight: bold; color:red">@lang('message.MarginMarkupMsg')</label>
                            <div>
                                <label class="mt-checkbox mt-checkbox-outline">
                                    <input type="checkbox" @click="chacge_sale_price(selected_index)" name="change_sale_price" value="ok" >
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        </div>
                    </div>
                    <!-- <h3 slot="header">
                        <div class="col-md-4">
                            <h3>
                                @lang('layout.MarginAndMarkup')
                            </h3>
                            <p>@lang('layout.Item'): @{{item_name}}</p>
                            
                        </div>
                    </h3> -->
                    <div slot="footer">
                        <button type=button class="modal-default-button"
                        v-on:click="showMarginMarkupModal = false">
                        @lang('layout.Close')
                    </button> 
                    <!-- <button type=button class="btn blue"
                        v-on:click="showMarginMarkupModal = false ,measure = null , type=null">
                        @lang('layout.Submit')
                    </button> -->
                    </div>
                </modal>
            @endif
            <!-- End Margin And Markup  Modal--> 
            <!-- BEGIN FORM-->
            {{Form::open(['route' => 'bill.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form'])}}
            {{ csrf_field() }}
            <!-- begin sale order modal -->
            <div id="salOrderApp" v-cloak>
            {{-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} --}}
                <input type="hidden" name="type" value="invoicelist"/>
                <!-- use the modal component, pass in the prop -->
                <modal v-if="showModalPurchaseOrder" @close="showModalPurchaseOrder = false">
                    <div slot="body">
                        <div class="row">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Select') </label>
                                    <select class="form-control" v-model="selected_purchase_order" @input="">
                                        <option v-for="order in purchaseOrderList" :value="order">
                                        <span>
                                        @{{order.type+':'+order.number+' '+order.description}}
                                        </span>
                                        </option>
                                    </select>
                                </div>


                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group">

                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Currency') </label>
                                    <input type="text" name=""
                                        :value="(!selected_purchase_order)?null:selected_purchase_order.currency"
                                        class="form-control" disabled="disabled">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Rate') </label>
                                    <input type="text" name=""
                                        :value="(!selected_purchase_order)?null:selected_purchase_order.rate"
                                        class="form-control" disabled="disabled">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">

                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Date') </label>
                                    <input type="text" name=""
                                        :value="(!selected_purchase_order)?null:selected_purchase_order.date"
                                        class="form-control" disabled="disabled">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                    <input type="text" name=""
                                        :value="(!selected_purchase_order)?null:selected_purchase_order.delivery_date"
                                        class="form-control" disabled="disabled">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group">
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Category') </label>
                                    <input type="text" name=""
                                        :value="(!selected_purchase_order)?null:selected_purchase_order.category"
                                        class="form-control" disabled="disabled">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Description') </label>
                                    <input type="text" name=""
                                        :value="(!selected_purchase_order)?null:selected_purchase_order.description"
                                        class="form-control" disabled="disabled">
                                </div>

                            </div>
                        </div>
                        <br>
                        <p style="color: red">@lang('layout.SOmsg')
                    </div>
                    <div slot="footer">
                        <button type="button" v-if="selected_purchase_order" @click="getPurchaseOrders"
                                class="btn btn-success">
                            @lang('layout.Submit')
                        </button>
                        <button type="button" class="btn btn-danger" v-on:click="showModalPurchaseOrder=false">
                            @lang('layout.Cancel')
                        </button>
                    </div>
                </modal>
            {{-- {{Form::close()}} --}}
            </div>
            <!-- end sale order modal -->
            <div class="form-body" style="padding-top: 0px">
                <div class="row" style="margin-bottom: 20px; padding: 10px;">
                    <input type="hidden" name="temp_type" value="bill">
                    <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                        <div class="col-md-3" v-show="showWhat('member_class')=='yes'">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.MemberClass')</label>
                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                            </div>
                        </div>
                        <div class="@if(getDescriptionASMemberName() == 'true') col-md-5 @else col-md-5 @endif">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Vendor')</label>
                                <div class="input-group">
                                    <v-select label="name" @input="memberChange(), getSummary()" :options="vendor"
                                    @search="MemberSearch"  v-model="selected_vendor"></v-select>
                                    <input type="hidden" name="vendor" v-validate="'required'" data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id" required>
                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                        <i class="fa fa-plus" style="color: white"></i>
                                    </span> 
                                </div>
                                <span class="required">@{{ errors.first('vendor') }}</span>
                            </div>
                        </div>
                        <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-md-2">
                            <div class="form-group">
                                <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                <div>
                                    <input type="text" name="other_member_name" class="form-control" v-model="other_member_name">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.BillNumber')</label>
                                <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.BillNumber')" v-model="number" @input="checkNo()" class="form-control">
                                <span class="required">@{{ errors.first('number') }}</span>
                                <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                            </div>
                        </div> 
                        <div class="col-md-12" style="padding: 0px !important;">
                            <div :class="(selected_purchase_order && selected_vendor && selected_purchase_order.vendor_id == selected_vendor.id) ? 'col-lg-3': 'col-lg-3'">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                    <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                            </div>
                            <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3' : 'col-lg-3 col-md-3' }} col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Currency') </label>
                                    <v-select label="code" @input="selectedRate, changeContractDiffer()" :options="setRates" v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                    
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>
                            </div>
                            <div class="col-lg-3" v-if="selected_purchase_order && selected_vendor && selected_purchase_order.vendor_id == selected_vendor.id">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.PONumber')</label>
                                    <input type="text" class="form-control" :value="(!selected_purchase_order)?null:selected_purchase_order.number" readonly>
                                </div>
                            </div>
                            <div class="{{ auth()->user()->company()->first()->tag != 1? 'col-lg-3 col-md-3' : 'col-lg-3 col-md-3' }} col-sm-12 col-xs-12">
                                <div class="form-group">
                                <label class="control-label">@lang('layout.Rate') @{{selectedRate}}</label>
                                    <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?1:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                </div>
                                <span v-if="differentRate" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                            </div>
                        </div>
                        <div class="col-md-12" style="padding: 0px !important;">
                            @if(auth()->user()->company()->first()->tag != 1)
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ExchangeRateHQ')</label>
                                        <input type="number" name="currency_rate_hq" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?0:selected_currency.hq_rate" class="form-control" :class="{'has-error':rate<=0}">
                                        <span class="required">@{{ errors.first('currency_rate') }}</span>
                                    </div>
                                </div>
                            @endif
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','discount')) displayNone @endif">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Discount')</label>
                                    <div class="input-group">
                                        <input v-model="discountFiled" class="form-control"type="number" min="0">
                                        <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                            <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                        </span>
                                        <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                            <input type="hidden" name="discount_type" value="percent">
                                        </span>
                                        <input type="hidden" name="discountTotal" :value="discount">
                                        <input type="hidden" name="discount" :value="discountFiled">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','date')) displayNone @endif">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif
                                    name="date" class="form-control date now" autocomplete="off">
                                    <span class="required">@{{ errors.first('date') }}</span>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','overdueDate')) displayNone @endif">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.OverdueDate')</label>
                                    <date_picker name="overdue_date" v-model="overdue_date" ></date_picker>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','hour')) displayNone @endif">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Hour')</label>
                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                        @if(getHourType() == 24)
                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @else
                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @endif
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-clock-o"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12" style="padding: 0px !important;">
                            @if(systemConfig()[20] == 1)
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','contractName')) displayNone @endif">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select label="Contract_Name" @input="contractChange()" :options="contract" v-model="selected_contract"></v-select>
                                        <input type="hidden" name="contract_id" :value="(this.selected_contract==null)?null:selected_contract.id">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12 @if(!getCustomeForm('bill','wagonNumber')) displayNone @endif" v-if="(this.selected_contract==null)?false:true">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.WagonNumber')</label>
                                        <input type="text" name="wagon_number" v-model="wagon_number" class="form-control" placeholder="0011">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','bourseDate')) displayNone @endif" v-show="(this.selected_contract==null)?false:true">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.BourseDate')</label>
                                        <input type="text" class="form-control date" name="bourse_date" autocomplete="off">
                                    </div>
                                </div>
                            @endif
                            @if(systemConfig()[16] != 0)
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','farmerContract')) displayNone @endif">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.FarmerContract')</label>
                                        <v-select class="vue-select2" label="name" :options="farmer_contract_list" v-model="selectedFarmerContract"></v-select>
                                        <input type="hidden" name="contract_farmer_id" v-model.number="(!selectedFarmerContract)?null:selectedFarmerContract.id">
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="col-md-12">
                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','description')) displayNone @endif">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control" rows="1" v-text="bill_description" ></textarea>
                                </div>
                            </div>
                            @if(getSaleSubMeasure()=="true")
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','subPrice')) displayNone @endif" >
                                <table class="table table-striped table-bordered table-advance ">
                                    <tr>
                                        <td class="t_body">
                                            <div>
                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SubPrice')
                                                    <input type="checkbox" @click="subPrice" name="sub_price" checked value="ok" >
                                                    <span></span>
                                                </label>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            @endif
                            @if(getSaleByOtherMeasureRate() == "true")
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','saleByOtherMeasureRate')) displayNone @endif">
                                <table class="table table-striped table-bordered table-advance ">
                                    <tr>
                                        <td class="t_body">
                                            <div>
                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaleByOtherMeasureRate')
                                                    <input type="checkbox" name="per_qty_check" v-model="per_qty_check">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            @endif
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('bill','salePrice')) displayNone @endif">
                                <table class="table table-striped table-bordered table-advance ">
                                    <tr>
                                        <td class="t_body" style="display: flex; justify-content: center; align-content: center; align-items: center;">
                                            <div>
                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SalePrice')
                                                    <input type="checkbox" name="check_sale_price" v-model="sale_price">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                                <div class="col-lg-1 col-md-1 col-sm-6 col-xs-12 @if(!getCustomeForm('bill','whatsapp')) displayNone @endif">
                                    <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox"  name="whatsapp" value="5" />
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            @endif
                            {{-- @if(getTelegramBot()=="true")
                            <div class="colp-lg-2 col-md-2 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12" style="margin-top: 1%;">
                                        <table class="table table-striped table-bordered table-advance">
                                            <tr>
                                                <td class="t_body" style="display: flex; justify-content: center; align-content: center; align-items: center;">
                                                    <div>
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <i class="fa fa-telegram" style="color:rgb(14 177 177); font-size:20px; margin-top: 5px;"></i>
                                                            <input type="checkbox" name="telegram" value="ok">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            @endif --}}
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-12" > 
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                            <div class="row" style="padding: 10px 20px;">
                                <!-- begin total -->
                                <div class="well" style="padding:0px; margin-bottom: 5px;background: transparent;">
                                    <table class="dashboard-tabel" width="100%">
                                        <tr>
                                            <td>
                                                <small style="font-weight: bolder;font-size:20px">@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800" style="font-weight: bolder;font-size:20px">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds ))}}</span>
                                                <small class="font-green-sharp" style="font-weight: bolder;font-size:20px">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>
                                                    @lang('layout.Discount'): (@{{Number.parseFloat(discount).toFixed(precision()) }}%)
                                                </small>
                                            </td>
                                            <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Payment'):</small>
                                            </td>
                                            <td class="text-right">
                                                <small>
                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number( Number(payeds))}}</span>
                                                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                </small>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <small>@lang('layout.Sub-Total'):</small>
                                            </td>
                                            <td class="text-right">
                                            <span class="text-right" data-counter="counterup"data-value="7800">@{{ format_number( Number(subtotal))}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <!-- end total -->
                                <div class="well" v-if="selected_vendor" style="padding: 0px !important;background: transparent;">
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <tr>
                                            <th style="text-align: center">@lang('layout.Currency') </th>
                                            <th style="text-align: center">@lang('layout.Payable')</th>
                                            <th style="text-align: center">@lang('layout.Receivable')</th>
                                            <th style="text-align: center">@lang('layout.AverageRate')</th>
                                        </tr>
                                        <tr v-for="summ in summary">
                                            <td style="text-align: center">
                                                @{{ summ.currency }}
                                            </td>
                                            <td style="text-align: center"> 
                                                @{{ format_number(Number(summ.payment)) }}
                                            </td>
                                            <td style="text-align: center">
                                                @{{format_number(Number(summ.invoice)) }}
                                            </td>
                                            <td style="text-align: center">
                                                @{{format_number(Number(summ.rate))}}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px 0px;">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                            {{-- <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">
                                <div class="form-group"> --}}
                                    {{-- <label class="control-label">@lang('layout.SerialNum')</label> --}}
                                    {{-- <input type="text" v-model="selected_inventory1" ref="barcode_search1" placeholder="@lang('layout.SerialNum')" class="form-control" @input="callOnItemloadGeneral(), editKey = false" >
                                    <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span>
                                </div>
                            </div> --}}

                            <div class="col-lg-5 col-md-6 col-sm-12 col-xs-12">  
                                <div class="input-group">
                                    <input type="text"  v-model="selected_inventory1"  placeholder="@lang('layout.SerialNum')"  ref="barcode_search1" class="form-control" @input="(!check_with_key)?callOnItemloadGeneral():''" >
                                    {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                    <span class="input-group-addon">
                                        <input type="checkbox" v-model="check_with_key" title="{{ __('layout.SearchItemsWithSpecificKey') }}">
                                        <span></span>
                                    </span>
                                </div>
                                <span v-if="item_not_found" class="required">@lang('layout.ItemNotFound')</span>
                            </div> 


                            <div class="col-lg-7 col-md-7 col-sm-6 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                    <div class="input-group">
                                        <v-select label="name" ref="barcode_search" @input="loadItemGeneral()"  v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')" ></v-select>
                                        <span class="btn btn-success input-group-addon " title="@lang('layout.AddNewItem')" @click="showInvModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                    <v-select label="site_name" v-model="selected_iventory_site" :options="inventory_sites1" placeholder="@lang('layout.Site')"></v-select>
                                </div>
                                <p v-if="selected_item && selected_iventory_site" >
                                    @{{(selected_item && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}} @{{(selected_item)?selected_item.measure.measure_name:''}}
                                </p>
                            </div>
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                        <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"  >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                        <select v-model="(selected_item == null)?null:selected_item.measure" @input="changeMesurss()" class="form-control" >
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(selected_item ==null)?false:true">
                                                <option v-for="measure in (selected_item==null)?null:selected_item.measure_list" :value="measure">
                                                    @{{measure.measure_name}}
                                                </option>
                                            </span>
                                        </select>
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-2 col-sm-12 col-xs-12" >
                                <div class="form-group">
                                    <!-- <div class="col-md-12"> -->
                                        <!-- <label class="control-label">@lang('layout.Price')</label> -->
                                        <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                    <!-- </div> -->
                                </div>
                            </div>
                            <div class="col-lg-1 col-md-2 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 100px">@lang('layout.Category') </th>
                                <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                @if(getSerailNumber() =="true")
                                    <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                @if(showLocation()=="true")
                                <th style="min-width: 100px"> @lang('layout.Location') </th>
                                @endif
                                @if(systemConfig()[16] != 0)
                                <th style="min-width: 100px">@lang('layout.Type') </th>
                                @endif
                                <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Description1') </th>
                                <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Model') </th>
                                <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Color') </th>
                                <th v-show="showWhat('expire_date')=='yes'" style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px" v-if="(selected_contract)">@lang('layout.Contract') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('oil_sale')=='yes'" style="min-width: 100px">@lang('layout.Density') </th>
                                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')</th>
                                @if(getShowCBM()=="true")
                                <th style="min-width: 100px">@lang('layout.CBM')</th>
                                @endif
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th style="min-width: 100px">@lang('layout.Cost') ({{getHomeCurrency()['code']}})</th>
                                <th style="min-width: 100px">@lang('layout.Cost') (@{{selected_currency.code}}) </th>
                                <th style="min-width: 100px" v-if="((selected_contract)?(selected_contract.pos_neg_amount && selected_contract.pos_neg_type):null)" > @lang('layout.Differ') </th>
                                <th style="min-width: 100px" v-if="((selected_contract)?(selected_contract.pos_neg_amount && selected_contract.pos_neg_type):null)" > @lang('layout.TotalPurchaseCost') </th>
                                @if(getM2()!="" && getSaleSubMeasure()!="true")	
                                    <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                @endif
                                @if(getSaleSubMeasure()=="true")	
                                <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                <th  v-show="sub_price==true" style="min-width: 100px">@lang('layout.SubPrice') </th>
                                @endif
                                <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                <th v-show="sale_price" style="min-width: 100px">@lang('layout.SalePrice') </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(item,index) in inventories">
                            <td>@{{index+1}}</td>
                            <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                                <v-select label="name" v-model="item.item_category" :options="inventory_category"@input="itemCategoryChange(index)"></v-select>
                                <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                            </td>
                            <td v-show="showWhat('inventory_brand')=='yes'">
                                <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @input="itemBrandChange(index)"></v-select>
                                <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                            </td>
                            <td class="highlight">
                            <div class="input-group">
                                <v-select label="name" @input="(editKey)?onItemload(index):''" @keyup.native="editKey = true" @Click.native="editKey = true" v-model="item.inventory" :options="temp_items" @search="onItemSearch"></v-select>
                                <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                {{-- <input type="hidden" name="purchase_order_detail_id[]"
                                :value="(!item.item)?null:item.item.purchase_order_detail_id"> --}}
                                <input type="hidden" name="purchase_order_detail_id[]" :value="(selected_purchase_order)?((!item.item || selected_vendor.id !=selected_purchase_order.vendor_id)?null:item.item.purchase_order_detail_id):null">
                                <input type="hidden" name="contract_detail_id[]" :value="(!item.item)?null:item.item.contract_detail_id">
                                <span class="btn btn-success input-group-addon" @click="showInfo(index)">
                                <i class="fa fa-info"></i></span>	
                            </div>
                            </td>
                            @if(getSerailNumber() =="true")
                            <td>
                                @{{(!item.item)?null:item.item.number}}
                            </td>
                            @endif
                            <td class="highlight">
                                <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                    <option value="null">@lang('layout.Select')</option>
                                    <span v-if="(item.item != null)">
                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                        </option>
                                    </span>
                                </select>
                                <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                            </td>
                            @if(showLocation()=="true")
                            <td>
                                <input name="location[]" v-model="(item.item==null)?null:item.location" type="text" class="form-control" placeholder="@lang('layout.Location')">
                            </td>
                            @endif
                            @if(systemConfig()[16] != 0)
                            <td class="highlight">
                                <select name="farmer_type[]" v-model="item.farmer_type" class="form-control">
                                    <option value="null">@lang('layout.Select')</option>
                                    <option value="Drawing">@lang('layout.Drawing')</option>
                                    <option value="Seed">@lang('layout.Seed')</option>
                                    <option value="CompanyDecrease">@lang('layout.CompanyDecrease')</option>
                                    <option value="WastageDecrease">@lang('layout.WastageDecrease')</option>
                                </select>
                            </td>
                            @endif
                            <td v-show="showWhat('sale_description')=='yes'">
                                <input type="text" placeholder="@lang('layout.Description1')" oninput = "autowidths(event)" name="inventory_description[]" v-model="(item.item==null)?null:item.inventory_description" class="form-control chan_length">
                            </td>
                            <td v-show="showWhat('sale_description')=='yes'">
                                <input type="text" placeholder="@lang('layout.Model')" oninput = "autowidths(event)" name="model[]" v-model="(item.item==null)?null:item.model" class="form-control chan_length">
                            </td>
                            <td v-show="showWhat('sale_description')=='yes'">
                                <input type="text" placeholder="@lang('layout.Color')" oninput = "autowidths(event)" name="color[]" v-model="(item.item==null)?null:item.color" class="form-control chan_length">
                            </td>
                            <td v-show="showWhat('expire_date')=='yes'">
                                <date_picker :name="'expire_date['+index+']'" v-model="(item.item==null)?null:item.expire_date" placeholder="@lang('layout.ExpireDate')" ></date_picker>
                            </td>
                            <td>
                                <input type="number" :name="'quantity['+index+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" @input="setRentQuantity(index), change_oil_qty(index)" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                            </td>
                            <td  v-if="(selected_contract)">
                                @{{myRound((item.item==null)?null:item.item.CQuantity)}}
                            </td>
                            <td>
                                @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                            </td>
                            <td v-show="showWhat('oil_sale')=='yes'">
                                <input type="number" name="density[]" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Density')" @input="change_oil_density(index)" v-model.number="(item.item==null)?null:item.item.density" oninput = "autowidths(event)" />
                            </td>
                            <td v-show="showWhat('other_measure')=='yes'">
                                <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure" oninput = "autowidths(event)" @input="change_qty_by_oil(index)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                            </td>
                            <td v-show="showWhat('other_measure2')=='yes'">
                                <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                            </td>
                            @if(getShowCBM()=="true")
                            <td>
                                <input type="number" name="cbm[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.CBM')">
                            </td>
                            @endif
                            <td class="highlight">
                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                    <option value="null">@lang('layout.Select')</option>
                                    <span v-if="(item.item ==null)?false:true">
                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                            @{{measure.measure_name}}
                                        </option>
                                    </span>
                                </select>
                                <input type="hidden" name="measure[]"
                                        :value="(item.item==null)?null:item.item.measure.measure_id">
                            </td>
                            <td>
                                @{{(item.item==null)?null: Number.parseFloat(item.item.new_rate).toFixed(precision())}}
                            </td>
                            <td>
                                <vue-numeric v-if="item.item"
                                    class="form-control chan_length"
                                    oninput = "autowidths(event)"
                                    v-model="item.item.cost"
                                    :max="99999999999999"
                                    currency=""
                                    :precision="((p_total)?7:precision())"
                                    @input="setNewRate(index)"
                                    @change="showMarginMarkup(index)"
                                    >
                                </vue-numeric>
                                <input type="hidden" name="inventory_price[]" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate,((p_total)?7:precision()), selected_currency.static_rate)" >
                                <input type="hidden" name="sale_rate_new[]" :value="(item.item==null)?null:item.new_sale_price" class="form-control" >
                            </td>
                            <td v-if="((selected_contract)?(selected_contract.pos_neg_amount && selected_contract.pos_neg_type):null)">
                                <input type="number" placeholder="@lang('layout.Differ')" step="any" name="contract_differ[]"
                                v-model="(item.item==null)?null:item.contract_differ"
                                oninput = "autowidths(event)"
                                class="form-control chan_length">
                            </td>
                            <td v-if="((selected_contract)?(selected_contract.pos_neg_amount && selected_contract.pos_neg_type):null)">
                                @{{ (item.item==null)?null:(((item.item.cost)?Number.parseFloat(item.item.cost):0) + ((item.contract_differ)?Number.parseFloat(item.contract_differ):0)) }}
                            </td>

                            @if(getM2()!="" && getSaleSubMeasure()!="true")	  
                                <td>
                                    <div class="input-group">
                                        <select  name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1">
                                            <option value="null">@lang('layout.Select')</option>
                                            <span v-if="(item.item ==null)?false:true">
                                                <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                            </option> 
                                            </span>
                                        </select>
                                        @if(getSaleAmountSecondMeasure()=="true")	
                                        <span class="input-group-addon">
                                            @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                        </span>
                                        @endif
                                    </div>
                                </td>
                            @endif
                            @if(getSaleSubMeasure()=="true")	  
                                <td>
                                    <select  name="measure1[]" class="form-control"  @change="measure1Change(index)" v-model="(item.item==null)?null:item.item.measure1">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                        <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                            @{{measure.measure_name}}
                                        </option> 
                                        </span>
                                    </select>
                                </td>
                                <td>
                                    @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td v-show="sub_price==true">
                                    <div class="input-group">
                                        <input type="number" placeholder="@lang('layout.SubPrice')"
                                                v-model="(item.item==null)?null:item.sub_price"
                                                @input="setNewRateTotal(index)"
                                                oninput = "autowidths(event)"
                                                class="form-control chan_length">
                                        <span class="input-group-addon">
                                            @{{selected_currency.symbol}}
                                        </span>
                                    </div>
                                </td>
                            @endif
                            <td v-show="showWhat('sale_discount')=='yes'">
                                <div class="input-group">
                                    <input type="number" name="inventory_discount[]"
                                            placeholder="@lang('layout.Discount')"
                                            v-model.number="(item.item==null)?null:item.item.discount"
                                            oninput = "autowidths(event)"
                                            class="form-control chan_length">
                                    <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                    </span>
                                    <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                    </span>
                                </div>

                            </td>
                            <td v-show="sale_price">
                                <input type="number" name="sale_price[]"
                                        placeholder="@lang('layout.SalePrice')" @input="setNewRate(index)"
                                        v-model.number="(item.item==null)?null:item.item.sale_price"
                                        oninput = "autowidths(event)" class="form-control chan_length">
                            </td>
                            <td>
                                <input type="number" :value="(item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate,per_qty_check,item.contract_differ, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                {{-- @{{ (item.item==null)?null:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate,per_qty_check,item.contract_differ).result }}
                                <b>@{{selected_currency.symbol}}</b> --}}
                            </td>
                            <td>
                                <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i
                                    class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                        </tr>
                        <tr style="background-color: #ffffff;">
                            <td></td>
                            <td>
                                <center>
                                    <button type="button" @click="addNew('inventory',1000)" class="btn btn-success">
                                        <i class="fa fa-plus"></i></button>
                                </center>
                            </td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            @if(getSaleSubMeasure()=="true")	
                            <td></td>
                            <td></td>
                            <td></td>
                            @endif
                            <td></td>
                        </tr>
                        </tbody>
                    </table>
                    <hr>
                    <!-- begin payments -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                        <tr>
                            <th class="text-center" style="min-width: 8px;"> #</th>
                            <th class="text-center"style="min-width: 70px;">@lang('layout.Number')</th> 
                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                            <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                            <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                            <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                            <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                            <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(payment,index) in payments">
                            <td>@{{index+1}}</td>
                            <td>
                                <span>@{{(payment.item==null)?null:(payment.item.pay_number)+index}}</span>

                                    <input  type="hidden"
                                        name="payment_number[]"
                                        :value="(payment.item==null)?null:(payment.item.pay_number)+index"
                                        />
                            </td>

                            <td class="highlight">
                                <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                            @click.native="addNew('payment',index)"
                                            @input="checkExistingPayment(index)">

                                </v-select>
                                <input type="hidden" :name="'payment_id['+index+']'"
                                        :value="(payment.item==null)?null:payment.item.id">
                            </td>

                            <td>
                                <span v-if="payment.item !=null">
                                    @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                </span>
                            </td>
                            <td>
                                <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                        type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                        class="form-control"
                                        placeholder="@lang('layout.Rate')" required/>
                                <input v-if="payment.item !=null" type="hidden" :name="'payment_rate['+index+']'"
                                        v-bind:value="payment.item.rate">
                                <input v-if="payment.item !=null" type="hidden" :name="'payment_rate_hq['+index+']'"
                                        v-bind:value="payment.item.hq_rate">
                            </td>
                            <td>
                                <input type="text" :name="'payment_currency['+index+']'" class="form-control"
                                        v-model="(payment.item==null)?null:payment.item.code"
                                        placeholder="@lang('layout.Currency')" required disabled/>

                                <input v-if="payment.item !==null" type="hidden" :name="'payment_currency['+index+']'"
                                        v-bind:value="payment.item.code"/>
                            </td>
                            <td>
                                {{-- <div class="input-group"> --}}
                                    <vue-numeric v-if="payment.item"
                                        class="form-control"
                                        v-model="payment.item.amount"
                                        :max="99999999999999"
                                        :currency="payment.item.code"
                                        :precision="precision()"
                                        >
                                    </vue-numeric>
                                    {{-- <input type="number" class="form-control" v-model.number="(payment.item==null)?null:payment.item.amount " placeholder="@lang('layout.PayAmount')" required/> --}}
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_amount['+index+']'" v-bind:value="payment.item.amount">

                                    {{-- <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                </div> --}}
                            </td>
                            <td>
                                @{{ (payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result }}
                                <b>@{{selected_currency.symbol}}</b>
                            </td>
                            <td>
                                <textarea class="form-control" name="payment_description[]" rows="2" placeholder="@lang('layout.Description')">@{{(payment.item==null)?null:payment.item.description}}</textarea>
                            </td>
                            <td>
                                <span v-on:click="deleteItem('payment',index)"><i
                                            class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <!-- end payments -->
                </div>
                <!-- Begin  Expense ------------------------------>   
                @if(getPurchaseExpense()=="true")                       
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width:3px;">@lang('layout.Expense')</th>
                                    </tr>
                                    <tr>
                                        <th class="text-center" style="width:3px;">#</th>
                                        <th class="text-center" style="width:3px;">@lang('layout.ExpenseAccount') <span class="required"> * </span></th>
                                        <th class="text-center" style="min-width: 130px;">
                                            @lang('layout.Description') <span class="required"> * </span>
                                        </th>
                                        <th class="text-center" style="min-width: 130px;">
                                            @lang('layout.Amount')<span class="required"> * </span>
                                        </th>
                                        <th style="min-width: 4px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for=" (row,index) in rows" class="even">
                                        <td class="td_one"><span span v-if="rows.length >1 "
                                                                class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                        </td>

                                        <td>
                                            <div class="form-group">
                                                <v-select   placeholder="@lang('layout.ExpenseAccount')" label="name"
                                                
                                                v-model="row.item" :options="(row.items)"
                                                
                                                >       
                                                </v-select>
                                                <input type="hidden" :name="'expense_account_id['+index+']'"
                                                    :value="(row.item==null)?null:row.item.id">


                                            </div>
                                        </td>
                                        <td>

                                            <input type="text" class="form-control" name="expense_description[]" class="form-control'"
                                            placeholder="@lang('layout.Description')" @click="addNew('expense',index)"/>
                                        </td>
                                        <td width="50%;" class="td_one">
                                            <div class="input-group">
                                            <input type="number" class="form-control" name="expense_amount[]" class="form-control'"
                                            placeholder="@lang('layout.Amount')" @click="addNew('expense',index)" v-model.number="(row.item==null)?null:row.item.amount"/>
                                            <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                            </div>
                                        </td>

                                        <td>
                                            <span v-on:click="deleteItem('expense',index)"><i
                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif
                <!--End Expense-------------------------------------->

                <!--Begin Draiver-->

                @if(getDriverInfo()=="true")
                    <br>
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                        <tr>
                            <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>
                        </tr>
                        </thead>
                    </table>
                    @if(systemConfig()[7] == 0)
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <!-- begin inputs -->
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TransferCode')</label>
                                            <input type="text" name="transfer_code" v-model="simple_driver_data.other_measure" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Transporter_name')</label>
                                            <input type="text" name="transporter_name" v-model="simple_driver_data.driver_name" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Transporter_phone')</label>
                                            <input type="test" name="transporter_phone" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                            {{Form::text('palce_of_weight',null,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                        </div>
                                    </div>

                                </div>
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.SourcePlace')</label>
                                            {{Form::text('source_place',null,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.PlateNumber')</label>
                                            <input type="text" name="plate_number" v-model="simple_driver_data.vehicle_name" placeholder="@lang('layout.PlateNumber')" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                            <input type="text" name="way_bill_number" v-model="simple_driver_data.wagon_number" placeholder="@lang('layout.WayBillNumber')" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TotalWeight')</label>
                                            <input type="text" name="total_weight" v-model="simple_driver_data.other_measure2" placeholder="@lang('layout.TotalWeight')" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                            <input type="text" name="empty_car_weight"
                                                placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TotalBori')</label>
                                            <input type="text" name="total_bori" v-model="simple_driver_data.description2" placeholder="@lang('layout.TotalBori')" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Description')</label>
                                            <textarea name="transfer_description" class="form-control" v-text="(simple_driver_data)?simple_driver_data.description:null" ></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    @endif
                    @if(systemConfig()[7] != 0)
                        <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th style="">@lang('layout.State') </th>
                                        <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                        <th style="min-width: 100px">@lang('layout.Transporter_name') </th>
                                        <!-- th v-if="driver_type == 'OwnDriver'" style="min-width: 100px">@lang('layout.TankerNumber') </th -->
                                        <th style="min-width: 100px">@lang('layout.VehicleName') </th>
                                        <th style="min-width: 100px">@lang('layout.TankerNumber') </th>
                                        <th v-if="driver_type == 'ForeignDriver1'" style="min-width: 100px">@lang('layout.Driver') </th>
                                        <th v-if="driver_type == 'ForeignDriver1'" style="min-width: 100px">@lang('layout.VehicleName') </th>
                                        <th style="min-width: 100px">@lang('layout.TransitNumber') </th>
                                        <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                                        <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
                                        <th style="min-width: 100px">@lang('layout.Destination') </th>
                                        <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
                                        <th style="min-width: 100px">@lang('layout.RentQuantity') </th>
                                        <th style="min-width: 100px">@lang('layout.Price') </th>
                                        <th style="min-width: 100px">@lang('layout.Currency') </th>
                                        <th style="min-width: 100px">@lang('layout.Rate') </th>
                                        <th style="min-width: 100px">@lang('layout.Rent') </th>
                                        <th style="min-width: 100px">@lang('layout.Rate') </th>
                                        <th style="min-width: 100px">@lang('layout.TotalTransferFee') </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(item,index) in inventories">
                                        <td>@{{index+1}}</td>
                                        
                                        <td>
                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" :name="'tran_fer['+index+']'" value="ok" checked />
                                            <span></span>
                                            </label>
                                            </div>
                                        </td>
                                        <td class="highlight">
                                            @{{(!item.item)?null:item.item.name}}
                                        </td>
                                        <td class="highlight">
                                            @{{(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_name)}}
                                        </td>
                                        <td>
                                            @{{(item.item==null)?null:item.item.quantity}}
                                        </td>
                                        <td>
                                            <v-select label="name" v-model="item.driver" @input="vehicleSearch(index)"
                                                    :options="driver"></v-select>
                                            <input type="hidden" :name="'driver_id['+index+']'" :value="(!item.driver)?null:item.driver.id">
                                            <input type="hidden" :name="'driver_type['+index+']'" :value="(!item.driver)?null:item.driver.driver_type">
                                            <input type="hidden" :name="'foreign_type['+index+']'" :value="(!item.driver)?null:item.driver.foreign_type">
                                        </td>
                                        <td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
                                            <v-select label="name" v-model="item.vehicle" @input="carChange(index)"
                                                    :options="vehicle"></v-select>
                                            <input type="hidden" :name="'vehicle_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.id">
                                            <input type="hidden" :name="'vehicle_currency['+index+']'" :value="(!item.vehicle)?null:item.vehicle.currency">
                                            <input type="hidden" :name="'vehicle_driver_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.driver_id">
                                            <input type="hidden" :name="'vehicle_foreign_type['+index+']'" :value="(!item.vehicle)?null:item.vehicle.foreign_type">
                                        </td>
                                        <td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
                                            <v-select label="name" v-model="item.tanker" @input="tankerChange(index)"
                                                    :options="vehicle"></v-select>
                                            <input type="hidden" :name="'tanker_id['+index+']'" :value="(!item.tanker)?null:item.tanker.id">
                                            <input type="hidden" :name="'tanker_currency['+index+']'" :value="(!item.tanker)?null:item.tanker.currency">
                                            <input type="hidden" :name="'tanker_driver_id['+index+']'" :value="(!item.tanker)?null:item.tanker.driver_id">
                                            <input type="hidden" :name="'tanker_foreign_type['+index+']'" :value="(!item.tanker)?null:item.tanker.foreign_type">
                                        </td>
                                        <td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                            <input type="text" :name="'other_driver_name['+index+']'"  placeholder="@lang('layout.Driver')"
                                            oninput = "autowidths(event)" class="form-control chan_length">
                                        </td>
                                        <td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                            <input type="text" :name="'other_vehicle_name['+index+']'"  placeholder="@lang('layout.VehicleName')"
                                            oninput = "autowidths(event)" class="form-control chan_length">
                                        </td>
                                        <td>
                                            <input type="text" :name="'transit_number['+index+']'" placeholder="@lang('layout.TransitNumber')" 
                                            oninput = "autowidths(event)" class="form-control chan_length">
                                        </td>
                                        
                                        <td>
                                            <input type="text" :name="'way_bill_number['+index+']'" placeholder="@lang('layout.WayBillNumber')"
                                            oninput = "autowidths(event)" class="form-control chan_length">
                                        </td>
                                        <td>
                                            <input type="text" :name="'source['+index+']'" placeholder="@lang('layout.SourcePlace')"
                                            oninput = "autowidths(event)" class="form-control chan_length">
                                        </td>
                                        <td>
                                            <input type="text" :name="'destination['+index+']'" placeholder="@lang('layout.Destination')"
                                            oninput = "autowidths(event)" class="form-control chan_length">
                                        </td>
                                        <td>
                                            <date_picker :name="'loading_date['+index+']'" oninput = "autowidths(event)" placeholder="@lang('layout.LoadingDate')" class="chan_length" ></date_picker>
                                        </td>
                                        <td>
                                            <input type="number" v-model.number="(item.item==null)?null:item.item.rent_quantity" :name="'rent_quantity['+index+']'"
                                                @input="TotalTransferFee(index)" 
                                                oninput = "autowidths(event)"
                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.RentQuantity')" />
                                            <span class="required">@{{ errors.first('rent_quantity['+index+']') }}</span>
                                        </td>
                                        <td>
                                            <input type="number" :name="'transfer_fee['+index+']'" 
                                                class="form-control input-style input-number chan_length"
                                                oninput = "autowidths(event)"
                                                v-model.number="(item==null)?null:item.transfer_fee"
                                                @input="TotalTransferFee(index)"
                                                placeholder="@lang('layout.Amount')">
                                        </td>
                                        <td>
                                            <v-select label="code" :options="item.currency_list"
                                                    v-model="item.currency"></v-select>
                                            <input type="hidden" :name="'currency_loading['+index+']'"
                                                :value="(!item.currency)?null:item.currency.code">
                                        </td>
                                        <td>
                                            <input type="number" :name="'currency_rate_loading['+index+']'"
                                            oninput = "autowidths(event)"
                                            v-model="!item.currency?0:item.currency.rate"
                                            class="form-control chan_length" :class="{'has-error':rate<=0}">
                                        </td>
                                        <td>
                                            <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' ">
                                                <input type="number" :name="'forign_rent_vehicle['+index+']'" placeholder="@lang('layout.Rate')"
                                                oninput = "autowidths(event)"
                                                v-model="(!item.vehicle)?0:item.vehicle.rent" class="form-control chan_length" />
                                            </div>
                                            <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' ">
                                                <input type="number" :name="'forign_rent_tanker['+index+']'" placeholder="@lang('layout.Rate')"
                                                oninput = "autowidths(event)"
                                                v-model="(!item.tanker)?0:item.tanker.rent" class="form-control chan_length" />
                                            </div>
                                        </td>
                                        <td>
                                            <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' " class="input-group">
                                                <input type="number" :name="'forign_rate_vehicle['+index+']'" placeholder="@lang('layout.Rate')"
                                                oninput = "autowidths(event)"
                                                v-model="!item.vehicle?0:item.vehicle.rate" class="form-control chan_length" />
                                                <span class="input-group-addon">
                                                @{{(!item.vehicle)?null:item.vehicle.currency}}
                                                </span>
                                            </div>
                                            <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' " class="input-group">
                                                <input type="number" :name="'forign_rate_tanker['+index+']'" placeholder="@lang('layout.Rate')"
                                                oninput = "autowidths(event)"
                                                v-model="!item.tanker?0:item.tanker.rate" class="form-control chan_length" />
                                                <span class="input-group-addon">
                                                @{{(!item.tanker)?null:item.tanker.currency}}
                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            @{{(item==null)?null:item.itransfer_total}}
                                        </td>
                                        
                                    </tr>
                                </tbody>
                            </table>
                                <hr/>
                                <br/>
                        </div>
                    @endif
                @endif
                <!--End Draiver-->
                <br>
                @if(getInvoiceTotal() == 'true')
                    <!-- begin total -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="dashboard-stat2 ">
                            <table class="dashboard-tabel" width="100%">
                                <tr>
                                    <td>
                                        <small>@lang('layout.Sub-Total'):</small>
                                    </td>
                                    <td class="text-right">
                                        <span class="text-right" data-counter="counterup"
                                            data-value="7800">@{{ format_number( Number(subtotal))}}</span>
                                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                    </td>

                                    
                                    <td>
                                        <small>@lang('layout.Discount'): (@{{
                                            Number.parseFloat(discount).toFixed(precision()) }}%)
                                        </small>
                                    </td>
                                    <td class="text-right">
                                        <span class="text-right" data-counter="counterup"
                                                data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                    </td>
                                    <td>
                                        <small>@lang('layout.Payment'):</small>
                                    </td>
                                    <td class="text-right">
                                        <small class="font-green-sharp">
                                            <span class="text-right" data-counter="counterup"
                                                    data-value="7800">@{{ format_number( Number(payeds))}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </small>
                                    </td>
                                    <td>
                                        <small>@lang('layout.Total') :</small>
                                    </td>
                                    <td class="text-right"><span data-counter="counterup"
                                                                    data-value="7800">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds ))}}</span>
                                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                    </td>
                                
                                </tr>
                                
                                
                            </table>

                        </div>
                    </div>
                    <!-- end total -->
                @endif
                <div class="row">
                    @if(getPrintDescription()=="true")
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.PrintDescription')</label>
                                    <textarea name="print_description" class="form-control" rows="2" v-text="print_description" ></textarea>
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Memo')</label>
                                <textarea name="memo" class="form-control" rows="2"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" @click="handleSubmit($event)" :disabled="disabled"
                v-if="((!isError) && (number_Error == false) && (isError1 == false))" class="btn green">@lang('layout.Submit')</button>
                <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" class="btn blue"
                :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('bill.index')}}" @click="clearTemp" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {!! Form::close() !!}
            <cmodal :show='showModal' @close="showModal=false">
            </cmodal>
            <invmodal :show='showInvModal' @close="showInvModal=false">
            </invmodal>
            <modal v-if="showMeasureModal" @close="showMeasureModal = false">
                <div slot="body">
                    <div class="row">
                        <div class="col-md-3">
                            <h4>@lang('layout.MetricType')</h4>
                            <span v-for="metric in metricList">
                                <div class="mt-radio-list">
                                    <label class="mt-radio"> @{{ metric.name }}

                                        <input name="metric" type="radio" v-bind:value="metric"
                                        v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                        <span></span>
                                    </label>
                                </div>
                            </span>
                        </div>
                        <div class="col-md-3">
                            <h4>@lang('layout.Measure') </h4>
                            <span v-for="measure1 in selectedMetric.measure">
                                <div class="mt-radio-list">
                                    <label class="mt-radio">
                                    <b v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </b>
                                    <b v-if="measure1.text !='Other'">@{{ measure1.text }} </b>
                                        <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                        <span></span>
                                    </label>
                                </div>
                            </span>
                        </div>
                        <div class="col-md-6">
                            <span v-if="selectedMeasure.text == 'Other'">
                                <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                <div>
                                    <div class="form-group">
                                        <label class="control-label col-md-5">
                                        @lang('layout.MeasureName')</label>
                                        <div class="col-md-7">
                                            <input type="text" class="form-control"
                                            placeholder="@lang('layout.EnterMeasureName')"
                                            v-model.trim="selectedMeasure.name">
                                            <span class="help-block">  </span>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="control-label col-md-5">
                                            @lang('layout.MeasureAmount')
                                        </label>
                                        <div class="col-md-7">
                                            <input type="number" class="form-control"
                                            placeholder="@lang('layout.EnterMeasureuint')"
                                            v-model.number="selectedMeasure.unit">
                                            <span class="help-block">  </span>
                                        </div>
                                    </div>
                                    <div class="form-group ">
                                        <label class="control-label col-md-5">
                                            @lang('layout.MeasureSymbol')
                                        </label>
                                        <div class="col-md-7">
                                            <input type="text" class="form-control"
                                            placeholder="@lang('layout.EnterMeasureSymbol')"
                                            v-model.trim="selectedMeasure.symbol">
                                            <span class="help-block">  </span>
                                        </div>
                                    </div>
                                </div>

                            </span>
                        </div>

                    </div>

                </div>
                <h3 slot="header">
                    <div class="col-md-4">
                        <h3>
                            @lang('layout.AddNewMeasure')
                        </h3>
                    </div>
                    <div class="col-md-4">
                        <div v-if="fieldErrors.length > 0">
                            <p class="text-danger" fieldErrors>
                                <spna v-text="fieldErrors"></spna>
                            </p>
                        </div>
                    </div>
                </h3>
                <div slot="footer">
                    <button type=button class="modal-default-button" v-on:click="addMeasure">
                        @lang('layout.OK')
                    </button>
                    <button type=button class="modal-default-button"
                    v-on:click="showMeasureModal = false , showInvModal = true ,measure = null , type=null">
                    @lang('layout.Cancel')
                </button>
                </div>
            </modal>
        </div>
        <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script type="text/javascript">

    @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

        Vue.use(VueInputAutowidth);
        Vue.use(VueNumeric.default);

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],
            created() {
                console.log('rrrrr');
            }

        });       
        
         Vue.component("MarginMarkupmodal", {
            template: "#modal-template",
            props: ['show'],
            created() {
            }

        });


        

        document.onkeydown = function (e) { 
        // save invoice by shif && enter
            if (e.ctrlKey && e.which == 13) {
                v.callOnItemloadGeneral();
            }
        }





        Vue.component('v-select', VueSelect.VueSelect);
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    classes: [],
                    selectedClass: null,
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Vendor") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_vendor = response.customer;
                        }
                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        /// inventory model
        var invm = null;
        Vue.component("invmodal", {
            template: '#invmodal-template',

            props: ['show'],
            data() {
                return {
                    measureList: [],
                    categories: [],
                    income: [],
                    cost: [],
                    asset: [],
                    rate: 0,
                    description: null,
                    number: null,
                    category: null,
                    selectMeasure: null,
                    incomeAccount: null,
                    costAccount: null,
                    assetAccount: null,
                }
            },
            created() {
                axios.get('{{route("inventory.create")}}', {
                        params: {
                            add_item: 'on'
                        }
                    }).then(
                    response => {
                        this.measureList = response.data.measure;
                        this.categories = response.data.category;
                        this.number = response.data.number;
                        this.income = response.data.income;
                        this.cost = response.data.cost;
                        this.asset = response.data.asset;
                        if(this.measureList.length>0)
                        {
                            this.selectMeasure=this.measureList[0];
                        }
                        if(this.income.length>0)
                        {
                            this.incomeAccount=this.income[0];
                        }
                        if(this.cost.length>0)
                        {
                            this.costAccount=this.cost[0];
                        }
                        if(this.asset.length>0)
                        {
                            this.assetAccount=this.asset[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
                showMeasureModal() {
                    invm = this;
                    v.showMeasureModal = true;
                    v.showInvModal = false;
                },

                onSubmit() {
                    var ivn = this;
                    v.showInvModal = false;
                    var datas = $("#modalFormInv").serializeArray();
                    // console.log(123,datas);
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("inventory.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'type': datas[1]['value'],
                            'number': datas[2]['value'],
                            'gauge': datas[3]['value'],
                            'rate': datas[4]['value'],
                            'description': datas[5]['value'],
                            'asset_account': this.assetAccount.id,
                            'um_id': this.selectMeasure.id,
                            'income_account': this.incomeAccount.id,
                            'cost_account': this.costAccount.id,
                            'cost': 1,
                            'category': (this.category) ? this.category.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        // console.log(123, response);
                        if (response) {
                            v.selected_inventory = null;
                            v.selected_inventory = response.item;
                        }
                        axios.get('{{route("inventory.create")}}', {
                            params: {
                                saveAndNew: 'on'
                            }
                        }).then(response => {
                            // console.log(1239, response);
                            ivn.number = response.data;
                            document.getElementById("modalFormInv").reset();
                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });
        /// inventory model

        function callSaveTemp() {
            @if(saveTempData() == 'true')
            setTimeout((function () {
                v.saveTemp();
                // console.log(12);
            }), 4e4)
            @endif
        }

        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var inventory_category = {!! $inventory_category !!};
        var memberClass = {!! $memberClass !!}; 
        let homeCurrency = {!! json_encode(getHomeCurrency()) !!}; 
        let ratesFetched = {!! $rates !!}; 
        var driver = {!! $driver !!};
        var vehicle = {!! $vehicle !!};
        var expense = {!! $expense !!}; 
        var pay_number = {!! $pay_number !!}; 
        var inventoryBrand = {!! $inventoryBrand !!}; 

        var v = new Vue({
            el: '#app',
            data: {
                dynamic_time:'',    
                number: "{{$number}}",
                old_number: "{{$number}}",
                number_msg: '',
                number_Error: false,
                editKey: false,
                showModal: false,
                showInvModal: false,
                driver_type: 'OwnDriver',
				showInfoModal: false,
				showMarginMarkupModal: false,
				disabled: false,
				differentRate: false,
                sub_price: true,
                brand: null,
                location: null,
                SNumber: null,
                vendor: [],
                all_vendor: [],
                selected_vendor: null,
                contract: [],
                selected_contract: null,
                banks: banks,
                selected_banks: null,
                currency: currency,
                selected_currency: {!!json_encode(getHomeCurrency()) !!},
                per_qty_check: false,
                sale_price: false,
                showModalPurchaseOrder: false,
                purchase_orders: false,
                purchaseOrderList: [],
                selected_purchase_order: null,
                inventory_category: inventory_category,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,
                brandItem: inventoryBrand,
                selected_iventory_brand: null,
                wagon_number: null,
                date: null,
                overdue_date: null,
                other_member_name: null,
                simple_driver_data: [{
                    cost: null,
                    description: null,
                    description2: null,
                    driver_name: null,
                    other_measure: null,
                    other_measure2: null,
                    vehicle_name: null,
                    wagon_number: null
                    }
                ],
                print_description: null,
                bill_description: null,
                rate: 0,
                temp_items: [],
                temp_driver_item: [],
                totalAmountes: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [
                    {inventory: null, item: null, item_category: null, item_brand: null, farmer_type: null, driver_type: 'OwnDriver', vehicle: null, tanker: null, driver: null, sub_price: null, contract_differ: null,currency_list:currency, currency: homeCurrency,new_sale_price:null},
                ],
				driver_data: [
                    {item: null, inventory:null,driver: null,vehicle:null,currency_list:currency, currency: homeCurrency,info:null},
                ],
                payments: [],
                rows: [
                    {
                        amount: null,
                        description: null,
                        items: expense,
                        item: null
                    },
                    {
                        amount: null,
                        description: null,
                        items: expense,
                        item: null
                    },
                ],
                expense:expense,
                selected_expense_account:null,
                discountFiled: 0,
                discountFiledRow: 0,
                discountIsAmount: false,
                memberClass: memberClass,
                selected_class: null,
                contract_items: [],
                summary: [],
                ref_no: '',
                msg: '',
                isError1: false,
                vehicle:vehicle,

                //begin Margin and markup vars
                item_name:null,
                markup_c:null,
                margin_c:null,
                margin_new:null,
                markup_new:null,
                current_cost:null,
                current_rate:null,
                sale_rate_new:null,
                change_sale_price:false,
                pay_number:pay_number,
                farmer_contract_list:[],
                selectedFarmerContract:null,

                p_total: false,
                item_not_found: false,
                counter_check: 0,
                counter_check1: 1,
                counter_check2: -1,
                selected_inventory: null,
                selected_inventory1: null,
                inventory_sites1: [],
                selected_iventory_site: null,
                selected_item: null,
                selected_quantity: null,
                selected_price: null,

                showMeasureModal: false,
                fieldErrors: [],
                selectedMetric: {},
                senddata: {},
                selectedMeasure: {},
                metricList:{!!json_encode(getMeasures())!!},
                check_with_key: false,

            },
            created: {
                // alert('ii',inventories);
            },
            computed: {
                setRates() { 
                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    static_rate: a.static_rate,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: a.rate,
                                    hq_rate: r.hq_rate,
                                    pay_number:pay_number
                                })
                            }
                        });
                    });

                    return rates;

                },
                selectedRate() {
                    if(this.selected_currency){ 
                        var newrate = (this.selected_currency) ? this.selected_currency.rate : 0; 
                        if (this.discountIsAmount && this.discountFiled && this.rate > 0 && this.selected_currency.rate > 0) { 
                            this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                            // this.discountFiled = ((this.discountFiled / this.rate) * this.selected_currency.static_rate / newrate);
                           
                        } 
                        this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                        for (var i = 0; i < this.inventories.length; i++) {
                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                if (this.inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                }
                                if (this.inventories[i].item.sale_price_new) { 
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.sale_price = this.inventories[i].item.sale_price_new * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.sale_price = this.inventories[i].item.sale_price_new * this.selected_currency.rate;
                                    @endif
                                }
                            }
                        }
                    }
                },
                discount() {
                    if (this.discountIsAmount) {
                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {
                        return this.discountFiled
                    }
                },

				
				// calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

                            var quantity = this.inventories[i]['item']['quantity'];
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var discount = this.inventories[i]['item']['discount'];
                            var contract_differ = this.inventories[i]['contract_differ'];
                            // console.log(32, new_rate , rate);
                            if (new_rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
								
								if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
									sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif 
                                }
								}
                            }
                            else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
								
								if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
									}
								} else { 
									if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
								}
                            }
                            
                            if (quantity > 0 && contract_differ != null && contract_differ != '') {
                                sum += (quantity * (Number.parseFloat(contract_differ)));
                            }

                        }
                        // this.totalAmountes=sum;

                    }
                    // for (var i = 0; i < this.services.length; i++) {
                    //     if (this.services[i].item)
                    //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                    // }
                    
                    
                    for (var i = 0; i < this.rows.length; i++) {
                        if (this.rows[i].item){
                            sum += this.rows[i]['item']['amount'];
                        }
                    }
					
					this.discountFiledRow = sum_discount;
					
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    this.differentRate = false;
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                                @endif

                                if (this.selected_currency.code == this.payments[i]['item']['code'] && this.payments[i]['item']['amount']) {
                                    if (this.selected_currency.rate != this.payments[i]['item']['rate']) {
                                        this.differentRate = true;
                                    }
                                }
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                @if(getAddItemWithZeroRate() != 'true')
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }
                                @endif

                            }
                        }
                    }
                    if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
            },
            mounted: function () {
                var selected_banks = null;
                var bank=_.find(this.banks,(v)=>v.id=={!! getDropdown('bill', 'account') !!});
                if (bank) {
                    selected_banks = bank;
                }

                this.payments.push({
                    items: this.banks,
                    item: selected_banks
                });


                @if(saveTempData() == 'true')
                axios.get("{{route('temp.bill.getData')}}", {
                    params: {
                        type: 'bill'
                    }
                })
                .then(function(response) {
                        // console.log('myrespo1', response);
                    if (response.data) {
                    if (response.data.form) {
                        
                        // v.purchase_orders = true;

                        v.bill_description = response.data.form.description;
                        v.number = response.data.form.number;
                        v.ref_no = response.data.form.ref_no;
                        v.date = response.data.form.date;
                        v.overdue_date = response.data.form.overdue_date;
                        v.other_member_name = response.data.form.other_member_name;
                        v.print_description = response.data.form.print_description;

                        if (response.data.form.member_id) {
                            v.selectMemeber(response.data.form.member_id);
                        }
                        if (response.data.form.class_id) {
                            v.selected_class = _.find(v.memberClass, (c) => c.id == response.data.form.class_id);
                        }
                        if (response.data.contract) {
                            v.selected_contract = response.data.contract;
                            v.wagon_number = response.data.form.contract_check;
                            v.contract_items = response.data.items;
                        }

                        v.discountFiled = response.data.form.discount;
                        if (response.data.form.discount_type) {
                            if (response.data.form.discount_type == 'percent') {
                                v.discountIsAmount = false;
                            }
                            else {
                                v.discountIsAmount = true;
                            }
                        }

                        for (var a = 0; a < v.currency.length; a++) {
                            if (v.currency[a].code == response.data.form.currency) {
                                v.selected_currency = v.currency[a];
                                v.selected_currency.rate = response.data.form.rate;
                            }
                        }

                    }
                    if (response.data.items) {
                    if (response.data.items.length > 0) {
                        v.inventories = [];
                        for (var r = 0; r < response.data.items.length; r++) {
                            // console.log(321,response.data.items[r]);
                            v.inventories.push({
                                inventory: response.data.items[r],
                                item: response.data.items[r],
                                item_category: response.data.items[r].item_category,
                                item_brand: null,
                                location: null,
                                inventory_description: null,
                                model: null,
                                color: null,
                                expire_date: null,
                                farmer_type: null,
                                driver_type: 'OwnDriver', vehicle: null, tanker: null, driver: null, sub_price: null,contract_differ: null,currency_list:currency, currency: homeCurrency,
                                new_sale_price: response.data.items[r].sale_price
                            });
                        }
                        for (var m = 1; m > response.data.items.length; m--) {
                            v.inventories.push(
                                {inventory: null, item: null, item_category: null, location: null, inventory_description: null, model: null, color: null, expire_date: null, item_brand: null, farmer_type: null, driver_type: 'OwnDriver', vehicle: null, tanker: null, driver: null, sub_price: null, contract_differ: null,currency_list:currency, currency: homeCurrency,new_sale_price:null}
                            );
                        }
                        
                    }
                    }
                    if (response.data.payment) {
                        if (response.data.payment.length > 0) {
                            v.payments = [];
                            for (var t = 0; t < response.data.payment.length; t++) {
                                var foundFlag = false;
                                var tempBank = null;
                                for (var y = 0; y < v.banks.length; y++) {
                                    if (response.data.payment[t].recevie_payment_id == v.banks[y].id) {
                                        foundFlag = true;
                                        tempBank = v.banks[y];
                                        tempBank.amount = response.data.payment[t].amount;
                                        tempBank.rate = response.data.payment[t].rate; 
                                        tempBank.description = response.data.payment[t].description;
                                        tempBank.number = response.data.payment[t].number;
                                    }
                                }
                                if (foundFlag) {
                                    v.payments.push({item: tempBank, items: v.banks});
                                }
                            }
                            v.payments.push({item: null, items: v.banks});
                        }
                    }
                    if (response.data.driver) {
                        v.simple_driver_data = response.data.driver
                    }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
                @endif
                
                callSaveTemp();

                // console.log(123, selected_iventory_site, this.inventories);
            },
            methods:
                {
                    //BEGIN - Used for dynamic input time
                    dynamicTime()
                        {
                            this.time_interval = setInterval(() => {
                                const now = new Date()
                                @if(getHourType() == 24)
                                    const hours = now.getHours().toString().padStart(2,'0')
                                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                                    this.dynamic_time = `${hours}:${minutes}`
                                @else
                                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                                    this.dynamic_time = `${timeString}`
                                @endif
                                
                            },1000);
                        },
                        stopDynamicTime()
                        {
                            clearInterval(v.time_interval)
                        },
                        changeTime()
                        {
                            v.dynamic_time = v.$refs.time_input.value
                        },
                    //END - Used for dynamic input time
                    getSummary() {
                        if (this.selected_vendor) {
                            this.getSummaryRecor(this.selected_vendor.id, this);
                        }
                    },
                    getSummaryRecor(id, v) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.summary = response.data;
                            } else {
                                v.summary = [];
                            }
                        })
                        .catch(function(error) {
                            v.summary = [];
                            console.log(error);
                        });
                    }, 

                    changeContractDiffer() {
                        if(this.selected_currency && this.selected_contract){
                            if (this.selected_contract.Currency && this.selected_contract.Rate) {
                                for (var i = 0; i < this.inventories.length; i++) {
                                    if (this.inventories[i].item && this.inventories[i].item != null) {
                                        var pos_neg_amount = 0;
                                        if(this.selected_contract.pos_neg_amount && this.selected_contract.pos_neg_type){
                                            pos_neg_amount = (this.selected_contract.pos_neg_type == 'negative')? Number.parseFloat(-this.selected_contract.pos_neg_amount) : Number.parseFloat(+this.selected_contract.pos_neg_amount);
                                        }
                                        @if(systemConfig()[30] == 1)
                                        pos_neg_amount = ((pos_neg_amount / this.selected_contract.Rate) * this.selected_currency.static_rate / this.selected_currency.rate);
                                        @else 
                                        pos_neg_amount = ((pos_neg_amount / this.selected_contract.Rate) * this.selected_currency.rate);
                                        @endif 
                                        this.inventories[i].contract_differ = pos_neg_amount;
                                    }
                                }
                            }
                        }
                    }, 
                    checkRefNo() { 
                        //console.log(vm.ref_no) 
                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) { 
                            axios.get("{{route('callMethod.search')}}",
                                { 
                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'purchases'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    checkNo() {
                        var chack = 'false';
                        var number = v.number;
                        if (number != null) {
                            axios.get("{{route('callMethod.search')}}", {

                                    params: {
                                        number: v.number,
                                        method_name: 'Search_number',
                                        table_name: 'purchases'
                                    },
                                })
                                .then(function(response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        // console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.number_msg = "@lang('layout.DuplicateData')";
                                        v.number_Error = true;
                                    } else {
                                        v.number_msg = 'no';
                                        v.number_Error = false;

                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });

                        }
                    },
                    contractChange() {
                        if (this.selected_contract) {
                            if (this.selected_contract.Currency) {

                                this.selected_currency = _.find(this.currency, (c) => c.code == this.selected_contract.Currency);
                                this.selected_currency.rate = this.selected_contract.Rate;

                                var pos_neg_amount = 0;
                                if(this.selected_contract.pos_neg_amount && this.selected_contract.pos_neg_type){
                                    pos_neg_amount = (this.selected_contract.pos_neg_type == 'negative')? Number.parseFloat(-this.selected_contract.pos_neg_amount) : Number.parseFloat(+this.selected_contract.pos_neg_amount)
                                }
                                
                                this.contract_items = [];
                                axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'contractItems',
                                        member_id: this.selected_vendor.id,
                                        contract_id: this.selected_contract.id
                                    }
                                })
                                    .then(function (response) {
                                        if (response.data.length > 0) {
                                            v.inventories = [];
                                            v.contract_items = response.data;
                                            v.temp_items = response.data;
                                            // console.log(33, response.data);
                                            for (var m = 0; m < v.contract_items.length; m++) {
                                                v.inventories.push({
                                                    inventory: v.contract_items[m],
                                                    item_category: null,
                                                    item_brand: null,
                                                    farmer_type: null,
                                                    item: v.contract_items[m],
                                                    driver_type: 'OwnDriver',
                                                    vehicle: null, 
                                                    location: null,
                                                    inventory_description: null,
                                                    model: null,
                                                    color: null,
                                                    expire_date: null,
                                                    tanker: null, 
                                                    driver: null,
                                                    sub_price: null,
                                                    contract_differ: pos_neg_amount,
                                                    currency_list:currency, 
                                                    currency: homeCurrency
                                                });
                                                
                                            }
                                            // console.log('ffff', v.inventories);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                    });
                            }
                        }
                    },
                     // chack_member_payable_levels
                    member_chack() {
                        var chack = 'false';
                        var member_id = this.selected_vendor.id;
                        if (member_id != null) {
                            var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                            var currency = $("input[name=currency]").val();
                            $.ajax({
                                url: "{{route('callMethod.search')}}",
                                async: false,
                                data: {
                                    member_id: member_id,
                                    method_name: 'Search_member_payable_levels',
                                    currency: currency,
                                    type:'vendor'
                                },
                                success: function(data) {
                                    // console.log('RRRRR',data)
                                    var r_amount = Number.parseFloat(data.amount);
                                    var r_m_amount = Number.parseFloat(data.m_amount);
                                    var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));

                                    if (r_amount != 0 && r_amount < totalss) {
                                        chack = 'true';
                                    } else {
                                        chack = 'false';
                                    }
                                }.bind(this),
                                error: function(error) {
                                    console.log(error)
                                }
                            });
                        }
                        return chack;
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                            if (v.member_chack() == 'true') {
                                var r = confirm("@lang('layout.member_payable_levels_vendor')");
                                if (r == true) {
                                    v.disabled = true;
                                    v.submitForm(e.target);
                                }
                            } else {
                                v.disabled = true;
                                v.submitForm(e.target);
                            }
                            }
                        });
                    },
					
					showInfo(index) {
						if (v.inventories[index].item != null) {
						v.showInfoModal = true;
						v.brand =    v.inventories[index]['item']['brand'];
						v.location = v.inventories[index]['item']['location'];
						v.SNumber = v.inventories[index]['item']['number'];
						// console.log('ffff',v.inventories[index]);
						}
                    },
                    showMarginMarkup(index) {
						if (v.inventories[index].item != null) {
                            v.selected_index = index;
						v.showMarginMarkupModal = true;

						v.SNumber = v.inventories[index]['item']['number'];
						v.item_name = v.inventories[index]['item']['name'];

                        var rate=v.inventories[index]['item']['sale_price'];
                        var cost=v.inventories[index]['item']['new_rate'];
                        var cost_old=v.inventories[index]['item']['rate'];

                        var resultCurrentMargin = (100*rate)/cost_old;
                        var markupCurrent = resultCurrentMargin-100;
                        resultCurrentMargin = myRound((markupCurrent*cost_old)/rate);

                        var resultCurrentMarkup  = (100*rate)/cost_old;
                        resultCurrentMarkup = myRound(resultCurrentMarkup-100);

                        var resultNewSalePrice = 0;
                        var total =Number.parseFloat(resultCurrentMarkup)+100;
                        resultNewSalePrice = (cost*total)/100;


                        var res_cu_markup  = (100*rate)/cost;
                        res_cu_markup = myRound(res_cu_markup-100);


						v.markup_c = res_cu_markup;
						v.margin_c = resultCurrentMargin;
                        
                        @if(systemConfig()[30] == 1)
                        v.current_cost = v.inventories[index]['item']['rate']* v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.current_cost = v.inventories[index]['item']['rate']* v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
                        v.current_rate = v.inventories[index]['item']['sale_price']* v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.current_rate = v.inventories[index]['item']['sale_price']* v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
						v.sale_rate_new = resultNewSalePrice* v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
						v.sale_rate_new = resultNewSalePrice* v.selected_currency.rate;
                        @endif

                        @if(systemConfig()[30] == 1)
                        var new_s_rate = v.sale_rate_new/ v.selected_currency.static_rate * v.selected_currency.rate;
                        @else 
                        var new_s_rate = v.sale_rate_new/v.selected_currency.rate;
                        @endif


                        var resultMarkup  = (100*new_s_rate)/cost;
                        resultMarkup = myRound(resultMarkup-100);

						v.markup_new = resultMarkup;


                        var resultm = 0;
                        var result1 = (100*rate)/cost;
                        var markup = result1-100;
                        resultm = myRound((markup*cost)/rate);

                        v.margin_new = (resultMarkup*cost)/v.sale_rate_new;

               
                
						}
                    },
                    chacge_sale_price(index)
                    {
                        if (v.change_sale_price == false) {
                                v.change_sale_price = true;
                                v.inventories[index]['new_sale_price'] = v.sale_rate_new;
                                // console.log('ffffbbbbbbbb',index,v.inventories[index]['new_sale_price'],v.change_sale_price);
                                v.change_sale_price = false;  
                            }else{
                                v.change_sale_price = false;
                            } 
                    },

                    addMeasure: function () {
                        let senddata = _.clone(this.selectedMetric);
                        senddata.measure = _.clone(this.selectedMeasure);

                        var req = axios.post("{{route('measure.store')}}",senddata)
                        .then(function (response) {
                            if (response) {
                                if (response.data) {
                                    // var measure_id = response.data.me.id;
                                    invm.selectMeasure = response.data.me;
                                    // console.log(444, response, measure_id);
                                }
                            }
                            v.showMeasureModal = false;
                            v.fieldErrors = [];
                            v.selectedMetric = {};
                            v.selectedMeasure = {};

                            axios.get("{{route('inventory.create')}}").then(function (response) {
                                invm.measureList = response.data;
                                v.showInvModal = true;
                            });
                        })
                        .catch(function (error) {
                            axios.get("{{route('inventory.create')}}").then(function (response) {
                                invm.measureList = response.data;
                                v.showInvModal = true;
                            });

                            v.fieldErrors = error.response.data

                        });

                    },

                    subPrice() {
                        if (v.sub_price == false) {
							v.sub_price = true;
                        }else{
							v.sub_price = false;
						}
						// console.log(v.sub_price);
                    },

                    subMQuantity(item = null, quantity = null) {
						if (item != null) {
							var result = 0;
							if (item.site) {
								if(item.measure_list && item.measure1){
								// console.log(383830000, Object.keys(item.measure_list).length);
                                    for (var i in item.measure_list) {
								// console.log(3838,i,item.measure_list[i],item.measure_unit,item.measure.measure_unit);
									if (item.measure_list[i].measure_id == item.measure1) {
										result = (quantity * item.measure.measure_unit) / (item.measure_unit);
										result = (result * item.measure_unit) / (item.measure_list[i].measure_unit);
									}
								}
                                }
							}
							return result;
						}
					},

                    secoundMeasurQuantity(item = null, quantity = null) {
						if (item != null) {
							var result = 0;
							if (item.site) {
								// console.log(3838399,item.measure_list, item.measure1);
								if(item.measure_list && item.measure1){
                                    for (var i in item.measure_list) {
								// console.log(3838,item.measure_list[i],item.measure_unit,item.measure.measure_unit);
									if (item.measure_list[i].measure_id == item.measure1) {
										result = (quantity * item.measure.measure_unit) / (item.measure_unit);
										result = (result * item.measure_unit) / (item.measure_list[i].measure_unit);
									}
								}
                                }
							}
							return result;
						}
					},

					setNewRateTotal(index = null) {
						if (this.inventories[index].item && this.inventories[index].sub_price > 0 ) {
						if (this.inventories[index].item.measure1) {
							var item = this.inventories[index].item;
							var sub_quantity = v.subMQuantity(item,item.quantity);
							var sub_price = this.inventories[index].sub_price;
							var total_price = (sub_quantity * sub_price);
							var quantity = item.quantity;
							if(quantity > 0){
                                if(this.selected_currency.rate > 0){
                                    @if(systemConfig()[30] == 1)
                                    item.new_rate = myRound((total_price/quantity)/this.selected_currency.static_rate * this.selected_currency.rate);
                                    @else 
                                    item.new_rate = myRound((total_price/quantity)/this.selected_currency.rate);
                                    @endif

                                }else{
                                    item.new_rate = myRound(total_price/quantity);
                                }
							}
							// console.log('asda changed111', sub_quantity,item.quantity,sub_price,item);
						}
						}
                    },

                    // calculate item price based on measure change
                    measure1Change(index) {
                        if (this.inventories[index].item != null) {
							if(this.inventories[index].item.quantity > 0 && this.inventories[index].sub_price > 0){
								if (this.inventories[index].item.measure1) {
									var item = this.inventories[index].item;
									var sub_quantity = v.subMQuantity(item,item.quantity);
									var sub_price = this.inventories[index].sub_price;
									var total_price = (sub_quantity * sub_price);
									var quantity = item.quantity;
									if(quantity > 0){
                                        if(this.selected_currency.rate > 0){
                                            @if(systemConfig()[30] == 1)
                                            item.new_rate = myRound((total_price/quantity)/this.selected_currency.static_rate * this.selected_currency.rate);
                                            @else 
                                            item.new_rate = myRound((total_price/quantity)/this.selected_currency.rate);
                                            @endif

                                        }else{
                                            item.new_rate = myRound(total_price/quantity);
                                        }
									}
								}
							}
                        }
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;
                            
                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            if(this.inventories[index].item.quantity > 0 && this.inventories[index].sub_price > 0){
								if (this.inventories[index].item.measure1) {
									var item = this.inventories[index].item;
									var sub_quantity = v.subMQuantity(item,item.quantity);
									var sub_price = this.inventories[index].sub_price;
									var total_price = (sub_quantity * sub_price);
									var quantity = item.quantity;
									if(quantity > 0){
                                        if(this.selected_currency.rate > 0){
                                            @if(systemConfig()[30] == 1)
                                            item.new_rate = myRound((total_price/quantity)/ this.selected_currency.static_rate * this.selected_currency.rate);
                                            @else 
                                            item.new_rate = myRound((total_price/quantity)/this.selected_currency.rate);
                                            @endif
                                        }else{
                                            item.new_rate = myRound(total_price/quantity);
                                        }
									}
								}
							}


                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_vendor) {
                            // get member contract
                            this.contract = [];
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'member_contract',
                                    member_id: this.selected_vendor.id
                                }
                            })
                                .then(function (response) {
                                    if (response.data.length > 0) {
                                        v.contract = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                            this.purchaseOrderSearch(this.selected_vendor.id);

                            this.farmer_contract_list = [];
                            this.selectedFarmerContract = null;
                            this.selected_contract = null;
                            this.take_farmer_contract_data(this);
                        }
                    },

                    change_oil_qty(index) {
                        @if(getOtherMeasure()=="true")
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                            var oil_qty = this.inventories[index]['item']['other_measure'];
                            var quantity = this.inventories[index]['item']['quantity'];
                            var density = this.inventories[index]['item']['density'];
                            @if(getSelectQuantityByOtherMSPurch()=="true")
                                if (quantity > 0 && oil_qty > 0) {
                                    this.inventories[index]['item']['density'] = Number.parseFloat(oil_qty / quantity).toFixed(7);
                                } else if (quantity > 0 && density > 0) {
                                    this.inventories[index]['item']['other_measure'] = Number.parseFloat(quantity * density).toFixed(7);
                                }
                            @else
                                if (quantity > 0 && density > 0) {
                                    this.inventories[index]['item']['other_measure'] = Number.parseFloat(quantity / density).toFixed(7);
                                }
                            @endif
                        }
                        @endif
                    },

                    change_oil_density(index) {
                        @if(getOtherMeasure()=="true")
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                            var oil_qty = this.inventories[index]['item']['other_measure'];
                            var quantity = this.inventories[index]['item']['quantity'];
                            var density = this.inventories[index]['item']['density'];
                            @if(getSelectQuantityByOtherMSPurch()=="true")
                                if (density > 0 && oil_qty > 0) {
                                    this.inventories[index]['item']['quantity'] = Number.parseFloat(oil_qty / density).toFixed(7);
                                } else if (density > 0 && quantity > 0) {
                                    this.inventories[index]['item']['other_measure'] = Number.parseFloat(quantity * density).toFixed(7);
                                }
                            @else
                                if (quantity > 0 && density > 0) {
                                    this.inventories[index]['item']['other_measure'] = Number.parseFloat(quantity / density).toFixed(7);
                                }
                            @endif
                        }
                        @endif
                    },
                    change_qty_by_oil(index) {
                        @if(getOtherMeasure()=="true")
                            if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                                var oil_qty = this.inventories[index]['item']['other_measure'];
                                var quantity = this.inventories[index]['item']['quantity'];
                                var density = this.inventories[index]['item']['density'];
                                @if(getSelectQuantityByOtherMSPurch()=="true")
                                    if (oil_qty > 0 && density > 0) {
                                        this.inventories[index]['item']['quantity'] = Number.parseFloat(oil_qty / density).toFixed(7);
                                    } else if (oil_qty > 0 && quantity > 0) {
                                        this.inventories[index]['item']['density'] = Number.parseFloat(oil_qty / quantity).toFixed(7);
                                    }
                                @else
                                    if (oil_qty > 0 && quantity > 0) {
                                        this.inventories[index]['item']['density'] = Number.parseFloat(quantity / oil_qty).toFixed(7);
                                    }
                                @endif
                            }
                        @endif
                    },

                    selectMemeber(id = null) {
                        if (id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    id: id,
                                    type: 'Vendor'
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    // console.log(response.data);
                                    v.selected_vendor = null;
                                    v.selected_vendor = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    memberClassChange() {
                        if (v.selected_class) {
                            v.vendor = [];
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Vendor'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.vendor = [];
                                    v.vendor = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Vendor'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.vendor = [];
                                v.vendor = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    // set new price
                    setNewRate(index) {
                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                            @endif 
                        }  
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.sale_price) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.sale_price_new = this.inventories[index].item.sale_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.sale_price_new = this.inventories[index].item.sale_price / this.selected_currency.rate;
                                @endif 
                            }
                        }
                        // if (this.inventories[index].item) {
                        //     this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        //     this.inventories[index].item.cost = this.$refs.in[index].value / this.selected_currency.rate;
                        // }
                    },

                    setQuantityByTotal(index) {
                        if (v.counter_check == 0) {
                            v.counter_check = 1;
                            setTimeout((function () {
                                v.counter_check1 = v.$refs.total[index].value;
                                v.setQuantityByT(index);
                            }), 2e2)
                        }  
                    },
                    setQuantityByT(index) {
                        setTimeout((function () {
                            v.counter_check2 = v.$refs.total[index].value;
                            v.setQuantityByTotals(index);
                        }), 2e3)
                    },
                    setQuantityByTotals(index) {
                        if (v.counter_check1 != v.counter_check2) {
                            v.counter_check1 = v.$refs.total[index].value;
                            v.setQuantityByT(index);
                        }else{
                            v.p_total = true;
                            if (v.$refs.total[index].value) {
                                if (v.inventories[index].item) {
                                    if (v.inventories[index]['item']['quantity']) {
                                        var quantity = v.inventories[index]['item']['quantity']; 
                                        @if(systemConfig()[30] == 1)
                                        v.inventories[index].item.new_rate = (v.$refs.total[index].value / quantity) / v.selected_currency.static_rate * v.selected_currency.rate;
                                        @else
                                        v.inventories[index].item.new_rate = (v.$refs.total[index].value / quantity) / v.selected_currency.rate;
                                        @endif 
                                        v.inventories[index].item.cost = v.$refs.total[index].value / quantity;
                                    }
                                }
                            }
                            v.counter_check = 0; 
                        }
                    },

                    take_farmer_contract_data(vm) {
                        axios.get("{{route('member.farmerContract')}}", {
                            params: {
                                member_id: this.selected_vendor.id
                            },
                        }).then(function (response) {
                            vm.farmer_contract_list = response.data;
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                    }, 

                    // set new price
                    TotalTransferFee(index) {
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.rent_quantity) {
                                this.inventories[index].itransfer_total = myRound(this.inventories[index].item.rent_quantity * this.inventories[index]['transfer_fee']);
                            }
						}
                    },

                    // set new price
                    setRentQuantity(index) {
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.quantity) {
                                this.inventories[index].item.rent_quantity = this.inventories[index].item.quantity;
                                this.TotalTransferFee(index);
                            }
						}
                    },
					
					vehicleSearch(index) {
						var plate = null;
						if (v.inventories[index].item) {
                          plate = v.inventories[index]['driver']['plate'];
                          v.driver_type = v.inventories[index]['driver']['driver_type'];
						  v.inventories[index]['driver_type'] = v.inventories[index]['driver']['driver_type'];
							// console.log('222',v.inventories[index]['driver']['driver_type']);
							// console.log(v.inventories[index]['transfer_fee'] ,v.inventories[index].item.quantity , v.inventories[index]['transfer_fee']);
						}
						if(plate != null){
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                            .then(function (response) {
								
                                if (response.data.result != null) {
                                // console.log('1231',response.data);
                                    v.inventories[index]['vehicle'] = null;
                                    v.inventories[index]['vehicle'] = response.data.result;
                                }
                                // console.log('1231',v.inventories[index]);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
						}
                    },
					
					// detect member change and searh
                    carChange(index) {
                        if (v.inventories[index].item) {
                            if (v.inventories[index]['vehicle'].foreign_type == "ok") {
                                var currency = _.find(this.currency, (c) => c.code == v.inventories[index]['vehicle'].currency);
                                v.inventories[index]['vehicle'].rate = currency.rate;
                                // console.log('rrrnnss', currency);
                                // console.log('rrrnn', currency.Rate);
                            }
							
                            this.TankerSearch(v.inventories[index]['vehicle'].tanker_number, index, this);
                        }
                    },
					// detect member change and searh
                    tankerChange(index) {
                        if (v.inventories[index].item) {
                            if (v.inventories[index]['tanker'].foreign_type == "ok") {
                                var currency = _.find(this.currency, (c) => c.code == v.inventories[index]['tanker'].currency);
                                v.inventories[index]['tanker'].rate = currency.rate;
                                // console.log('rrrnnss', currency);
                            }
                        }
                    },
                    TankerSearch(plate, index, vm) {
						if(plate != null){
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                            .then(function (response) {
								
                                if (response.data.result != null) {
                                    v.inventories[index]['tanker'] = null;
                                    v.inventories[index]['tanker'] = response.data.result;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
						}
                    },

                    // begin purchase order search
                    purchaseOrderSearch(member_id = null) {
                        
                        this.purchaseOrderList = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberPurchaseOrder',
                                member_id: member_id,
                            }
                        })
                            .then(function (response) {

                                if (response.data.length > 0) {
                                    v.showModalPurchaseOrder = true;
                                    v.purchaseOrderList = response.data;
									console.log('qweqwew', response.data);

                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    },
                    // end purchase order search
                    // get selected sale order
                    getPurchaseOrders() {
                        this.showModalPurchaseOrder = false;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'purchaseOrderItems',
                                purchase_order_id: this.selected_purchase_order.id,
                                type: ''
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    console.log("Purchase order items",response.data)
                                    v.inventories = [];
                                    for (var r = 0; r < response.data.length; r++) {
                                        v.inventories.push({
                                            inventory: response.data[r],
                                            item: response.data[r],
                                            item_category: response.data[r].item_category,
                                            item_brand: null,
                                            farmer_type: null,
											driver_type: 'OwnDriver',
                                            vehicle: null, 
                                            location: null,
                                            inventory_description: null,
                                            model: null,
                                            color: null,
                                            expire_date: null,
											tanker: null, 
											driver: null,
											sub_price: null,
											contract_differ: null,
											currency_list:currency, 
											currency: homeCurrency
                                        });
                                    }
                                    v.inventories.push({inventory: null, item: null, location: null, inventory_description: null, model: null, color: null, expire_date: null, item_category: null, item_brand: null, farmer_type: null, driver_type: 'OwnDriver', vehicle: null, tanker: null, driver: null, sub_price: null, contract_differ: null,currency_list:currency, currency: homeCurrency});
                                    v.purchase_orders = true;
                                    console.log('test check', v.selected_purchase_order);
                                    v.invoiceDescription = v.selected_purchase_order.description;

                                    // if (v.selected_purchase_order.discount_type == 'currency' && v.selected_purchase_order.discount) {
                                    //     v.discountFiled = (Number.parseFloat(v.selected_purchase_order.discount) / ((v.selected_purchase_order.rate)?Number.parseFloat(v.selected_purchase_order.rate):1));
                                    // }else{
                                    // }

                                    v.discountFiled = v.selected_purchase_order.discount;
                                    if (v.selected_purchase_order.discount_type) {
                                        if (v.selected_purchase_order.discount_type == 'currency') {
                                            v.discountIsAmount = true;
                                        } else {
                                            v.discountIsAmount = false;
                                        }
                                    }
                                    for (var a = 0; a < this.currency.length; a++) {
                                        if (v.currency[a].code == v.selected_purchase_order.currency) {
                                            v.selected_currency = v.currency[a];
                                            v.selected_currency.rate = v.selected_purchase_order.rate;
                                            v.rate = v.selected_purchase_order.rate;
                                        }
                                    }

                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },

                    // begin item search

                    onItemSearch: _.debounce((search, loading) => {

                        loading(true);

                        // console.log('klk',v.inventories[v.selected_index]['item_category']);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
						if (!v.selected_contract) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
									v.temp_items = [];
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
							
						}else{
							loading(false);
							v.temp_items = [];
							v.temp_items = v.contract_items 
						}
                    }, getDebounceTime()),
                    
                    onItemload(index) {
                        v.selected_index = index;
						if (!v.selected_contract) {
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index]['item_category']);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchPurchase',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    inventory_brand_id: inventory_brand_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
										
                                        @if(getDefaultSite() > 0)
											var sites_id = {{getDefaultSite()}}
                                            for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                                if (v.inventories[index].item.site_list[i].site_id == sites_id) {
                                                    v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                                }
                                            }
                                        @else
                                            var sites_id = {{ getDropdown('bill', 'site') }}
                                            for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                                if (v.inventories[index].item.site_list[i].site_id == sites_id) {
                                                    v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                                }
                                            }
                                        @endif
										
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
						}else{
						if(v.inventories[index].inventory){
							var inventory_id = v.inventories[index].inventory.id;
							axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'contractItems',
                                    member_id: this.selected_vendor.id,
                                    contract_id: this.selected_contract.id,
                                    inventory_id: inventory_id
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
										
										@if(getDefaultSite() > 0)
											var sites_id = {{getDefaultSite()}}
										for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
											if (v.inventories[index].item.site_list[i].site_id == sites_id) {
												v.inventories[index].item.site = v.inventories[index].item.site_list[i];
											}
										}
                                        @endif
										
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
						}
						}
                    },

                    loadItemGeneral() {
                        if (v.selected_inventory != undefined) {
                            this.editKey = false;
                            var inventory_id = v.selected_inventory.id;
                        
                            // console.log(888, number);
                            let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemSearchPurchase',
                                        inventory_id: inventory_id,
                                        inventory_category_id: inventory_category_id,
                                    }
                                })
                                .then(function(response) {

                                    var rate = 0;
                                    var static_rate = 0;
                                    if (v.selected_currency.rate > 0) {
                                        rate = v.selected_currency.rate;
                                        static_rate = v.selected_currency.static_rate;
                                    }

                                    if (response.data.length > 0) {
                                        v.selected_item = null;
                                        v.selected_iventory_site = null;
                                        v.selected_item = response.data[0];
                                        @if(systemConfig()[30] == 1)
                                        v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(static_rate) / Number.parseFloat(rate));
                                        @else 
                                        v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate));
                                        @endif

                                        v.inventory_sites1 = response.data[0].site_list;  
                                        v.last_item_sale = response.data[0].last_item_sale;  
                                        // console.log(123, response.data[0]);

                                    }else{
                                        // $('#success-sound')[0].play();
                                        // $('#error-sound')[0].play();
                                        v.item_not_found = true;
                                        setTimeout((function () {
                                            v.item_not_found = false;
                                            v.$refs.barcode_search.$refs.search.focus();
                                        }), 2e3)
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })

                        }
                    },

                    callOnItemloadGeneral() {
                        this.editKey = false;
                        if (v.counter_check == 0) {
                            v.counter_check = 1;
                            @if(getBarcodeType()=="true")
                            setTimeout((function () {
                                v.counter_check1 = v.selected_inventory1;
                                v.call2();
                                // console.log(12);
                            }), 1e1)
                            @else
                            setTimeout((function () {
                                v.counter_check1 = v.selected_inventory1;
                                v.call2();
                                // console.log(12);
                            }), 2e2)
                            @endif
                        }
                    },
                    call2() {
                        @if(getBarcodeType()=="true")
                        setTimeout((function () {
                            v.counter_check2 = v.selected_inventory1;
                            v.onItemloadGeneral();
                            // console.log(13);
                        }), 1e1)
                        @else
                        setTimeout((function () {
                            v.counter_check2 = v.selected_inventory1;
                            v.onItemloadGeneral();
                            // console.log(13);
                        }), 2e2)
                        @endif
                    },
                    onItemloadGeneral(id = null) {
                        if (v.counter_check1 != v.counter_check2) {
                            v.counter_check1 = v.selected_inventory1;
                            v.call2();
                        }else{
                            this.editKey = false;
                            if (v.selected_inventory != undefined || id || v.selected_inventory1) {
                                
                                var inventory_id = id;
                                if (v.selected_inventory != undefined) {
                                    inventory_id = v.selected_inventory.id;
                                }

                                let number = v.selected_inventory1;

                                // console.log(888, number);
                                let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                                let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                                axios.get("{{route('callMethod.search')}}", {
                                        params: {
                                            method_name: 'itemSearchPurchase',
                                            inventory_id: inventory_id,
                                            inventory_category_id: inventory_category_id,
                                            inventory_site_id: inventory_site_id,
                                            number: number,
                                        }
                                    })
                                    .then(function(response) {
                                        if (response.data.length > 0) {
                                            var che = null;
                                            var checkD = true;

                                            var rate = 0;
                                            var static_rate = 0;
                                            if (v.selected_currency.rate > 0) {
                                                rate = v.selected_currency.rate;
                                                static_rate = v.selected_currency.static_rate;
                                            }

                                            @if(NotDuplicateItem() =="true")
                                            if (v.inventories != null && response.data[0].id) {
                                                for (var i = 0; i < v.inventories.length; i++) {
                                                    if (v.inventories[i].item && v.inventories[i].item != null) {
                                                        if (v.inventories[i].item.id == response.data[0].id) {
                                                            v.inventories[i].item.quantity = ( Number.parseFloat(v.inventories[i].item.quantity) + 1);
                                                            checkD = false;
                                                        }
                                                    }
                                                }
                                            }
                                            @endif

                                            if (checkD) {
                                                for (var i = 0; i < v.inventories.length; i++) {
                                                    if (v.inventories[i].item && v.inventories[i].item != null) {
                                                        che = 'ok';
                                                    } else {
                                                        v.inventories.splice(i, 1);
                                                    }
                                                }
                                                if(!che){
                                                    v.inventories = [];
                                                }
                                                // console.log(2121, response.data[0]);
                                                if (inventory_site_id) {
                                                    for (var i = 0; i < response.data[0].site_list.length; i++) {
                                                        if (response.data[0].site_list[i].site_id == inventory_site_id) {
                                                            response.data[0].site = response.data[0].site_list[i];
                                                        }
                                                    }
                                                }
                                                response.data[0].quantity = (v.selected_quantity > 0)?v.selected_quantity:1;

                                                if (v.selected_price > 0) {
                                                    response.data[0].cost = Number.parseFloat(v.selected_price);
                                                    @if(systemConfig()[30] == 1)
                                                    response.data[0].new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(static_rate) * Number.parseFloat(rate)):1;
                                                    @else 
                                                    response.data[0].new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                                                    @endif
                                                }
                                                

                                                v.inventories.unshift({
                                                    inventory: response.data[0],
                                                    item: response.data[0],
                                                    location: null,
                                                    item_category: response.data[0].item_category,
                                                    item_brand: response.data[0].inventory_brand,
                                                    farmer_type: null,
                                                    driver_type: 'OwnDriver',
                                                    vehicle: null, 
                                                    tanker: null, 
                                                    driver: null,
                                                    sub_price: null,
                                                    contract_differ: null,
                                                    currency_list:currency, 
                                                    currency: homeCurrency
                                                });

                                                v.selected_inventory = null;
                                                v.selected_inventory1 = null;
                                                v.counter_check = 0;
                                                v.temp_items = [];
                                                
                                                // const inp = v.$refs.barcode_search.$refs.search;
                                                // console.log(v.$refs.barcode_search.$refs.search.value);
                                                // v.$refs.barcode_search.$refs.search.focus();
                                                // v.$refs.barcode_search.$refs.search = null;
                                                v.$refs.barcode_search1.focus();

                                            }else{
                                                setTimeout((function () {
                                                    v.selected_inventory = null;
                                                    v.selected_inventory1 = null;
                                                    v.counter_check = 0;
                                                    v.$refs.barcode_search1.focus();
                                                }), 2e2)
                                            }
                                            
                                        }else{
                                            // $('#success-sound')[0].play();
                                            // $('#error-sound')[0].play();
                                            v.item_not_found = true;
                                            setTimeout((function () {
                                                v.item_not_found = false;
                                                v.selected_inventory = null;
                                                v.selected_inventory1 = null;
                                                v.counter_check = 0;
                                                v.$refs.barcode_search1.focus();
                                                // console.log(12);
                                            }), 2e3)
                                        }
                                    })
                                    .catch(function(error) {
                                        console.log(error);
                                    }) 
                            }
                        }
                    }, 
                    changeMesurss() {
                        setTimeout(() => {
                            if (v.selected_item) {
                                if (v.selected_item.measure && v.selected_item.measure_unit && v.selected_currency) {
                                    var rate = v.selected_currency.rate;
                                    var static_rate = v.selected_currency.static_rate;
                                    @if(systemConfig()[30] == 1)
                                    v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit))  * Number.parseFloat(static_rate) / Number.parseFloat(rate)).toFixed(precision());
                                    @else 
                                    v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * Number.parseFloat(rate)).toFixed(precision());
                                    @endif
                                }
                            } 
                        }, 300);
                    }, 
                    addData() {
                        if (v.selected_item) {
                            var che = null;
                            for (var i = 0; i < v.inventories.length; i++) {
                                if (v.inventories[i].item && v.inventories[i].item != null) {
                                    che = 'ok';
                                } else {
                                    v.inventories.splice(i, 1);
                                }
                            }
                            if(!che){
                                v.inventories = [];
                            }

                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
                            if (inventory_site_id) {
                                for (var i = 0; i < v.selected_item.site_list.length; i++) {
                                    if (v.selected_item.site_list[i].site_id == inventory_site_id) {
                                        v.selected_item.site = v.selected_item.site_list[i];
                                    }
                                }
                            }

                            var rate = 0;
                            var static_rate = 0;
                            if (v.selected_currency.rate > 0) {
                                rate = v.selected_currency.rate;
                                static_rate = v.selected_currency.static_rate;
                            } 
                            v.selected_item.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
                            if (v.selected_price > 0) {
                                v.selected_item.cost = Number.parseFloat(v.selected_price);
                            } 
                            @if(systemConfig()[30] == 1)
                            v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(static_rate) * Number.parseFloat(rate)):1;
                            @else 
                            v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                            @endif    
                            v.inventories.unshift({
                                inventory: v.selected_item,
                                item: v.selected_item,
                                item_category: v.selected_item.item_category,
                                item_brand: v.selected_item.inventory_brand,
                                farmer_type: null,
                                driver_type: 'OwnDriver',
                                vehicle: null, 
                                tanker: null, 
                                driver: null,
                                sub_price: null,
                                contract_differ: null,
                                currency_list:currency, 
                                currency: homeCurrency 
                            });

                            v.selected_inventory = null;
                            v.selected_inventory1 = null;
                            v.counter_check = 0;
                            v.temp_items = [];
                            // v.selectSaleNumber(0);
                            
                            // const inp = v.$refs.barcode_search.$refs.search;
                            // console.log(v.$refs.barcode_search.$refs.search.value);
                            v.$refs.barcode_search.$refs.search.focus();
                            // v.$refs.barcode_search.$refs.search = null;
                            // v.$refs.barcode_search.focus();

                            v.selected_item = null;
                            v.selected_price = 0;
                            v.selected_quantity = 0;
                            
                        }
                    },
                    
                    resetData() {
                        v.selected_inventory = null;
                        v.selected_item = null;
                        v.selected_iventory_site = null;
                        v.selected_price = 0;
                        v.selected_quantity = 0;
                        v.$refs.barcode_search.$refs.search.focus();
                    },

                    //ajax call to get items
                    setIndex(e) {
                        // v.temp_items=[];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                        if (!v.selected_contract) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                            let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id,
                                    inventory_brand_id: inventory_brand_id
                                }
                            })
                                .then(function (response) {
                                    if (v.purchase_orders) {
                                    } else {
                                        v.inventories[v.selected_index]['item'] = null;
                                        v.inventories[v.selected_index]['inventory'] = null;
                                    }
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }

                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }else{
							loading(false);
							v.temp_items = [];
							v.temp_items = v.contract_items 
						}

                        }

                    },

                    itemBrandChange(index) {
                        v.setIndex(index);

                        v.selected_iventory_brand = this.inventories[index]['item_brand'];
                        if (this.inventories[index]['item_brand'] != null) {
                        if (!v.selected_contract) {
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = this.inventories[index]['item_brand'].id; 
                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemesSearchSale',
                                        inventory_category_id: inventory_category_id,
                                        inventory_brand_id: inventory_brand_id
                                    }
                                })
                                .then(function(response) {
                                    if (v.purchase_orders) {
                                    } else {
                                        v.inventories[index]['item'] = null;
                                        v.inventories[index]['inventory'] = null;
                                    }
                                    v.temp_items = [];

                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });
                        }else{
                            loading(false);
                            v.temp_items = [];
                            v.temp_items = v.contract_items 
						}
                        }

                    },

                    // end item search

                    // contract search


                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        if (v.inventories[index] != undefined) {
                            v.selected_iventory_category = this.inventories[index]['item_category'];
                            v.selected_iventory_brand = this.inventories[index]['item_brand'];
                        }

                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
									this.temp_items = [];
                                    this.inventories.push({
                                        inventory: null,
                                        item: null,
                                        item_category: this.selected_iventory_category,
                                        item_brand: this.selected_iventory_brand,
                                        farmer_type: null,
										driver_type: 'OwnDriver',
                                        vehicle: null, 
                                        location: null,
                                        inventory_description: null,
                                        model: null,
                                        color: null,
                                        expire_date: null,
										tanker: null, 
										driver: null,
										sub_price: null,
										contract_differ: null,
										currency_list:currency, 
										currency: homeCurrency
                                    });
                                }
                            }
                            if (type == 'driver') {
                                if (this.driver_data[index + 1] == undefined) {
                                    this.temp_driver_item = [];

                                    let currency = _.clone(this.currency);

                                    this.driver_data.push({item: null, inventory:null,driver: null,vehicle:null,currency_list:currency, currency: homeCurrency,info:null});
                                
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            } 
                            if (type == 'expense') {
                                if (this.rows[index + 1] == undefined) {
                                    this.rows.push({
                                        amount: null,
                                        description: null
                                    });
                                }
                            }
                        }
                        
                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp; 
                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        this.editKey = false;
                        if (type != null) {
                            // console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                            if(type=='driver')
                            {
                                this.driver_data.splice(index,1);
                            } 
                            if(type=='expense')
                            {
                                this.rows.splice(index,1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        v.disabled = true;
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("purchase-form").submit()
                            }
                            else {
                                v.disabled = false;
                            }
                        });

                    },

                    defaultValue() {
                        this.selected_vendor = null;
                        this.selected_contract = null;

                        this.inventories = [
                            {inventory: null, item: null, sub_price: null, contract_differ: null, item_category: this.selected_iventory_category, item_brand: this.selected_iventory_brand},
                        ];

                        this.payments = [
                            {
                                items: banks,
                                item: null,
                            }
                        ];

                        this.selected_purchase_order = null;
                        this.discountFiled = 0;
                        this.temp_items = [];
                    },



                    /// begin methods of transfer


                    // begin item search

                    onItemSearchDriver: _.debounce((search, loading) => {

                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                            }
                        })
                            .then(function (response) {
                                v.temp_driver_item = [];
                                if (response.data.length > 0) {
                                    v.temp_driver_item = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    onItemloadDriver(index) {
                        
                        if (v.driver_data[index].inventory != null) {
                            var inventory_id = v.driver_data[index].inventory.id;
                            
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchPurchase',
                                    inventory_id: inventory_id,
                                }
                            })
                                .then(function (response) {
                                    v.driver_data[index].item = null;
                                    if (response.data.length > 0) {
                                        v.driver_data[index].item = response.data[0];
                                        
                                        @if(getDefaultSite() > 0)
                                            var sites_id = {{getDefaultSite()}}
                                        for (var i = 0; i < v.driver_data[index].item.site_list.length; i++) {
                                            if (v.driver_data[index].item.site_list[i].site_id == sites_id) {
                                                v.driver_data[index].item.site = v.driver_data[index].item.site_list[i];
                                            }
                                        }
                                        @endif
                                        
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },
                    // end methods of transfer
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {
                                    if (v.member_chack() == 'true') {
                                        var r = confirm("@lang('layout.member_payable_levels')");
                                        if (r == true) {
                                            v.disabled = true;
                                            var url = "{{route('bill.store')}}";
                                            form_id = 'purchase-form';
                                            var data = $('#' + form_id).serialize();
                                            toggleBlock(true);
                                            axios.post(url, data)
                                                .then(function (response) {
                                                    toggleBlock(0);

                                                    if (response.data.result == 1) {
                                                        $('#' + form_id).trigger('reset');
                                                        //$('#success-sound')[0].play();
                                                        toastr.success('', response.data.message);
                                                        v.number = Number(v.old_number) + 1;
                                                        v.old_number = Number(v.old_number) + 1;
                                                        v.ref_no = null;

                                                        // v.defaultValue();
                                                        location.reload();
                                                    }
                                                    else {
                                                        var message = "{{__('message.Warning')}}";
                                                        v.disabled = false;
                                                        //$('#error-sound')[0].play();
                                                        toastr.warning('', message);
                                                    }
                                                })
                                                .catch(function (error) {
                                                    toggleBlock(0);
                                                    v.disabled = false;
                                                    console.log(error);
                                                    var message = "{{__('message.Warning')}}";
                                                    //$('#error-sound')[0].play();
                                                    toastr.warning('', message);
                                                });
                                        }
                                    } else {
                                        v.disabled = true;
                                        var url = "{{route('bill.store')}}";
                                        form_id = 'purchase-form';
                                        var data = $('#' + form_id).serialize();
                                        toggleBlock(true);
                                        axios.post(url, data)
                                            .then(function (response) {
                                                toggleBlock(0);

                                                if (response.data.result == 1) {
                                                    $('#' + form_id).trigger('reset');
                                                    //$('#success-sound')[0].play();
                                                    toastr.success('', response.data.message);
                                                    v.number = Number(v.old_number) + 1;
                                                    v.old_number = Number(v.old_number) + 1;
                                                    v.ref_no = null;

                                                    // v.defaultValue();
                                                    location.reload();
                                                }
                                                else {
                                                    var message = "{{__('message.Warning')}}";
                                                    v.disabled = false;
                                                    //$('#error-sound')[0].play();
                                                    toastr.warning('', message);
                                                }
                                            })
                                            .catch(function (error) {
                                                toggleBlock(0);
                                                v.disabled = false;
                                                console.log(error);
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            });
                                    }
                                }
                            })
                    },
                    saveTemp() {
                        var url = "{{route('temp.bill.store')}}";
                        form_id = 'purchase-form';
                        var data = $('#' + form_id).serialize();
                        axios.post(url, data)
                        .then(function(response) {
                            // console.log('sss11', response);
                            callSaveTemp();
                        })
                        .catch(function(error) {
                            console.log(error);
                            callSaveTemp();
                        });
                    },
                    clearTemp() {
                        axios.get("{{route('temp.clear')}}", {
                            params: {
                                type: 'bill'
                            }
                        })
                        .then(function(response) {
                            // console.log('sss11', response);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush