@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn"> 
            <div class="caption">
                <i class=""></i>@lang('layout.Billinformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th class="">
                                <i class="fa fa-bars"></i> @lang('layout.BillNumber')
                            </th>
                            <th class="">
                                <i class="fa "></i> @lang('layout.ContractCode')  
                            </th>
                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.Vendor')  
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th> 
                            <th>
                                <i class="fa fa-text-width"></i> @lang('layout.Date')
                            </th> 
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th>
                            <th>
                                <i class="fa fa-"></i> @lang('layout.Quantity')
                            </th>
                            <th>
                                <i class="fa fa-"></i> @lang('layout.Measure')
                            </th>
                            <th>
                                <i class="fa fa-dollar"></i> @lang('layout.Amount')
                            </th>
                            <th>
                                <i class="fa fa-dollar"></i> @lang('layout.Discount') 
                            </th>
                            <th>
                                <i class="fa fa-money"></i> @lang('layout.Currency') 
                            </th>
                            <th>
                                <i class="fa fa-money"></i> @lang('layout.Rate') 
                            </th> 
                        </tr>
                    </thead>
                    <tbody> 
                        <td class=""> {{$billInfo->number }}  </td>
                        <td class=""> {{$billInfo->orderNumber}}  </td>
                        <td class=""> {{$billInfo->vendor}}  </td>
                        <td class=""> {{$billInfo->account}}  </td>
                        <td class=""> {{convertDate($billInfo->date)}}  </td>
                        <td class=""> {{$billInfo->hour}}  </td>
                        <td class=""> {{myRound($billInfo->qty) }}  </td>
                        <td class=""> {{$billInfo->unit }}  </td>
                        <td class=""> {{myRound($billInfo->amount)}}  </td>
                        <td class=""> {{$billInfo->discount }}  </td>
                        <td class=""> {{$billInfo->currency }}  </td>
                        <td class=""> {{$billInfo->rate }}  </td>
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th width="">
                            <i class=" fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                        <th width=" ">
                            <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ $billInfo->description}}  </td>
                        <td class=" "> {{ $billInfo->memo}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
			@if(getDriverInfo() == "true")          
            <div class="table-scrollable">
                <h4>@lang('layout.DriverInfo')</h4>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th class="">
                            <i class="fa fa-bars"></i> @lang('layout.TransferCode')
                        </th>
                        <th class="">
                            <i class="fa fa-user"></i> @lang('layout.Transporter_name')  
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Transporter_phone')
                        </th> 
                        <th>
                            <i class="fa fa-text-width"></i> @lang('layout.PlaceOfWeight')
                        </th> 
                         <th>
                            <i class="fa "></i> @lang('layout.SourcePlace')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.PlateNumber') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.WayBillNumber') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.TotalWeight') 
                        </th>  
                        <th>
                            <i class="fa  "></i> @lang('layout.EmptyCarWeight') 
                        </th>  
                        <th>
                            <i class="fa  "></i> @lang('layout.Description') 
                        </th> 
                    </tr>
                    </thead>
                    <tbody> 
                        <td class=""> {{$billInfo->transferCode }}  </td>
                        <td class=""> {{$billInfo->driver}}  </td>
                        <td class=""> {{$billInfo->driverPhone}}  </td>
                        <td class=""> {{$billInfo->PlaceOfWeight}}  </td>
                        <td class=""> {{$billInfo->sourcePlace }}  </td>
                        <td class=""> {{$billInfo->plateNumber }}  </td>
                        <td class=""> {{$billInfo->wayBillNumber }}  </td>
                        <td class=""> {{$billInfo->totalWeight }}  </td>
                        <td class=""> {{$billInfo->emptyCarWeight }}  </td>
                        <td class=""> {{$billInfo->trDesription }}  </td> 
                    </tr>
                    </tbody>
                </table>
            </div>
            @endif
			
        </div>
    </div>


    <div class="tabbable tabbable-tabdrop">

        
    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_buy">@lang('layout.BillDetails')</a>
        </li>
        <li>
            <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
        </li> 
    </ul>

    <div class="tab-content">
        <div class="tab-pane active" id="tab1">
      <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET--> 
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.BillDetails')</span>
                    </div>
                    <div class="tools"></div>
                      <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Bill_DetailsRoll"/>
                           <input type="hidden" name="id" value="{{$billInfo->bill_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Bill_DetailsRoll"/>
                           <input type="hidden" name="id" value="{{$billInfo->bill_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i>  @lang('layout.PDF')</button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="bill">
                        <thead>
                        <tr>
                            <th>@lang('layout.Code') </th>
                            <th>@lang('layout.ItemName') </th>
							@if(systemConfig()[9] == 0 )
                            <th>@lang('layout.Length') </th>
                            <th>@lang('layout.Width') </th>
                            <th>@lang('layout.Wing') </th>
							@endif
							@if(itemBrand()=="true")
							 <th>@lang('layout.Brand')</th>
							@endif
                            @if(showLocation()=="true")
							 <th>@lang('layout.Location')</th>
							@endif
							@if(systemConfig()[9] != 0 )
                            <th>@lang('layout.Photo') </th>
                            <th>@lang('layout.ExpireDate') </th>
							@endif
                            <th>@lang('layout.Quantity') </th>
                            <th>@lang('layout.Measure') </th>
                            <th>@lang('layout.PurchaseCost') </th>
                            <th>@lang('layout.Currency') </th>
							@if(getOtherMeasure()=="true")
                            <th>@lang('layout.OMeasureValue1')</th>
                            @endif
                            @if(getOtherMeasure2()=="true")
                            <th>@lang('layout.OMeasureValue2')</th>
                            @endif
                            <th>@lang('layout.Expense') </th>
                            <th>@lang('layout.CostOfGoodSold') </th>
                            <th>@lang('layout.TotalPurchaseCost') </th>
                            <th>@lang('layout.TotalCostOfGoodSold') </th>
                            <th>@lang('layout.Action') </th> 
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
    </div>

    <div class="tab-pane" id="tab2"> 
        <div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
        </div>
    </div>
    <div class="portlet-body">
           <div class="portlet light bordered">
                    <div class="portlet-body">
                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="redirect_route" value="bill_roll.show">
                                    <input type="hidden" name="foreign_data_id" value="{{$billInfo->bill_id}}">
                                    <input type="hidden" name="path" value="uploads/Bill">
                                    <input type="hidden" name="table_name" value="purchases"> 
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-7">
                                              <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                        <img src="" alt=""> </div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                    <div>
                                                        <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                            
                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                               
                                <div class="margiv-top-10">
                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                    <a href="{{route('bill.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </form>
                    </div>
            </div>
        <table class="table table-striped table-bordered table-hover" id="attachment">
            <thead>
            <tr>  
            <th>@lang('layout.AttachmentTitle')</th>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.Action')</th>
            </tr>
            </thead>
        </table>
    </div>
</div>
</div>

    </div>

</div>

@endsection
@push('scripts')

<script>


    // roots for the attacments................................
    $('#attachment').DataTable({
            ajax:{
                url:'{{route("bill_roll.show",$billInfo->bill_id)}}',
                data:{type:'attachment'}
              },
            
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [ 
                { data: 'title', name: 'attachments.title'},
                { data: 'description', name: 'attachments.description'},
                { data: 'actions',         name: 'actions', orderable:false,searchable:false},
            ]
        });

    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#bill').DataTable({
           ajax:{
                url:'{{route("bill_roll.show",$billInfo->bill_id)}}',
                data:{type:'bill_roll'}
              }, 
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns:[
                { data: 'code', name: 'code',orderable:false,searchable:false  },
                { data: 'name', name: 'items.name' },
				
				@if(systemConfig()[9] == 0 )
                { data: 'lengths', name: 'lengths',orderable:false,searchable:false  },
                { data: 'widths', name: 'widths',orderable:false,searchable:false  },
                { data: 'khada', name: 'khada',orderable:false,searchable:false  },
				@endif
				@if(itemBrand()=="true")
				  { data: 'brand',        name: 'brand',searchable:false },
				@endif
                @if(showLocation()=="true")
				  { data: 'location',     name: 'location',searchable:false },
				@endif
				@if(systemConfig()[9] != 0 )
                { data: 'image', name: 'image',orderable:false,searchable:false  },
                { data: 'expire_date', name: 'expire_date',orderable:false,searchable:false  },
				@endif
				
                { data: 'qty', name: 'qty',orderable:false,searchable:false },
                { data: 'purchaseMeasure', name: 'purchaseMeasure',orderable:false,searchable:false },
                { data: 'Amount', name: 'Amount' ,orderable:false,searchable:false},
                { data: 'Currency', name: 'Currency' ,orderable:false,searchable:false},
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure' },
                @endif
                @if(getOtherMeasure2()=="true")
                { data: 'other_measure2', name: 'other_measure2' },
                @endif
				{ data: 'expense_cost', name: 'expense_cost' ,orderable:false,searchable:false},
                { data: 'unit_cost', name: 'unit_cost' ,orderable:false,searchable:false},
                { data: 'Total', name: 'Total',orderable:false,searchable:false },
                { data: 'totol_cost_of_good_sold', name: 'totol_cost_of_good_sold',orderable:false,searchable:false },
                { data: 'actions', name: 'actions',orderable:false,searchable:false },
				
        ]

        });
    });

</script>


@endpush
