@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")

<div class="row" >

  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateEnterBill') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>
    <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <!-- BEGIN FORM-->
      {!! Form::model($purchase, ['method' => 'PATCH','route' => ['billChack.update',$purchase->id],'class'=>'form-horizont','id'=>'purchase-form','files'=> true]) !!}
            

      {{ csrf_field() }}

      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
            <!-- begin inputs -->
            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Vendor')</label>
                    
                    <v-select  label="name" @input="memberChange()" :options="vendor" v-model="selected_vendor"></v-select>
                    <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
					<input v-if="(vendor_id == (!selected_vendor?null:selected_vendor.id))" type="hidden" name="purchase_order" :value="selected_purchase_order" />
                  </div>
                </div> 
              </div>

              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label col-md-12"><br></label>
                    
                    <button type="button" class="btn blue btn-block" @click="showModal = true">@lang('layout.NewVendor')</button>
                  </div>
                </div> 
              </div>

              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.BillNumber')</label>
                    
                    <input type="number" name="number" value="{{$purchase->number}}" class="form-control">
                  </div>
                </div> 
              </div>
              
            </div>

            <div class="row">
              
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Currency')</label>
                    
                    
                    <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                    <input type="hidden" name="currency" :value="selected_currency.code">

                  </div>
                </div> 
              </div>

              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Rate')</label>
                    
                    <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                  </div>
                </div> 
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Discount')</label>
                    
                    <div class="input-group">
                     
                      <input  v-model="discountFiled" class="form-control"
                      type="number" min="0" max="100">
                      <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                      </span>
                      <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                        <input type="hidden" name="discount_type" value="percent">
                      </span>
                      <input type="hidden" name="discountTotal" :value="discount">
                      <input type="hidden" name="discount" :value="discountFiled">
                    </div>

                  </div>
                </div> 
              </div>
            </div>

            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.ContractName')</label>
                    
                    <v-select v-model="selected_contract" label="Contract_Name" :options="contract" ></v-select>
                    <input type="hidden" name="contract_id" :value="(this.selected_contract==null)?null:selected_contract.id">
                  </div>
                </div> 
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Description')</label>
                    
                    <textarea  name="description" class="form-control" rows="1">{{$purchase->description}}</textarea>
                  </div>
                </div> 
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Date')</label>
                    
                    <input type="text" value="{{$billInfo->date}}"  name="date"  class="form-control date" autocomplete="off">
                  </div>
                </div> 
              </div>
              
            </div>
            <div class="row">
             <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
              <div class="form-group">
                
                <div class="col-md-12">
                  <label class="control-label">@lang('layout.OverdueDate')</label>
                  
                  <input type="text" value="{{$billInfo->overdue_date}}"  name="overdue_date"  class="form-control date" autocomplete="off">
                </div>
              </div> 
            </div>
          </div>
          <!-- end inputs -->
        </div>
        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

          <!-- begin total -->
          <div class="dashboard-stat2 ">
            <table class="dashboard-tabel" width="100%">
              <tr>
                <td>
                  <small>@lang('layout.Total') :</small>
                </td>
                <td class="text-right"><span data-counter="counterup"
                 data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                 <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
               </td>
             </tr>

             <tr>
              <td>
                <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
              </td>
              <td class="text-right">
               <span class="text-right" data-counter="counterup"
               data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
               <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
             </td>
           </tr>

           <tr>
            <td>
              <small>@lang('layout.Payment'):</small>
            </td>
            <td class="text-right">
              <small class="font-green-sharp">
                <span class="text-right" data-counter="counterup"
                data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
              </small>
            </td>
          </tr>


          <tr>
            <td>
              <small>@lang('layout.Sub-Total'):</small>
            </td>
            <td class="text-right">
              <span class="text-right" data-counter="counterup"
              data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
            </td>
          </tr>
          <!-- tr>
			<td>
			  <small>@lang('layout.Sub-Total'):</small>
			</td>
			<td class="text-right">
			  <span class="text-right" data-counter="counterup"
			  data-value="7800">@{{ ser_sum.toFixed(precision())}}</span>
			  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
			</td>
		  </tr -->


        </table>

      </div>

      <!-- end total -->
    </div>

  </div>

  <div class="row" >
	       <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
        <thead>
          <tr>
            <th>#</th>
            <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
            <th style="min-width: 100px">@lang('layout.SiteName') </th>
            <th style="min-width: 100px">@lang('layout.Code') </th>
			<th v-show="showWhat('expire_date')=='yes'" >@lang('layout.ExpireDate') </th>
            <th style="min-width: 100px">@lang('layout.Quantity') </th>
            <th style="min-width: 100px">@lang('layout.OnHand') </th>
            <th  v-show="showWhat('other_measure')=='yes'" class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue') </th>
            <th style="min-width: 100px">@lang('layout.Measure') </th>
			@if(systemConfig()[9] == 0 )
            <th style="min-width: 100px">@lang('layout.Width') </th>
            <th style="min-width: 100px">@lang('layout.Wing') </th>
			@endif
			@if(systemConfig()[9] != 0 )
            <th style="min-width: 100px">@lang('layout.Photo') </th>
			@endif
            <th style="min-width: 100px">@lang('layout.NewCost') </th>
            <th style="min-width: 100px">@lang('layout.Total') </th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <tr v-for="(item,index) in inventories">
		  <td>@{{index+1}}</td>
            <td class="highlight">
              <v-select label="name" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @keyup.native="onItemLoadCode(index)"  @click.native="onItemLoadCode(index), addNew('inventory',index)"></v-select>
              <input type="hidden" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
              
              <input v-if="(vendor_id == (!selected_vendor?null:selected_vendor.id))" type="hidden" :name="'purchase_order_detail_id['+index+']'" :value="(!item.item)?null:item.item.purchase_order_detail_id">
            </td>
			
			<td>
			   <div class="input-group">
				   <v-select placeholder="@lang('layout.SiteName') " label="name"  :options="sites" v-model="(item.item==null)?null:item.item.site" ></v-select>
				   <input type="hidden" :name="'site_id['+index+']'"  :value="(item.item==null)?null:item.item.site.id">
				</div>
				</td>
			   <td>
			   <div class="input-group">
					<input :name="'code['+index+']'" :value="(!item.item)?null:item.item.code"  ref="code" @input="setNewRate(index)"  type="text" class="form-control" placeholder="@lang('layout.Code')" >
				</div>
			</td>
			
			
         <td v-show="showWhat('expire_date')=='yes'">
			<date_picker :name="'expire_date['+index+']'" v-model="(!item.item)?null:item.item.expire_date" placeholder="@lang('layout.ExpireDate')" ></date_picker>
         </td>
         <td>
           <input type="number" :name="'quantity['+index+']'" v-model.number="(item.item==null)?null:item.item.quantity" ref="quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
           
         </td>

         <td>
           @{{myRound((item.item==null)?null:(item.item.quantity) )}}
         </td>
         <td v-show="showWhat('other_measure')=='yes'" class="other_measure">
           <input type="number" :name="'other_measure_amount['+index+']'"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue')">
         </td>
         <td class="highlight">
          <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
            <option value="null">@lang('layout.Select')</option>
            <span v-if="(item.item ==null)?false:true">
              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                @{{measure.measure_name}}
              </option> 
            </span>
          </select>
          
          <input type="hidden" :name="'measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
        </td>
		@if(systemConfig()[9] == 0 )
		<td>
		   <div class="input-group">
				<input :name="'widths['+index+']'" :value="(item.item==null)?null:item.item.widths" ref="widths" @input="setNewRate(index)" type="number" class="form-control" placeholder="@lang('layout.Width')" >
			</div>
	   </td>
	   <td>
		   <div class="input-group">
				<input :name="'khada['+index+']'" :value="(item.item==null)?null:item.item.khada" ref="khada" @input="setNewRate(index)" type="number" class="form-control" placeholder="@lang('layout.Wing')" >
			</div>
	   </td>
	   
	   @endif
	   @if(systemConfig()[9] == 1 )
	   <td>
		   <div class="input-group">
				<input :name="'photo['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')" >
				<input  type="hidden" :name="'last_image['+index+']'" v-model="(item.item==null)?null:item.item.image" >
				
			</div>
	   </td>
	   @endif
        <td>
          <div class="input-group">
            <input type="number" :name="'inventory_price['+index+']'"  placeholder="@lang('layout.Cost')"   :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate(index)" class="form-control">
            <span class="input-group-addon">
              @{{selected_currency.symbol}}
            </span>
          </div>
          
        </td>
        <td>
         <div>
           <div class="input-group">
            <input type="number" class="form-control inner_input"   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate)" placeholder="@lang('layout.Total')" disabled>
            <span class="input-group-addon" >
              <b>@{{selected_currency.symbol}}</b>
            </span>
          </div>
        </div>
      </td>
      <td>
       <span v-if="inventories.length > 1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
     </td>
   </tr>
   <!--tr style="background-color: #ffffff;">
    <td></td>
    <td><center>
     <button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
   </center></td>
   <td></td>    @click.native="addNew('inventory',index)"
   <td></td>
   <td></td>
   <td></td>
   <td></td>
   <td></td>
   <td></td>
 </tr -->
</tbody>
</table>

  <hr>
<!-- begin payments -->
<table id="table_content" class="table table-striped table-bordered table-advance table-hover">
  <thead>
    <tr>
      <th class="text-center" style="min-width: 8px;"> # </th>
      <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
      <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
      <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
      <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
      <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
      <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
      <th></th>
      
    </tr>
  </thead>
  <tbody>
    <tr v-for="(payment,index) in payments">
      <td>@{{index+1}}</td>
      <td class="highlight">
        <v-select label="name" v-model="payment.item"  :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">
          
        </v-select>
        <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
      </td>
      
      <td>
       
        <span v-if="payment.item !=null">
         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
       </span>
     </td>
     <td>
       <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="(payment.item==null)?null:payment.item.rate "
       class="form-control"
       placeholder="@lang('layout.Rate')" required/>
       <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
       v-bind:value="payment.item.rate">
     </td>
     <td>
       <input type="text" name="payment_currency[]" class="form-control"
       v-model="(payment.item==null)?null:payment.item.code"
       placeholder="@lang('layout.Currency')" required disabled/>

       <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
       v-bind:value="payment.item.code"/>
     </td>
     <td>
      <div class="input-group">
        <input type="number" class="form-control"
        v-model.number="(payment.item==null)?null:payment.item.amount "
        placeholder="@lang('layout.PayAmount')" required/>

        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
        v-bind:value="payment.item.amount">

        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
      </div>
    </td>
    <td>
     <div class="input-group">
      <input type="number" class="form-control"
      :value="(payment.item==null)?null:totalPayments(payment.item,selected_currency.rate)"
      placeholder="@lang('layout.Total')" style="min-width: 100px" required />
      <span class="input-group-addon">@{{selected_currency.symbol}}</span>
    </div>
  </td>
  <td>
   <span  v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
 </td>
</tr>
</tbody>
</table>
<!-- end payments -->
</div>

	
                    <!--Begin Draiver-->

                    @if(getDriverInfo()=="true")
                        <br>
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                            </tr>
                            </thead>
                        </table>

                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <!-- begin inputs -->
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TransferCode')</label>
                                            {{Form::text('transfer_code',$billInfo->transferCode,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                                        </div>
                                    </div>

                                    <div class="col-md-3">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Transporter_name')</label>
                                            <input type="test" name="transporter_name" value="{{$billInfo->driver}}"
                                                   class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Transporter_phone')</label>
                                            <input type="test" name="transporter_phone"
                                                   value="{{$billInfo->driverPhone}}" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                            {{Form::text('palce_of_weight',$billInfo->PlaceOfWeight,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                        </div>
                                    </div>


                                </div>
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.SourcePlace')</label>
                                            {{Form::text('source_place',$billInfo->sourcePlace,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.PlateNumber')</label>
                                            <input type="text" name="plate_number" value="{{$billInfo->plateNumber}}"
                                                   placeholder="@lang('layout.PlateNumber')" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                            <input type="text" name="way_bill_number"
                                                   value="{{$billInfo->wayBillNumber}}"
                                                   placeholder="@lang('layout.WayBillNumber')" class="form-control">

                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TotalWeight')</label>
                                            <input type="text" name="total_weight" value="{{$billInfo->totalWeight}}"
                                                   placeholder="@lang('layout.TotalWeight')" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                            <input type="text" name="empty_car_weight"
                                                   value="{{$billInfo->emptyCarWeight}}"
                                                   placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                                        </div>
                                    </div>
                                    <!-- div class="col-md-3">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.TotalBori')</label>
                                            <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')"
                                                   value="{{$billInfo->bori}}" class="form-control">
                                        </div>
                                    </div -->
                                    <div class="col-md-6">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Description')</label>
                                            {{Form::textarea('transfer_description',$billInfo->trDesription,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                @endif
                <!--End Draiver-->

</div>
<div class="col-xs-12 col-sm-10 col-md-11 text-center">
  <button type="button" v-if="!isError" @click="submitForm" class="btn green">@lang('layout.Submit')</button>
  
  
  <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
</div>  
{!! Form::close() !!}
<cmodal :show='showModal' @close="showModal=false">
  
</cmodal>
</div>                  
<!-- END FORM-->
</div>
</div> 

@endsection
@push('scripts')


<script type="text/javascript">
  Vue.component('v-select', VueSelect.VueSelect);
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
      return {
        types: [],
        receivables: [],
        payables: [],
        code: null,
        selectType: null,
        selectPay: null,
        selectReceive: null,
        classes:[],
        selectedClass: null,

      }
    },
    created(){
      
      axios.get('{{route("customer.create")}}').then(
        response=>{
          this.types = response.data.types;
          if(this.types)
          {
            for(var i=0;i<this.types.length;i++)
            {
              if(this.types[i].type=="Vendor")
              {
               this.selectType=this.types[i];
             }
           }
         }
         this.receivables = response.data.receivable;
         this.payables = response.data.payable;
         this.code = response.data.code;
         this.classes = response.data.member_class;
          if(this.receivables.length>0)
          {
              this.selectReceive=this.receivables[0];
          }
          if(this.payables.length>0)
          {
              this.selectPay=this.payables[0];
          }

       }).catch(error=> console.log(error));
    },
    methods:{
      onSubmit(){

        v.showModal = false;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers:{'X-CSRF-TOKEN':"{{csrf_token()}}"},
          url:'{{route("customer.store")}}',
          method:'post',
          data: {
            "name": datas[0]['value'],
            'code': datas[1]['value'],
            'email': datas[2]['value'],
            'phone': datas[3]['value'],
            'address1': datas[4]['value'],
            'type':this.selectType.id,
            'receivable':this.selectReceive.id,
            'payable':this.selectPay.id,
            'class':(this.selectedClass)?this.selectedClass.id:null
          },
          dataType: 'json',

        }).done(function(response){
          axios.get('{{route("bill.create")}}').then(response=>{
            
            v.vendor =response.data.customer;
            document.getElementById("modalForm").reset();

          }).catch(error=> console.log(error));

        }).fail(function(error){
          console.log('error',error);
        });
        
      }
    }
  });




  var vendor={!! $vendor !!};
  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var selectedBank = {!! $selectedBank !!};
  var purchaseContract={!! $purchaseContract !!};
  var purchase={!! $purchase !!};
  var v = new Vue({
    el: '#app',
    data: {
     showModal: false,
     selected_purchase_order:<?php if($purchase->order_id){echo $purchase->order_id; }else{echo 'null';} ?>,
     vendor_id:{!! $purchase->vendor_id !!},
     vendor:{!! $vendor !!},
     selected_vendor:{!! $selectedVendor !!},
     contract:[],
     selected_contract:null,
     banks:banks,
     selected_banks:selectedBank,
     currency:{!! $currency !!},
     selected_currency:{!! $selectedCurrency !!},
     selected_item:{!! $selectedItem !!},
	 open_stock_data:{!!json_encode($opening)!!},
	 sites:{!!json_encode($site)!!},
	 purchase:purchase,
     rate:0,
     discountFiled: 0,
     discountIsAmount:false,
     temp_items:[],
     totalAmountes: [],
     ser_sum: null,
     item_sum: null,
     newCost:[
     null,
     null,
     null,
     null],
     inventories:[
     ],
     payments: [
     ],
	 services:[
			],
   },


   computed:{
    selectedRate()
    {            
     this.rate= (this.selected_currency)?this.selected_currency.rate:0;
	 // console.log('jjas', this.rate);
   },
   discount()
   {
    if(this.discountIsAmount){

      if(this.subtotal>0 && this.discountFiled) {
        return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
      }else {
        return 0;
      }
    }else {

      return this.discountFiled
    }

  },

          // calculate subtotal
          subtotal: function ()
          {
            var sum = 0;
            var ser_sum = 0;
            for (var i = 0; i < this.inventories.length; i++) {
              if (this.inventories[i].item && this.inventories[i].item !=null)
              {  

                var quantity=this.inventories[i]['item']['quantity'];
                var rate=this.inventories[i]['item']['rate'];
                var new_rate=this.inventories[i]['item']['new_rate'];
                var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                var measure_unit=this.inventories[i]['item']['measure_unit'];
                if(new_rate !=rate && quantity>0)
                {
                 sum +=new_rate*quantity*this.selected_currency.rate;
               }
               else
               {
                sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
              }
              
            }

          }

              // for (var i = 0; i < this.services.length; i++) {
                     // if (this.services[i]['item']['qut_in'] != null && this.services[i]['item']['cost'] != null)
                         // ser_sum += this.services[i]['item']['qut_in'] * this.services[i]['item']['cost'] * this.selected_currency.rate;
                 // }

                 // this.ser_sum = ser_sum;
                 this.item_sum = sum;

                return sum;
              },

          // check payed amount
          payeds: function ()
          {
            var sum = 0;
            for (var i = 0; i < this.payments.length; i++)
            {

              if(this.payments[i].item !=null && this.payments[i].item)
              {
               if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
               {
                      //
                      sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']) ;
                    }
                  }
                }
                return sum;
              },

            // check data validation
            isError: function () 
            {
              var isError = false;
              var flag=false;
              for (var i = 0; i < this.inventories.length; i++)
              {
                if (this.inventories[i].item)
                {
                  flag=true;
                  if(((this.inventories[i]['item']['rate'] <=0) ))
                  {
                    var rate=this.inventories[i]['item']['rate'];
                    var new_rate=this.inventories[i]['item']['new_rate'];
                    if(rate <=0 && new_rate <=0)
                    {
                     isError = true;
                   }
                   
                 }
               } 
             }
             if(this.inventories.length==0 || this.selected_vendor==undefined || this.selected_vendor==null || this.flag==false)
             {
              isError = true;
            }
            return isError;
            

          },
        },
        mounted:function()
        {
			
			for(var i=0;i<this.open_stock_data.length;i++)
        {
          // console.log('ssssssss',this.open_stock_data[i]);
          this.services.push({item:this.open_stock_data[i]});
		  
        }
			
      // initialize the selected item
      for(var i=0;i<this.selected_item.length;i++)
      {
        this.inventories.push({item:this.selected_item[i], inventory:this.selected_item[i]});
      }
	  this.inventories.push({item:null, inventory:null});
	  // console.log('66666',this.inventories);
      // initialize payments
      for(var k=0;k<this.selected_banks.length;k++)
      {
        var foundFlag=false;
        var tempBank=null;
        for(var j=0;j<this.banks.length;j++)
        {
          if(this.banks[j].id==this.selected_banks[k].Account_id)
          {
           foundFlag=true;
           tempBank=this.banks[j];
           tempBank.amount=this.selected_banks[k].Amount;
           tempBank.rate=this.selected_banks[k].Rate;
         }
       }
       if(foundFlag)
       {

        this.payments.push({item:tempBank,items:this.banks});
      }

    }

    for(var w=1;w>this.selected_banks.length;w--)
    {
     this.payments.push({item:null,items:banks});
   }
      // end payment

      if(this.purchase)
      {
       this.discountFiled=this.purchase.discount; 
       if(this.purchase.discount_type)
       {
        if(this.purchase.discount_type=='percent')
        {
         this.discountIsAmount=false;
       }
       else
       {
         this.discountIsAmount=true;
       }
     } 
   }
 },
 methods:
 {
       // calculate item price based on measure change
       measureChange(index)
       {
        
         if(this.inventories[index].item !=null){
          var item=this.inventories[index].item;
          
          var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
          result=Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
          }
        },
       // detect member change and searh
       memberChange()
       {
         if(this.selected_vendor)
         {
            // get member contract
               // get member contract
               this.contract=[];
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'member_contract',
                  member_id:this.selected_vendor.id
                }
              })
               .then(function (response)
               {
                 if(response.data.length>0)
                 {
                  v.contract=response.data;
                  if(v.contract)
                  {
                    for(var m=0;m<v.contract.length;m++)
                    {

                      if(v.contract[m].id == purchaseContract.contract_id)
                      {
                       v.selected_contract = v.contract[m];
                     }
                   }
                 }

               }
             })
               .catch(function (error)
               {
                console.log(error);
              });
             }
           },
       // set new price
       setNewRate(index)
       {
         if(this.inventories[index].item){
			 // console.log('123',this.inventories);
			this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
		  
			this.inventories[index].item.code = this.$refs.code[index].value;
			// this.inventories[index].item.lengths = this.$refs.lengths[index].value;
         if(this.$refs.widths){
			this.inventories[index].item.widths = this.$refs.widths[index].value;
			this.inventories[index].item.khada = this.$refs.khada[index].value;
		 }
			// this.inventories[index].item.cost = this.$refs.cost[index].value;
			this.inventories[index].item.quantity = this.$refs.quantity[index].value;

		  
        }

      },
      // begin item search


      onItemSearch:_.debounce((search,loading) =>{
        loading(true);
        axios.get("{{route('callMethod.search')}}",{
          params:{
            method_name:"itemSearchNameRoll",
            keyword:search,
          }
        })
        .then(function(response){
          v.temp_items = [];
          if(response.data.length >0)
          {
            v.temp_items = response.data;

          // console.log('132', v.temp_items);
          }
          loading(false);
        })
        .catch(function(error){
          console.log(error);
        })
      },getDebounceTime()),

       // end item search
	   
	    //ajax call to get items code
		onItemLoadCode(selectedIndex) {
			// v.selectedIndex = selectedIndex;
			
			if (v.inventories[selectedIndex].inventory != null) {
				// console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
				var inventory_id = v.inventories[selectedIndex].inventory.id;
				
				axios.get("{{route('callMethod.search')}}", {
					params: {
						member_id: v.member_id,
						method_name: 'itemSearchPurchaseRoll',
						inventory_id: inventory_id,
						// inventory_category_id: inventory_category_id,
					}
				})
				.then(function (response) {
					if (response.data.length > 0) {
						v.inventories[selectedIndex].item = null;
						v.inventories[selectedIndex].item = response.data[0];
					console.log('gg');
					}
				})
				.catch(function (error) {
					console.log(error);
				})
			}
			
		},

       // end item search
	   
	   

       // contract search


       
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
        
        if(type !=null)
        {
         if(type=='inventory')
         {
          if(this.inventories[index+1]==undefined)
          {
			for(var i=0;i<this.inventories.length;i++)
				{
				  if(this.inventories[i].item!=null)
				  {
					v.inventories[i].item.code = this.$refs.code[i].value;
					// v.inventories[i].item.lengths = this.$refs.lengths[i].value;
					if(this.$refs.widths)
				  {
					v.inventories[i].item.widths = this.$refs.widths[i].value;
					v.inventories[i].item.khada = this.$refs.khada[i].value;
				  }
					// v.inventories[i].item.cost = this.$refs.cost[i].value;
					v.inventories[i].item.quantity = this.$refs.quantity[i].value;
				  }
			  
				}  
			  
            this.temp_items=[];
            this.inventories.push({item:null, inventory:null});
          }
        }
        if(type=='payment')
        {
          if(this.payments[index+1]==undefined)
          {
            this.checkExistingPayment(index,'');
            this.payments.push({
              items: this.banks,
              item: null,
            });
          }
        }
      }
      
    },

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
	   // console.log(this.banks);
        var bank_temp=this.banks.slice();
        var bank_temp1=[];
        for(var i=0;i<this.payments.length;i++)
        {
          if(this.payments[i].item !=null)
          {
            var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
            if(fined !=-1)
            {
              var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
            }
          }
        }
        this.payments[index].items = bank_temp.filter((item) => {
          return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
        });
               //this.payments[index].items =bank_temp; 


             },
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
           // console.log(type);
           if(type=='inventory')
           {
            this.inventories.splice(index, 1);
          }
          if(type=='payment')
          {
            this.payments.splice(index, 1);
          }
        }
        
      },
	  
	  
	  
	  // generic function for adding item to list
		add_roll(index)
		{
				
				
				
				
				if(v.services[index+1]==undefined)
				{
				  v.services.push({
					item:{
						name:' ',
						id:null,
						inventory_site_id:null,
						main_stocks_id:null,
						m_stocks_in_id:null,
						code:null,
						lengths:null,
						widths:null,
						khada:null,
						cost:null,
						qut_in:null
					}
				});
				
				
				}
			 
		  
		},
		// delete item from list
		deleteItem_roll(index)
		{
				this.services.splice(index, 1);
		  
		},
	  
       // submit the form
       submitForm() 
       {

        if(this.isError==true) {
          alert('there is no item');
          return false;
        }
        swal({
          title:"@lang('layout.AreYouSure?')",
          buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
          text: "",
          icon: "info",
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete) {
            document.getElementById("purchase-form").submit()

          } else {

          }
        });

      },
    
	// 
	
	 // saveAndNew() {
                   
                                    // var url = "{{url('billChack/'.$purchase->id)}}";
                                    // form_id = 'purchase-form';
                                    // var data = $('#' + form_id).serialize();
                                    // toggleBlock(true);
                                    // axios.post(url, data)
                                        // .then(function (response) {
                                            // toggleBlock(0);

                                            // if (response.data.result == 1) {
                                                // window.location.href("{{url('bill_roll')}}");
                                            // }
                                            // else {
                                                // var message = "{{__('message.Warning')}}";
                                                // //$('#error-sound')[0].play();
                                                // toastr.warning('', message);
                                            // }
                                        // })
                                        // .catch(function (error) {
                                            // toggleBlock(0);
                                            // console.log(error);
                                            // var message = "{{__('message.Warning')}}";
                                            // //$('#error-sound')[0].play();
                                            // toastr.warning('', message);
                                        // });

                    // },

	
	},
    created:function()
    {
     
    }

  });

</script>


@endpush