@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
<style>
</style>
@stop
@section('content')
@include("layouts.Cmodal")
<div class="row">
  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        @if($duplicate)
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Enterbill') </span>
        @else 
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateEnterBill') </span>
        @endif
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>
    <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <!-- BEGIN FORM-->
      @if($duplicate)
      {!! Form::model($purchase, ['method' => 'post','route' => ['bill_roll.store',$purchase->id],'class'=>'form-horizont','id'=>'purchase-form','files'=> true]) !!}
      @else 
      {!! Form::model($purchase, ['method' => 'PATCH','route' => ['bill_roll.update',$purchase->id],'class'=>'form-horizont','id'=>'purchase-form','files'=> true]) !!}
      @endif
      {{ csrf_field() }}
      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
            <div class="col-lg-12" style="padding: 0px !important;">
              <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Vendor')</label>
                    <div class="input-group">
                        <v-select label="name" @input="memberChange()" @search="MemberSearch" :options="vendor" v-model="selected_vendor"></v-select>
                        <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                        <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                            <i class="fa fa-plus" style="color: white"></i>
                        </span> 
                    </div>
                    <input v-if="(vendor_id == (!selected_vendor?null:selected_vendor.id))" type="hidden" name="purchase_order" :value="selected_purchase_order" />
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                <div class="form-group">
                  @if($duplicate)
                  <div>
                    <label class="control-label">@lang('layout.BillNumber')</label>
                    <input type="number" name="number" value="{{$numberDuplicate}}" class="form-control">
                  </div>
                  @else 
                  <div>
                    <label class="control-label">@lang('layout.BillNumber')</label>
                    <input type="number" name="number" value="{{$purchase->number}}" class="form-control">
                  </div>
                  @endif
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','date')) displayNone @endif">
                <div class="form-group">
                  <div>
                    <label class="control-label">@lang('layout.Date')</label>
                    <input type="text" value="{{$billInfo->date}}" name="date" class="form-control date" autocomplete="off"
                    @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                    <span class="required">@{{ errors.first('date') }}</span>
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','hour')) displayNone @endif">
                <div class="form-group">
                  <div>
                    <label class="control-label">@lang('layout.Hour')</label>
                    <div class="input-group">
                        @if(getHourType() == 24)
                        <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$purchase->hour}}">
                        @else
                        <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$purchase->hour}}" >
                        @endif
                        <span class="input-group-btn">
                            <button class="btn default" type="button">
                                <i class="fa fa-clock-o"></i>
                            </button>
                        </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 @if(!getCustomeForm('billroll','referenceNumber')) displayNone @endif" style="margin-right: 10px;">
              <div class="form-group">
                  <label class="control-label">@lang('layout.ReferenceNumber')</label>
                  <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                  <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
              </div>
            </div>
            <div class="col-lg-12" style="padding: 0px !important;">
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Currency')</label>
                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                    <input type="hidden" name="currency" :value="selected_currency.code">
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Rate')</label>
                    <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                    <span v-if="differentRate" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Discount')</label>
                    <div class="input-group">
                      <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                      <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                      </span>
                      <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                        <input type="hidden" name="discount_type" value="percent">
                      </span>
                      <input type="hidden" name="discountTotal" :value="discount">
                      <input type="hidden" name="discount" :value="discountFiled">
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','overdueDate')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.OverdueDate')</label>
                    <input type="text" value="{{$billInfo->overdue_date}}" name="overdue_date" class="form-control date" autocomplete="off">
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-12" style="padding: 0px !important;">
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','contractName')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.ContractName')</label>
                    <v-select v-model="selected_contract" label="Contract_Name" :options="contract"></v-select>
                    <input type="hidden" name="contract_id" :value="(this.selected_contract==null)?null:selected_contract.id">
                  </div>
                </div>
              </div>
              @if(getSaleByOtherMeasureRate() == "true")
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','saleByOtherMeasureRate')) displayNone @endif">
                <div class="col-md-12 form-group">
                  <label class=" control-label">@lang('layout.SaleByOtherMeasureRate')</label>
                  <div>
                    <label class="mt-checkbox mt-checkbox-outline">
                      <input type="checkbox" name="per_qty_check" v-model="per_qty_check" <?php if($billInfo->per_qty == 'on'){echo 'checked';} ?> >
                      <span></span>
                    </label>
                  </div>
                </div>
              </div>
              @endif
              <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','description')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Description')</label>
                    <textarea name="description" class="form-control" rows="1">{{$purchase->description}}</textarea>
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','editDescription')) displayNone @endif">
                <label class="control-label">@lang('layout.EditDescription')</label>
                <div class="col-md-12 mt-checkbox">
                  <label class="mt-checkbox mt-checkbox-outline">
                    <input type="checkbox" name="edit_des" value="yes" >
                    <span></span>
                  </label>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-3 col-md-12 col-sm-12" > 
            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
            <!-- begin total -->
            <div class="dashboard-stat2" style="padding-bottom: 0px !important;">
              <table class="dashboard-tabel" width="100%">
                <tr>
                  <td>
                    <small>@lang('layout.Total') :</small>
                  </td>
                  <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                  </td>
                </tr>
                <tr>
                  <td>
                    <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
                  </td>
                  <td class="text-right">
                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                  </td>
                </tr>
                <tr>
                  <td>
                    <small>@lang('layout.Payment'):</small>
                  </td>
                  <td class="text-right">
                    <small class="font-green-sharp">
                      <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                    </small>
                  </td>
                </tr>
                <tr>
                  <td>
                    <small>@lang('layout.Sub-Total'):</small>
                  </td>
                  <td class="text-right">
                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                  </td>
                </tr>
                <!-- tr>
                <td>
                  <small>@lang('layout.Sub-Total'):</small>
                </td>
                <td class="text-right">
                  <span class="text-right" data-counter="counterup"
                  data-value="7800">@{{ ser_sum.toFixed(precision())}}</span>
                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                </td>
                </tr -->
              </table>
            </div>
            <!-- end total -->
            </div>
          </div>
          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

            
          </div>
          <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
        </div>

        <div class="row" style="overflow-x: scroll;">
          <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
            <thead>
              <tr>
                <th>#</th>
                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 100px">@lang('layout.Category') </th>
                <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                <th style="min-width: 100px">@lang('layout.Code') </th>
                <th v-show="showWhat('expire_date')=='yes'">@lang('layout.ExpireDate') </th>
                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                <th v-show="showWhat('other_measure')=='yes'" class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue1')</th>
                <th v-show="showWhat('other_measure2')=='yes'" class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue2')</th>
                <th style="min-width: 100px">@lang('layout.Measure') </th>
                @if(itemBrand()=="true")
                <th style="min-width: 100px">@lang('layout.Brand')</th>
                @endif
                @if(showLocation()=="true")
                <th style="min-width: 100px">@lang('layout.Location')</th>
                @endif
                @if(getShowSuperceedNo()=="true")
                <th style="min-width: 100px">@lang('layout.SuperceedNo')</th>
                @endif
                <th style="min-width: 100px">@lang('layout.Default_Rate')</th>
                @if(systemConfig()[9] == 0 )
                <th style="min-width: 100px">@lang('layout.Width') </th>
                @if(systemConfig()[21] == 1)
                <th style="min-width: 100px">@lang('layout.Length') </th>
                @endif
                @endif
                @if(systemConfig()[21] == 1)
                <th style="min-width: 100px">@lang('layout.UnitPrice') </th>
                @endif
                @if(getShowWing()!="false")
                <th style="min-width: 100px">@lang('layout.Wing') </th>
                <th style="min-width: 100px">@lang('layout.ApproxWeight') </th>
                @endif
                @if(systemConfig()[9] != 0 )
                @if(itemPicture()=="true")
                <th style="min-width: 100px">@lang('layout.Photo') </th>
                @endif
                @endif
                <th style="min-width: 100px">@lang('layout.NewCost') </th>
                <th style="min-width: 100px">@lang('layout.Total') </th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(item,index) in inventories">
                <td>@{{index+1}}</td>
                <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                  <v-select label="name" v-model="item.item_category" :options="inventory_category" @keyup.native="itemCategoryChange(index)" @click.native="addNew('inventory',index), itemCategoryChange(index)"></v-select>
                  <input type="hidden" :name="'inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                </td>
                <td class="highlight">
                  <v-select label="name" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @keyup.native="onItemLoadCode(index)" @click.native="onItemLoadCode(index), addNew('inventory',index)"></v-select>
                  <input type="hidden" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">

                  <input v-if="(vendor_id == (!selected_vendor?null:selected_vendor.id))" type="hidden" :name="'purchase_order_detail_id['+index+']'" :value="(!item.item)?null:item.item.purchase_order_detail_id">
                  
                  <input type="hidden" :name="'main_stocks_id['+index+']'" :value="(!item)?null:item.main_stocks_id">
                  <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(!item)?null:item.m_stocks_in_id">
                </td>

                <td>
                  <!-- <div class="input-group"> -->
                    <v-select placeholder="@lang('layout.SiteName') " label="name" :options="sites" v-model="(item.item==null)?null:item.item.site"></v-select>
                    <input type="hidden" :name="'site_id['+index+']'" :value="(item.item==null)?null:item.item.site.id">
                  <!-- </div> -->
                </td>
                <td>
                  <!-- <div class="input-group"> -->
                    <input :name="'code['+index+']'" :value="(!item.item)?null:item.item.code" ref="code" @input="setNewRate(index)" type="text"
                    oninput = "autowidths(event)"
                     class="form-control chan_length" placeholder="@lang('layout.Code')">
                  <!-- </div> -->
                </td>
                <td v-show="showWhat('expire_date')=='yes'">
                  <date_picker :name="'expire_date['+index+']'" v-model="(!item.item)?null:item.item.expire_date" 
                  oninput = "autowidths(event)"
                  class="chan_length" placeholder="@lang('layout.ExpireDate')"></date_picker>
                </td>
                <td>
                  <input type="number" :name="'quantity['+index+']'" v-model.number="(item.item==null)?null:item.item.quantity" ref="quantity" @input="setNewRate(index)"
                  oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">

                </td>

                <td>
                  @{{myRound((item.item==null)?null:(item.item.quantity) )}}
                </td>
                <td v-show="showWhat('other_measure')=='yes'" class="other_measure">
                  <input type="number" :name="'other_measure_amount['+index+']'" v-model.number="(item.item==null)?null:item.item.other_measure" 
                  oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                </td>
                <td v-show="showWhat('other_measure2')=='yes'" class="other_measure">
                  <input type="number" :name="'other_measure_amount2['+index+']'" v-model.number="(item.item==null)?null:item.item.other_measure2"
                  oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                </td>
                <td class="highlight">
                  <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                    <option value="null">@lang('layout.Select')</option>
                    <span v-if="(item.item ==null)?false:true">
                      <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                        @{{measure.measure_name}}
                      </option>
                    </span>
                  </select>

                  <input type="hidden" :name="'measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                </td>
                @if(itemBrand()=="true")
                <td>
                  <v-select placeholder="@lang('layout.Brand')" label="name" :options="brandAll" v-model="(item.item==null)?null:item.item.selectedBrand"></v-select>
                  <input type="hidden" :name="'brand_id['+index+']'" :value="(item.item==null)?null:((item.item.selectedBrand==null)?null:item.item.selectedBrand.id)">
                </td>
                @endif
                @if(showLocation()=="true")
                <td>
                  <input :name="'location['+index+']'" :value="(item.item==null)?null:item.item.location" ref="location" @input="setNewRate(index)" type="text"
                  oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Location')">
                </td>
                @endif
                @if(getShowSuperceedNo()=="true")
                <td>
                  <input :name="'superceed['+index+']'" type="text" :value="(item.item==null)?null:item.item.superceed" ref="superceed" @input="setNewRate(index)" 
                  oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.SuperceedNo')">
                </td>
                @endif
                <td>
                  <input :name="'price['+index+']'" type="text" @input="setNewRate(index)" :value="(item.item==null)?null:item.item.price" ref="price" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Default_Rate')">
                </td>
                @if(systemConfig()[9] == 0 )
                <td>
                    <input :name="'widths['+index+']'" :value="(item.item==null)?null:item.item.widths" ref="widths" @input="setNewRate(index), changeMetraz(index)" type="number"
                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Width')">
                </td>
                @if(systemConfig()[21] == 1)
                <td>
                    <input :name="'lengths['+index+']'" type="number" :value="(item.item==null)?null:item.item.lengths" ref="lengths" @input="setNewRate(index), changeMetraz(index)" class="form-control" placeholder="@lang('layout.Length')" >
                </td>
                @endif
                @endif
                @if(systemConfig()[21] == 1)
                <td>
                    <input :name="'unit_price['+index+']'" type="number" @input="setNewRate(index), changeCost(index)" :value="(item.item==null)?null:item.item.unit_price" ref="unit_price" class="form-control" placeholder="@lang('layout.UnitPrice')">
                </td>
                @endif
                @if(getShowWing()!="false")
                <td>
                  <!-- <div class="input-group"> -->
                    <input :name="'khada['+index+']'" :value="(item.item==null)?null:item.item.khada" ref="khada" @input="setNewRate(index)" type="number"
                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                  <!-- </div> -->
                </td>
                <td>
                  <!-- <div class="input-group"> -->
                    <input :name="'approx_weight['+index+']'" :value="(item.item==null)?null:item.item.approx_weight" ref="approx_weight" @input="setApproxWeight(index)"  type="number"
                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.ApproxWeight')">
                  <!-- </div> -->
                </td>
                @endif
                @if(systemConfig()[9] == 1 )
                @if(itemPicture()=="true")
                <td>
                  <!-- <div class="input-group"> -->
                    <input :name="'photo['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')">
                    <input type="hidden" :name="'last_image['+index+']'" v-model="(item.item==null)?null:item.item.image">

                  <!-- </div> -->
                </td>
                @endif
                @endif
                <td>
                  <vue-numeric v-if="item.item"
                      class="form-control chan_length"
                      oninput = "autowidths(event)"
                      v-model="item.item.cost"
                      :max="99999999999999"
                      currency=""
                      :precision="precision()"
                      @input="setNewRate(index)"
                      >
                  </vue-numeric>
                  <input type="hidden" :name="'inventory_price['+index+']'" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" >

                </td>
                <td>
                  @{{ (item.item==null)?null:getItemTotals(item.item,selected_currency.rate,null,null,1,per_qty_check,  null, selected_currency.static_rate) }}
                  <b>@{{selected_currency.symbol}}</b>
                </td>
                <td>
                  @if($edit_sale != 'yes')
                  <span v-if="inventories.length > 1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                  @endif
                </td>
              </tr>
              <!--tr style="background-color: #ffffff;">
                <td></td>
                <td><center>
                <button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
              </center></td>
              <td></td>    @click.native="addNew('inventory',index)"
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
            </tr -->
            </tbody>
          </table>

          <hr>
          <!-- begin payments -->
          <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
            <thead>
              <tr>
                <th class="text-center" style="min-width: 8px;"> # </th>
                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                <th></th>

              </tr>
            </thead>
            <tbody>
              <tr v-for="(payment,index) in payments">
                <td>@{{index+1}}</td>
                <td class="highlight">
                  <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">

                  </v-select>
                  <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                </td>

                <td>

                  <span v-if="payment.item !=null">
                    @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.amount))}}
                  </span>
                </td>
                <td>
                  <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate" class="form-control" placeholder="@lang('layout.Rate')" required />
                  <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                </td>
                <td>
                  <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" required disabled />

                  <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                </td>
                <td>
                  <vue-numeric v-if="payment.item"
                      class="form-control"
                      v-model="payment.amount"
                      :max="99999999999999"
                      :currency="payment.item.code"
                      :precision="precision()"
                      >
                  </vue-numeric>
                  <input v-if="payment.item !=null" type="hidden" :name="'payment_amount['+index+']'" v-bind:value="payment.amount">
                </td>
                <td>
                  <div class="input-group">
                    @if(systemConfig()[30] == 1)
                    <input type="number" class="form-control" :value="!payment.item?null:((payment.amount / payment.item.static_rate * payment.item.rate) * selected_currency.static_rate/selected_currency.rate).toFixed(precision())" readonly
                    placeholder="@lang('layout.Total')" style="min-width: 100px" required />
                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                    @else
                    <input type="number" class="form-control" :value="!payment.item?null:(payment.amount*selected_currency.rate/payment.item.rate).toFixed(precision())" readonly
                    placeholder="@lang('layout.Total')" style="min-width: 100px" required />
                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                    @endif
                  </div>
                </td>
                <td>
                  <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                </td>
              </tr>
            </tbody>
          </table>
          <!-- end payments -->
        </div>


        <!--Begin Draiver-->

        @if(getDriverInfo()=="true")
        <br>
        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
          <thead>
            <tr>
              <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

            </tr>
          </thead>
        </table>

        <div class="row">
          <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <!-- begin inputs -->
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.TransferCode')</label>
                  {{Form::text('transfer_code',$billInfo->transferCode,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                </div>
              </div>

              <div class="col-md-3">

                <div class="col-md-12">
                  <label class="control-label">@lang('layout.Transporter_name')</label>
                  <input type="test" name="transporter_name" value="{{$billInfo->driver}}" class="form-control">

                </div>
              </div>
              <div class="col-md-3">

                <div class="col-md-12">
                  <label class="control-label">@lang('layout.Transporter_phone')</label>
                  <input type="test" name="transporter_phone" value="{{$billInfo->driverPhone}}" class="form-control">

                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                  {{Form::text('palce_of_weight',$billInfo->PlaceOfWeight,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                </div>
              </div>


            </div>
            <div class="row">

              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.SourcePlace')</label>
                  {{Form::text('source_place',$billInfo->sourcePlace,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.PlateNumber')</label>
                  <input type="text" name="plate_number" value="{{$billInfo->plateNumber}}" placeholder="@lang('layout.PlateNumber')" class="form-control">

                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.WayBillNumber')</label>
                  <input type="text" name="way_bill_number" value="{{$billInfo->wayBillNumber}}" placeholder="@lang('layout.WayBillNumber')" class="form-control">

                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.TotalWeight')</label>
                  <input type="text" name="total_weight" value="{{$billInfo->totalWeight}}" placeholder="@lang('layout.TotalWeight')" class="form-control">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                  <input type="text" name="empty_car_weight" value="{{$billInfo->emptyCarWeight}}" placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                </div>
              </div>
              <!-- div class="col-md-3">
                  <div class="col-md-12">
                      <label class="control-label ">@lang('layout.TotalBori')</label>
                      <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')"
                              value="{{$billInfo->bori}}" class="form-control">
                  </div>
              </div -->
              <div class="col-md-6">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.Description')</label>
                  {{Form::textarea('transfer_description',$billInfo->trDesription,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                </div>
              </div>
            </div>
          </div>

        </div>
        @endif
        <!--End Draiver-->
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label">@lang('layout.Memo')</label>
                        <textarea name="memo" class="form-control" rows="2">{{$purchase->memo}}</textarea>
                    </div>
                </div>
            </div>
        </div>
      </div>
      <div class="col-xs-12 col-sm-10 col-md-11 text-center">
        <button type="button" v-if="!isError" @click="submitForm" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
        @if(!$duplicate)
        <button type="button" v-if="!isError" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.Check') / @lang('layout.Update')</button>
        @endif
        <a href="{{route('bill_roll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
      </div>
      {!! Form::close() !!}
      <cmodal :show='showModal' @close="showModal=false">

      </cmodal>
    </div>
    <!-- END FORM-->
  </div>
</div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

<script type="text/javascript">

@if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif


  Vue.use(VueInputAutowidth);
  Vue.component('v-select', VueSelect.VueSelect);
  Vue.use(VueNumeric.default);

  Vue.component("cmodal", {
    template: '#cmodal-template',

    props: ['show'],
    data() {
      return {
        types: [],
        receivables: [],
        payables: [],
        code: null,
        selectType: null,
        selectPay: null,
        selectReceive: null,
        classes: [],
        selectedClass: null,

      }
    },
    created() {

      axios.get('{{route("customer.create")}}').then(
        response => {
          this.types = response.data.types;
          if (this.types) {
            for (var i = 0; i < this.types.length; i++) {
              if (this.types[i].type == "Vendor") {
                this.selectType = this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
          this.classes = response.data.member_class;
          if (this.receivables.length > 0) {
            this.selectReceive = this.receivables[0];
          }
          if (this.payables.length > 0) {
            this.selectPay = this.payables[0];
          }

        }).catch(error => console.log(error));
    },
    methods: {
      onSubmit() {

        v.showModal = false;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers: {
            'X-CSRF-TOKEN': "{{csrf_token()}}"
          },
          url: '{{route("customer.store")}}',
          method: 'post',
          data: {
            "name": datas[0]['value'],
            'code': datas[1]['value'],
            'email': datas[2]['value'],
            'phone': datas[3]['value'],
            'address1': datas[4]['value'],
            'type': this.selectType.id,
            'receivable': this.selectReceive.id,
            'payable': this.selectPay.id,
            'class': (this.selectedClass) ? this.selectedClass.id : null
          },
          dataType: 'json',

        }).done(function(response) {
          if (response) {
              v.selected_vendor = response.customer;
          }
        }).fail(function(error) {
          console.log('error', error);
        });

      }
    }
  });

  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var bank_edit = {!! $bank_edit !!};
  var selectedBank = {!! $selectedBank !!};
  var purchaseContract={!! $purchaseContract !!};
  var purchase={!! $purchase !!};
  var inventory_category = {!! $inventory_category !!};

  var v = new Vue({
    el: '#app',
    data: {
      showModal: false,
      selected_purchase_order: <?php if ($purchase->order_id) {echo $purchase->order_id;} else {echo 'null';} ?>,
      vendor_id: {!!$purchase->vendor_id!!},
      vendor: [],
      selected_vendor: {!!$selectedVendor!!},
      contract: [],
      selected_contract: null,
      banks: banks,
      selected_banks: selectedBank,
      currency: {!!$currency!!},
      selected_currency: {!!$selectedCurrency!!},
      selected_item: {!!$selectedItem!!},
      open_stock_data: {!!json_encode($opening) !!},
      sites: {!!json_encode($site) !!},
      brandAll: {!!$brand!!},
      purchase: purchase,
      inventory_category: inventory_category,
      per_qty_check:{{($billInfo->per_qty == 'on')?'true':'false'}},
      rate: 0,
      discountFiled: 0,
      selectedIndex: 0,
      discountIsAmount: false,
      disabled: false,
      differentRate: false,
      temp_items: [],
      totalAmountes: [],
      ser_sum: null,
      item_sum: null,
      newCost: [
        null,
        null,
        null,
        null
      ],
      inventories: [],
      payments: [],
      services: [],
      ref_no: '',
      msg: '',
      isError1: false,
    },


    computed: {
      selectedRate() {
        if(this.selected_currency){
          this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

          for (var i = 0; i < this.inventories.length; i++) {
              if (this.inventories[i].item && this.inventories[i].item != null) {
                  if (this.inventories[i].item.new_rate) {
                      @if(systemConfig()[30] == 1)
                      this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                      @else 
                      this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                      @endif
                  }
              }
          }
        }
      },
      discount() {
        if (this.discountIsAmount) {

          if (this.subtotal > 0 && this.discountFiled) {
            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
          } else {
            return 0;
          }
        } else {

          return this.discountFiled
        }

      },

      // calculate subtotal
      subtotal: function() {
        var sum = 0;
        var ser_sum = 0;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item && this.inventories[i].item != null) {

            var quantity = this.inventories[i]['item']['quantity'];
            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                quantity = this.inventories[i]['item']['other_measure'];
            }
            var rate = this.inventories[i]['item']['rate'];
            var new_rate = this.inventories[i]['item']['new_rate'];
            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
            var measure_unit = this.inventories[i]['item']['measure_unit'];
            if (new_rate != rate && quantity > 0) {
              @if(systemConfig()[30] == 1)
              sum += new_rate * quantity *  this.selected_currency.static_rate  / this.selected_currency.rate;
              @else 
              sum += new_rate * quantity * this.selected_currency.rate;
              @endif
            } else {
              @if(systemConfig()[30] == 1)
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
              @endif
            }

          }

        }

        // for (var i = 0; i < this.services.length; i++) {
        // if (this.services[i]['item']['qut_in'] != null && this.services[i]['item']['cost'] != null)
        // ser_sum += this.services[i]['item']['qut_in'] * this.services[i]['item']['cost'] * this.selected_currency.rate;
        // }

        // this.ser_sum = ser_sum;
        this.item_sum = sum;

        return sum;
      },

      // check payed amount
      payeds: function() {
        this.differentRate = false;
        var sum = 0;
        for (var i = 0; i < this.payments.length; i++) { 
          if (this.payments[i].item != null && this.payments[i].item) {
            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
              @if(systemConfig()[30] == 1)
              sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += (this.payments[i]['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
              @endif

              if (this.selected_currency.code == this.payments[i]['item']['code'] && this.payments[i]['amount']) {
                if (this.selected_currency.rate != this.payments[i]['item']['rate']) {
                  this.differentRate = true;
                }
              }
            }
          }
        }
        return sum;
      },

      // check data validation
      isError: function() {
        var isError = false;
        var flag = false;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item) {
              var rate = this.inventories[i]['item']['rate'];
              var new_rate = this.inventories[i]['item']['new_rate'];
              @if(getAddItemWithZeroRate() != 'true')
              if (new_rate <= 0) {
                flag = true;
              }
              @endif
          }
        }
        if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || flag) {
          isError = true;
        }
        return isError;


      },
    },
    mounted: function() {

      if(this.purchase.ref_no){
        this.ref_no = this.purchase.ref_no;
      }

      for (var i = 0; i < this.open_stock_data.length; i++) {
        // console.log('ssssssss',this.open_stock_data[i]);
        this.services.push({
          item: this.open_stock_data[i]
        });

      }

      // initialize the selected item
      for (var i = 0; i < this.selected_item.length; i++) {
        this.selected_item[i].selectedBrand = _.find({!!$brand!!}, (o) => o.id == this.selected_item[i]['brand_id']);
        var item_category = _.find(this.inventory_category, (o) => o.id == this.selected_item[i]['inventory_category_id']);

        this.inventories.push({
          item: this.selected_item[i],
          inventory: this.selected_item[i],
          item_category: item_category,
          main_stocks_id:  this.selected_item[i].main_stocks_id, 
          m_stocks_in_id:  this.selected_item[i].m_stocks_in_id
        });
      }
      this.inventories.push({
        item: null,
        inventory: null,
        item_category: null,
        main_stocks_id: null, m_stocks_in_id: null
      });
      // initialize payments
      for (var k = 0; k < this.selected_banks.length; k++) {
        var foundFlag = false;
        var tempBank = null;
        for (var j = 0; j < bank_edit.length; j++) {
          if (bank_edit[j].id == this.selected_banks[k].Account_id) {
            foundFlag = true;
            tempBank = bank_edit[j];
            tempBank.amount = this.selected_banks[k].Amount;
            if (this.selected_currency.code == tempBank.code) {
                tempBank.rate = this.selected_currency.rate;
            } else {
                tempBank.rate = this.selected_banks[k].Rate;
            }
          }
        }
        if (foundFlag) {

          this.payments.push({
            item: tempBank,
            items: this.banks, 
            amount: tempBank.amount
          });
        }

      }

      for (var w = 1; w > this.selected_banks.length; w--) {
        this.payments.push({
          item: null,
          amount: null,
          items: banks
        });
      }
      // end payment

      if (this.purchase) {
        this.discountFiled = this.purchase.discount;
        if (this.purchase.discount_type) {
          if (this.purchase.discount_type == 'percent') {
            this.discountIsAmount = false;
          } else {
            this.discountIsAmount = true;
          }
        }
      }
    },
    methods: {

      changeMetraz(index) {
          @if(systemConfig()[21] == 1)
          if (this.inventories[index]) {
              if (this.inventories[index].item.lengths != null && this.inventories[index].item.widths != null && this.inventories[index].item && this.inventories[index].item != null) {

                  var lengths = Number.parseFloat(this.inventories[index].item.lengths);
                  var widths = Number.parseFloat(this.inventories[index].item.widths);
                  if (lengths > 0 && widths > 0) {
                    this.inventories[index].item.other_measure = myRound(lengths * widths);
                    // console.log(22,lengths, widths);
                    if (this.inventories[index].item.other_measure != null && this.inventories[index].item.unit_price != null) {
                        var other_measure = Number.parseFloat(this.inventories[index].item.other_measure);
                        var unit_price = Number.parseFloat(this.inventories[index].item.unit_price);
                        if (unit_price > 0 && other_measure > 0) {
                          // console.log(22,other_measure, unit_price, this.selected_currency.rate);
                          @if(systemConfig()[30] == 1)
                          this.inventories[index].item.new_rate = myRound((other_measure * unit_price) / this.selected_currency.static_rate * this.selected_currency.rate);
                          @else 
                          this.inventories[index].item.new_rate = myRound((other_measure * unit_price)) / Number.parseFloat(this.selected_currency.rate);
                          @endif

                        }
                    }
                  }
              }
          }
          @endif
      },

      changeCost(index) {
          @if(systemConfig()[21] == 1)
          if (this.inventories[index]) {
            if (this.inventories[index].item && this.inventories[index].item != null) {
              if (this.inventories[index].item.other_measure != null && this.inventories[index].item.unit_price != null) {
                  var other_measure = Number.parseFloat(this.inventories[index].item.other_measure);
                  var unit_price = Number.parseFloat(this.inventories[index].item.unit_price);
                  if (unit_price > 0 && other_measure > 0) {
                      // console.log(other_measure, unit_price, this.selected_currency.rate);

                      @if(systemConfig()[30] == 1)
                      this.inventories[index].item.new_rate = myRound((other_measure * unit_price)) / Number.parseFloat(this.selected_currency.static_rate) * Number.parseFloat(this.selected_currency.rate);
                      @else 
                      this.inventories[index].item.new_rate = myRound((other_measure * unit_price)) / Number.parseFloat(this.selected_currency.rate);
                      @endif
                  
                    }
              }
            }
          }
          @endif
      },

      // calculate item price based on measure change
      measureChange(index) {

        if (this.inventories[index].item != null) {
          var item = this.inventories[index].item;

          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
          result = Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate = result;

          // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

        }
      },
      // detect member change and searh
      memberChange() {
        if (this.selected_vendor) {
          // get member contract
          // get member contract
          this.contract = [];
          axios.get("{{route('callMethod.search')}}", {
              params: {
                method_name: 'member_contract',
                member_id: this.selected_vendor.id
              }
            })
            .then(function(response) {
              if (response.data.length > 0) {
                v.contract = response.data;
                if (v.contract) {
                  for (var m = 0; m < v.contract.length; m++) {

                    if (v.contract[m].id == purchaseContract.contract_id) {
                      v.selected_contract = v.contract[m];
                    }
                  }
                }

              }
            })
            .catch(function(error) {
              console.log(error);
            });
        }
      },

      memberClassChange() {
          if (v.selected_class) {
              v.vendor = [];
              let class_id = v.selected_class.id;
          
              axios.get("{{route('callMethod.search')}}", {
                  params: {
                      method_name: 'SearchMember',
                      class_id: class_id,
                      type: 'Vendor'
                  }
              })
              .then(function(response) {
                  if (response.data.length > 0) {
                      // console.log(response.data);
                      v.vendor = [];
                      v.vendor = response.data;
                  }
              })
              .catch(function(error) {
                  console.log(error);
              })
          }
      },
      MemberSearch: _.debounce((search, loading) => {
          loading(true);
          let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
          
          axios.get("{{route('callMethod.search')}}", {
              params: {
                  method_name: 'SearchMember', 
                  keyword: search,
                  class_id: class_id,
                  type: 'Vendor'
              }
          })
          .then(function(response) {
              if (response.data.length > 0) {
                  // console.log(response.data);
                  v.vendor = [];
                  v.vendor = response.data;
              }
              loading(false);
          })
          .catch(function(error) {
              loading(false);
              console.log(error);
          })
      }, getDebounceTime()),

      // set new price
      setNewRate(index) {
        if (this.inventories[index].item) {
          this.inventories[index].item.code = this.$refs.code[index].value;
          // this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          if (this.$refs.widths) {
            this.inventories[index].item.widths = this.$refs.widths[index].value;
          }
          @if(systemConfig()[21] == 1)
          if (this.$refs.lengths) {
            this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          }
          if (this.$refs.unit_price) {
            this.inventories[index].item.unit_price = this.$refs.unit_price[index].value;
          }
          @endif
          if (this.$refs.price) {
            this.inventories[index].item.price = this.$refs.price[index].value;
          }
          @if(getShowWing()!="false")
          if (this.$refs.khada) {
            this.inventories[index].item.khada = this.$refs.khada[index].value;
          }
            this.inventories[index].item.approx_weight = 0;
          // if (this.$refs.approx_weight) {
          //   this.inventories[index].item.approx_weight = this.$refs.approx_weight[index].value;
          //   // console.log('3333',this.inventories[index].item);
          // }

          if (v.inventories[index].item.khada && v.inventories[index].item.quantity) {

              var khada = v.inventories[index].item.khada;
              var quantity = v.inventories[index].item.quantity;

              if (khada != null && quantity != null) {
                  v.inventories[index].item.approx_weight = Number.parseFloat(quantity / khada).toFixed(10);
              }
          }

          @endif
          @if(showLocation()=="true")
          if (this.$refs.location) {
            this.inventories[index].item.location = this.$refs.location[index].value;
          }
          @endif
          @if(getShowSuperceedNo()=="true")
          if (this.$refs.superceed) {
            v.inventories[index].item.superceed = this.$refs.superceed[index].value;
          }
          @endif
          // if (this.$refs.other_measure && showWhat('other_measure')=='yes') {
          //   this.inventories[index].item.other_measure = this.$refs.other_measure[index].value;
          // }
          // if (this.$refs.other_measure2 && showWhat('other_measure2')=='yes') {
          //   this.inventories[index].item.other_measure2 = this.$refs.other_measure2[index].value;
          // }
          // this.inventories[index].item.cost = this.$refs.cost[index].value;
          this.inventories[index].item.quantity = this.$refs.quantity[index].value;
          if (this.selected_currency.rate) {
            @if(systemConfig()[30] == 1)
            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
            @else 
            this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
            @endif 
          }


        }

      },
      // set new price
      setApproxWeight(index) {
        if (this.inventories[index].item) {
          @if(getShowWing()!="false")
          if (this.$refs.approx_weight) {
            this.inventories[index].item.approx_weight = this.$refs.approx_weight[index].value;
          }
          @endif

        }

      },
      // begin item search
      itemCategoryChange(index) {

        v.selectedIndex = index;
        v.selected_iventory_category = this.inventories[index]['item_category'];
        if (this.inventories[index]['item_category'] != null) {
          if (v.inventories[index].item == null || !v.inventories[0].item.purchase_order_detail_id) {
            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
            axios.get("{{route('callMethod.search')}}", {
                params: {
                  method_name: 'itemSearchNameRoll',
                  inventory_category_id: inventory_category_id
                }
              })
              .then(function(response) {
                v.inventories[index]['item'] = null;
                v.inventories[index]['inventory'] = null;
                v.temp_items = [];

                if (response.data.length > 0) {
                  v.temp_items = response.data;
                }

              })
              .catch(function(error) {
                console.log(error);
              });

          } else {
            loading(false);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                  method_name: 'purchaseOrderItemsRoll',
                  purchase_order_id: v.selected_purchase_order.id,
                  type: ''
                }
              })
              .then(function(response) {
                if (response.data.length > 0) {
                  // v.temp_items= [];
                  v.temp_items = response.data;
                }

              })
              .catch(function(error) {
                console.log(error);
              })
          }

        }

      },

      onItemSearch: _.debounce((search, loading) => {
        var selectedIndex = v.selectedIndex;
        let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: "itemSearchNameRoll",
              keyword: search,
              inventory_category_id: inventory_category_id,
            }
          })
          .then(function(response) {
            v.temp_items = [];
            if (response.data.length > 0) {
              v.temp_items = response.data;

              // console.log('132', v.temp_items);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      }, getDebounceTime()),

      // end item search

      //ajax call to get items code
      onItemLoadCode(selectedIndex) {
        v.selectedIndex = selectedIndex;

        if (v.inventories[selectedIndex].inventory != null) {
          // console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
          var inventory_id = v.inventories[selectedIndex].inventory.id;

          axios.get("{{route('callMethod.search')}}", {
              params: {
                member_id: v.member_id,
                method_name: 'itemSearchPurchaseRoll',
                inventory_id: inventory_id,
                // inventory_category_id: inventory_category_id,
              }
            })
            .then(function(response) {
              if (response.data.length > 0) {
                v.inventories[selectedIndex].item = null;
                v.inventories[selectedIndex].item = response.data[0];
                // console.log('gg');
                v.temp_items = [];
              }
            })
            .catch(function(error) {
              console.log(error);
            })
        }

      },

      // end item search



      // contract search



      // end contract search

      // generic function for adding item to list
      addNew(type = null, index) {

        if (type != null) {
          if (type == 'inventory') {
            if (this.inventories[index + 1] == undefined) {
              for (var i = 0; i < this.inventories.length; i++) {
                if (this.inventories[i].item != null) {
                  v.inventories[i].item.code = this.$refs.code[i].value;
                  // v.inventories[i].item.lengths = this.$refs.lengths[i].value;
                  if (this.$refs.widths) {
                    v.inventories[i].item.widths = this.$refs.widths[i].value;
                  }
                  @if(getShowWing()!="false")
                  if (this.$refs.khada) {
                    v.inventories[i].item.khada = this.$refs.khada[i].value;
                  }
                  if (this.$refs.approx_weight) {
                    v.inventories[i].item.approx_weight = this.$refs.approx_weight[i].value;
                  }
                  @endif

                  // v.inventories[i].item.cost = this.$refs.cost[i].value;
                  v.inventories[i].item.quantity = this.$refs.quantity[i].value;
                }

              }

              this.temp_items = [];
              this.inventories.push({
                item: null,
                inventory: null,
                item_category: null,
                main_stocks_id: null, m_stocks_in_id: null
              });
            }
          }
          if (type == 'payment') {
            if (this.payments[index + 1] == undefined) {
              this.checkExistingPayment(index, '');
              this.payments.push({
                items: this.banks,
                item: null,
                amount: null,
              });
            }
          }
        }

      },

      // in here you can check and decide to allow duplicate bank for payment or not
      checkExistingPayment(index = null, name = '') {
        // console.log(this.banks);
        var bank_temp = this.banks.slice();
        var bank_temp1 = [];
        for (var i = 0; i < this.payments.length; i++) {
          if (this.payments[i].item != null) {
            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
            if (fined != -1) {
              var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
            }
          }
        }
        this.payments[index].items = bank_temp.filter((item) => {
          return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
        });
        //this.payments[index].items =bank_temp; 


      },
      // delete item from list
      deleteItem(type = null, index) {
        if (type != null) {
          // console.log(type);
          if (type == 'inventory') {
            swal({
                title: "@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    this.inventories.splice(index, 1);
                }
                else {
                    
                }
            });
          }
          if (type == 'payment') {
            this.payments.splice(index, 1);
          }
        }

      },



      // generic function for adding item to list
      add_roll(index) {




        if (v.services[index + 1] == undefined) {
          v.services.push({
            item: {
              name: ' ',
              id: null,
              inventory_site_id: null,
              main_stocks_id: null,
              m_stocks_in_id: null,
              code: null,
              lengths: null,
              widths: null,
              khada: null,
              approx_weight: null,
              cost: null,
              qut_in: null
            }
          });


        }


      },
      // delete item from list
      deleteItem_roll(index) {
        this.services.splice(index, 1);

      },

      // submit the form
      submitForm() {
        this.$validator.validate().then(valid => {
          if (valid) {
        if (this.isError == true) {
          alert('there is no item');
          return false;
        }
        v.disabled = true;
        swal({
          title: "@lang('layout.AreYouSure?')",
          buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
          text: "",
          icon: "info",
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete) {
            document.getElementById("purchase-form").submit()

          } else {
            v.disabled = false;
          }
        });
      } 
    });

      },

      // 

      saveAndNew() {
        this.$validator.validate().then(valid => {
          if (valid) {
          if (!this.isError) {
              v.disabled = true;
              var url = "{{route('bill_roll.update',$purchase->id)}}";
              form_id = 'purchase-form';
              var data = $('#' + form_id).serialize();
              toggleBlock(true);
              axios.post(url, data)
                  .then(function(response) {
                      toggleBlock(0);
                      // console.log('sss11', response.data);
                      if (response.data.result == 1) {

                          var a = document.createElement('a');
                          a.href = "{{route('bill_roll.index')}}";
                          document.body.appendChild(a);
                          a.click();
                          document.body.removeChild(a);

                          // location.reload("{{route('bill_roll.index')}}");
                      } else {
                          v.disabled = false;
                          var message = "{{__('message.Warning')}}";
                          //$('#error-sound')[0].play();
                          toastr.warning('', message);
                          // toastr.warning('', response.data[1]);
                      }
                  })
                  .catch(function(error) {
                      toggleBlock(0);
                      v.disabled = false;
                      // console.log(error,v.disabled);
                      var message = "{{__('message.Warning')}}";
                      //$('#error-sound')[0].play();
                      toastr.warning('', message);
                  });

          } else {
              alert('there is no item');
              return false;
          }
        } 
      });
      },


    },
    created: function() {

    }

  });
</script>


@endpush