@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
@include("layouts.Cmodal")
@include("bills.modal")

<div class="row" >

  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Enterbill') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>
    <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <!-- BEGIN FORM-->
      {{Form::open(['route' => 'bill_roll.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form'])}}
      {{ csrf_field() }}

      <!-- begin sale order modal -->
      <div id="salOrderApp" v-cloak>
        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
        <input type="hidden" name="type" value="invoicelist"/>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModalPurchaseOrder" @close="showModalPurchaseOrder = false" >
          <div slot="body">
            <div class="row">
              <div class="form-group">

                <div  class="col-md-12">
                  <label class="control-label ">@lang('layout.Select') </label>
                  <select class="form-control" style="border: 1px solid black !important" v-model="selected_purchase_order" @input="getPurchaseOrdersList"  >
                    <option v-for="order in purchaseOrderList" :value="order" v-if="order.new_qut_in > order.qut_out">
                      <span>
                       @lang('layout.Number'): @{{order.number}} -- @lang('layout.Code'): @{{order.orderNumber+' '+order.description}}
                     </span>
                   </option>
                 </select>
               </div>

               
             </div>
           </div>

            <div class="row">
              <div class="form-group">
                <div  class="col-md-12">
                  <label class="control-label ">@lang('layout.Select') </label>
                  <select class="form-control" style="border: 1px solid black !important" v-model="selected_purchase_order_list">
                    <option v-for="orders in purchaseOrderList_new" :value="orders">
                      <span>
                       @{{orders.item.name}}
                     </span>
                   </option>
                 </select>
               </div>
             </div>
           </div>

           <div class="row">
            <div class="form-group">

              <div  class="col-md-6">
                <label class="control-label ">@lang('layout.Currency') </label>
                <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.currency" class="form-control" disabled="disabled">
              </div>
              <div  class="col-md-6">
                <label class="control-label ">@lang('layout.Rate') </label>
                <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.rate" class="form-control" disabled="disabled">
              </div>
            </div>
          </div>
          <div class="row">
            <div class="form-group">

              <div  class="col-md-6">
                <label class="control-label ">@lang('layout.Date') </label>
                <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.date" class="form-control" disabled="disabled">
              </div>
              <div  class="col-md-6">
                <label class="control-label ">@lang('layout.DeliveryDate') </label>
                <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.delivery_date" class="form-control" disabled="disabled">
              </div>
            </div>
          </div>
          <div class="row">
            <div class="form-group">

              <div  class="col-md-12">
                <label class="control-label ">@lang('layout.Description') </label>
                <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.description" class="form-control" disabled="disabled">
              </div>
              
            </div>
          </div>
          <br>
          <p style="color: red">@lang('layout.SOmsg')
           
          </div>

          <div slot="footer">
            <button type="button" v-if="selected_purchase_order && selected_purchase_order_list" @click="getPurchaseOrders" class="btn btn-success">
              @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" v-on:click="showModalPurchaseOrder=false">
              @lang('layout.Cancel')
            </button>
          </div>
        </modal>
        <!-- {{Form::close()}} -->
      </div>
      <!-- end sale order modal -->


      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
            <!-- begin inputs -->
            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Vendor')</label>
                    
                    <v-select  label="name" @input="memberChange()" :options="vendor" v-model="selected_vendor"></v-select>
                    <input type="hidden" name="vendor" v-validate="'required'" data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id" required>
                    <span class="required">@{{ errors.first('vendor') }}</span>
                  </div>
                </div> 
              </div>

              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label col-md-12"><br></label>
                    
                    <button type="button" class="btn blue" @click="showModal = true">@lang('layout.NewVendor')</button>
                  </div>
                </div> 
              </div>

              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.BillNumber')</label>
                    
                    <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.BillNumber')" value="{{$number}}" class="form-control">
                    <span class="required">@{{ errors.first('number') }}</span>
                  </div>
                </div> 
              </div>
              
            </div>

            <div class="row">
              
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Currency')</label>
                    
                    
                    <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                    <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                    <span class="required">@{{ errors.first('currency') }}</span>
                    
                  </div>
                </div> 
              </div>

              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Rate')</label>
                    
                    <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                    
                    
                  </div>
                </div> 
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.ContractName')</label>
                    
                    <v-select  label="Contract_Name" :options="contract" v-model="selected_contract"></v-select>
                    <input type="hidden" name="contract_id" :value="(this.selected_contract==null)?null:selected_contract.id">
                  </div>
                </div> 
              </div>
              
            </div>

            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Description')</label>
                    
                    <textarea  name="description" class="form-control" rows="1"></textarea>
                  </div>
                </div> 
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Date')</label>
                    
                    <input type="text" name="date"  class="form-control date" autocomplete="off">
                  </div>
                </div> 
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.OverdueDate')</label>
                    
                    <input type="text" name="overdue_date"  class="form-control date" autocomplete="off">
                  </div>
                </div> 
              </div>
            </div>
            <!-- end inputs -->
          </div>
          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

            <!-- begin total -->
            <div class="dashboard-stat2 ">
              <table class="dashboard-tabel" width="100%">
                <tr>
                  <td>
                    <small>@lang('layout.Total') :</small>
                  </td>
                  <td class="text-right"><span data-counter="counterup"
                   data-value="7800">@{{ Number.parseFloat((subtotal )-payeds).toFixed(precision())}}</span>
                   <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                 </td>
               </tr>

               
               <tr>
                <td>
                  <small>@lang('layout.Payment'):</small>
                </td>
                <td class="text-right">
                  <small class="font-green-sharp">
                    <span class="text-right" data-counter="counterup"
                    data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                  </small>
                </td>
              </tr>


              <tr>
                <td>
                  <small>@lang('layout.Sub-Total'):</small>
                </td>
                <td class="text-right">
                  <span class="text-right" data-counter="counterup"
                  data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                </td>
              </tr>

              <tr>
                <td>
                  <small>@lang('layout.Sub-Total'):</small>
                </td>
                <td class="text-right">
                  <span class="text-right" data-counter="counterup"
                  data-value="7800">@{{ ser_sum.toFixed(precision())}}</span>
                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                </td>
              </tr>
            </table>

          </div>

          <!-- end total -->
        </div>

      </div>

      <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
       <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
        <thead>
          <tr>
            <th style="min-width: 130px">@lang('layout.ItemName') </th>
            <th>@lang('layout.ExpireDate') </th>
            <th style="min-width: 100px">@lang('layout.Quantity') </th>
            <th style="min-width: 100px">@lang('layout.OnHand') </th>
            <th class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue') </th>

            <th style="min-width: 100px">@lang('layout.Measure') </th>
            <th style="min-width: 100px">@lang('layout.NewCost') </th>
            <th style="min-width: 100px">@lang('layout.Total') </th>
          </tr>
        </thead>
        <tbody>
          <tr v-for="(item,index) in inventories">
            <td class="highlight">
              <v-select label="name" v-model="item.item" :options="temp_items" @search="onItemSearch"></v-select>
              <input type="hidden" name="inventory_id" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
              <span class="required">@{{ errors.first('inventory_id') }}</span>
              
              <input type="hidden" name="purchase_order_detail_id" :value="(!item.item)?null:item.item.purchase_order_detail_id">
            </td>
         <td>
           <input type="text" placeholder="@lang('layout.ExpireDate')" name="expire_date" class="form-control date">
         </td>
         <td>
           <input type="number" name="quantity" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
           <span class="required">@{{ errors.first('quantity') }}</span>
           
         </td>

         <td>
           @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
         </td>
         <td class="other_measure">
           <input type="number" name="other_measure_amount"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue')">
         </td>
         <td class="highlight">
          <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
            <option value="null">@lang('layout.Select')</option>
            <span v-if="(item.item ==null)?false:true">
              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                @{{measure.measure_name}}
              </option> 
            </span>
            
            
          </select>
          
          <input type="hidden" name="measure" :value="(item.item==null)?null:item.item.measure.measure_id">
        </td>
        <td>
          <div class="input-group">
            <input type="number" name="inventory_price"  placeholder="@lang('layout.Cost')"   :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate(index)" class="form-control">
            <span class="input-group-addon">
              @{{selected_currency.symbol}}
            </span>
          </div>
          
        </td>
        <td>
         <div>
           <div class="input-group">
            <input type="number" class="form-control inner_input"   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate)" placeholder="@lang('layout.Total')" disabled>
            <span class="input-group-addon" >
              <b>@{{selected_currency.symbol}}</b>
            </span>
          </div>
        </div>
      </td>
      <!-- td>
       <span v-if="index > 0" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
     </td -->
   </tr>
   <!--tr style="background-color: #ffffff;">
    <td></td>
    <td><center>
     <button type="button" @click="addNew('inventory',100)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
   </center></td>
   <td></td>
   <td></td>
   <td></td>
   <td></td>
   <td></td>
   <td></td>
   <td></td>
 </tr -->
</tbody>
</table>


       <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
        <thead>
          <tr>
            <th>#</th>
            <th style="min-width: 100px">@lang('layout.SiteName') </th>
            <th style="min-width: 100px">@lang('layout.Code') </th>
            <th style="min-width: 100px">@lang('layout.Length') </th>
            <th style="min-width: 100px">@lang('layout.Width') </th>
            <th style="min-width: 100px">@lang('layout.Wing') </th>
            <th style="min-width: 100px">@lang('layout.Quantity') </th>
            <th style="min-width: 100px">@lang('layout.NewCost') </th>
            <th></th>
          </tr>
        </thead>
        <tbody>

			<tr style="background-color: #ffffff;"  v-for="(service,index) in services">
			   <td>@{{index+1}}</td>
			   <td>
			   <div class="input-group">
				   <v-select placeholder="@lang('layout.SiteName') " label="name"  :options="sites" @click.native="addNew_roll(index)" v-model="service.site" ></v-select>
				   <input type="hidden" name="site_id[]"  :value="(service.site)?service.site.id:null">
				</div>
				</td>
			   <td>
			   <div class="input-group">
					<input name="code[]" type="text" v-model="service.maxCode"  class="form-control" placeholder="@lang('layout.Code')" >
				</div>
			   </td>
			   <td>
			   <div class="input-group">
									<input name="lengths[]" type="number" class="form-control" placeholder="@lang('layout.Length')" >
								</div>
			   </td>
			   <td>
			   <div class="input-group">
									<input name="widths[]" type="number" class="form-control" placeholder="@lang('layout.Width')" >
								</div>
			   </td>
			   <td>
			   <div class="input-group">
									<input name="khada[]" type="number" class="form-control" placeholder="@lang('layout.Wing')" >
								</div>
			   </td>
			   <td>
			   <div class="input-group">
									<input name="qut_in[]" type="number" class="form-control" placeholder="@lang('layout.Quantity')"  v-model.number="service.qty" >
								</div>
			   </td>
			   <td>
			   <div class="input-group">
									<input name="cost_roll[]" type="number" class="form-control" placeholder="@lang('layout.NewCost')"  v-model.number="service.cost" >
								</div>
			   </td>
			   <td>
			   <div class="input-group">
								 <span  v-if="index > 0"   v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
							</div>
			   </td>
			</tr>
		</tbody>
	</table>
<hr>

<!-- begin payments -->
<table id="table_content" class="table table-striped table-bordered table-advance table-hover">
  <thead>
    <tr>
      <th class="text-center" style="min-width: 8px;"> # </th>
      <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
      <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
      <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
      <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
      <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
      <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
      <th></th>
      
    </tr>
  </thead>
  <tbody>
    <tr v-for="(payment,index) in payments">
      <td>@{{index+1}}</td>
      <td class="highlight">
        <v-select label="name" v-model="payment.item"  :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">
          
        </v-select>
        <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
      </td>
      
      <td>
       
        <span v-if="payment.item !=null">
         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
       </span>
     </td>
     <td>
       <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="(payment.item==null)?null:payment.item.rate "
       class="form-control"
       placeholder="@lang('layout.Rate')" required/>
       <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
       v-bind:value="payment.item.rate">
     </td>
     <td>
       <input type="text" name="payment_currency[]" class="form-control"
       v-model="(payment.item==null)?null:payment.item.code"
       placeholder="@lang('layout.Currency')" required disabled/>

       <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
       v-bind:value="payment.item.code"/>
     </td>
     <td>
      <div class="input-group">
        <input type="number" class="form-control"
        v-model.number="(payment.item==null)?null:payment.item.amount "
        placeholder="@lang('layout.PayAmount')" required/>

        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
        v-bind:value="payment.item.amount">

        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
      </div>
    </td>
    <td>
     <div class="input-group">
      <input type="number" class="form-control"
      :value="(payment.item==null)?null:totalPayments(payment.item,selected_currency.rate)"
      placeholder="@lang('layout.Total')" style="min-width: 100px" required />
      <span class="input-group-addon">@{{selected_currency.symbol}}</span>
    </div>
  </td>
  <td>
   <span  v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
 </td>
</tr>
</tbody>
</table>
<!-- end payments -->
</div>



</div>
<div class="col-xs-12 col-sm-10 col-md-11 text-center">
  <button type="button" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
  <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
</div>  
{!! Form::close() !!}
<cmodal :show='showModal' @close="showModal=false">
  
</cmodal>
</div>                  
<!-- END FORM-->
</div>
</div> 

@endsection
@push('scripts')


<script type="text/javascript">

  @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif


  Vue.component("modal",{
    template:"#modal-template",
    props:['show'],

  });
  Vue.component('v-select', VueSelect.VueSelect);
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
      return {
        classes:[],
        selectedClass: null,
        types: [],
        receivables: [],
        payables: [],
        code: null,
        selectType: null,
        selectPay: null,
        selectReceive: null,
        
      }
    },
    created(){
      
      axios.get('{{route("customer.create")}}').then(
        response=>{
          this.types = response.data.types;
          if(this.types)
          {
            for(var i=0;i<this.types.length;i++)
            {
              if(this.types[i].type=="Vendor")
              {
               this.selectType=this.types[i];
             }
           }
         }
         this.receivables = response.data.receivable;
         this.payables = response.data.payable;
         this.code = response.data.code;
         this.classes = response.data.member_class;
          if(this.receivables.length>0)
          {
              this.selectReceive=this.receivables[0];
          }
          if(this.payables.length>0)
          {
              this.selectPay=this.payables[0];
          }

       }).catch(error=> console.log(error));
    },
    methods:{
      onSubmit(){

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers:{'X-CSRF-TOKEN':"{{csrf_token()}}"},
          url:'{{route("customer.store")}}',
          method:'post',
          data: {"name":datas[0]['value'],'email':datas[1]['value'],'phone':datas[2]['value'],'address1':datas[3]['value'],'type':this.selectType.id,'receivable':this.selectReceive.id,'payable':this.selectPay.id,'class':(this.selectedClass)?this.selectedClass.id:null},
          dataType: 'json',

        }).done(function(response){
          axios.get('{{route("bill.create")}}').then(response=>{
            
            v.vendor =response.data.customer;
            document.getElementById("modalForm").reset();

          }).catch(error=> console.log(error));

        }).fail(function(error){
          console.log('error',error);
        });
        
      }
    }
  });



  var vendor={!! $vendor !!};
  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var maxCode = {!! $maxCode !!};
  var v = new Vue({
    el: '#app',
    data: {
     showModal: false,
     vendor:vendor,
     selected_vendor:null,
     contract:[],
     selected_contract:null,
     banks:banks,
     selected_banks:null,
     currency:currency,
     maxCode:maxCode,
     selected_currency:defaultCurrency(),

     showModalPurchaseOrder:false,
     purchaseOrderList:[],
     purchaseOrderList_new:[],
     selected_purchase_order:null,
     selected_purchase_order_list:null,
	 sites:{!! json_encode($site) !!},
     rate:0, 
     temp_items:[],
     totalAmountes: [],
     ser_sum: null,
     item_sum: null,
     newCost:[
     null,
     null,
     null,
     null],
     inventories:[
     {item:null},
     ],
     payments: [
     {
      items: banks,
      item: null,
    }
    ],
	services:[
	  {
	  site: null,
	  qty: null,
	  cost: null,
	  maxCode: maxCode,
	  },
	],
  },
  computed:{
    selectedRate()
    {            
     this.rate= (this.selected_currency)?this.selected_currency.rate:0;
   },
   
          // calculate subtotal
          subtotal: function ()
          {
            var sum = 0;
            var ser_sum = 0;
            for (var i = 0; i < this.inventories.length; i++) {
              if (this.inventories[i].item && this.inventories[i].item !=null)
              {  

                var quantity=this.inventories[i]['item']['quantity'];
                var rate=this.inventories[i]['item']['rate'];
                var new_rate=this.inventories[i]['item']['new_rate'];
                var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                var measure_unit=this.inventories[i]['item']['measure_unit'];
                if(new_rate !=rate && quantity>0)
                {
                 sum +=new_rate*quantity*this.selected_currency.rate;
               }
               else
               {
                sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
              }
              
            }

            }
              
              for (var i = 0; i < this.services.length; i++) {
                     if (this.services[i]['qty'] != null && this.services[i]['qty'] != null)
                         ser_sum += this.services[i]['qty'] * this.services[i]['cost'] * this.selected_currency.rate;
                 }

                 this.ser_sum = ser_sum;
                 this.item_sum = sum;


                return sum;
              },

          // check payed amount
          payeds: function ()
          {
            var sum = 0;
            for (var i = 0; i < this.payments.length; i++)
            {

              if(this.payments[i].item !=null && this.payments[i].item)
              {
               if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
               {
                      //
                      sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']) ;
                    }
                  }
                }
                return sum;
              },

            // check data validation
            isError: function () 
            {
              var isError = false;
              var flag=false;
              for (var i = 0; i < this.inventories.length; i++)
              {
                if (this.inventories[i].item)
                {
                  flag=true;
                  if(((this.inventories[i]['item']['rate'] <=0) ))
                  {
                    rate=this.inventories[i]['item']['rate'];
                    new_rate=this.inventories[i]['item']['new_rate'];
                    if(rate <=0 && new_rate <=0)
                    {
                     isError = true;
                   }
                   
                 }
               }
             }
             if(this.inventories.length==0 || this.selected_vendor==undefined || this.selected_vendor==null || flag==false)
             {
              isError = true;
            }
            return isError;
            

          },
        },
        methods:
        {
          handleSubmit(e) {
           this.$validator.validate().then(valid => {
            if (valid) {
					// alert(e.target);
					v.submitForm(e.target);
				}
			});
         },
         
       // calculate item price based on measure change
       measureChange(index)
       {
        
         if(this.inventories[index].item !=null){
          var item=this.inventories[index].item;
          
          var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
          result=Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate =result;

          
        }
      },
       // detect member change and searh
       memberChange()
       {
         if(this.selected_vendor)
         {
            // get member contract
            this.contract=[];
            axios.get("{{route('callMethod.search')}}",{
              params:{
                method_name:'member_contract',
                member_id:this.selected_vendor.id
              }
            })
            .then(function (response)
            {
             if(response.data.length>0)
             {
              v.contract=response.data;
            }
          })
            .catch(function (error)
            {
              console.log(error);
            });

            this.purchaseOrderSearch(this.selected_vendor.id)
          }
        },
       // set new price
       setNewRate(index)
       {
         if(this.inventories[index].item){
          this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
        }

      },

       // begin purchase order search
       purchaseOrderSearch(member_id=null)
       {
        this.purchaseOrderList=[];
        axios.get("{{route('callMethod.search')}}",{
          params:{
            method_name:'memberPurchaseOrder_roll',
            member_id:member_id,
          }
        })
        .then(function(response){

			console.log('kkkk',response.data);
          if(response.data.length >0)
          {
            v.showModalPurchaseOrder=true;
            v.purchaseOrderList=response.data;
            
          }
        })
        .catch(function(error){
          console.log(error);
        });
      },
       // end purchase order search
        // get selected sale order
        getPurchaseOrders()
        {
          this.showModalPurchaseOrder = false;
			 v.inventories[0] = v.selected_purchase_order_list;
			 v.deleteItem('inventory',100);
			
          // axios.get("{{route('callMethod.search')}}",{
            // params:{
              // method_name:'purchaseOrderItems',
              // purchase_order_id:this.selected_purchase_order.id,
              // // purchase_order_item_id:this.selected_purchase_order_list.id,
              // type:''
            // }
          // })
          // .then(function (response)
          // {
           // if(response.data.length>0)
           // {
            // v.inventories = [];
            // for(var r = 0; r<response.data.length; r++){
              // v.inventories.push({item:response.data[r]});
            // }
            // v.inventories.push({item:null});
            // console.log('test check',v.inventories);
            // v.invoiceDescription = v.selected_sale_order.description;

          // }
          
        // })
          // .catch(function (error)
          // {
            // console.log(error);
          // })
        },


       // get selected sale order list
        getPurchaseOrdersList()
        {
			setTimeout(function(){ v.getPurchaseOrdersLists(); },200);
		},
			getPurchaseOrdersLists()
        {
          //this.showModalPurchaseOrder = false;
          axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'purchaseOrderItemsRoll',
              purchase_order_id:this.selected_purchase_order.id,
              type:''
            }
          })
          .then(function (response)
          {
           if(response.data.length>0)
           {
            v.purchaseOrderList_new = [];
            for(var r = 0; r<response.data.length; r++){
              v.purchaseOrderList_new.push({item:response.data[r]});
            }
            //v.purchaseOrderList_new.push({item:null});
            //console.log('test check',v.purchaseOrderList_new);
            //v.invoiceDescription = v.selected_sale_order.description;

          }
          
        })
          .catch(function (error)
          {
            console.log(error);
          })
		  
        },

      // begin item search
      onItemSearch:_.debounce((search,loading) =>{
        loading(true);
        axios.get("{{route('callMethod.search')}}",{
          params:{
            method_name:'itemSearchPurchaseRoll',
            keyword:search,
          }
        })
        .then(function(response){
          v.temp_items= [];

          if(response.data.length >0)
          {
            v.temp_items = response.data;
          }
          loading(false);
        })
        .catch(function(error){
          console.log(error);
        });
      },getDebounceTime()),

       //ajax call to get items
       

       // end item search

       // contract search


       
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
        this.temp_items=[];
        if(type !=null)
        {
         if(type=='inventory')
         {
          if(this.inventories[index+1]==undefined)
          {
            this.temp_items=[];
            this.inventories.push({item:null});
          }
        }
        if(type=='payment')
        {
          if(this.payments[index+1]==undefined)
          {
            this.checkExistingPayment(index,'');
            this.payments.push({
              items: this.banks,
              item: null,
            });
          }
        }
      }
      
    },
	
	// generic function for adding item to list
	addNew_roll(index)
	{
			if(this.services[index+1]==undefined)
			{
			  this.services.push({
				site: null,
				maxCode: (this.maxCode+index+1),
			});
			}
		 
	  
	},

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
        var bank_temp=this.banks.slice();
        var bank_temp1=[];
        for(var i=0;i<this.payments.length;i++)
        {
          if(this.payments[i].item !=null)
          {
            var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
            if(fined !=-1)
            {
              var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
            }
          }
        }
        this.payments[index].items = bank_temp.filter((item) => {
          return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
        });
               //this.payments[index].items =bank_temp; 


             },
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
           console.log(type);
           if(type=='inventory')
           {
            this.inventories.splice(index, 1);
          }
          if(type=='payment')
          {
            this.payments.splice(index, 1);
          }
        }
        
      },
	  
	  // delete item from list
		deleteItem_roll(index)
		{
				this.services.splice(index, 1);
		  
		},
	  
       // submit the form
       submitForm() 
       {

        if(this.isError==true) {
          alert('there is no item');
          return false;
        }
        swal({
          title:"@lang('layout.AreYouSure?')",
          buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
          text: "",
          icon: "info",
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete)
          {
            document.getElementById("purchase-form").submit()

          }
          else
          {

          }
        });

      },
    },
    created:function()
    {
     
    }

  });

</script>


@endpush