@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('content')
@include("layouts.Cmodal")
@include("layouts.Invmodal")
@include("bills.modal")
<div class="row">
  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Enterbill') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>
    <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <div id="measure">
        <modal v-if="showInfoModal" @close="showInfoModal = false">
          <div slot="body">
            <div class="row">
              <div class="col-md-6">
                <div class="row col-md-12">
                  <h4 class=" col-md-3">
                    @lang('menu.InventoryBrand') :</h4>
                  <h4 class="col-md-8">
                    @{{ brand }}
                  </h4>
                </div>
                <div class="row col-md-12">
                  <h4 class=" col-md-3">
                    @lang('layout.Location') :</h4>
                  <h4 class="col-md-8">
                    @{{ location }}
                  </h4>
                </div>
              </div>
              <div class="col-md-6">
                <div class="row col-md-12">
                  <h4 class=" col-md-3">
                    @lang('layout.SerialNum') :</h4>
                  <h4 class="col-md-8">
                    @{{ SNumber }}
                  </h4>
                </div>
              </div>

            </div>

          </div>
          <h3 slot="header">
            <div class="col-md-4">
              <h3>
                @lang('layout.OtherInformations') @lang('layout.Item')
              </h3>
            </div>
          </h3>
          <div slot="footer">
            <button type=button class="modal-default-button" v-on:click="showInfoModal = false ,measure = null , type=null">
              @lang('layout.Cancel')
            </button>
          </div>
        </modal>
      </div>
      <!-- BEGIN FORM-->
      {{Form::open(['route' => 'bill_roll.store','method' => 'POST','class' => 'form-horizontal','id'=>'purchase-form','files'=> true])}}
      {{ csrf_field() }}
      <!-- begin sale order modal -->
      <div id="salOrderApp" v-cloak>
        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
        <input type="hidden" name="type" value="invoicelist" />
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModalPurchaseOrder" @close="showModalPurchaseOrder = false">
          <div slot="body">
            <div class="row">
              <div class="form-group">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.Select') </label>
                  <select class="form-control" style="border: 1px solid black !important" v-model="selected_purchase_order">
                    <option v-for="order in purchaseOrderList" :value="order" v-if="order.new_qut_in > order.qut_out">
                      <span>
                        @lang('layout.Number'): @{{order.number}} -- @lang('layout.Code'): @{{order.orderNumber+' '+order.description}}
                      </span>
                    </option>
                  </select>
                </div>
              </div>
            </div>

            <!-- div class="row">
              <div class="form-group">
                <div  class="col-md-12">
                  <label class="control-label ">@lang('layout.Select') </label>
                  <select class="form-control" style="border: 1px solid black !important" v-model="selected_purchase_order_list">
                    <option v-for="orders in purchaseOrderList_new" :value="orders">
                      <span>
                       @{{orders.item.name}}
                     </span>
                   </option>
                 </select>
               </div>
             </div>
           </div -->

            <div class="row">
              <div class="form-group">
                <div class="col-md-6">
                  <label class="control-label ">@lang('layout.Currency') </label>
                  <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.currency" class="form-control" disabled="disabled">
                </div>
                <div class="col-md-6">
                  <label class="control-label ">@lang('layout.Rate') </label>
                  <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.rate" class="form-control" disabled="disabled">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="form-group">

                <div class="col-md-6">
                  <label class="control-label ">@lang('layout.Date') </label>
                  <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.date" class="form-control" disabled="disabled">
                </div>
                <div class="col-md-6">
                  <label class="control-label ">@lang('layout.DeliveryDate') </label>
                  <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.delivery_date" class="form-control" disabled="disabled">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="form-group">

                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.Description') </label>
                  <input type="text" name="" :value="(!selected_purchase_order)?null:selected_purchase_order.description" class="form-control" disabled="disabled">
                </div>

              </div>
            </div>
            <br>
            <p style="color: red">@lang('layout.SOmsg')

          </div>

          <div slot="footer">
            <button type="button" v-if="selected_purchase_order" @click="getPurchaseOrdersList" class="btn btn-success">
              @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" v-on:click="showModalPurchaseOrder=false">
              @lang('layout.Cancel')
            </button>
          </div>
        </modal>
        <!-- {{Form::close()}} -->
      </div>
      <!-- end sale order modal -->
      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
            <div class="col-md-12" style="padding: 0px !important;">
              <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Vendor')</label>
                    <div class="input-group">
                        <v-select label="name" @input="memberChange(), getSummary()" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                        <input type="hidden" name="vendor" v-validate="'required'" data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id" required>
                        <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                            <i class="fa fa-plus" style="color: white"></i>
                        </span> 
                    </div>
                    <span class="required">@{{ errors.first('vendor') }}</span>
                    <input type="hidden" name="purchase_order" :value="!selected_purchase_order?null:selected_purchase_order.id">
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.BillNumber')</label>
                    <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.BillNumber')" v-model="number" @input="checkNo()" class="form-control">
                    <span class="required">@{{ errors.first('number') }}</span>
                    <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','date')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Date')</label>
                    <input type="text" name="date" class="form-control date" autocomplete="off"
                    @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                    <span class="required">@{{ errors.first('date') }}</span>
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','hour')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Hour')</label>
                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                        @if(getHourType() == 24)
                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                        @else
                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                        @endif
                        <span class="input-group-btn">
                            <button class="btn default" type="button">
                                <i class="fa fa-clock-o"></i>
                            </button>
                        </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            {{-- <div class="row p-2"> --}}
            <div class="col-lg-3 @if(!getCustomeForm('billroll','referenceNumber')) displayNone @endif" style="margin-right: 10px;">
              <div class="form-group">
                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
              </div>
            </div>
            {{-- </div> --}}
            <div class="col-md-12" style="padding: 0px !important;">
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Currency')</label>
                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                    <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                    <span class="required">@{{ errors.first('currency') }}</span>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Rate')</label>
                    <input type="number" name="currency_rate" v-validate="'required|decimal:8'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                    <span v-if="differentRate" style="background: #efefef; font-size: 14px;" class="required">@lang('message.DifferentRateMsg')</span>
                  </div>
                </div>
              </div>
              <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.ContractName')</label>
                    
                    <v-select  label="Contract_Name" :options="contract" v-model="selected_contract"></v-select>
                    <input type="hidden" name="contract_id" :value="(this.selected_contract==null)?null:selected_contract.id">
                  </div>
                </div> 
              </div -->
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Discount')</label>
                    <div class="input-group">
                      <input v-model="discountFiled" class="form-control" type="number" min="0">
                      <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                      </span>
                      <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                        <input type="hidden" name="discount_type" value="percent">
                      </span>
                      <input type="hidden" name="discountTotal" :value="discount">
                      <input type="hidden" name="discount" :value="discountFiled">
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','overdueDate')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.OverdueDate')</label>
                    <input type="text" name="overdue_date" class="form-control date" autocomplete="off">
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-12" style="padding: 0px !important;">
              <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','description')) displayNone @endif">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Description')</label>
                    <textarea name="description" class="form-control" rows="1"></textarea>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-12" style="margin-top: 10px;">
              @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                <div class="col-lg-1 col-md-1 col-sm-6 col-xs-12 @if(!getCustomeForm('billroll','whatsapp')) displayNone @endif">
                  <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                  <div class="col-md-12 mt-checkbox">
                      <label class="mt-checkbox mt-checkbox-outline">
                          <input type="checkbox"  name="whatsapp" value="5" />
                          <span></span>
                      </label>
                  </div>
                </div>
              @endif
              @if(getSaleByOtherMeasureRate() == "true")
              <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','saleByOtherMeasureRate')) displayNone @endif">
                <div class="col-md-12 form-group">
                  <label class=" control-label">@lang('layout.SaleByOtherMeasureRate')</label>
                  <div>
                    <label class="mt-checkbox mt-checkbox-outline">
                      <input type="checkbox" name="per_qty_check" v-model="per_qty_check">
                      <span></span>
                    </label>
                  </div>
                </div>
              </div>
              @endif
              @if(ImportEngineNumberByExcel()=="true")
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','importEngineNumberByExcel')) displayNone @endif">
                <div class="col-md-12 form-group">
                  <label class=" control-label">@lang('layout.ImportEngineNumberByExcel')</label>
                  <div>
                    <label class="mt-checkbox mt-checkbox-outline">
                      <input type="checkbox" name="import_engine_number" v-model="import_engine_number">
                      <span></span>
                    </label>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('billroll','sampleExcelFile')) displayNone @endif">
                <a href="{{url('/')}}/import_file/simple_import_engine_chassis_number_excel_file.xlsx">
                  <span class="btn btn-success">
                  <i class="fa fa-download"></i>
                  @lang('layout.SampleExcelFile')
                  </span>
                </a>
              </div>
              @endif
            </div>
          </div>
          <div class="col-lg-3 col-md-3 col-sm-12" > 
            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
              <!-- begin total -->
              <div class="dashboard-stat2" style="padding: 15px 15px 0px 15px;">
                <table class="dashboard-tabel" width="100%">
                  <tr>
                    <td>
                      <small>@lang('layout.Total') :</small>
                    </td>
                    <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - ((discount * subtotal)/100))-payeds).toFixed(precision())}}</span>
                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <small>
                        @lang('layout.Discount'): (@{{Number.parseFloat(discount).toFixed(precision()) }}%)
                      </small>
                    </td>
                    <td class="text-right">
                      <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*subtotal/100)) }}</span>
                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <small>@lang('layout.Payment'):</small>
                    </td>
                    <td class="text-right">
                      <small class="font-green-sharp">
                        <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                        <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                      </small>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <small>@lang('layout.Sub-Total'):</small>
                    </td>
                    <td class="text-right">
                      <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                    </td>
                  </tr>
                  <tr>
                    <td>
                      <small>@lang('layout.Sub-Total'):</small>
                    </td>
                    <td class="text-right">
                      <span class="text-right" data-counter="counterup" data-value="7800">@{{ ser_sum.toFixed(precision())}}</span>
                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                    </td>
                  </tr>
                </table>
              </div>
              <!-- end total -->
              <div class="dashboard-stat2" style="padding: 0px 15px 0px 15px;" v-if="selected_vendor">
                <table class="dashboard-tabel table-bordered" width="100%">
                  <thead>
                    <tr>
                      <th class="text-center">@lang('layout.Currency') </th>
                      <th class="text-center">@lang('layout.Payable')</th>
                      <th class="text-center">@lang('layout.Receivable')</th>
                      <th class="text-center">@lang('layout.AverageRate')</th>
                    </tr>
                  </thead>
                  <tbody>
                    <span>
                      <tr v-for="summ in summary">
                        <td class="highlight text-center">
                          @{{ summ.currency }}
                        </td>
                        <td class="text-center"> 
                          @{{ format_number(Number(summ.payment)) }}
                        </td>
                        <td class="text-center">
                          @{{format_number(Number(summ.invoice)) }}
                        </td>
                        <td class="text-center">
                          @{{format_number(Number(summ.rate))}}
                        </td>
                      </tr>
                    </span>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px 15px 0px;">
            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"  >
              <div class="form-group">
                <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                <div class="input-group">
                  <v-select label="name" ref="barcode_search" @input="loadItemGeneral()"  v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')" ></v-select>
                  <span class="btn btn-success input-group-addon " title="@lang('layout.AddNewItem')" @click="showInvModal = true" style="background-color:  rgb(84, 199, 211)">
                      <i class="fa fa-plus" style="color: white"></i>
                  </span> 
                </div>
              </div>
            </div>
            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
              <div class="form-group">
                <!-- <label class="control-label">@lang('layout.Site')</label> -->
                <v-select label="site_name" v-model="selected_iventory_site" :options="inventory_sites1" placeholder="@lang('layout.Site')"></v-select>
              </div>
              <p v-if="selected_item && selected_iventory_site" >
                @{{(selected_item && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}} @{{(selected_item)?selected_item.measure.measure_name:''}}
              </p>
            </div>
            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
              <div class="form-group">
                <!-- <div class="col-md-12"> -->
                  <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                  <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                <!-- </div> -->
              </div>
            </div>
            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
              <div class="form-group">
                <!-- <div class="col-md-12"> -->
                <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                <select v-model="(selected_item == null)?null:selected_item.measure" class="form-control" >
                  <option value="null">@lang('layout.Select')</option>
                  <span v-if="(selected_item ==null)?false:true">
                    <option v-for="measure in (selected_item==null)?null:selected_item.measure_list" :value="measure">
                      @{{measure.measure_name}}
                    </option>
                  </span>
                </select>
                <!-- </div> -->
              </div>
            </div>
            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" >
              <div class="form-group">
                <!-- <div class="col-md-12"> -->
                  <!-- <label class="control-label">@lang('layout.Price')</label> -->
                  <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                <!-- </div> -->
              </div>
            </div>
            <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;" >
              <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
              <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
            </div>
          </div>
        </div>
        <div class="row" style="overflow-x: scroll;" v-if="inventories.length>0">
          <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
            <thead>
              <tr>
                <th>#</th>
                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 100px">@lang('layout.Category') </th>
                <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                @if(itemBrand()=="true")
                <th style="min-width: 80px;">@lang('layout.Brand')</th>
                @endif
                <th style="min-width: 100px">@lang('layout.Code') </th>
                <th v-show="showWhat('expire_date')=='yes'">@lang('layout.ExpireDate') </th>
                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                <th v-show="showWhat('other_measure')=='yes'" class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue1')</th>
                <th v-show="showWhat('other_measure2')=='yes'" class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue2')</th>
                <th style="min-width: 100px">@lang('layout.Measure') </th>
                @if(showLocation()=="true")
                <th style="min-width: 100px">@lang('layout.Location')</th>
                @endif
                @if(getShowSuperceedNo()=="true")
                <th style="min-width: 100px">@lang('layout.SuperceedNo')</th>
                @endif
                <th style="min-width: 100px">@lang('layout.Default_Rate')</th>
                @if(systemConfig()[9] == 0 )
                <th style="min-width: 100px">@lang('layout.Width') </th>
                @if(systemConfig()[21] == 1)
                <th style="min-width: 100px">@lang('layout.Length') </th>
                @endif
                @endif
                @if(systemConfig()[21] == 1)
                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.UnitPrice') </th>
                @endif
                @if(getShowWing()!="false")
                <th style="min-width: 100px">@lang('layout.Wing') </th>
                <th style="min-width: 100px">@lang('layout.ApproxWeight') </th>
                @endif
                @if(systemConfig()[9] != 0 )
                @if(itemPicture()=="true")
                <th style="min-width: 100px">@lang('layout.Photo') </th>
                @endif
                @endif
                <th style="min-width: 100px">@lang('layout.Cost') ({{getHomeCurrency()['code']}})</th>
                <th style="min-width: 100px">@lang('layout.NewCost') (@{{selected_currency.code}}) </th>
                <th style="min-width: 100px">@lang('layout.Total') </th>
                @if(ImportEngineNumberByExcel()=="true")
                <th v-if="import_engine_number" style="min-width: 100px">@lang('layout.EngineNumber') @lang('layout.File')</th>
                @endif
                <th></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(item,index) in inventories">
                <td>@{{index+1}}</td>
                <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                  <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange(index)" @click.native="addNew('inventory',index)"></v-select>
                  <input type="hidden" :name="'inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                </td>
                <td class="highlight">
                  <div class="input-group">
                    <v-select label="name" v-model="item.inventory" :options="temp_items" @search="onItemSearch" 
                    @input="(editKey)?onItemLoadCode(index):''" @keyup.native="addNew('inventory',index), editKey = true" @Click.native="addIndex(index), editKey = true" ></v-select>
                    <input type="hidden" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                    <input type="hidden" :name="'purchase_order_detail_id['+index+']'" :value="(!item.item)?null:item.item.purchase_order_detail_id">
                    <span class="btn btn-success input-group-addon" @click="showInfo(index)"> <i class="fa fa-info"></i> </span>
                  </div>
                </td>
                <td>
                  <!-- <div class="input-group"> -->
                    <v-select placeholder="@lang('layout.SiteName') " label="name" :options="(item.item==null)?sites:item.item.site_list" v-model="(!item.item)?null:item.item.site"></v-select>
                    <input type="hidden" :name="'site_id['+index+']'" :value="(item.item)?item.item.site.id:null">
                  <!-- </div> -->
                </td>
                @if(itemBrand()=="true")
                <td>
                  <v-select placeholder="@lang('layout.Brand')" label="name" @input="selectCode(index)" :options="brandAll" v-model="item.selectedBrand"></v-select>
                  <input type="hidden" :name="'brand_id['+index+']'" :value="(item.selectedBrand)?item.selectedBrand.id:null">
                </td>
                @endif
                <td >
                  <input :name="'code['+index+']'" type="text" {{-- v-model="item.maxCode" --}} v-model="item.maxCode" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Code')">
                </td>
                <td v-show="showWhat('expire_date')=='yes'">
                  <date_picker :name="'expire_date['+index+']'" oninput = "autowidths(event)" class="chan_length" placeholder="@lang('layout.ExpireDate')"></date_picker>
                </td>
                <td>
                  <input type="number" :name="'quantity['+index+']'" v-model.number="(item.item==null)?null:item.item.quantity" @input="changeApproxWeight(index)"
                  oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                </td>
                <td>
                  @{{myRound((item.item==null)?null:purchaseItemQuantity(item.item,item.item.quantity))}}
                </td>
                <td v-show="showWhat('other_measure')=='yes'" class="other_measure">
                  <input type="number" :name="'other_measure_amount['+index+']'" v-model.number="(item.item==null)?null:item.item.other_measure" @input="changeCost(index)" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                </td>
                <td v-show="showWhat('other_measure2')=='yes'" class="other_measure">
                  <input type="number" :name="'other_measure_amount2['+index+']'" v-model.number="(item.item==null)?null:item.item.other_measure2" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                </td>
                <td class="highlight">
                  <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                    <option value="null">@lang('layout.Select')</option>
                    <span v-if="(item.item ==null)?false:true">
                      <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                        @{{measure.measure_name}}
                      </option>
                    </span>
                  </select>
                  <input type="hidden" :name="'measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                </td>
                @if(showLocation()=="true")
                <td>
                  <input :name="'location['+index+']'" type="text" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Location')">
                </td>
                @endif
                @if(getShowSuperceedNo()=="true")
                <td>
                  <input :name="'superceed['+index+']'" type="text" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.SuperceedNo')">
                </td>
                @endif
                <td>
                  <input :name="'price['+index+']'" type="text" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Default_Rate')">
                </td>
                @if(systemConfig()[9] == 0 )
                <td>
                  <input :name="'widths['+index+']'" v-model="item.widths" @input="changeMetraz(index)" type="number" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Width')">
                </td>
                @if(systemConfig()[21] == 1)
                <td>
                  <input :name="'lengths['+index+']'" type="number" v-model="item.lengths" type="number" @input="changeMetraz(index)" class="form-control" placeholder="@lang('layout.Length')" >
                </td>
                @endif
                @endif
                @if(systemConfig()[21] == 1)
                <td v-show="showWhat('other_measure')=='yes'">
                  <input :name="'unit_price['+index+']'" type="number" @input="changeCost(index)" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.UnitPrice')" v-model.number="item.unit_price">
                </td>
                @endif
                @if(getShowWing()!="false")
                <td>
                  <!-- <div class="input-group"> -->
                    <input :name="'khada['+index+']'" type="number" v-model="item.khada" @input="changeApproxWeight(index)"
                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                  <!-- </div> -->
                </td>
                <td>
                  <!-- <div class="input-group"> -->
                    <input :name="'approx_weight['+index+']'" type="number" step="any" v-model="item.approx_weight"
                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.ApproxWeight')">
                  <!-- </div> -->
                </td>
                @endif
                @if(systemConfig()[9] != 0 )
                @if(itemPicture()=="true")
                <td>
                  <input :name="'photo['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')">
                </td>
                @endif
                @endif
                <td>
                  @{{(item.item==null)?null: Number.parseFloat(item.item.new_rate).toFixed(precision())}}
                </td>
                <td>
                  <vue-numeric v-if="item.item" class="form-control chan_length" oninput = "autowidths(event)" v-model="item.item.cost" :max="99999999999999"  currency="" :precision="precision()" @input="setNewRate(index)">
                  </vue-numeric>
                  <input type="hidden" :name="'inventory_price['+index+']'" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" >
                </td>
                <td>
                  @{{ (item.item==null)?null:getItemTotals(item.item,selected_currency.rate,null,null,1,per_qty_check, null, selected_currency.static_rate) }}
                  <b>@{{selected_currency.symbol}}</b>
                </td>
                @if(ImportEngineNumberByExcel()=="true")
                <td v-if="import_engine_number">
                  <!-- <div class="input-group"> -->
                    <input :name="'engine_number_file['+index+']'" type="file" class="form-control" placeholder="@lang('layout.EngineNumber')">
                  <!-- </div> -->
                </td>
                @endif
                <td>
                  <span v-if="inventories.length > 1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                </td>
              </tr>
              <tr style="background-color: #ffffff;">
                <td></td>
                <td><center>
                <button type="button" @click="addNew('inventory',inventories.length - 1)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
                </center></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
              </tr>
            </tbody>
          </table>
          <hr>
          <!-- begin payments -->
          <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
            <thead>
              <tr>
                <th class="text-center" style="min-width: 8px;"> # </th>
                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(payment,index) in payments">
                <td>@{{index+1}}</td>
                <td class="highlight">
                  <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">
                  </v-select>
                  <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                </td>
                <td>
                  <span v-if="payment.item !=null">
                    @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                  </span>
                </td>
                <td>
                  <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" required />
                  <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                </td>
                <td>
                  <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" required disabled />
                  <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                </td>
                <td>
                  <vue-numeric v-if="payment.item" class="form-control" v-model="payment.item.amount" :max="99999999999999" :currency="payment.item.code" :precision="precision()">
                  </vue-numeric>
                  <input v-if="payment.item !=null" type="hidden" :name="'payment_amount['+index+']'" v-bind:value="payment.item.amount">
                </td>
                <td>
                  <div class="input-group">
                    <input type="number" class="form-control" :value="(payment.item==null)?null:totalPayments(payment.item,selected_currency.rate, null, selected_currency.static_rate)" placeholder="@lang('layout.Total')" style="min-width: 100px" required />
                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                  </div>
                </td>
                <td>
                  <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                </td>
              </tr>
            </tbody>
          </table>
          <!-- end payments -->
        </div>
        <!--Begin Draiver-->
        @if(getDriverInfo()=="true")
        <br>
        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
          <thead>
            <tr>
              <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>
            </tr>
          </thead>
        </table>
        <div class="row">
          <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <!-- begin inputs -->
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.TransferCode')</label>
                  {{Form::text('transfer_code',null,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label">@lang('layout.Transporter_name')</label>
                  <input type="test" name="transporter_name" class="form-control">
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label">@lang('layout.Transporter_phone')</label>
                  <input type="test" name="transporter_phone" class="form-control">
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                  {{Form::text('palce_of_weight',null,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.SourcePlace')</label>
                  {{Form::text('source_place',null,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.PlateNumber')</label>
                  <input type="text" name="plate_number" placeholder="@lang('layout.PlateNumber')" class="form-control">
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.WayBillNumber')</label>
                  <input type="text" name="way_bill_number" placeholder="@lang('layout.WayBillNumber')" class="form-control">
                </div>
              </div>
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.TotalWeight')</label>
                  <input type="text" name="total_weight" placeholder="@lang('layout.TotalWeight')" class="form-control">
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-3">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                  <input type="text" name="empty_car_weight" placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                </div>
              </div>
              <!-- div class="col-md-3">
                  <div class="col-md-12">
                      <label class="control-label ">@lang('layout.TotalBori')</label>
                      <input type="text" name="total_bori" placeholder="@lang('layout.TotalBori')"
                              class="form-control">
                  </div>
              </div -->
              <div class="col-md-6">
                <div class="col-md-12">
                  <label class="control-label ">@lang('layout.Description')</label>
                  {{Form::textarea('transfer_description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                </div>
              </div>
            </div>
          </div>
        </div>
        @endif
        <!--End Draiver-->
        <div class="row">
          <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="form-group">
              <div class="col-md-12">
                <label class="control-label">@lang('layout.Memo')</label>
                <textarea name="memo" class="form-control" rows="2"></textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-xs-12 col-sm-10 col-md-11 text-center">
        <button type="button" v-if="((!isError) && (number_Error == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
        <button type="button" class="btn blue" @click="saveAndNew($event)" :disabled="disabled" v-if="((!isError) && (number_Error == false))" >@lang('layout.SaveAndNew')</button>
        <a href="{{route('bill_roll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
      </div>
      {!! Form::close() !!}
      <cmodal :show='showModal' @close="showModal=false">
      </cmodal>
      <invmodal :show='showInvModal' @close="showInvModal=false">
      </invmodal>
      <modal v-if="showMeasureModal" @close="showMeasureModal = false">
        <div slot="body">
            <div class="row">
                <div class="col-md-3">
                    <h4>@lang('layout.MetricType')</h4>
                    <span v-for="metric in metricList">
                        <div class="mt-radio-list">
                            <label class="mt-radio"> @{{ metric.name }}

                                <input name="metric" type="radio" v-bind:value="metric"
                                v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                <span></span>
                            </label>
                        </div>
                    </span>
                </div>
                <div class="col-md-3">
                    <h4>@lang('layout.Measure') </h4>
                    <span v-for="measure1 in selectedMetric.measure">
                        <div class="mt-radio-list">
                            <label class="mt-radio">
                            <b v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </b>
                            <b v-if="measure1.text !='Other'">@{{ measure1.text }} </b>
                                <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                <span></span>
                            </label>
                        </div>
                    </span>
                </div>
                <div class="col-md-6">
                    <span v-if="selectedMeasure.text == 'Other'">
                        <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                        <div>
                            <div class="form-group">
                                <label class="control-label col-md-5">
                                @lang('layout.MeasureName')</label>
                                <div class="col-md-7">
                                    <input type="text" class="form-control"
                                    placeholder="@lang('layout.EnterMeasureName')"
                                    v-model.trim="selectedMeasure.name">
                                    <span class="help-block">  </span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-5">
                                    @lang('layout.MeasureAmount')
                                </label>
                                <div class="col-md-7">
                                    <input type="number" class="form-control"
                                    placeholder="@lang('layout.EnterMeasureuint')"
                                    v-model.number="selectedMeasure.unit">
                                    <span class="help-block">  </span>
                                </div>
                            </div>
                            <div class="form-group ">
                                <label class="control-label col-md-5">
                                    @lang('layout.MeasureSymbol')
                                </label>
                                <div class="col-md-7">
                                    <input type="text" class="form-control"
                                    placeholder="@lang('layout.EnterMeasureSymbol')"
                                    v-model.trim="selectedMeasure.symbol">
                                    <span class="help-block">  </span>
                                </div>
                            </div>
                        </div>

                    </span>
                </div>

            </div>

        </div>
        <h3 slot="header">
            <div class="col-md-4">
                <h3>
                    @lang('layout.AddNewMeasure')
                </h3>
            </div>
            <div class="col-md-4">
                <div v-if="fieldErrors.length > 0">
                    <p class="text-danger" fieldErrors>
                        <spna v-text="fieldErrors"></spna>
                    </p>
                </div>
            </div>
        </h3>
        <div slot="footer">
            <button type=button class="modal-default-button" v-on:click="addMeasure">
                @lang('layout.OK')
            </button>
            <button type=button class="modal-default-button"
            v-on:click="showMeasureModal = false, showInvModal = true ,measure = null , type=null">
            @lang('layout.Cancel')
        </button>
        </div>
      </modal>
    </div>
    <!-- END FORM-->
  </div>
</div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
<script type="text/javascript">
  @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif

  Vue.use(VueInputAutowidth);
  Vue.use(VueNumeric.default);

  Vue.component("modal", {
    template: "#modal-template",
    props: ['show'],

  });
  Vue.component('v-select', VueSelect.VueSelect);
  Vue.component("cmodal", {
    template: '#cmodal-template',

    props: ['show'],
    data() {
      return {
        classes: [],
        selectedClass: null,
        types: [],
        receivables: [],
        payables: [],
        code: null,
        selectType: null,
        selectPay: null,
        selectReceive: null,

      }
    },
    created() {

      axios.get('{{route("customer.create")}}').then(
        response => {
          this.types = response.data.types;
          if (this.types) {
            for (var i = 0; i < this.types.length; i++) {
              if (this.types[i].type == "Vendor") {
                this.selectType = this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
          this.classes = response.data.member_class;
          if (this.receivables.length > 0) {
            this.selectReceive = this.receivables[0];
          }
          if (this.payables.length > 0) {
            this.selectPay = this.payables[0];
          }

        }).catch(error => console.log(error));
    },
    methods: {
      onSubmit() {

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers: {
            'X-CSRF-TOKEN': "{{csrf_token()}}"
          },
          url: '{{route("customer.store")}}',
          method: 'post',
          data: {
            "name": datas[0]['value'],
            'code': datas[1]['value'],
            'email': datas[2]['value'],
            'phone': datas[3]['value'],
            'address1': datas[4]['value'],
            'type': this.selectType.id,
            'receivable': this.selectReceive.id,
            'payable': this.selectPay.id,
            'class': (this.selectedClass) ? this.selectedClass.id : null
          },
          dataType: 'json',

        }).done(function(response) {
          if (response) {
              v.selected_vendor = response.customer;
          }
        }).fail(function(error) {
          console.log('error', error);
        });

      }
    }
  });

  /// inventory model
  var invm = null;
  Vue.component("invmodal", {
      template: '#invmodal-template',

      props: ['show'],
      data() {
          return {
              measureList: [],
              categories: [],
              income: [],
              cost: [],
              asset: [],
              rate: 0,
              description: null,
              number: null,
              category: null,
              selectMeasure: null,
              incomeAccount: null,
              costAccount: null,
              assetAccount: null,
          }
      },
      created() {

          axios.get('{{route("inventory.create")}}', {
                  params: {
                      add_item: 'on'
                  }
              }).then(
              response => {
                  this.measureList = response.data.measure;
                  this.categories = response.data.category;
                  this.number = response.data.number;
                  this.income = response.data.income;
                  this.cost = response.data.cost;
                  this.asset = response.data.asset;
                  if(this.measureList.length>0)
                  {
                      this.selectMeasure=this.measureList[0];
                  }
                  if(this.income.length>0)
                  {
                      this.incomeAccount=this.income[0];
                  }
                  if(this.cost.length>0)
                  {
                      this.costAccount=this.cost[0];
                  }
                  if(this.asset.length>0)
                  {
                      this.assetAccount=this.asset[0];
                  }

              }).catch(error => console.log(error));
      },
      methods: {
        showMeasureModal() {
            invm = this;
            v.showMeasureModal = true;
            v.showInvModal = false;
          },
          onSubmit() {
              var ivn = this;
              v.showInvModal = false;
              var datas = $("#modalFormInv").serializeArray();
              // console.log(123,datas);
              $.ajax({
                  headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                  url: '{{route("inventory.m_store")}}',
                  method: 'post',
                  data: {
                      "name": datas[0]['value'],
                      'type': datas[1]['value'],
                      'number': datas[2]['value'],
                      'gauge': datas[3]['value'],
                      'rate': datas[4]['value'],
                      'description': datas[5]['value'],
                      'asset_account': this.assetAccount.id,
                      'um_id': this.selectMeasure.id,
                      'income_account': this.incomeAccount.id,
                      'cost_account': this.costAccount.id,
                      'cost': 1,
                      'category': (this.category) ? this.category.id : null
                  },
                  dataType: 'json',

              }).done(function (response) {
                  // console.log(123, response);
                  if (response) {
                      v.selected_inventory = null;
                      v.selected_inventory = response.item;
                  }
                  axios.get('{{route("inventory.create")}}', {
                      params: {
                          saveAndNew: 'on'
                      }
                  }).then(response => {
                      // console.log(1239, response);
                      ivn.number = response.data;
                      document.getElementById("modalFormInv").reset();
                  }).catch(error => console.log(error));

              }).fail(function (error) {
                  console.log('error', error);
              });

          }
      }
  });
  /// inventory model

  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var maxCode = {!! $maxCode !!};
  var inventory_category = {!! $inventory_category !!};
  var v = new Vue({
    el: '#app',
    data: {
      dynamic_time:'',
      number: "{{$number}}",
      number_msg: '',
      editKey: false,
      number_Error: false,
      showModal: false,
      showInfoModal: false,
      showInvModal: false,
      differentRate: false,
      brand: null,
      location: null,
      SNumber: null,
      vendor: [],
      selected_vendor: null,
      contract: [],
      selected_contract: null,
      banks: banks,
      selected_banks: null,
      currency: currency,
      maxCode: maxCode,
      selected_currency: defaultCurrency(),
      inventory_category: inventory_category,
      showModalPurchaseOrder: false,
      discountFiled: 0,
      discountFiledRow: 0,
      discountIsAmount: false,
      purchaseOrderList: [],
      purchaseOrderList_new: [],
      selected_purchase_order: null,
      selected_purchase_order_list: null,
      sites: {!!json_encode($site) !!},
      brandAll: {!!$brand!!},
      per_qty_check: false,
      import_engine_number: false,
      rate: 0,
      selectedIndex: 0,
      temp_items: [],
      totalAmountes: [],
      summary: [],
      ser_sum: null,
      item_sum: null,
      disabled: false,
      newCost: [
        null,
        null,
        null,
        null
      ],
      inventories: [{
        item: null, 
        item_category: null,
        site: null,
        selectedBrand: null,
        lengths: null,
        widths: null,
        unit_price: null,
        khada: null, 
        approx_weight: null,
        maxCode: maxCode
      }, ],
      payments: [],
      services: [{
        site: null,
        qty: null,
        cost: null,
        maxCode: maxCode,
      }, ],

      selected_inventory: null,
      inventory_sites1: [],
      selected_iventory_site: null,
      selected_item: null,
      selected_quantity: null,
      selected_price: null,

      showMeasureModal: false,
      fieldErrors: [],
      selectedMetric: {},
      senddata: {},
      selectedMeasure: {},
      metricList:{!!json_encode(getMeasures())!!},
      ref_no: '',
      msg: '',
      isError1: false,

    },
    computed: {
      selectedRate() {
        if(this.selected_currency){
          var newrate = (this.selected_currency) ? this.selected_currency.rate : 0;
          if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0) {
              this.discountFiled = ((this.discountFiled / this.rate) * newrate);
          }
          this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;


          for (var i = 0; i < this.inventories.length; i++) {
              if (this.inventories[i].item && this.inventories[i].item != null) {
                  if (this.inventories[i].item.new_rate) {                      
                    @if(systemConfig()[30] == 1)
                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                    @else 
                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                    @endif
                    
                  }

              }
          }

        }
      },

      // calculate subtotal
      subtotal: function() {
        var sum = 0;
        var ser_sum = 0;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item && this.inventories[i].item != null) {

            var quantity = this.inventories[i]['item']['quantity'];
            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                quantity = this.inventories[i]['item']['other_measure'];
            }

            var rate = this.inventories[i]['item']['rate'];
            var new_rate = this.inventories[i]['item']['new_rate'];
            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
            var measure_unit = this.inventories[i]['item']['measure_unit'];
            if (new_rate != rate && quantity > 0) {
              @if(systemConfig()[30] == 1)
              sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
              @else 
              sum += new_rate * quantity * this.selected_currency.rate;
              @endif
            } else {
              @if(systemConfig()[30] == 1)
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
              @endif
            }
          }
        }

        for (var i = 0; i < this.services.length; i++) {
          if (this.services[i]['qty'] != null && this.services[i]['qty'] != null)
          @if(systemConfig()[30] == 1)
            ser_sum += this.services[i]['qty'] * this.services[i]['cost'] * this.selected_currency.static_rate / this.selected_currency.rate;
          @else 
            ser_sum += this.services[i]['qty'] * this.services[i]['cost'] * this.selected_currency.rate;
          @endif
        }

        this.ser_sum = ser_sum;
        this.item_sum = sum;


        return sum;
      },

      // check payed amount
      payeds: function() {
        this.differentRate = false;
        var sum = 0;
        for (var i = 0; i < this.payments.length; i++) {

          if (this.payments[i].item != null && this.payments[i].item) {
            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
              @if(systemConfig()[30] == 1)
              sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
              @else 
              sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
              @endif

              if (this.selected_currency.code == this.payments[i]['item']['code'] && this.payments[i]['item']['amount']) {
                if (this.selected_currency.rate != this.payments[i]['item']['rate']) {
                  this.differentRate = true;
                }
              }
            }
          }
        }
        return sum;
      },

      // check data validation
      isError: function() {
        var isError = false;
        var flag = false;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item) {
              rate = this.inventories[i]['item']['rate'];
              new_rate = this.inventories[i]['item']['new_rate'];
              @if(getAddItemWithZeroRate() != 'true')
              if (new_rate <= 0) {
                flag = true;
              }
              @endif
          }
        }
        if (this.inventories.length == 0 || this.selected_vendor == undefined || this.selected_vendor == null || flag) {
          isError = true;
        }
        return isError;


      },
      discount() {
        if (this.discountIsAmount) {

          if (this.subtotal > 0 && this.discountFiled) {
            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
          } else {
            return 0;
          }
        } else {

          return this.discountFiled
        }

      },
    },
    mounted: function () {
        var selected_banks = null;
        var bank=_.find(this.banks,(v)=>v.id=={!! getDropdown('billRoll', 'account') !!});
        if (bank) {
            selected_banks = bank;
        }

        this.payments.push({
            items: this.banks,
            item: selected_banks
        });
        
        // console.log(123, selected_iventory_site, this.inventories);
    },
    methods: {

      checkRefNo() {

      //console.log(vm.ref_no)

      var chack = 'false';
      var ref_no = v.ref_no;
      if (ref_no != null) {


          axios.get("{{route('callMethod.search')}}",
              {

                  params: {
                      ref_no: v.ref_no,
                      method_name: 'Search_ref_no',
                      table_name: 'purchases'
                  },
              })
              .then(function (response) {
                  // console.log(response.data.result);
                  if (response.data.result != null) {
                      console.log(response.data.result);
                      // v.temp_items=response.data;
                      v.msg = "@lang('layout.DuplicateData')";
                      v.isError1 = true;
                  }
                  else {
                      v.msg = 'no';
                      v.isError1 = false;

                  }
              })
              .catch(function (error) {
                  console.log(error);
              });

      }
      },
      //BEGIN - Used for dynamic input time
      dynamicTime()
          {
              this.time_interval = setInterval(() => {
                  const now = new Date()
                  @if(getHourType() == 24)
                      const hours = now.getHours().toString().padStart(2,'0')
                      const minutes = now.getMinutes().toString().padStart(2,'0') 
                      // const seconds = now.getSeconds().toString().padStart(2,'0')
                      this.dynamic_time = `${hours}:${minutes}`
                  @else
                      const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                      this.dynamic_time = `${timeString}`
                  @endif
                  
              },1000);
          },
          stopDynamicTime()
          {
              clearInterval(v.time_interval)
          },
          changeTime()
          {
              v.dynamic_time = v.$refs.time_input.value
          },
      //END - Used for dynamic input time
      changeMetraz(index) {
          @if(systemConfig()[21] == 1)
          if (this.inventories[index]) {
              if (this.inventories[index].lengths != null && this.inventories[index].widths != null && this.inventories[index].item && this.inventories[index].item != null) {

                  var lengths = this.inventories[index].lengths;
                  var widths = this.inventories[index].widths;

                  this.inventories[index].item.other_measure = myRound(lengths * widths);

                  if (this.inventories[index].item.other_measure != null && this.inventories[index].unit_price != null) {
                    var other_measure = this.inventories[index].item.other_measure;
                    var unit_price = this.inventories[index].unit_price; 
                    @if(systemConfig()[30] == 1)
                    this.inventories[index].item.new_rate = myRound((other_measure * unit_price) / this.selected_currency.static_rate * this.selected_currency.rate);
                    @else 
                    this.inventories[index].item.new_rate = myRound((other_measure * unit_price) / this.selected_currency.rate);
                    @endif 
                }
              }
          }
          @endif
      },

      changeApproxWeight(index) {
          @if(getShowWing()!="false")
          if (this.inventories[index]) {
              if (this.inventories[index].khada != null && this.inventories[index].item && this.inventories[index].item != null) {

                  var khada = this.inventories[index].khada;
                  var quantity = this.inventories[index].item.quantity;

                  if (khada != null && quantity != null) {
                      var other_measure = this.inventories[index].item.other_measure;
                      var unit_price = this.inventories[index].unit_price;

                      this.inventories[index].approx_weight = Number.parseFloat(quantity / khada).toFixed(10);
                  }
              }
          }
          @endif
      },

      changeCost(index) {
          @if(systemConfig()[21] == 1)
          if (this.inventories[index]) {
            if (this.inventories[index].item && this.inventories[index].item != null) {
              if (this.inventories[index].item.other_measure != null && this.inventories[index].unit_price != null) {
                  var other_measure = this.inventories[index].item.other_measure;
                  var unit_price = this.inventories[index].unit_price;
                
                  @if(systemConfig()[30] == 1)
                  this.inventories[index].item.new_rate = myRound((other_measure * unit_price) / this.selected_currency.static_rate * this.selected_currency.rate);
                  @else 
                  this.inventories[index].item.new_rate = myRound((other_measure * unit_price) / this.selected_currency.rate);
                  @endif

              }
            }
          }
          @endif
      },
      
      getSummary() {
          if (this.selected_vendor) {
              this.getSummaryRecor(this.selected_vendor.id, this);
          }
      },
      getSummaryRecor(id, v) {
          axios.get("{{route('callMethod.search')}}", {
              params: {
                  method_name: 'memberStatment',
                  member_id: id,
              }
          })
          .then(function(response) {
              if (response.data.length > 0) {
                  v.summary = response.data;
              } else {
                  v.summary = [];
              }
          })
          .catch(function(error) {
              v.summary = [];
              console.log(error);
          });
      },
      // chack_member_payable_levels
        member_chack() {
          var chack = 'false';
          var member_id = this.selected_vendor.id;
          if (member_id != null) {
              var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
              var currency = $("input[name=currency]").val();
              $.ajax({
                  url: "{{route('callMethod.search')}}",
                  async: false,
                  data: {
                      member_id: member_id,
                      method_name: 'Search_member_payable_levels',
                      currency: currency,
                      type:'vendor'
                  },
                  success: function(data) {
                      // console.log('RRRRR',data)
                      var r_amount = Number.parseFloat(data.amount);
                      var r_m_amount = Number.parseFloat(data.m_amount);
                      var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));

                      if (r_amount != 0 && r_amount < totalss) {
                          chack = 'true';
                      } else {
                          chack = 'false';
                      }
                  }.bind(this),
                  error: function(error) {
                      console.log(error)
                  }
              });
          }
          return chack;
      },

      handleSubmit(e) {
        this.$validator.validate().then(valid => {
          if (valid) {
            if (v.member_chack() == 'true') {
                var r = confirm("@lang('layout.member_payable_levels_vendor')");
                if (r == true) {
                    v.disabled = true;
                    v.submitForm(e.target);
                }
            } else {
                v.disabled = true;
                v.submitForm(e.target);
            }
          }
        });
      },
      checkNo() {
          var chack = 'false';
          var number = v.number;
          if (number != null) {
              axios.get("{{route('callMethod.search')}}", {

                      params: {
                          number: v.number,
                          method_name: 'Search_number',
                          table_name: 'purchases'
                      },
                  })
                  .then(function(response) {
                      // console.log(response.data.result);
                      if (response.data.result != null) {
                          // console.log(response.data.result);
                          // v.temp_items=response.data;
                          v.number_msg = "@lang('layout.DuplicateData')";
                          v.number_Error = true;
                      } else {
                          v.number_msg = 'no';
                          v.number_Error = false;

                      }
                  })
                  .catch(function(error) {
                      console.log(error);
                  });

          }
      },
      // calculate item price based on measure change
      measureChange(index) {

        if (this.inventories[index].item != null) {
          var item = this.inventories[index].item;

          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
          result = Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate = result;


        }
      },

      addMeasure: function () {
          let senddata = _.clone(this.selectedMetric);
          senddata.measure = _.clone(this.selectedMeasure);

          var req = axios.post("{{route('measure.store')}}",senddata)
          .then(function (response) {
              if (response) {
                  if (response.data) {
                      // var measure_id = response.data.me.id;
                      invm.selectMeasure = response.data.me;
                      // console.log(444, response, measure_id);
                  }
              }
              v.showMeasureModal = false;
              v.fieldErrors = [];
              v.selectedMetric = {};
              v.selectedMeasure = {};

              axios.get("{{route('inventory.create')}}").then(function (response) {
                  invm.measureList = response.data;
                  v.showInvModal = true;
              });
          })
          .catch(function (error) {
              axios.get("{{route('inventory.create')}}").then(function (response) {
                  invm.measureList = response.data;
                  v.showInvModal = true;
              });

              v.fieldErrors = error.response.data

          });

      },

      // detect member change and searh
      memberChange() {
        if (this.selected_vendor) {
          // get member contract
          this.contract = [];
          axios.get("{{route('callMethod.search')}}", {
              params: {
                method_name: 'member_contract',
                member_id: this.selected_vendor.id
              }
            })
            .then(function(response) {
              if (response.data.length > 0) {
                v.contract = response.data;
              }
            })
            .catch(function(error) {
              console.log(error);
            });

          this.purchaseOrderSearch(this.selected_vendor.id)
        }
      },

      memberClassChange() {
          if (v.selected_class) {
              v.vendor = [];
              let class_id = v.selected_class.id;
          
              axios.get("{{route('callMethod.search')}}", {
                  params: {
                      method_name: 'SearchMember',
                      class_id: class_id,
                      type: 'Vendor'
                  }
              })
              .then(function(response) {
                  if (response.data.length > 0) {
                      // console.log(response.data);
                      v.vendor = [];
                      v.vendor = response.data;
                  }
              })
              .catch(function(error) {
                  console.log(error);
              })
          }
      },
      MemberSearch: _.debounce((search, loading) => {
          loading(true);
          let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
          
          axios.get("{{route('callMethod.search')}}", {
              params: {
                  method_name: 'SearchMember', 
                  keyword: search,
                  class_id: class_id,
                  type: 'Vendor'
              }
          })
          .then(function(response) {
              if (response.data.length > 0) {
                  // console.log(response.data);
                  v.vendor = [];
                  v.vendor = response.data;
              }
              loading(false);
          })
          .catch(function(error) {
              loading(false);
              console.log(error);
          })
      }, getDebounceTime()),
      
      // set new price
      setNewRate(index) {
        if (this.inventories[index].item) {
          @if(systemConfig()[30] == 1)
          this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
          @else 
          this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
          @endif
        }
        // if (this.inventories[index].item) {
        //   this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
        //   this.inventories[index].item.cost = this.$refs.in[index].value / this.selected_currency.rate;
        // }

      },

      showInfo(index) {
        if (v.inventories[index].item != null) {
          v.showInfoModal = true;
          v.brand = v.inventories[index]['item']['brand'];
          v.location = v.inventories[index]['item']['location'];
          v.SNumber = v.inventories[index]['item']['number'];
          // console.log('ffff',v.inventories[index]);
        }
      },
      // begin purchase order search
      purchaseOrderSearch(member_id = null) {
        this.purchaseOrderList = [];
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'memberPurchaseOrder_roll',
              member_id: member_id,
            }
          })
          .then(function(response) {

            // console.log('kkkk', response.data);
            if (response.data.length > 0) {
              v.showModalPurchaseOrder = true;
              v.purchaseOrderList = response.data;

            }
          })
          .catch(function(error) {
            console.log(error);
          });
      },
      // end purchase order search
      // get selected sale order
      getPurchaseOrders() {
        this.showModalPurchaseOrder = false;
        v.inventories[0] = v.selected_purchase_order_list;
        v.deleteItem('inventory', 1000);

        // axios.get("{{route('callMethod.search')}}",{
        // params:{
        // method_name:'purchaseOrderItems',
        // purchase_order_id:this.selected_purchase_order.id,
        // // purchase_order_item_id:this.selected_purchase_order_list.id,
        // type:''
        // }
        // })
        // .then(function (response)
        // {
        // if(response.data.length>0)
        // {
        // v.inventories = [];
        // for(var r = 0; r<response.data.length; r++){
        // v.inventories.push({item:response.data[r]});
        // }
        // v.inventories.push({item:null});
        // console.log('test check',v.inventories);

        // }

        // })
        // .catch(function (error)
        // {
        // console.log(error);
        // })
      },


      // get selected sale order list
      getPurchaseOrdersList() {
        setTimeout(function() {
          v.getPurchaseOrdersLists();
        }, 200);
      },
      getPurchaseOrdersLists() {
        this.showModalPurchaseOrder = false;
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'purchaseOrderItemsRoll',
              purchase_order_id: this.selected_purchase_order.id,
              type: ''
            }
          })
          .then(function(response) {
            if (response.data.length > 0) {
              v.inventories = [];
              var index = 0;
              for (var r = 0; r < response.data.length; r++) {
                var mcode = (response.data[r].code)?response.data[r].code:(maxCode + r);
                v.inventories.push({
                  item: response.data[r],
                  inventory: response.data[r],
                  site: null, item_category: null,
                  selectedBrand: null,
                  lengths: null,
                  widths: null,
                  unit_price: null,
                  khada: null, 
                  approx_weight: null,
                  maxCode: mcode
                });
                index = r;
              }

              v.inventories.push({
                item: null,
                site: null, item_category: null,
                selectedBrand: null,
                lengths: null,
                widths: null,
                unit_price: null,
                khada: null, 
                approx_weight: null,
                maxCode: (maxCode + index + 1)
              });

              v.temp_items = [];
              v.temp_items = response.data;
              // console.log('test check',v.inventories);
              // console.log('test check',v.temp_items);
              // v.deleteItem('inventory',100);

              v.invoiceDescription = v.selected_purchase_order.description;
              v.discountFiled = v.selected_purchase_order.discount;
              if (v.selected_purchase_order.discount_type) {
                  if (v.selected_purchase_order.discount_type == 'currency') {
                      v.discountIsAmount = true;
                  } else {
                      v.discountIsAmount = false;
                  }
              }

              for (var a = 0; a < this.currency.length; a++) {
                  if (v.currency[a].code == v.selected_purchase_order.currency) {
                      v.selected_currency = v.currency[a];
                      v.selected_currency.rate = v.selected_purchase_order.rate;
                      v.rate = v.selected_purchase_order.rate;
                  }
              }

            }

          })
          .catch(function(error) {
            console.log(error);
          })

      },

      itemCategoryChange(index) {
        
        v.selectedIndex = index;
        v.selected_iventory_category = this.inventories[index]['item_category'];
        if (this.inventories[index]['item_category'] != null) {
        if (v.inventories[index].item == null || !v.inventories[0].item.purchase_order_detail_id) {
              let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
              axios.get("{{route('callMethod.search')}}", {
                  params: {
                      method_name: 'itemSearchNameRoll',
                      inventory_category_id: inventory_category_id
                  }
              })
                  .then(function (response) {
                      v.inventories[index]['item'] = null;
                      v.inventories[index]['inventory'] = null;
                      v.inventories[index]['selectedBrand'] = null;
                      v.temp_items = [];

                      if (response.data.length > 0) {
                          v.temp_items = response.data;
                      }

                  })
                  .catch(function (error) {
                      console.log(error);
                  });

            }else{
							loading(false);
							axios.get("{{route('callMethod.search')}}", {
                params: {
                  method_name: 'purchaseOrderItemsRoll',
                  purchase_order_id: v.selected_purchase_order.id,
                  type: ''
                }
              })
              .then(function(response) {
                if (response.data.length > 0) {
                  // v.temp_items= [];
                  v.temp_items = response.data;
                }

              })
              .catch(function(error) {
                console.log(error);
              })
						}

            }

        },

      // begin item search
      onItemSearch: _.debounce((search, loading) => {
        // console.log('ddd332',v.inventories[0].item.purchase_order_detail_id);
        var selectedIndex = v.selectedIndex;
        if (v.inventories[0].item == null || !v.inventories[0].item.purchase_order_detail_id) {
          let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
          loading(true);
          axios.get("{{route('callMethod.search')}}", {
              params: {
                method_name: 'itemSearchNameRoll',
                keyword: search,
                inventory_category_id: inventory_category_id,
              }
            })
            .then(function(response) {
              v.temp_items = [];

              if (response.data.length > 0) {
                v.temp_items = response.data;
              }
              // console.log('new', v.temp_items);
              loading(false);
            })
            .catch(function(error) {
              console.log(error);
            });
        } else {
          // console.log(33333333,v.selected_purchase_order.id);
          axios.get("{{route('callMethod.search')}}", {
              params: {
                method_name: 'purchaseOrderItemsRoll',
                purchase_order_id: v.selected_purchase_order.id,
                type: ''
              }
            })
            .then(function(response) {
              if (response.data.length > 0) {
                // v.temp_items= [];
                v.temp_items = response.data;
              }

            })
            .catch(function(error) {
              console.log(error);
            })
        }
      }, getDebounceTime()),

      //ajax call to get items

      //ajax call to get items code
      onItemLoadCode(selectedIndex) {
        v.selectedIndex = selectedIndex;

        if (v.inventories[selectedIndex].inventory != null) {
          if (v.inventories[0].item == null || !v.inventories[0].item.purchase_order_detail_id) {
            // console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
            var inventory_id = v.inventories[selectedIndex].inventory.id;
            // let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

            axios.get("{{route('callMethod.search')}}", {
                params: {
                  member_id: v.member_id,
                  method_name: 'itemSearchPurchaseRoll',
                  inventory_id: inventory_id,
                  // inventory_category_id: inventory_category_id,
                }
              })
              .then(function(response) {
                v.inventories[selectedIndex].item = null;
                if (response.data.length > 0) {
                  v.inventories[selectedIndex].item = response.data[0];

                  @if(getDefaultSite() > 0)
											var sites_id = {{getDefaultSite()}}
                      for (var i = 0; i < v.inventories[selectedIndex].item.site_list.length; i++) {
                          if (v.inventories[selectedIndex].item.site_list[i].site_id == sites_id) {
                              v.inventories[selectedIndex].item.site = v.inventories[selectedIndex].item.site_list[i];
                          }
                      }
                  @else
                      var sites_id = {{ getDropdown('billRoll', 'site') }}
                      for (var i = 0; i < v.inventories[selectedIndex].item.site_list.length; i++) {
                          if (v.inventories[selectedIndex].item.site_list[i].site_id == sites_id) {
                              v.inventories[selectedIndex].item.site = v.inventories[selectedIndex].item.site_list[i];
                          }
                      }
                  @endif

                  v.temp_items = [];

                  // console.log('gg');

                  // v.onItemSearchCodeSelect(selectedIndex);

                }
              })
              .catch(function(error) {
                console.log(error);
              })
          } else {
            v.inventories[selectedIndex].item = v.inventories[selectedIndex].inventory;
          }
        }

      },

      // end item search
      //ajax call to get items code
      selectCode(selectedIndex) {
        @if(getCodeBrand()=="true")
        if (v.inventories[selectedIndex].item != null && v.inventories[selectedIndex].selectedBrand != null) {

          console.log('12', v.inventories[selectedIndex]);
          var selectedBrandId = v.inventories[selectedIndex].selectedBrand.id;
          var site_id = v.inventories[selectedIndex].item.site.id;
          var inventory_id = v.inventories[selectedIndex].item.site.inventory_id;

          axios.get("{{route('callMethod.search')}}", {
              params: {
                method_name: 'getItemCodePurches',
                inventory_id: inventory_id,
                site_id: site_id,
                selectedBrandId: selectedBrandId,
              }
            })
            .then(function(response) {

              console.log('ggll', response.data);
              if (response.data.length > 0) {
                v.inventories[selectedIndex].maxCode = response.data;

              }
            })
            .catch(function(error) {
              console.log(error);
            })
        }
        @endif

      },

      // end item search
      loadItemGeneral() {
          if (v.selected_inventory != undefined) {
            this.editKey = false;
              var inventory_id = v.selected_inventory.id;
          
              // let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

              axios.get("{{route('callMethod.search')}}", {
                      params: {
                          member_id: v.member_id,
                          method_name: 'itemSearchPurchaseRoll',
                          inventory_id: inventory_id,
                          // inventory_category_id: inventory_category_id,
                      }
                  })
                  .then(function(response) {
                      if (response.data.length > 0) {
                          v.selected_item = null;
                          v.selected_iventory_site = null;
                          v.selected_item = response.data[0];
                          v.selected_price = response.data[0].rate;
                          v.inventory_sites1 = response.data[0].site_list;  
                          v.last_item_sale = response.data[0].last_item_sale;  
                          // console.log(123, response.data[0]);

                      }else{
                          // $('#success-sound')[0].play();
                          // $('#error-sound')[0].play();
                          v.item_not_found = true;
                          setTimeout((function () {
                              v.item_not_found = false;
                              v.$refs.barcode_search.$refs.search.focus();
                          }), 2e3)
                      }
                  })
                  .catch(function(error) {
                      console.log(error);
                  })

          }
      },

      addData() {
          if (v.selected_item) {
              var che = null;
              for (var i = 0; i < v.inventories.length; i++) {
                  if (v.inventories[i].item && v.inventories[i].item != null) {
                      che = 'ok';
                  } else {
                      v.inventories.splice(i, 1);
                  }
              }
              if(!che){
                  v.inventories = [];
              }

              let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
              if (inventory_site_id) {
                  for (var i = 0; i < v.selected_item.site_list.length; i++) {
                      if (v.selected_item.site_list[i].site_id == inventory_site_id) {
                          v.selected_item.site = v.selected_item.site_list[i];
                      }
                  }
              }
          
              v.selected_item.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
              v.selected_item.new_rate = (v.selected_price > 0)?v.selected_price:1;
              // console.log(21,v.inventories,v.inventories.length)
              var index = v.inventories.length;
              v.inventories.push({
                  inventory: v.selected_item,
                  item: v.selected_item,
                  item_category: v.selected_item.item_category,
                  price_level:null,
                  site: null,
                  selectedBrand: null,
                  lengths: null,
                  widths: null,
                  unit_price: null,
                  khada: null, 
                  approx_weight: null,
                  maxCode: (maxCode + index)
              });

              v.selected_inventory = null;
              v.counter_check = 0;
              v.temp_items = [];
              // v.selectSaleNumber(0);
              @if(getShwoPriceLevel()=="general_percent")
              setTimeout((function () {
                  v.change_sale_rate_by_price_level_general();
              }), 400);
              @endif

              // const inp = v.$refs.barcode_search.$refs.search;
              // console.log(v.$refs.barcode_search.$refs.search.value);
              v.$refs.barcode_search.$refs.search.focus();
              // v.$refs.barcode_search.$refs.search = null;
              // v.$refs.barcode_search.focus();

              v.selected_item = null;
              v.selected_price = 0;
              v.selected_quantity = 0;
              
          }
      },
      
      resetData() {
          v.selected_inventory = null;
          v.selected_item = null;
          v.selected_iventory_site = null;
          v.selected_price = 0;
          v.selected_quantity = 0;
          v.$refs.barcode_search.$refs.search.focus();
      },

      // generic function for adding item to list
      addIndex(index) {
        // this.temp_items = [];
        v.selectedIndex = index;
      },

      // generic function for adding item to list
      addNew(type = null, index) {
        // this.temp_items = [];
        if (type != null) {
          if (type == 'inventory') {
            if (this.inventories[index + 1] == undefined) {
                this.temp_items = [];
              this.inventories.push({
                item: null, item_category: null,
                site: null,
                selectedBrand: null,
                lengths: null,
                widths: null,
                unit_price: null,
                maxCode: (maxCode + index + 1)
              });
            }
          }
          if (type == 'payment') {
            if (this.payments[index + 1] == undefined) {
              this.checkExistingPayment(index, '');
              this.payments.push({
                items: this.banks,
                item: null,
              });
            }
          }
        }

      },

      // generic function for adding item to list
      addNew_roll(index) {
        if (this.services[index + 1] == undefined) {
          this.services.push({
            site: null,
            maxCode: (this.maxCode + index + 1),
          });
        }


      },

      // in here you can check and decide to allow duplicate bank for payment or not
      checkExistingPayment(index = null, name = '') {
        var bank_temp = this.banks.slice();
        var bank_temp1 = [];
        for (var i = 0; i < this.payments.length; i++) {
          if (this.payments[i].item != null) {
            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
            if (fined != -1) {
              var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
            }
          }
        }
        this.payments[index].items = bank_temp.filter((item) => {
          return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
        });
        //this.payments[index].items =bank_temp; 


      },
      // delete item from list
      deleteItem(type = null, index) {
        this.editKey = false;
        if (type != null) {
          // console.log(type);
          if (type == 'inventory') {
            this.inventories.splice(index, 1);
          }
          if (type == 'payment') {
            this.payments.splice(index, 1);
          }
        }

      },

      // delete item from list
      deleteItem_roll(index) {
        this.services.splice(index, 1);

      },

      // submit the form
      submitForm() { 
        if (this.isError == true) {
          alert('there is no item');
          return false;
        }
        v.disabled = true;
        swal({
          title: "@lang('layout.AreYouSure?')",
          buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
          text: "",
          icon: "info",
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete) {
            document.getElementById("purchase-form").submit()

          } else {
            v.disabled = false;
          }
        });

      },
      saveAndNew()
      {
          this.$validator.validate()
          .then(valid =>{
              if(valid)
              {
                if (v.member_chack() == 'true') {
                    var r = confirm("@lang('layout.member_payable_levels')");
                    if (r == true) {
                      v.disabled = true;
                      var url="{{route('bill_roll.store')}}";
                      form_id='purchase-form';
                      var data= $('#'+form_id).serialize();
                      // console.log(444, data);
                      toggleBlock(true);
                      axios.post(url,data)
                      .then(function(response){
                              toggleBlock(0);
                              if(response.data.result==1)
                              {
                                  $('#'+form_id).trigger('reset');
                                  
                                  toastr.success('',response.data.message); 
                                  location.reload();
                              
                              }
                              else
                              {
                                v.disabled = false;
                                  var message="{{__('message.Warning')}}";
                                  //$('#error-sound')[0].play();
                                  toastr.warning('',message);
                              }
                      })
                      .catch(function(error){
                        v.disabled = false;
                        toggleBlock(0);
                          console.log(error);
                          var message="{{__('message.Warning')}}";
                          //$('#error-sound')[0].play();
                          toastr.warning('',message);
                      });
                    }
                } else {
                  v.disabled = true;
                  var url="{{route('bill_roll.store')}}";
                  form_id='purchase-form';
                  var data= $('#'+form_id).serialize();
                  // console.log(444, data);
                  toggleBlock(true);
                  axios.post(url,data)
                  .then(function(response){
                          toggleBlock(0);
                          if(response.data.result==1)
                          {
                              $('#'+form_id).trigger('reset');
                              
                              toastr.success('',response.data.message); 
                              location.reload();
                          
                          }
                          else
                          {
                            v.disabled = false;
                              var message="{{__('message.Warning')}}";
                              //$('#error-sound')[0].play();
                              toastr.warning('',message);
                          }
                  })
                  .catch(function(error){
                    v.disabled = false;
                    toggleBlock(0);
                      console.log(error);
                      var message="{{__('message.Warning')}}";
                      //$('#error-sound')[0].play();
                      toastr.warning('',message);
                  });
                }
              }
          })
      },
    },
    created: function() {

    }

  });
</script>


@endpush