@extends('layouts.report')
<?php 
$reportTitle = __('layout.BillsReport');
?>
@section('content')
@include('layouts.report-header')

<?php
$report = customeReport('enter_bills','index');
?>

<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
  <table class="main-table">
  
 <thead>
     <tr class="bg">

   <td class="center" ><div > @lang('layout.Record')</div></td>
   <td class="center"  style="display: <?=(!show('bill_number',$report))?'none':'';?>"><div > @lang('layout.BillNumber') </div></td>
   <td class="center"  style="display: <?=(!show('date',$report))?'none':'';?>"><div > @lang('layout.Date')</div></td>

   <td class="center"  style="display: <?=(!show('vendor',$report))?'none':'';?>"><div > @lang('layout.Vendor')</div></td>
   <td class="center"  style="display: <?=(!show('account',$report))?'none':'';?>"><div > @lang('layout.Account')</div></td>
   <td class="center"  style="display: <?=(!show('amount',$report))?'none':'';?>"><div > @lang('layout.Amount')</div></td>
   <td class="center"  style="display: <?=(!show('rate',$report))?'none':'';?>"><div > @lang('layout.Rate')</div></td>
   <td class="center"  style="display: <?=(!show('currency',$report))?'none':'';?>"><div > @lang('layout.Currency')</div></td>
   <td class="center"  style="display: <?=(!show('discount_type',$report))?'none':'';?>"><div > @lang('layout.DiscountType')</div></td>
   <td class="center"  style="display: <?=(!show('discount',$report))?'none':'';?>"><div > @lang('layout.Discount')</div></td>

 </tr>
 </thead>
 <?php
 $count = 0;
  $total_home_currency=0;
  $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>

  <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->amount;
  }
  ?>
  

 <td class="center">{{++$count}}</td>
  
 <td style="display: <?=(!show('bill_number',$report))?'none':'';?>" class="center">{{$record->number}}</td>
 <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
  {{convertDate($record->date)}}
 </td>
 <td style="display: <?=(!show('vendor',$report))?'none':'';?>" class="center">{{$record->vendor}}</td>
 <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->account}}</td>
 <td style="display: <?=(!show('amount',$report))?'none':'';?>" class="center">{{round($record->amount,2)}}</td>
 <td style="display: <?=(!show('rate',$report))?'none':'';?>" class="center">{{$record->rate}}</td>
 <td style="display: <?=(!show('currency',$report))?'none':'';?>" class="center">{{$record->Currency}}</td>
 <td style="display: <?=(!show('discount_type',$report))?'none':'';?>" class="center">{{$record->discount_type}}</td>

 <td style="display: <?=(!show('discount',$report))?'none':'';?>" class="center">{{$record->discount}}</td>
</tr>
  @endforeach   
</tbody>
</table>

<table>
  <tr>

  </tr>
</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="4"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record')</div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{Currency()->code}}</div></td>

</tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection