@extends('layouts.app')
@section('style')
    <style type="text/css">
        table.td {
            border-top: 0px;
        }

        .header {

        }

    </style>
@stop
@section('content')

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet">
            <div class="portlet-title" id="backbtn">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InventoryCategoryDetails')</span>
                </div>
                <div class="pull-right">
                    <a class="btn btn-primary" href="{{ route('inventoryCategory.index') }}"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Back')</a>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-9">
                        <table class="table">
                            <thead>
                            <tr class="header">
                                <th><b>@lang('layout.Title')</b></th>
                                <th><b>@lang('layout.Data')</b></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td>
                                    <i class="fa fa-check-square"></i> <b>@lang('layout.CategoryId')</b>
                                </td>
                                <td>
                                    {{$inventoryCategory->id}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-database"></i> <b>@lang('layout.CategoryName')</b>
                                </td>
                                <td>
                                    {{$inventoryCategory->name}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-bars"></i> <b>@lang('layout.Description')</b>
                                </td>
                                <td>
                                    {{$inventoryCategory->description}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-tumblr"></i> <b>@lang('layout.Parent')</b>
                                </td>
                                <td>
                                    {{$inventoryCategory->Parent}}
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-clock-o"></i><b> @lang('layout.CreatedAt')</b>
                                </td>
                                <td>
                                    {{convertDate($inventoryCategory->created_at)}}

                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <i class="fa fa-history"></i><b> @lang('layout.UpdatedAt')</b>
                                </td>
                                <td>
                                    {{convertDate($inventoryCategory->updated_at)}}

                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
 
