@extends('layouts.app')
@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'bank_check'"
                      @closed="closeModal">

            <div slot=body>


                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Type') </label>
                            <select name="category" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="payment">@lang('layout.Payment')</option>
                                <option value="receive">@lang('layout.Receive')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase"> @lang('layout.BankCheckList') </span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('bankCheck-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                         </span>
                    @endpermission
                <!--  @permission('bankCheck-create')
                        <a href="{{route('assembly.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button></a>

                @endpermission -->
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="assembly">
                    <thead>
                    <tr>
                        <th>@lang('layout.MemberName')</th>
                        <th>@lang('layout.CheckNumber')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.CheckDate')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@endsection

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        let d;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            d = $('#assembly').DataTable({
                ajax: '{{route("check.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?1:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,

                columns: [
                    {data: 'member_name', name: 'members.name'},
                    {data: 'check_number', name: 'check_number'},
                    {data: 'category', name: 'category'},
                    {data: 'date', name: 'date'},
                    {data: 'type', name: 'type'},
                    {data: 'status', name: 'status'},
                    {data: 'description', name: 'description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', searchable:false, orderable:false},


                ]

            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof d =='object'){
                        d.clear();
                        d.ajax.reload();
                    }
                }
            }
        });
    </script>


@endpush
