@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')
@include('drawings.modal')

</style>

<!-- BEGIN CONTENT -->
<div id="print-modal"> 
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'taftish_index'"
        @closed="closeModal"> 
        <div slot="body"> 
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['EmployeeRewards-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row"> 
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.User'):</label>
                                                    <v-select placeholder="@lang('layout.User')" label="name"
                                                              v-model="userReport"
                                                              :options="{{json_encode($userReport)}}">
                                                    </v-select>
                                                    <input type="hidden" name="user_id"
                                                           v-model.number="(!userReport)?null:userReport.id">          
                                            </div>
                                        </div> 
                                        <div class="col-md-4">
                                            <label class="control-label">@lang('layout.Action') </label>
                                            <select name="status" v-model="status" class="form-control">
                                                <option value="add">@lang('layout.Add')</option>
                                                <option value="update">@lang('layout.Update')</option>
                                                <option value="delete">@lang('type.delete')</option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                           
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example"
                                                            v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example"
                                                            v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="taftish_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


        </div>
    </report-modal>
</div>

<!-- BEGIN TAB PORTLET-->


    <div class="row" >
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.AuditsList')</span>
                </div>
                <div class="tools"> </div>
                <div class=" pull-right">
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>

                </div>
            </div>

              <div class="search-form" id="app">
                    <div class="col-md-12" class="input-group input-medium margin-top-10">
                        <div class="col-md-3">
                            <label class="control-label col-md-3">@lang('layout.Type')</label>
                        <select class="form-control"  @change="getData()" v-model="user_action"  name="user_action">
                            <option value="">@lang('layout.Select')</option>
                            <option value="add">@lang('layout.Add')</option>
                            <option value="update">@lang('layout.Update')</option>
                            <option value="delete">@lang('layout.Delete')</option>
                        </select>

                        </div><div class="col-md-3">
                            <label class="control-label col-md-3">@lang('layout.User')</label>
                        <select class="form-control"  @change="getData()" v-model="user_id"  name="user_id">
                            <option value="">@lang('layout.Select')</option>
                            <option v-for="user in userList" :value="user.id">
                                @{{user.name}}
                            </option>
                        </select>

                        </div>

                   <div class="col-md-6">
                         <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                     <div class="input-group">
                                        <input class="form-control date" v-model="from_date" @click="getData()" id="range-from-example" autocomplete="off" name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" v-model="to_date" @click="getData()"  id="range-to-example" autocomplete="off" name="to_date">

                                    </div>
                                </div>


                                </div>
                            </div>
                   </div>
                   </div>
               </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="audit">
                    <thead>
                    <tr>
                        <th>@lang('layout.TableName')</th>
                        <th>@lang('layout.Action')</th>
                       <!--  <th>@lang('layout.OldValue')</th>
                        <th>@lang('layout.NewValue')</th> -->
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.IpAddress')</th>
                        <th>@lang('layout.MacAddress')</th>
                        <th>@lang('layout.BrowserInfo')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
     Vue.component("v-select", VueSelect.VueSelect);

     var cust_rep = {!!customeReportNewData('taftish_index')!!};


    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        getRecord();
    } );

    function getRecord()
    {
           var from_date=document.getElementById('range-from-example').value;
           var to_date=document.getElementById('range-to-example').value;
            $('#audit').DataTable( {
             ajax:{
                    url:'{{route("audit.index")}}',
                    data:{user_action:vmfilter.user_action,user_id:vmfilter.user_id,from_date:from_date,to_date:to_date}
                },
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?2:2}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            paging:true,
            scrollCollapse: true,
            destroy: true,
            serverSide: true,
            columns: [
                { data: 'table_name', name: 'audits.table_name' },
                { data: 'action', name: 'audits.action' },
                // { data: 'old_value', name: 'old_value', orderable:false,searchable:false },
                // { data: 'new_value', name: 'audits.new_value',orderable:false,searchable:false },
                { data: 'Date', name: 'audits.date'},
                { data: 'ip_address', name: 'audits.ip_address'},
                { data: 'mac_address', name: 'audits.mac_address'},
                { data: 'browser_info', name: 'audits.browser_info'},
                { data: 'description', name: 'audits.description' },
                { data: 'name', name: 'users.name'},
                { data: 'actions', name: 'actions', orderable:false,searchable:false},
            ]
        } );
    }
// start app
 var userList = {!!$userList!!};
var vmfilter = new Vue({
    el: '#app',
    data:{
        user_action:null,
        from_date:null,
        userList:userList,
        user_id:null,
        to_date:null
    },
    methods:{
         getData(){

           getRecord();
    }
    }
});


var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                userReport : null,
                pdfRoute: '{!!route('audit.report') !!}',
                excelRoute: '{!! route('audit.report') !!}',
                selected_member:null,
                memberlist:[],
                customReportData:
                [
                {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.IpAddress")', column_name: 'ip_address',checkedColumn:(cust_rep.ip_address)?'checked':'',column_percentage:(cust_rep.ip_address___percent)?cust_rep.ip_address___percent:''},
                 {Name: '@lang("layout.MacAddress")', column_name: 'mac_address',checkedColumn:(cust_rep.mac_address)?'checked':'',column_percentage:(cust_rep.mac_address___percent)?cust_rep.mac_address___percent:''},
                 {Name: '@lang("layout.BrowserInfo")', column_name: 'browser_info',checkedColumn:(cust_rep.browser_info)?'checked':'',column_percentage:(cust_rep.browser_info___percent)?cust_rep.browser_info___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.TableName")', column_name: 'table_name',checkedColumn:(cust_rep.table_name)?'checked':'',column_percentage:(cust_rep.table_name___percent)?cust_rep.table_name___percent:''},
   
                
                
                
                ],
                  cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                 
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });








</script>
@endpush
