@extends('layouts.app')
@section('style')
    {{--<link rel="stylesheet" href="{{url('vue/wizardform/vue-form-wizard.min.css')}}">--}}
@stop

@section('content')

    <!-- BEGIN CONTENT BODY -->
        <!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href="index.html">Home</a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                    <span>Form Stuff</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div class="btn-group pull-right">
                    <button type="button" class="btn green btn-sm btn-outline dropdown-toggle" data-toggle="dropdown"> Actions
                        <i class="fa fa-angle-down"></i>
                    </button>
                    <ul class="dropdown-menu pull-right" role="menu">
                        <li>
                            <a href="#">
                                <i class="icon-bell"></i> Action</a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="icon-shield"></i> Another action</a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="icon-user"></i> Something else here</a>
                        </li>
                        <li class="divider"> </li>
                        <li>
                            <a href="#">
                                <i class="icon-bag"></i> Separated link</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase"> Add New Item</span>
                {{--<span class="caption-helper">some info...</span>--}}
            </div>
            <div class="tools">
                <a href="" class="collapse"> </a>
                <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                <a href="" class="reload"> </a>
                <a href="" class="remove"> </a>
            </div>
        </div>
        <div class="portlet-body form" id="item-service">
            <!-- BEGIN FORM-->
            {{--{{Form::open(['route' => 'item.store','method' => 'POST','class' => 'form-horizontal'])}}--}}
    </div>
</div>
    <div class="panel-body" id="app">
        {{Form::open(['route' => 'payment.store','method' => 'POST','class' => 'form-horizontal'])}}

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label class="control-label col-md-3">@lang('layout.Vendor')</label>
                    <div class="col-md-6">
                        {{Form::select('vendor',$vendor,null,['class' => 'form-control','v-model' => 'customer'])}}
                    </div>
                </div>
             </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label class="control-label col-md-3">@lang('layout.AccountPayable')</label>
                    <div class="col-md-6">
                        {{Form::select('account',$account,null,['class' => 'form-control','v-model' => 'account'])}}
                    </div>
                </div>
             </div>
        </div>
        <div class="form-section"></div>

        <table class="table table-hover">
            <thead>
            <tr>
                <th style="width: 20px;">@lang('layout.No.') </th>

                <th style="width: 80px;">@lang('layout.Qty') </th>
                <th style="width: 180px;">@lang('layout.Item') </th>
                <th>@lang('layout.Description')</th>
                <th style="width: 80px;">U/M</th>
                <th style="width: 130px;" class="text-right">@lang('layout.Cost') </th>
                <th style="width: 90px;">@lang('layout.Tax') </th>
                <th style="width: 130px;">@lang('layout.Total') </th>

            </tr>
            </thead>
            <tbody v-sortable.tr="rows">
            <tr v-for="row in rows" track-by="$index">
                <td>
                    @{{ $index +1 }}
                </td>
                <td>
                    {{--{{Form::number('qty[0]',null,['class' => 'form-control', 'v-model'=>'row.item'])}}--}}
                    <input name="qty[]" class="form-control" v-model="row.qty" number/>
                </td>
                <td>

{{--                    {!! Form::select('item',$item,null,['class' => 'form-control','v-model'=> 'row.item'])!!}--}}
                    <select name="item[]" class="form-control" v-model="row.pr">
                        @foreach($items as $item)
                            @foreach($item->costs as $it)
                                <option value="{{$item->id}},{{$it->amount}}" >{{$item->name}}</option>
                                @break
                            @endforeach


                        @endforeach
                    </select>
                    {{--@{{row.price = row.price.split(",")[1]}}--}}
                    {{--@{{row.price}}--}}
                </td>
                <td>
                    <input class="form-control" v-model="row.description"/>
                </td>
                <td>
                    <select name class="form-control" v-model="row.tax">
                        <option value="0">0%</option>
                        <option value="10">10%</option>
                        <option value="20">20%</option>
                    </select>
                </td>
                <td>
                    <input name="cost[]" class="form-control text-right" v-bind:value="row.pr.split(',')[1]" v-model="row.cost | currencyDisplay" number data-type="currency"/>
                </td>
                <td>
                    <select class="form-control" v-model="row.tax">
                        <option value="0">0%</option>
                        <option value="10">10%</option>
                        <option value="20">20%</option>
                    </select>
                </td>
                <td>
                    <input class="form-control text-right" :value="row.qty * row.cost | currencyDisplay" v-model="row.total | currencyDisplay" number readonly />
                    <input type="hidden" :value="row.qty * row.price * row.tax / 100" v-model="row.tax_amount | currencyDisplay" number/>
                </td>
                <td>
                    <button class="btn btn-primary btn-xs" v-on:click="addRow($index)">@lang('layout.AddRow')</button>
                    <button class="btn btn-danger btn-xs" v-on:click="removeRow($index)">@lang('layout.RemoveRow')</button>
                </td>
            </tr>
            </tbody>
            <tfoot>

            <tr>
                <td colspan="5" class="text-right">@lang('layout.Tax')</td>
                <td colspan="1" class="text-right">@{{ taxtotal | currencyDisplay }}</td>
                <td></td>
            </tr>
            <tr>
                <td colspan="5" class="text-right">@lang('layout.Total')</td>
                <td colspan="1" class="text-right">@{{ total | currencyDisplay }}</td>
                <td></td>
            </tr>
            <tr>
                <td colspan="5" class="text-right">@lang('layout.Delivery') </td>
                <td colspan="1" class="text-right"><input class="form-control text-right" v-model="delivery | currencyDisplay" number/></td>
                <td></td>
            </tr>
            <tr>
                <td colspan="5" class="text-right"><strong>@lang('layout.GrandTotal')</strong></td>
                <td colspan="1" class="text-right"><strong>@{{ grandtotal = total + delivery | currencyDisplay }}</strong></td>
                <td></td>
            </tr>
            </tfoot>
        </table>
        <button v-on:click="getData()">@lang('layout.SubmitDate')</button>
        <input type="submit">
        {{Form::close()}}
        <pre>@{{ $data | json }}</pre>
        <pre>@{{ $items | json }}</pre>

    </div>
@endsection

@push('scripts')
{{--<script src='http://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js'></script>--}}
{{--<script src='http://openexchangerates.github.io/accounting.js/accounting.min.js'></script>--}}
{{--<script src='http://rubaxa.github.io/Sortable/Sortable.js'></script>--}}
{{--<script src='http://cdnjs.cloudflare.com/ajax/libs/vue/1.0.28/vue.min.js'></script>--}}
{{--<script type="text/javascript" src="https://cdn.jsdelivr.net/vue.resource/0.9.3/vue-resource.min.js"></script>--}}
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>--}}



<!-- BEGIN PAGE LEVEL PLUGINS -->
{{--<script src="{{url('/')}}/assets/global/plugins/moment.min.js" type="text/javascript"></script>--}}
{{--<script src="{{url('/')}}/assets/global/plugins/bootstrap-daterangepicker/daterangepicker.min.js" type="text/javascript"></script>--}}
{{--<script src="{{url('/')}}/assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>--}}
{{--<!-- END PAGE LEVEL PLUGINS -->--}}

<!-- BEGIN PAGE LEVEL SCRIPTS -->
{{--<script src="{{url('/')}}/assets/pages/scripts/components-date-time-pickers.min.js" type="text/javascript"></script>--}}
<!-- END PAGE LEVEL SCRIPTS -->
{{--<script src="{{url('vue/wizardform/vue.min.js')}}"></script>--}}
<script src="{{url('js/vue.min.js')}}"></script>
{{--<script src="{{url('vue/wizardform/vue-form-wizard.js')}}"></script>--}}
<script src="{{url('vue/accounting.min.js')}}"></script>
<script src="{{url('vue/Sortable.js')}}"></script>
<script>
//    Vue.http.headers.common['X-CSRF-TOKEN'] = document.querySelector('#token').getAttribute('value');
//      Vue.http.headers.common['X-CSRF-TOKEN'] = $("#token").attr("value");
    Vue.filter('currencyDisplay', {
        // model -> view
        read: function (val) {
            if (val > 0) {
                return accounting.formatMoney(val, "$", 2, ".", ",");
            }
        },
        // view -> model
        write: function (val, oldVal) {
            return accounting.unformat(val, ",");
        }
    });

    Vue.directive('sortable', {
        twoWay: true,
        deep: true,
        bind: function () {
            var that = this;

            var options = {
                draggable: Object.keys(this.modifiers)[0]
            };

            this.sortable = Sortable.create(this.el, options);
            console.log('sortable bound!')

            this.sortable.option("onUpdate", function (e) {
                that.value.splice(e.newIndex, 0, that.value.splice(e.oldIndex, 1)[0]);
            });

            this.onUpdate = function(value) {
                that.value = value;
            }
        },
        update: function (value) {
            this.onUpdate(value);
        }
    });

    var vm = new Vue({
        el: '#app',
        data: {
            rows: [
                //initial data
                {},
                {},
                {},
                {},

//                {qty: 5,item:1 ,description: "Something", price: 55.20, tax: 10},
//                {qty: 2,item:2, description: "Something else", price: 1255.20, tax: 20},
            ],
            total: 0,
            grandtotal: 0,
            taxtotal: 0,
            delivery: 0,
            account:null,
            customer:null

        },
        computed: {
            total: function () {
                var t = 0;
                $.each(this.rows, function (i, e) {
                    t += accounting.unformat(e.total, ",");
                });
                return t;
            },
            taxtotal: function () {
                var tt = 0;
                $.each(this.rows, function (i, e) {
                    tt += accounting.unformat(e.tax_amount, ",");
                });
                return tt;
            },
            pp: function () {

                return rows.price = 0;
            }
        },
        methods: {
            addRow: function (index) {
                try {
                    this.rows.splice(index + 1, 0, {});
                } catch(e)
                {
                    console.log(e);
                }
            },
            removeRow: function (index) {
                this.rows.splice(index, 1);
            },
            getData: function () {
//                var self = this;
{{--                self .$http.post("{{route('invoice.store')}}",vm.rows);--}}
                {{--this.$http.post('{{route('invoice.store')}}',JSON.parse(this.data))--}}
                    {{--.success(function(post){--}}
                        {{--location.href = '{{route('item.index')}}';--}}
                        {{--/// Something like.... router.redirect('/')--}}
                    {{--});--}}
                {{--this.$http.post("{{route('invoice.store')}}",this.data).then(function (response) {--}}
                        {{--console.log(response.data)--}}
                    {{--},function (response) {--}}
                        {{--console.log(response.data)--}}
                    {{--});--}}

                {{--$.ajax({--}}
                    {{--context: this,--}}
                    {{--type: "POST",--}}
                    {{--data: {--}}
                        {{--rows: this.rows,--}}
                        {{--total: this.total,--}}
                        {{--delivery: this.delivery,--}}
                        {{--taxtotal: this.taxtotal,--}}
                        {{--grandtotal: this.grandtotal,--}}
                    {{--},--}}

                    {{--url: "{{route('invoice.store')}}"--}}

                {{--});--}}
                {{--var payload = {--}}
                    {{--showerType:"d",--}}
                    {{--// .. and so on--}}
                {{--}--}}
                {{--this.$http.post("{{route('invoice.store')}}", payload)--}}
            }
        }
    });

//    var newJson = JSON.stringify(this.rows);
//    this.$http.post('makePayment', newJson, function(data){
//        this.processed = data;
//        console.log(data);
//    });

</script>


<!-- BEGIN PAGE LEVEL PLUGINS -->
{{--<script src="{{url('/')}}/assets/global/plugins/moment.min.js" type="text/javascript"></script>--}}
{{--<script src="{{url('/')}}/assets/global/plugins/bootstrap-daterangepicker/daterangepicker.min.js" type="text/javascript"></script>--}}
{{--<script src="{{url('/')}}/assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>--}}
{{--<!-- END PAGE LEVEL PLUGINS -->--}}

<!-- BEGIN PAGE LEVEL SCRIPTS -->
{{--<script src="{{url('/')}}/assets/pages/scripts/components-date-time-pickers.min.js" type="text/javascript"></script>--}}
<!-- END PAGE LEVEL SCRIPTS -->
{{--<script src="{{url('vue/wizardform/vue.min.js')}}"></script>--}}
{{--<script src="{{url('vue/wizardform/vue-form-wizard.js')}}"></script>--}}
{{--<script src="{{url('vue/accounting.min.js')}}"></script>--}}
{{--<script src="{{url('vue/Sortable.js')}}"></script>--}}
@endpush