@extends('layouts.factor-master')
@section('content')

<?php
$report = customeReportNew('taftish_index');
$_user= !in_array('user', $report);
$_status= !in_array('status', $report);
$_date= !in_array('date', $report);
$_ip_address= !in_array('ip_address', $report);
$_mac_address= !in_array('mac_address', $report);
$_browser_info= !in_array('browser_info', $report);
$_description= !in_array('description', $report);
$_table_name= !in_array('table_name', $report);

 
$report_percent = customeReportNewPercent('taftish_index');
$_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
$_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_ip_address_percent= (array_key_exists('ip_address___percent', $report_percent))?$report_percent['ip_address___percent']:null;
$_mac_address_percent= (array_key_exists('mac_address___percent', $report_percent))?$report_percent['mac_address___percent']:null;
$_browser_info_percent= (array_key_exists('browser_info___percent', $report_percent))?$report_percent['browser_info___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_table_name_percent= (array_key_exists('table_name___percent', $report_percent))?$report_percent['table_name___percent']:null;


// dd($_mac_address_percent);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.TaftishReport')</h3>

@if($from_date || $to_date || $userName)
<table class="main-table">
    <tr class="bg">
       
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif 
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif

        @if($userName)
        <td>
            <span>@lang('layout.User')</span>:
            <BDO>{{$userName}}</BDO>
        </td>
        @endif  
 
 
    </tr>
</table>
<br>
@endif

<table class="main-table">
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            @if($_table_name)<th @if($_table_name_percent) width="{{$_table_name_percent}}%" @endif>@lang('layout.TableName')</th>@endif
            @if($_status)<th @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Action')</th>@endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            @if($_ip_address)<th @if($_ip_address_percent) width="{{$_ip_address_percent}}%" @endif>@lang('layout.IpAddress')</th>@endif
            @if($_mac_address)<th @if($_mac_address_percent) width="{{$_mac_address_percent}}%" @endif>@lang('layout.MacAddress')</th>@endif
            @if($_browser_info)<th @if($_browser_info_percent) width="{{$_browser_info_percent}}%" @endif>@lang('layout.BrowserInfo')</th>@endif
           
            @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif
           
            @if(!$userName)
            @if($_user)<th @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</th>@endif
             @endif
        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr> 
        <td class="center">{{++$count}}</td> 
        @if($_table_name)<td class="center">{{$record->table_name}}</td>@endif

        @if($record->action == 'add')
        @if($_status)<td class="center" style="color: green;">@lang('layout.Add')</td>@endif
        @elseif($record->action == 'update')
        @if($_status)<td class="center" style="color: blue;">@lang('layout.Update')</td>@endif
        @else
        @if($_status)<td class="center" style="color: red;">@lang('type.delete')</td>@endif
        @endif
      
        @if($_date)<td class="center">{{convertDate($record->Date)}}</td>@endif
        
        @if($_ip_address)<td class="center">{{$record->ip_address}}</td>@endif
        @if($_mac_address)<td class="center">{{$record->mac_address}}</td>@endif
         
        @if($_browser_info)<td style="text-align: center;">{{$record->browser_info}}</td>@endif
      
        @if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
        @if(!$userName)
        @if($_user)<td  style="text-align: center;">{{$record->name}}</td>@endif
       @endif
    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection