@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.AttendanceSheetReport')</h3>

@if($attendance_class_name)
<table class="main-table">
    <tr class="bg">
            <td>
                <span>@lang('layout.EmployeeAttendanceClass'): {{$attendance_class_name}}</span>
            </td>
    </tr>
</table>
<br>
@endif

<table class="main-table">
<thead>
  <tr class="bg">
    <td class="center"><div> @lang('layout.Record')</div></td>
    <td class="center"><div> @lang('layout.Date')</div></td>
    <td class="center"><div> @lang('layout.PresentAbsent')</div></td>
    <td class="center"><div> @lang('layout.ShiftNo')</div></td>
    <td class="center"><div> @lang('layout.HourNo')</div></td>
    <td class="center"><div> @lang('layout.TotalPresents')</div></td>
    <td class="center"><div> @lang('layout.TotalAbsents')</div></td>
    <td class="center"><div> @lang('layout.NotGivenAttendance')</div></td>
    <td class="center"><div> @lang('layout.Description')</div></td>
    <td class="center"><div> @lang('layout.User')</div></td>    
  </tr>
</thead>


<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
  <td class="center">{{convertDate($record['date'])}}</td>
  <td class="center">{{$record['present_adsent']}}</td>
  <td class="center">{{$record['static_shift']}}</td>
  <td class="center">{{$record['static_hour']}}</td>
  <td class="center">{{$record['totalPresents']}}</td>
  <td class="center">{{$record['totalAbsents']}}</td>
  <td class="center">{{$record['countmember']}}</td>
  <td class="center">{{$record['description']}}</td>
  <td class="center">{{$record['user']}}</td>
</tr>
@endforeach  


</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection