@extends('layouts.app')

@section('content')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.AttendanceSheetDetails')</span>
                </div>
                <div class="tools"></div>
				
            </div>
            <div class="portlet-body">

            <div class="tabbable-line tabbable-custom-profile">
            <ul class="nav nav-tabs">  
                <li class="active">
                <a href="#both" data-toggle="tab" id="tab-both" style="color:green">
                <i class="fa  "></i><b> @lang('layout.All') </b></a>
                </li>
                <li class="">
                <a href="#on" data-toggle="tab" id="tab-on" style="color:green">
                <i class="fa  "></i><b> @lang('layout.Present') </b></a>
                </li> 
                <li class="">
                <a href="#off" data-toggle="tab" id="tab-off" style="color: red">
                <i class="fa  "></i><b> @lang('layout.Absent') </b></a>
                </li>
                <li class="">
                <a href="#leave" data-toggle="tab" id="tab-leave" style="color: blue">
                <i class="fa  "></i><b> @lang('layout.Leave') </b></a>
                </li>
                <li>
                    <a href="#attachment" data-toggle="tab" id="tab-attachment">@lang('layout.Attachments')</a>
                </li>


            </ul> 
            <div class="tab-content padding" style="padding: 0px;">
                <div class="tab-pane active" id="both">
                <div class="row">
                <div class="col-md-12">
                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.All')</span>
                        </div>
                        <div class="tools"> </div> 
                        
                        <div class="actions">
                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}  
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="attendanceSheet">
                        <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.JobTitle')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.WorkType')</th>
                            <th>@lang('layout.PresentAbsent')</th>
                            <th>@lang('layout.HoursOrShifts')</th>
                            <th>@lang('layout.Rent')</th>
                            <th>@lang('layout.OvertimeHours')</th>
                            <th>@lang('layout.OvertimeAmount')</th>
                            <th>@lang('layout.DelayHours')</th>
                            <th>@lang('layout.DelayAmount')</th>
                            <th>@lang('layout.TotalOverTime')</th>
                            <!-- <th>@lang('layout.OvertimeQuantity')</th>
                            <th>@lang('layout.OvertimeQuantity')</th> -->
                            <th>@lang('layout.Leave')</th>
                            <th>@lang('layout.LeaveType')</th>
                            <th>@lang('layout.Description')</th>

                            <!--   "overtime_qty" => 2.0
                                "overtime_amount" => 100.0
                                "overtime_currency" => 100.0
                                "overtime_rate" => 100.0
                                "overtime_type" => "ساعت وار" -->


                        </tr>
                        </thead>
                    </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
                </div>
                </div>
            </div> 
            <div class="tab-pane" id="on">
            <div class="row">
                <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Present')</span>
                        </div>
                        <div class="tools"> </div> 
                        <div class="actions">
                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details_present"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details_present"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}  
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="present_table">
                            <thead>
                            <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.JobTitle')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.WorkType')</th>
                            <th>@lang('layout.PresentAbsent')</th>
                            <th>@lang('layout.HoursOrShifts')</th>
                            <th>@lang('layout.TotalOverTime')</th>
                            <th>@lang('layout.Leave')</th>
                            <th>@lang('layout.LeaveType')</th>
                            <th>@lang('layout.Description')</th>


                        </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>
            </div>            
            
            <div class="tab-pane" id="off">
            <div class="row">
                <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Absent')</span>
                        </div>
                        <div class="tools"> </div> 
                        <div class="actions">
                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details_absent"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details_absent"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}  
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="absent_table">
                            <thead>
                            <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.JobTitle')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.WorkType')</th>
                            <th>@lang('layout.PresentAbsent')</th>
                            <th>@lang('layout.HoursOrShifts')</th>

                            <th>@lang('layout.Leave')</th>
                            <th>@lang('layout.LeaveType')</th>
                            <th>@lang('layout.Description')</th>

                        </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>
            </div> 
            
            
            <div class="tab-pane" id="leave">
            <div class="row">
                <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Leave')</span>
                        </div>
                        <div class="tools"> </div> 
                        <div class="actions">
                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details_leave"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="attendance_sheet_details_leave"/>
                            <input type="hidden" name="id" value="{{$id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}  
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="leave_table">
                            <thead>
                            <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.JobTitle')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.WorkType')</th>

                            <th>@lang('layout.Leave')</th>
                            <th>@lang('layout.LeaveType')</th>
                            <th>@lang('layout.Description')</th>

                        </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>
            </div>

            <div class="tab-pane" id="attachment">
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="portlet light bordered">
                            <div class="portlet-body">

                                <form role="form" action="{{route('attachment.store')}}" method="post"
                                      enctype="multipart/form-data">

                                    @csrf
                                    <input type="hidden" name="redirect_route" value="attendanceSheet.show">
                                    <input type="hidden" name="foreign_data_id" value="{{$id}}">
                                    <input type="hidden" name="path" value="uploads/AttendaceSheet">
                                    <input type="hidden" name="table_name" value="attendances">

                                    <div class="row">
                                        <div class="col-md-3" id="attach">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Employee')</label>
                                                <v-select 
                                                label="member_name" 
                                                :options="members"
                                                v-model="selected_member"
                                                >
                                            </v-select>
                                            <input type="hidden" name="member_id" :value="!selected_member?null:selected_member.member_id" >
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                <input type="text" name="title" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                <textarea name="description" class="form-control" rows="1"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <div class="fileinput-new thumbnail"
                                                         style="width: 140px; height: 70px;">
                                                        <img src="" alt=""></div>
                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                         style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                    <div>
                                                                <span class="btn default btn-file">
                                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                    <input type="hidden" value="" name=""><input
                                                                            type="file" name="photo"> </span>

                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                           data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="margiv-top-10" style="text-align: center">
                                        <button type="button" onclick="regForm(this)"
                                                class="btn green"> @lang('layout.Submit') </button>
                                        <a href="{{route('jobTitle.index')}}"
                                           class="btn default">@lang('layout.Cancel')</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="attachment_table">
                            <thead>
                            <tr>
                                <th>@lang('layout.Employee')</th>
                                <th>@lang('layout.AttachmentTitle')</th>
                                <th>@lang('layout.Description')</th>
                                <th>@lang('layout.Action')</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>   

        </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop

@include('print.modal')

@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);

        $(document).ready(function(){
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#attendanceSheet').DataTable({
                ajax:{
                    url:'{{route("attendanceSheet.show",$id)}}',
                    data:{type:'both'}
                },
                pageLength:'{{getPageRows()}}',
                order: [[ 1, "{{getRowOrder()}}" ]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                retrieve: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'dates', name: 'dates'},
                    {data: 'name', name: 'name'},
                    {data: 'job', name: 'job'},
                    {data: 'attendance_type2', name: 'attendance_type2'},
                    // {data: 'id_card', name: 'id_card'},
                    {data: 'WorkType', name: 'WorkType'},
                    {data: 'presentAbsent', name: 'presentAbsent', searchable: false},
                    {data: 'static_time', name: 'static_time'},
                    {data: 'rent', name: 'rent'},
                    {data: 'overtime_qty_hours', name: 'overtime_qty_hours',searchable: false,orderable:false},
                    {data: 'overtime_amount_hours', name: 'overtime_amount_hours',searchable: false,orderable:false},
                    {data: 'delay_qty_hours', name: 'delay_qty_hours',searchable: false,orderable:false},
                    {data: 'delay_amount_hours', name: 'delay_amount_hours',searchable: false,orderable:false},
                    // {data: 'overtime_type', name: 'overtime_type',searchable: false,orderable:false},
                    // {data: 'overtime_qty', name: 'overtime_qty',searchable: false,orderable:false},
                    {data: 'Overtimes', name: 'Overtimes',searchable: false,orderable:false},
                    {data: 'leaveTypeName', name: 'leaveTypeName', searchable: false},
                    {data: 'leaveType', name: 'leaveType', searchable: false},
                    {data: 'description', name: 'description'}
                ]
            });
            });

$(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

  $('#tab-on').on('shown.bs.tab', function(event){

    $('#present_table').DataTable({
                ajax:{
                    url:'{{route("attendanceSheet.show",$id)}}',
                    data:{type:'present'}
                },
                pageLength:'{{getPageRows()}}',
                order: [[ 1, "{{getRowOrder()}}" ]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                retrieve: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'dates', name: 'dates'},
                    {data: 'name', name: 'name'},
                    {data: 'job', name: 'job'},
                    {data: 'attendance_type2', name: 'attendance_type2'},
                    // {data: 'id_card', name: 'id_card'},
                    {data: 'WorkType', name: 'WorkType'},
                    {data: 'presentAbsent', name: 'presentAbsent', searchable: false},
                    {data: 'static_time', name: 'static_time'},
                    // {data: 'overtime_type', name: 'overtime_type',searchable: false,orderable:false},
                    // {data: 'overtime_qty', name: 'overtime_qty',searchable: false,orderable:false},
                    {data: 'Overtimes', name: 'Overtimes',searchable: false,orderable:false},
                    
                    {data: 'leaveTypeName', name: 'leaveTypeName', searchable: false},
                    {data: 'leaveType', name: 'leaveType', searchable: false},
                    {data: 'description', name: 'description'}
                ]
            }); 
  });
});	
	

$(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
  $('#tab-off').on('shown.bs.tab', function(event){

    $('#absent_table').DataTable({
                ajax:{
                    url:'{{route("attendanceSheet.show",$id)}}',
                    data:{type:'absent'}
                },
                pageLength:'{{getPageRows()}}',
                order: [[ 1, "{{getRowOrder()}}" ]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                retrieve: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'dates', name: 'dates'},
                    {data: 'name', name: 'name'},
                    {data: 'job', name: 'job'},
                    {data: 'attendance_type2', name: 'attendance_type2'},
                    // {data: 'id_card', name: 'id_card'},
                    {data: 'WorkType', name: 'WorkType'},
                    {data: 'presentAbsent', name: 'presentAbsent', searchable: false},
                    {data: 'static_time', name: 'static_time'},
                    // {data: 'overtime_type', name: 'overtime_type',searchable: false,orderable:false},
                    // {data: 'overtime_qty', name: 'overtime_qty',searchable: false,orderable:false},
                    // {data: 'Overtimes', name: 'Overtimes',searchable: false,orderable:false},
                    
                    {data: 'leaveTypeName', name: 'leaveTypeName', searchable: false},
                    {data: 'leaveType', name: 'leaveType', searchable: false},
                    {data: 'description', name: 'description'}
                ]
            }); 
  });
});
$(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
  $('#tab-leave').on('shown.bs.tab', function(event){

    $('#leave_table').DataTable({
                ajax:{
                    url:'{{route("attendanceSheet.show",$id)}}',
                    data:{type:'leave'}
                },
                pageLength:'{{getPageRows()}}',
                order: [[ 1, "{{getRowOrder()}}" ]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                retrieve: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'dates', name: 'dates'},
                    {data: 'name', name: 'name'},
                    {data: 'job', name: 'job'},
                    {data: 'attendance_type2', name: 'attendance_type2'},
                    // {data: 'id_card', name: 'id_card'},
                    {data: 'WorkType', name: 'WorkType'},
                    // {data: 'overtime_type', name: 'overtime_type',searchable: false,orderable:false},
                    // {data: 'overtime_qty', name: 'overtime_qty',searchable: false,orderable:false},
                    // {data: 'Overtimes', name: 'Overtimes',searchable: false,orderable:false},
                    
                    {data: 'leaveTypeName', name: 'leaveTypeName', searchable: false},
                    {data: 'leaveType', name: 'leaveType', searchable: false},
                    {data: 'description', name: 'description'}
                ]
            }); 
  });
});

$(document).ready(function () {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#tab-attachment').on('shown.bs.tab', function(event){
        $('#attachment_table').DataTable({
            ajax: {
                url: '{{route("attendanceSheet.show",$id)}}',
                data: {type: 'attachment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',

            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                {data: 'member_name', name: 'member_name',orderable: false, searchable: false},
                {data: 'title', name: 'attachments.title'},
                {data: 'description', name: 'attachments.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });              
    });              
}); 





        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                memberlist: [],
                selectedMember: [],
                member_id: [],

                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
             watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.member_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

               onMemberSearch(search, loading) {
                loading(true);
                this.searchMember(search, loading, this);
            },

            searchMember(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'member',
                        type: 'Employee',
                        search: search,
                    }
                })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
            }

        });


        new Vue({
            el: '#anchore-modal',

            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

    var attendanceSheetMembers = {!! json_encode($attendanceSheetMembers) !!}
    Vue.component('v-select', VueSelect.VueSelect);

    var att = new Vue({
        el:"#attach",
        data:{
            members: attendanceSheetMembers,
            selected_member:null
        }

    });
    </script>
@endpush
