@extends('layouts.app')
@section('style')
<style>
     .modal-container{
            width: 60% !important;
        }
</style>
@endsection
@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'attendance_sheet'" 
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="col-md-4">
                       <label class="control-label ">@lang('layout.SelectMember') </label>
                       <v-select class="vue-select2"
                                 v-model="selectedMember"
                                 :multiple="true" label="name"
                                 @search="onMemberSearch"
                                 :options="memberlist">
                       </v-select>
                       <input type="hidden" name="member_id"
                              :value="member_id.length > 0 ? member_id:null">
                      
                   </div>
                  
                   <div class="col-md-4">
                        <label class="control-label ">@lang('layout.EmployeeAttendanceClass') </label>
                        <v-select class="vue-select2"
                                v-model="selected_attendance_class"
                                label="name"
                                :options="attendanceClass">
                        </v-select>
                        <input type="hidden" name="attendance_class_id" :value="(!selected_attendance_class)?null:selected_attendance_class.id">
                        <input type="hidden" name="attendance_class_name" :value="(!selected_attendance_class)?null:selected_attendance_class.name">
                    
                    </div>

                    <div class="col-md-4">
                        <label class="control-label ">@lang('layout.Type') </label>
                        <select name="dataType" class="form-control">
                            <option value="summary">@lang('layout.Summary')</option>
                            <option value="details">@lang('layout.Details')</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <div class="col-md-4">
                                <label class="control-label ">@lang('layout.Date')</label>
                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                    <option value="Today">@lang('type.Today')</option>
                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                </select>
                            </div>
                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12" style="color: red">
                        @lang('message.AttendanceSheetReportMsg')
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="col-md-2 col-sm-2">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.Attendance')</span>
            </div>
            <div class="col-md-4 col-sm-4" id="date_part">
                <div class="form-group">
                {{Form::open(['route' => 'attendanceSheetAll.destroy','method' => 'DELETE','class' => 'form-horizontal', 'id'=>'sales-form'])}}
                {{ csrf_field() }}
                    <div class="form-group  hidden-print">
                        <div class="input-group">
                            <input name="part_number" class="form-control" ref="part_number" placeholder="@lang('layout.PartNumber')"  type="number" />
                            <span class="input-group-addon btn" style="padding: 0px;" > <button type="button" @click="submitForm($event)" style="padding: 0px 8px; color:red;" > @lang('layout.Delete') </button> </span>
                        </div>
                    </div>
                {!! Form::close() !!}
                </div>
            </div>

            <div class="portlet-title">
                
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('attendance-export')

                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>

                    @endpermission
                    @permission('attendance-create')
                    @if (fingerprint() == 'true')
                    <a href="{{route('attendanceSheet.indexFinger')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-list"></i> @lang('layout.FingerprintLog')
                        </button>
                    </a>
                    <a href="{{route('attendanceSheet.createByFinger')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Fingerprint')
                        </button>
                    </a>
                    @endif
                    <a href="{{route('attendanceSheet.createByDate')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNewBetweenDates')
                        </button>
                    </a>
                    <a href="{{route('attendanceSheet.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <div id="load_loader">
                    <img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
                </div>
                <table class="table table-striped table-bordered table-hover" id="attendanceSheet">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.EmployeeAttendanceClass')</th>
                        <th>@lang('layout.ShiftNo')</th>
                        <th>@lang('layout.HourNo')</th>
                        <th>@lang('layout.TotalPresents')</th>
                        <th>@lang('layout.TotalAbsents')</th>
                        <th>@lang('layout.PartNumber')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop

@include('print.modal')

@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        var attendanceClass  = {!! $employeeAttendanceClass !!}

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
           var ttt =  $('#attendanceSheet').DataTable({
                // processing: true,
                ajax: '{{route("attendanceSheet.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [[ 0, "{{getRowOrder()}}" ]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                paging: true,
                serverSide: true,
                
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'attendances.id'},
                    {data: 'dates', name: 'attendances.date'},
                    {data: 'member_att_class', name: 'employee_attendance_classes.name'},
                    {data: 'static_shift', name: 'attendances.static_shift'},
                    {data: 'static_hour', name: 'attendances.static_hour'},
                    {data: 'totalPresent', name: 'totalPresent',searchable:false},
                    {data: 'totalAbsent', name: 'totalAbsent',searchable:false},
                    {data: 'part_number', name: 'attendances.part_number'},
                    {data: 'description', name: 'attendances.description'},
                    {data: 'user', name: 'users.name'},
                    { data: 'actions', name: 'actions' ,searchable:false,orderable:false}
                ]
            });

            $('#load_loader').hide();
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                memberlist: [],
                selectedMember: [],
                member_id: [],
                attendanceClass:attendanceClass,
                selected_attendance_class:null,

                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
             watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.member_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

               onMemberSearch(search, loading) {
                loading(true);
                this.searchMember(search, loading, this);
            },

            searchMember(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'member',
                        type: 'Employee',
                        search: search,
                    }
                })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },

            //ajax call to get dates
            getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }

        });


        new Vue({
            el: '#anchore-modal',

            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        var v = new Vue({
            el: '#date_part',

            methods: {
                // submit the form
                submitForm(e) {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Delete')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("sales-form").submit()
                        } else {
                            
                        }
                    });
                },
                // submit the form
            }
        });
    </script>
@endpush
@section('vselectStyle')
    <style type="text/css">
        .v-select .selected-tag {
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@endsection
