@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.AttendanceSheetReport')</h3>

<table class="main-table">

<thead>
  <tr class="bg">
    <td class="center">@lang('layout.Record')</td>
    <td class="center">@lang('layout.Date')</td>
    <td class="center">@lang('layout.Name')</td>
    <td class="center">@lang('layout.JobTitle')</td>
    <td class="center">@lang('layout.Type')</td>
    <td class="center">@lang('layout.WorkType')</td>
    <td class="center">@lang('layout.PresentAbsent')</td>
    <td class="center">@lang('layout.HoursOrShifts')</td>
    <td class="center">@lang('layout.Rent')</td>
    <td class="center">@lang('layout.OvertimeHours')</td>
    <td class="center">@lang('layout.OvertimeAmount')</td>
    <td class="center">@lang('layout.DelayHours')</td>
    <td class="center">@lang('layout.DelayAmount')</td>
    <td class="center">@lang('layout.TotalOverTime')</td>
    <td class="center">@lang('layout.Leave')</td>
    <td class="center">@lang('layout.LeaveType')</td>
    <td class="center">@lang('layout.Description')</td>
  </tr>
</thead>


<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
  <td class="center">{{convertDate($record['date'])}}</td>
  <td class="center">{{$record['name']}}</td>
  <td class="center">{{$record['job']}}</td>
  <td class="center">{{$record['attendance_type2']}}</td>
  <td class="center">{{__("type.".$record['attendance_type'])}}</td>
  @if($record['present_adsent']==0 || $record['present_adsent']==2)
  <td class="center">
    0
  </td>
  @endif  
  @if($record['present_adsent']==1)
  <td class="center">1</td>
  @endif
  <td class="center">{{$record['static_time']}}</td>
  <td class="center">@if($record['rent']){{$record['rent']}} {{$record['currency']}} @endif</td>
  <td class="center">{{$record['overtime_qty']}}</td>
  <td class="center">{{$record['overtime_amount']}}</td>
  <td class="center">{{$record['delay_qty']}}</td>
  <td class="center">{{$record['delay_amount']}}</td>
  <td class="center">{{$record['total_orverwork']}}</td>
  <td class="center">{{$record['leaveTypeName']}}</td>
  <td class="center">{{($record['leave_type'])?__("type.".$record['leave_type']):''}}</td>
  <td class="center">{{$record['description']}}</td>
</tr>
@endforeach  
</table>
<br>
 <!--  Totals -->
<table class="main-table">
  <thead>
    <tr class="bg">
      <td><div class="center"> @lang('layout.TotalPresents')</div></td>
      <td><div class="center"> @lang('layout.TotalAbsents')</div></td>
      
    </tr>
  </thead>
  <tr>
    <td class="center">{{$presents}}</td>
    <td class="center">{{$absents}}</td>
  </tr>
</table>
 <!-- End Totals -->



 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection