@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense');
$_number=in_array('number', $report);
$_type_number=in_array('type_number', $report);
$_date=in_array('date', $report);
$_vendor=in_array('vendor', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_description=in_array('description', $report);
$_type=in_array('type', $report);
$_expense_type=in_array('expense_type', $report);
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.AttendanceSheetReport')</h3>

@if($from_date || $to_date || $attendance_class_name)
<table class="main-table">
    <tr class="bg">
        @if($attendance_class_name)
          <td>
            <span>@lang('layout.EmployeeAttendanceClass'): {{$attendance_class_name}}</span>
        </td>
        @endif
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
</table>
<br>
@endif

<table class="main-table">
<thead>
  <tr class="bg">
    <td class="center" ><div> @lang('layout.Record')</div></td>
    <td class="center" ><div> @lang('layout.Name')</div></td>
    <td class="center" ><div> @lang('layout.JobTitle')</div></td>
    <td class="center" ><div> @lang('layout.Type')</div></td>
    <?php
      for ($i=1; $i <=31 ; $i++) { 
        echo '<td class="center"  style="width:15;"><div>'.$i.'</div></td>';
      }
    ?>
    <td class="center" ><div> @lang('layout.PresentDay')</div></td>
    <td class="center" ><div> @lang('layout.AbsentDay')</div></td>
    <td class="center" ><div> @lang('layout.PresentHourAndShift')</div></td>
    <td class="center" ><div> @lang('layout.AbsentHourAndShift')</div></td>
    <td class="center" ><div> @lang('layout.JustifiedLeave')</div></td>
    <td class="center" ><div> @lang('layout.TotalOverTime')</div></td>
    <td class="center" ><div> @lang('layout.Rent')</div></td>
    <td class="center" ><div> @lang('layout.OvertimeHours')</div></td>
    <td class="center" ><div> @lang('layout.OvertimeAmount')</div></td>
    <td class="center" ><div> @lang('layout.DelayHours')</div></td>
    <td class="center" ><div> @lang('layout.DelayAmount')</div></td>
    <td class="center" ><div> @lang('layout.User')</div></td>
    <td class="center" ><div> @lang('layout.Signature')</div></td>
  </tr>
</thead>
<?php
$count = 0;
?>
@foreach($data AS $record)

<?php
  $total_overtime_hours = $record['total_overtime_and_delay']['total_overtime'];
  $total_delay_hours = $record['total_overtime_and_delay']['total_delay'];
  $total_overtime_amount = $record['total_overtime_and_delay']['total_overtime_amount'];
  $total_delay_amount = $record['total_overtime_and_delay']['total_delay_amount'];
?>
<tr>
<td class="center">{{++$count}}</td>
  <td class="center">{{$record['Name']}}</td>
  <td class="center">{{$record['job']}}</td>
  <!-- <td class="center"> {{$record['Type']}}</td>  -->
  <td class="center"> {{__("type.".$record['Type'])}}</td>   
  @foreach($record['data_att'] AS $data_att)
    <td class="center">
    @if($data_att)
        @if($data_att->present_adsent==0 || $data_att->present_adsent==2)
          0
        @endif  
        @if($data_att->present_adsent==1)
          1
      @endif
    @else
    {{" "}}
    @endif
    </td>
  @endforeach
  <td class="center">{{$record['Presents']}}</td>
  <td class="center">{{$record['Absent']}}</td>
  <td class="center">{{$record['PresentsHS']}}</td>
  <td class="center">{{$record['AbsentHS']}}</td>
  <td class="center">{{$record['total_justified_absent']}}</td>
  <td class="center">{{$record['total_orverwork']}} @if($record['total_orverwork'] > 0) {{getHomeCurrency()[getCurrencyType()]}}@endif</td>
  <td class="center">{{$record['total_rent']}}  @if($record['total_rent'] > 0) {{$record['currency']}} @endif</td>
  <td class="center">{{$total_overtime_hours}}</td>
  <td class="center">{{$total_overtime_amount}}</td>
  <td class="center">{{$total_delay_hours}}</td>
  <td class="center">{{$total_delay_amount}}</td>
  <td class="center">{{$record['user']}}</td>
  <td class="center"></td>

  


</tr>
@endforeach  
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection