@extends('layouts.app')
@section('style')
    <style type="text/css">
        table.td {
            border-top: 0px;
        }

        .header {}

    </style>
@stop
@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AttachmentShow')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <h2 class="text-center" style="margin-bottom:35px;">
            وضعیت: 
            @if($attachment->status == 'in')
            <span class="text-success"> ورودی </span> 
            @else
            <span class="text-danger"> خروجی </span>
            @endif
        </h2>
        <div class="portlet-body">
            <div class="table-scrollable">
              
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            @if($attachment->attachment_class_name)
                            <th>
                                <i class=""></i> @lang('menu.AttachmentClass')
                            </th>
                            @endif
                            <th>
                                <i class=""></i> @lang('layout.Category')
                            </th>
                            <th>
                                <i class=""></i> @lang('layout.AttachmentTitle')
                            </th>

                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Number')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.ReferenceNumber')
                            </th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            @if($attachment->attachment_class_name)<td> {{ $attachment->attachment_class_name }} </td>@endif
                            <td> {{ $attachment->table_name }} </td>
                            <td> {{ $attachment->title }} </td>
                            <td> {{ $attachment->number }} </td>

                            <td> {{ $attachment->ref_number }} </td>
                            
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th>
                                <i class=""></i> @lang('layout.FilesCount')
                            </th>
                            <th>
                                <i class=""></i> @lang('layout.FileType')
                            </th>

                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.surrender')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.recipient')
                            </th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="hidden-xs"> {{ $attachment->count }} </td>
                            <td class="hidden-xs"> {{ $attachment->file_type }} </td>
                            <td class="hidden-xs"> {{ $attachment->in_sender }} </td>

                            <td class="hidden-xs"> {{ $attachment->member_name }} </td>
                            
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th>
                                <i class=""></i> @lang('layout.InDate')
                            </th>
                            <th>
                                <i class=""></i> @lang('layout.Location')
                            </th>

                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Taghazah')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Description')
                            </th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="hidden-xs"> {{ convertDate($attachment->in_date) }} </td>
                            <td class="hidden-xs"> {{ $attachment->location }} </td>
                            <td class="hidden-xs"> {{ $attachment->part }} </td>

                            <td class="hidden-xs"> {{ $attachment->description }} </td>
                          

                        </tr>
                    </tbody>
                </table>


                @if($attachment->status == 'out')
                <h3 class="text-center text-danger" style="margin-top:40px;margin-bottom:30px;"> اطلاعات خروج </h3>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th>
                                <i class=""></i> @lang('layout.DateOut')
                            </th>
                            <th>
                                <i class=""></i> @lang('layout.surrender')
                            </th>

                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.recipient')
                            </th>

                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.mainreciever')
                            </th>
                         
                            
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="hidden-xs"> {{ convertDate($attachment->out_date) }} </td>
                            <td class="hidden-xs"> {{ $attachment->employee_name }} </td>
                            <td class="hidden-xs"> {{ $attachment->out_receiver }} </td>
                            <td class="hidden-xs"> {{ $attachment->main_receiver }} </td>
                          

                        </tr>
                    </tbody>
                </table>
                @endif
            </div>
        </div>

    </div>


@endsection

@push('scripts')

    <script>

    </script>
@endpush
