@extends('layouts.app')
@section('style')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
<style type="text/css">
    .v-select .selected-tag {
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection
@section('content')
@include('drawings.modal')

</style>

 <!-- new modal -->

 <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'delivery'"
                  @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    
                    <div class="col-md-3" >
                        <label class="control-label">@lang('menu.AttachmentClass') </label>
                        <v-select placeholder="@lang('menu.AttachmentClass')" label="name"
                                    v-model="selected_attachment_class"
                                    :options="attachmentClass">
                            </v-select>
                            <input type="hidden" name="attachment_class_id"
                                v-model.number="(!selected_attachment_class)?null:selected_attachment_class.id">
                    </div> 
                    <div class="col-md-3" >
                        <label class="control-label">@lang('menu.AttachmentCategory') </label>
                        <v-select placeholder="@lang('menu.AttachmentCategory')" label="name"
                                    v-model="selected_category"
                                    :options="attachmentCategory">
                            </v-select>
                            <input type="hidden" name="category_id"
                                v-model.number="(!selected_category)?null:selected_category.id">
                    
                            </div> 
                            
                            <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                <input type="text" name="attachment_tittle" class="form-control">
                        </div>
                    </div>


                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Status') </label>
                        <select name="status" v-model="status" class="form-control">
                            <option value="in">@lang('type.In')</option>
                            <option value="out">@lang('type.Out')</option>
                        </select>
                    </div>
                    <div class="col-md-3" v-if="status == 'in' || !status">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.surrender')</label>
                                <input type="text" name="surrender" class="form-control">
                        </div>
                    </div>
                    
                    <div class="col-md-3" v-if="status == 'in' || !status">
                        <label class="control-label">@lang('layout.recipient')</label>
                        <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                        <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                    </div>

                    
                    
                    <div class="col-md-3"v-if="status == 'out'">
                        <label class="control-label">@lang('layout.recipient')</label>
                        <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                        <input type="hidden" name="out_sender" :value="!selected_employee?null:selected_employee.id">
                    </div>

                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Type') </label>
                        <select name="Type" class="form-control">
                            <option value="all">@lang('layout.All')</option>
                            <option value="includeCategory">@lang('layout.IncludeCategory')</option>
                        </select>
                    </div>

                    <div class="col-lg-3 col-md-3">
                        <label class="control-label">@lang('layout.Category')</label>
                        {{-- <select class="form-control" v-model="category" placeholder="{{__('Search1')}} "  name="category">
                        <option value="">@lang('layout.Select')</option>
                        @foreach($categories as $att)
                        <option value="{{$att->table_name}}">{{$att->table_name}}</option>
                        @endforeach
                    </select> --}}
                        <v-select placeholder="@lang('layout.Category')" label="name"
                                v-model="selected_categories"
                                :options="categoriesVselect"
                                :multiple="true"
                                >
                        </v-select>
                        {{-- <input type="hidden" name="category"
                            v-model.number="(!selected_categories)?null:selected_categories.name"> 
                             --}}
                            <input type="hidden" name="category"
                            :value="categoryList.length > 0 ? categoryList:null">
                            
                </div>  

                    <div class="col-md-3" v-if="status == 'out'">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.surrender')</label>
                                <input type="text" name="out_reciver" class="form-control">
                        </div>
                    </div>
   
                </div>
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>

                            <div slot="date">
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

<!-- /new modal -->



    <div class="row" >
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-archive font-dark"></i> &nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.AttachmentsManagement')</span>
                </div>
                <div class="tools"> </div>
                <div class=" pull-right">
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @permission('AttachmentClass-list')
                    <a href="{{route('attachmentClass.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('menu.AttachmentClass')
                        </button>
                    </a>
                    @endpermission
                    @permission('attachmentCategory-list')
                    <a href="{{route('attachmentCategory.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('menu.AttachmentCategory')
                        </button>
                    </a>
                    @endpermission
                    <a href="{{route('attachment.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>

                </div>
            </div>

              <div class="search-form" id="app">
                    <div class="col-lg-12 col-md-12" class="input-group input-medium ">
                        <div class="col-lg-3 col-md-3">
                            <label class="control-label">@lang('menu.AttachmentClass')</label>
                        <select class="form-control"  @change="getData()" v-model="attachment_class_id" placeholder="{{__('Search1')}} "  name="attachment_class_id">
                            <option value="">@lang('layout.Select')</option>
                            @foreach($attachmentClass as $att_class)
                            <option value="{{$att_class->id}}">{{$att_class->name}}</option>
                            @endforeach
                        </select>
                        </div>  
                        
                        <div class="col-lg-3 col-md-3">
                            <label class="control-label">@lang('layout.Category')</label>
                        <select class="form-control"  @change="getData()" v-model="category" placeholder="{{__('Search1')}} "  name="category">
                            <option value="">@lang('layout.Select')</option>
                            @foreach($categories as $att)
                            <option value="{{$att->table_name}}">{{$att->table_name}}</option>
                            @endforeach
                        </select>
                        </div>  

                         <div class="col-lg-3 col-md-3">
                                <label class="control-label ">@lang('layout.AttachmentTitle')</label> 
                                <input type="text" name="title" @input="getData()" v-model="title" class="form-control" autocomplete="off">
                        </div> 

                        <div class="col-lg-3 col-md-3">
                                <label class="control-label">@lang('layout.Description')</label>
                                <input type="text" name="description" @input="getData()" v-model="description" class="form-control" autocomplete="off">
                        </div>
 
                   </div>
               </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="attachments">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('menu.AttachmentClass')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.InDate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.FileType')</th>
                        <th>@lang('layout.OpeningDate')</th>
                        <th>@lang('layout.ExpireDate')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Action')</th>
                   
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
     Vue.component("v-select", VueSelect.VueSelect);
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        getRecord();
    } );

    function getRecord()
    {
           var from_date = null;
           var to_date = null;
            $('#attachments').DataTable( {
             ajax:{
                    url:'{{route("attachment.index")}}',
                    data:{category:vmf.category,from_date:from_date,to_date:to_date,title:vmf.title,description:vmf.description,attachment_class_id:vmf.attachment_class_id}
                },
            pageLength:'{{getPageRows()}}',
            order: [[0,"{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            destroy: true,
            serverSide: true,
            columns: [
                { data: 'id',            name: 'id',searchable:false},
                { data: 'number',        name: 'number' },
                { data: 'ref_number',    name: 'ref_number' },
                { data: 'attachment_class_name',    name: 'attachment_class_name',orderable:false,searchable:false},
                { data: 'table_name',    name: 'table_name',orderable:false,searchable:false},
                { data: 'title',         name: 'title' },
                { data: 'in_date',       name: 'in_date' },
                { data: 'description',   name: 'description'},
                { data: 'status',    name: 'status'},
                { data: 'file_type',     name: 'file_type',orderable:false,searchable:false},
                { data: 'start_date',    name: 'start_date'},
                { data: 'end_date',    name: 'end_date'},
                { data: 'user',          name: 'users.name'},
                { data: 'actions',       name: 'actions',orderable:false,searchable:false }
            ]
        } );
    }
// start app

var vmf = new Vue({
    el: '#app',
    data:{
        category:null,
        from_date:null,
        to_date:null,
        title:null,
        number:null,
        description:null,
        attachment_class_id:null
    },
    methods:{
         getData(){

           getRecord();
    }
    }
})


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });


        var attachmentCategory = {!! $attachmentCategory !!};
        var attachmentClass = {!! json_encode($attachmentClass) !!};
        var CategoriesVselect = {!! json_encode($categoriesVselect) !!};
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("attachment.report") !!}',
                excelRoute: '{!! route("attachment.report") !!}',
                selectedMember: null,
                member: null,
                status: null,
                selected_category : null,
                category:null,
                categoryList:[],
                attachmentCategory:attachmentCategory,
                employee:[],
                selected_categories:null,
                categoriesVselect:CategoriesVselect,
                selected_employee:null,
                attachmentClass:attachmentClass,
                selected_attachment_class:null
            },
            watch: {
                selected_categories: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.name);
                    });

                    this.categoryList = x;
                    console.log('x value');
                    console.log(x);
                },
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                getData(){

                    getRecord();
                    },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                
            MemberSearch: _.debounce((search, loading) => {  
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Employee'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vm.employee = [];
                    vm.employee = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),


            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        
        
</script>
@endpush

