



@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.Attachment')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                    <form role="form" action="{{route('attachment.storeexitattach')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="redirect_route" value="receive.show">
                        <input type="hidden" name="foreign_data_id" value="">
                        <input type="hidden" name="path" value="uploads/otherAttachments">
                        <input type="hidden" name="table_name" value="">
                        <input type="hidden" name="attach_id" value="{{$attachment->id}}">
                         <div class="row">
                  

                            <div class="col-md-3">
                              <div class="form-group">
                                <label class="control-label">@lang('menu.AttachmentCategory')</label>
                                
                                    <v-select placeholder="@lang('menu.AttachmentCategory')" label="name"
                                              v-model="selected_category"
                                              :options="attachmentCategory">
                                    </v-select>
                                    <input type="hidden" name="category_id" 
                                           v-model.number="(!selected_category)?null:selected_category.id">
                              
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" value="{{$attachment->title}}" name="title" class="form-control">
                                </div>
                            </div>  
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Number')</label>
                                        <input type="text" value="{{$attachment->number}}" name="number" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" value="{{$attachment->ref_number}}" name="ReferenceNumber" class="form-control">
                                </div>
                            </div>
                            
                          
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.FilesCount')</label>
                                        <input type="number" value="{{$attachment->count}}" name="FilesCount" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.FileType')</label>
                                        <input type="text" value="{{$attachment->file_type}}" name="FileType" value="{{$attachment->file_type}}" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.surrender')</label>
                                <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                                <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                            </div>


                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.recipient')</label>
                                        <input type="text"  name="surrender" class="form-control">
                                </div>
                            </div>
                            
                           
                            
                           
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.mainreciever')</label>
                                        <input type="text" value="{{$attachment->main_receiver}}" name="mainreciever" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.DateOut')</label>
                                    <input type="text" value="{{convertDate($attachment->in_date)}}" name="out_Date" class="form-control date now" autocomplete="off">
                                </div>
                            </div>
                          
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Location')</label>
                                        <input type="text" value="{{$attachment->location}}" name="Location" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Taghazah')</label>
                                        <input type="text" value="{{$attachment->part}}" name="Taghazah" class="form-control">
                                </div>
                            </div>
                            
                           
                           
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description"  class="form-control">{{$attachment->description}}
                                            
                                        </textarea>
                                </div>
                            </div>
                           
 
                            
                        </div>
                   
                          <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button type="button" @click="handleSubmit($event)"
                                    class="btn green">@lang('layout.Submit')</button>

                            <a href="{{route('attachment.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                </form>
            </div>
            <!-- END FORM-->
        </div>
    </div>


    
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component("v-select", VueSelect.VueSelect);


        var attachmentCategory = {!! $attachmentCategory !!};
        var attachment = {!! $attachment !!};

        let vu = new Vue({
            el: '#app',
            data: {
                attachment:attachment,
                employee:[],
                selected_employee:null,
                selected_category     : null,
                attachmentCategory:attachmentCategory
            },
            mounted() {
                // console.log(213, attachment);
                if (attachment.attachment_category_id && attachmentCategory) {
                    this.selected_category = _.find(attachmentCategory, (s) => s.id == attachment.attachment_category_id);
                }
            },

            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

            MemberSearch: _.debounce((search, loading) => {  
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Employee'
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vu.employee = [];
                    vu.employee = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

            }
        })

    </script>
@endpush 