@extends('layouts.factor-master')
@section('content')
    <h3 class="table-caption" style="text-align: center;">@lang('layout.AttachmentReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
            @if(count($category_name)>0)
            <td>
                <span>@lang('layout.Category')</span>: 
                @foreach($category_name as $bank)
                {{$bank['table_name']}} , 
                @endforeach
            </td>
            @endif

        @if($attachmentClass_name)
        <td>
            <span>@lang('menu.AttachmentClass')</span>:
            <BDO >{{$attachmentClass_name}}</BDO>
        </td>
    @endif

    @if($status)
    @if($status == 'out')
    <td style="color:red"><span>@lang('layout.Status')</span>: @lang('type.Out') </td>
    @else
    <td style="color:green"><span>@lang('layout.Status')</span>: @lang('type.In') </td>
    @endif
@endif
    
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
            <tr class="bg">
                <td><div class="center">  @lang('layout.Record')  </div></td>
                <th>@lang('layout.Number')</th>
                <th>@lang('layout.StartDate')</th>
                <th>@lang('layout.EndDate')</th>
                @if(!count($category_name)>0)
                @if(!$attachmentClass_name)
                <th>@lang('menu.AttachmentClass')</th>
                @endif
                @if(!$categories_name)
                <th>@lang('layout.Category')</th>
                @endif
                @endif
                <th>@lang('layout.ReferenceNumber')</th>
                <th>@lang('layout.Description')</th>
                <th>@lang('layout.AttachmentTitle')</th>
                <th>@lang('layout.FilesCount')</th>
                <th>@lang('layout.FileType')</th>
                <th>@lang('layout.surrender')</th>
                <th>@lang('layout.recipient')</th>
                <th>@lang('layout.InDate')</th>
                <th>@lang('layout.Location')</th>
                <th>@lang('layout.Taghazah')</th>
                @if(!$status)
                <th>@lang('layout.Status')</th>
                @endif
                <th>@lang('layout.DateOut')</th>
                <th>@lang('layout.surrender')</th>
                <th>@lang('layout.recipient')</th>
                <th>@lang('layout.mainreciever')</th>
            </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{convertDate($record->start_date)}}</td>
                <td class="center">{{convertDate($record->end_date)}}</td>
                @if(!count($category_name)>0)
                @if(!$attachmentClass_name)
                <td class="center">{{$record->attachment_class_name}}</td>
                @endif
                @if(!$categories_name)
                <td class="center">{{$record->table_name}}</td>
                @endif
                @endif
                <td class="center">{{$record->ref_number}}</td>
                <td class="center">{{$record->description}}</td>
                <td class="center">{{$record->title}}</td>
                <td class="center">{{$record->count}}</td>
                <td class="center">{{$record->file_type}}</td>
                <td class="center">{{$record->in_sender}}</td>
                <td class="center">{{$record->member_name}}</td>
                <td class="center">{{convertDate($record->in_date)}}</td>
                <td class="center">{{$record->location}}</td>
                <td class="center">{{$record->part}}</td>
                @if(!$status)
                @if($record->status == 'out')
                <td class="center" style="color:red"> @lang('type.Out') </td>
                @else
                <td class="center" style="color:green"> @lang('type.In') </td>
                @endif
                @endif
                <td class="center">{{convertDate($record->out_date)}}</td>
                <td class="center">{{$record->employee_name}}</td>
                <td class="center">{{$record->out_receiver}}</td>
                <td class="center">{{$record->main_receiver}}</td> 
            </tr>
        @endforeach

    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection