@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.Attachment')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                    <form role="form" action="{{route('attachment.storeNew')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="redirect_route" value="receive.show">
                        <input type="hidden" name="foreign_data_id" value="">
                        <input type="hidden" name="path" value="uploads/otherAttachments">
                        <input type="hidden" name="table_name" value="">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('menu.AttachmentCategory')</label>
                                    <v-select placeholder="@lang('menu.AttachmentCategory')" label="name"
                                            v-model="selected_category"
                                            :options="attachmentCategory"
                                            @input = "attachmentCategoryClass()"
                                            >
                                    </v-select>
                                    <input type="hidden" name="category_id"
                                        v-model.number="(!selected_category)?null:selected_category.id">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('menu.AttachmentClass')</label>
                                    <v-select placeholder="@lang('menu.AttachmentClass')" label="name"
                                            v-model="selected_attachment_class"
                                            :options="attachmentClass">
                                    </v-select>
                                    <input type="hidden" name="attachment_class_id"
                                        v-model.number="(!selected_attachment_class)?null:selected_attachment_class.id">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                        <input type="text" name="title" class="form-control">
                                </div>
                            </div>  
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Number')</label>
                                        <input type="text" name="number" class="form-control" value="{{$number}}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ReferenceNumber" class="form-control">
                                </div>
                            </div>
                            
                          
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.OpeningDate')</label>
                                    <input type="text" name="start_date" class="form-control date now" autocomplete="off">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ExpireDate')</label>
                                    <input type="text" name="end_date" class="form-control date now" autocomplete="off">
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.FilesCount')</label>
                                        <input type="number" name="FilesCount" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.FileType')</label>
                                        <input type="text" name="FileType" class="form-control">
                                </div>
                            </div>

                           
                            
                           
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.InDate')</label>
                                    <input type="text" name="InDate" class="form-control date now" autocomplete="off">
                                </div>
                            </div>
                          
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Location')</label>
                                        <input type="text" name="Location" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Taghazah')</label>
                                        <input type="text" name="Taghazah" class="form-control">
                                </div>
                            </div>
                            
                           
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.surrender')</label>
                                        <input type="text" name="surrender" class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.recipient')</label>
                                <v-select label="name" :options="employee" @search="MemberSearch" v-model="selected_employee"></v-select>
                                <input type="hidden" name="employee" :value="!selected_employee?null:selected_employee.id">
                            </div>
                              <div class="col-md-6">
                                  <div class="form-group">
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                            <img src="" alt=""> </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                        <div>
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                   
                          <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <button type="button" @click="handleSubmit($event)"
                                    class="btn green">@lang('layout.Submit')</button>

                            <a href="{{route('attachment.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                </form>
            </div>
            <!-- END FORM-->
        </div>
    </div>


    
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        Vue.component("v-select", VueSelect.VueSelect);


        var attachmentCategory = {!! $attachmentCategory !!};
        var attachmentClass = {!! $attachmentClass !!};

        let vu = new Vue({
            el: '#app',
            data: {
                employee:[],
                selected_employee:null,
                selected_category     : null,
                attachmentCategory:attachmentCategory,
                attachmentClass:attachmentClass,
                attachmentClass_default:attachmentClass,
                selected_attachment_class:null
            },


            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

        attachmentCategoryClass() {
            vu.selected_attachment_class = null;
            vu.attachmentClass = vu.attachmentClass_default;

            if (this.selected_category != null && this.selected_category.attachment_class_id != null) {
                let attachment_category_id = this.selected_category.id;
                axios.get("{{route('callAttachmentCategoryClass.categoryClass')}}", {
                        params: {
                            method_name: 'classSearch',
                            attachment_category_id: attachment_category_id
                        }
                    })
                    .then(function(response) {
                        vu.attachmentClass = [];
                        vu.selected_attachment_class = null;
                        if (response.data.item.length > 0) {
                            // vu.attachmentClass = response.data.item;
                            vu.selected_attachment_class= response.data.item[0]
                        }
                    }) 
                    .catch(function(error) {
                        console.log(error);
                    });
            }

        },

        MemberSearch: _.debounce((search, loading) => {  
            loading(true);
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    type: 'Employee'
                } 
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vu.employee = [];
                    vu.employee = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

            }
        })

    </script>
@endpush 