@extends('layouts.app')
@section('content')


<!-- END PAGE HEADER-->


<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase"> @lang('layout.AssemblyItemList') </span>
            </div>
            <div class="tools"> </div> 
                <div class="btn-group pull-right">
                    @permission('assembly-export')
                        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="assemblylist"/>
                        <button type="submit" id="sample_editable_1_new"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}}
                        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="assemblylist"/>
                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}
                    @endpermission
                    @permission('assembly-create')
                        <a href="{{route('assembly.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission
                </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="assembly">
                <thead>
                <tr>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.FormulaName')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.CostAccount')</th>
                        <th>@lang('layout.AssetAccount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->


@endsection
 
@push('scripts')
<script>
    $(document).ready(function () {
        $('#assembly').DataTable({
            ajax: '{{route("assembly.index")}}',
            pageLength:'{{getPageRows()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns: [
                {data: 'code', name: 'assemblies.code'},
                {data: 'formula_name', name: 'assemblies.name'},
                {data: 'item_name', name: 'items.name'},
                {data: 'measure', name: 'measure',orderable:false,searchable:false},
                {data: 'costAccount', name: 'costAccount',orderable:false,searchable:false},
                {data: 'assetAccount', name: 'assetAccount',orderable:false,searchable:false},
                {data: 'date', name: 'assemblies.date',},
                {data: 'description', name: 'assemblies.description'},
                {data: 'actions', name: 'account',orderable:false,searchable:false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]

        });
    });
</script>


@endpush
