@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'assemblylist'"
                      @closed="closeModal">

            <div slot=body>


            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase"> @lang('layout.AssemblyItemList') </span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('assembly-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                         </span>
                    @endpermission
                    @permission('assembly-create')
                    <a href="{{route('assembly.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @if(systemConfig()[8] != 0 )
                        <a href="{{route('assembly_m.create')}}">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNewRoll')
                            </button>
                        </a>
                    @endif
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="assembly">
                    <thead>
                    <tr>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.FormulaName')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.CostAccount')</th>
                        <th>@lang('layout.AssetAccount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@endsection

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#assembly').DataTable({
                ajax: '{{route("assembly.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:6}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'code', name: 'assemblies.code'},
                    {data: 'formula_name', name: 'assemblies.name'},
                    {data: 'item_name', name: 'items.name'},
                    {data: 'measure', name: 'measure', searchable: false},
                    {data: 'costAccount', name: 'costAccount', orderable: false, searchable: false},
                    {data: 'assetAccount', name: 'assetAccount', orderable: false, searchable: false},
                    {data: 'date', name: 'assemblies.date',},
                    {data: 'username', name: 'users.name'},
                    {data: 'description', name: 'assemblies.description'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


                ]

            });
        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush
