@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@stop
@section('content')
<!-- BEGIN CONTENT BODY -->
@include("layouts.Invmodal")
@include("bills.modal")
<!-- END PAGE BAR -->
<div class="row">
  <div class="portlet light bg-inverse">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewAssembly')</span>
        {{--<span class="caption-helper"></span>--}}
      </div>
      <div class="tools">
        <a href="" class="collapse"> </a>
        <a href="#portlet-config" data-toggle="modal" class="config"> </a>
        <a href="" class="reload"> </a>
        <a href="" class="remove"> </a>
      </div>
    </div>
    <div class="portlet-body form" id="assembaly" v-cloak>
      <!-- BEGIN FORM-->
      {{Form::open(['route' => 'assembly.store','method' => 'POST','class' => 'form-','id'=>'assembly-form'])}}
      <div class="form-body">
        <div class="row">
          <input type="hidden" name="temp_type" value="assembly">
          <div class="col-md-12">
            <div class="col-md-4">
              <div class="form-group">
                <label class="control-label"> @lang('layout.ItemName')</label>
                <div class="input-group">
                  <v-select label="name" v-model="selected_assembly_item" :options="formula_items" @search="onItemSearch"></v-select>
                  <input type="hidden" name="item" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                  <span class="btn btn-success input-group-addon " title="@lang('layout.AddNewItem')" @click="showInvModal = true" style="background-color:  rgb(84, 199, 211)">
                      <i class="fa fa-plus" style="color: white"></i>
                  </span> 
                </div>
                <span class="required">@{{ errors.first('item') }}</span>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label class="control-label">@lang('layout.Measure')</label>

                <input type="text" class="form-control" readonly="" :value="(!selected_assembly_item)?null:selected_assembly_item.measure">

              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label class="control-label">@lang('layout.AssemblyName')</label>

                {{Form::text('name',null,['class' => 'form-control','placeholder' =>__('layout.EnterAssemblyName'),'v-model' =>'name','v-validate' =>'"required|min:2"','data-vv-as' => __('layout.EnterAssemblyName')])}}
                <span class="required">@{{ errors.first('name') }}</span>

              </div>
            </div>

          </div>

          <div class="col-md-12">
            <div class="col-md-4">
              <div class="form-group">
                <label class="control-label ">@lang('layout.AssemblyCode')</label>

                {{Form::number('code',$code,['class' => 'form-control','min' =>'0','placeholder' =>__('layout.AssemblyCode'),'v-model' =>'code','v-validate' =>'"required"','data-vv-as' => __('layout.AssemblyCode')])}}
                <span class="required">@{{ errors.first('code') }}</span>

              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label class="control-label ">@lang('layout.Date')</label>
                <date_picker name="date" v-model="date" placeholder="@lang('layout.Date')"></date_picker>
              </div>
            </div>


            <div class="col-md-4">
              <div class="form-group">
                <label class="control-label col-md-4">@lang('layout.Description') </label>
                <textarea name="description" class="form-control" rows="2" v-text="description"></textarea>
              </div>
            </div>
          </div>
        </div>

        <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
        <div v-if="assemlby_items.length >0 " class="">
          <table id="table_content" class="table table-bordered">
            <thead>
              <tr>
                <th class="text-center" style="width: 25px;"> # </th>
                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                <th style="width: 20px;"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(inventory,InventoryIndex) in assemlby_items" class="even">
                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                </td>
                <td class="td_one">
                  <v-select label="name" v-model="inventory.item" :options="temp_items" @search="onItemsSearch" @Click.native="setIndex(InventoryIndex)"></v-select>
                  <input type="hidden" :name="'inventory_id['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(inventory.item==null)?null:inventory.item.id">
                  <span class="required">@{{ errors.first('inventory_id['+InventoryIndex+']') }}</span>
                </td>
                <td>
                  <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" class="form-control input_style" placeholder="Measure" required="required">

                    <span v-if="inventory.item.measure_list !=null">
                      <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                    </span>
                 
                  </select>

                  <input type="hidden" name="inventory_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                </td>
                <td>
                  <input type="number" :name="'inventory_qty['+InventoryIndex+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(inventory.item==null)?null:inventory.item.qty" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                  <span class="required">@{{ errors.first('inventory_qty['+InventoryIndex+']') }}</span>
                </td>

                <td>
                  <span v-if="InventoryIndex > 0" v-on:click="deleteItem('inventory',InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                </td>
              </tr>
              <tr style="background-color: #ffffff;">
                <td></td>
                <td>
                  <center>
                    <span @click="addNew('inventory',100)" class="btn btn-success"><i class="fa fa-plus"></i></span>
                  </center>
                </td>
                <td></td>
                <td></td>
                <td></td>
              </tr>

            </tbody>
          </table>

        </div>
        <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
        </button>

        <div class="form-section"></div>
        <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>

        <div v-if="otherBuild.length >0 " class="">

          <table id="table_content" class="table table-bordered">
            <thead>
              <tr>
                <th class="text-center" style="width: 25px;"> # </th>
                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                <th style="width: 20px;"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(inventory,InventoryIndex) in otherBuild" class="even">
                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                </td>
                <td class="td_one">

                  <v-select label="name" v-model="inventory.item" :options="temp_items" @click.native="addNew('otherBuilds',InventoryIndex)" @search="onItemsSearch"></v-select>
                  <input type="hidden" name="other_build_id[]" :value="(inventory.item==null)?null:inventory.item.id">

                </td>
                <td>
                  <select v-if="(inventory.item !=null)" v-model="(inventory.item == null)?null:inventory.item.measure" class="form-control input_style" placeholder="Measure" required="required">
                    <span v-if="inventory.item.measure_list !=null">
                      <option v-if="(inventory.item !=null)" v-for="measures in inventory.item.measure_list" :value="measures">@{{ measures.measure_name }}</option>
                    </span>
                  </select>

                  <input type="hidden" name="other_build_measure[]" :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                </td>
                <td>
                  <input name="other_build_qty[]" class="form-control inpu-number-fild" :class="" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" placeholder="@lang('layout.Quantity')" />
                </td>
                <td>
                  <span v-on:click="deleteItem('otherBuild',InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                </td>
              </tr>

            </tbody>
          </table>

        </div>

        <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
        </button>

        <div v-if="type !='UnstructuredFormula'">

          @if(getBuildExpense() == "true")
          <!-- build expense -->

          <div class="form-section"></div>
          <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>

          <div v-if="expenses.length >0 " class="">

            <table id="table_content" class="table table-bordered">
              <thead>
                <tr>
                  <th class="text-center" style="width: 25px;"> # </th>
                  <th class="text-center" style="min-width: 160px;">@lang('layout.ExpenseAccount')</th>
                  <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                  <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                  <th style="width: 20px;"></th>
                </tr>
              </thead>
              <tbody>
                <tr v-for="(expense,index) in expenses" class="even">
                  <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                  </td>
                  <td class="td_one">

                    <v-select label="name" v-model="expense.expense_account" :options="expense_account" @click.native="addNew('expense',index)"></v-select>
                    <input type="hidden" name="expense_id[]" :value="(expense.expense_account==null)?null:expense.expense_account.id">

                  </td>
                  <td>
                    <input type="text" name="expense_description[]" v-model="expense.description" class="form-control" placeholder="@lang('layout.Description')">
                  </td>
                  <td>
                    <input type="number" name="expense_amount[]" v-model="expense.amount" class="form-control" placeholder="@lang('layout.Amount')">
                  </td>
                  <td>
                    <span v-on:click="deleteItem('expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                  </td>
                </tr>

              </tbody>
            </table>

          </div>
          
          <!-- end build expense -->
          @endif
        </div>

        <div class="row">
          <div class="col-md-offset-3 col-md-9">
            <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
            <button type="button" class="btn blue" @click="saveAndNew($event)" v-if="!isError" >@lang('layout.SaveAndNew')</button>
            <a href="{{route('assembly.index')}}" @click="clearTemp" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

          </div>
        </div>

      </div>
      {{Form::close()}}
      
        <invmodal :show='showInvModal' @close="showInvModal=false">
        
        </invmodal>

        <modal v-if="showMeasureModal" @close="showMeasureModal = false">
          <div slot="body">
              <div class="row">
                  <div class="col-md-3">
                      <h4>@lang('layout.MetricType')</h4>
                      <span v-for="metric in metricList">
                          <div class="mt-radio-list">
                              <label class="mt-radio"> @{{ metric.name }}

                                  <input name="metric" type="radio" v-bind:value="metric"
                                  v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                  <span></span>
                              </label>
                          </div>
                      </span>
                  </div>
                  <div class="col-md-3">
                      <h4>@lang('layout.Measure') </h4>
                      <span v-for="measure1 in selectedMetric.measure">
                          <div class="mt-radio-list">
                              <label class="mt-radio">
                              <b v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </b>
                              <b v-if="measure1.text !='Other'">@{{ measure1.text }} </b>
                                  <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                  <span></span>
                              </label>
                          </div>
                      </span>
                  </div>
                  <div class="col-md-6">
                      <span v-if="selectedMeasure.text == 'Other'">
                          <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                          <div>
                              <div class="form-group">
                                  <label class="control-label col-md-5">
                                  @lang('layout.MeasureName')</label>
                                  <div class="col-md-7">
                                      <input type="text" class="form-control"
                                      placeholder="@lang('layout.EnterMeasureName')"
                                      v-model.trim="selectedMeasure.name">
                                      <span class="help-block">  </span>
                                  </div>
                              </div>

                              <div class="form-group">
                                  <label class="control-label col-md-5">
                                      @lang('layout.MeasureAmount')
                                  </label>
                                  <div class="col-md-7">
                                      <input type="number" class="form-control"
                                      placeholder="@lang('layout.EnterMeasureuint')"
                                      v-model.number="selectedMeasure.unit">
                                      <span class="help-block">  </span>
                                  </div>
                              </div>
                              <div class="form-group ">
                                  <label class="control-label col-md-5">
                                      @lang('layout.MeasureSymbol')
                                  </label>
                                  <div class="col-md-7">
                                      <input type="text" class="form-control"
                                      placeholder="@lang('layout.EnterMeasureSymbol')"
                                      v-model.trim="selectedMeasure.symbol">
                                      <span class="help-block">  </span>
                                  </div>
                              </div>
                          </div>

                      </span>
                  </div>

              </div>

          </div>
          <h3 slot="header">
              <div class="col-md-4">
                  <h3>
                      @lang('layout.AddNewMeasure')
                  </h3>
              </div>
              <div class="col-md-4">
                  <div v-if="fieldErrors.length > 0">
                      <p class="text-danger" fieldErrors>
                          <spna v-text="fieldErrors"></spna>
                      </p>
                  </div>
              </div>
          </h3>
          <div slot="footer">
              <button type=button class="modal-default-button" v-on:click="addMeasure">
                  @lang('layout.OK')
              </button>
              <button type=button class="modal-default-button"
              v-on:click="showMeasureModal = false, showInvModal = true ,measure = null , type=null">
              @lang('layout.Cancel')
          </button>
          </div>
        </modal>

      </div>
        <!-- END FORM-->
  </div>
</div>

@endsection
@push('scripts')

<script src="{{url('/vue/sweetalert1.min.js')}}"></script>



<script>
  Vue.component('v-select', VueSelect.VueSelect);

  @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif
  
  Vue.component("modal", {
      template: "#modal-template",
      props: ['show'],
      created() {
          console.log('rrrrr');
      }

  });  

    /// inventory model
    var invm = null;
    Vue.component("invmodal", {
        template: '#invmodal-template',

        props: ['show'],
        data() {
            return {
                measureList: [],
                categories: [],
                income: [],
                cost: [],
                asset: [],
                rate: 0,
                description: null,
                number: null,
                category: null,
                selectMeasure: null,
                incomeAccount: null,
                costAccount: null,
                assetAccount: null,
            }
        },
        created() {

            axios.get('{{route("inventory.create")}}', {
                    params: {
                        add_item: 'on'
                    }
                }).then(
                response => {
                    this.measureList = response.data.measure;
                    this.categories = response.data.category;
                    this.number = response.data.number;
                    this.income = response.data.income;
                    this.cost = response.data.cost;
                    this.asset = response.data.asset;
                    if(this.measureList.length>0)
                    {
                        this.selectMeasure=this.measureList[0];
                    }
                    if(this.income.length>0)
                    {
                        this.incomeAccount=this.income[0];
                    }
                    if(this.cost.length>0)
                    {
                        this.costAccount=this.cost[0];
                    }
                    if(this.asset.length>0)
                    {
                        this.assetAccount=this.asset[0];
                    }

                }).catch(error => console.log(error));
        },
        methods: {
            showMeasureModal() {
                invm = this;
                sales.showMeasureModal = true;
                sales.showInvModal = false;
            },

            onSubmit() {
                var ivn = this;
                sales.showInvModal = false;
                var datas = $("#modalFormInv").serializeArray();
                // console.log(123,datas);
                $.ajax({
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    url: '{{route("inventory.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'type': datas[1]['value'],
                        'number': datas[2]['value'],
                        'gauge': datas[3]['value'],
                        'rate': datas[4]['value'],
                        'description': datas[5]['value'],
                        'asset_account': this.assetAccount.id,
                        'um_id': this.selectMeasure.id,
                        'income_account': this.incomeAccount.id,
                        'cost_account': this.costAccount.id,
                        'cost': 1,
                        'category': (this.category) ? this.category.id : null
                    },
                    dataType: 'json',

                }).done(function (response) {
                    // console.log(123, response);
                    if (response) {
                      response.item.id = response.item.item_id;
                      sales.selected_assembly_item = null;
                      sales.selected_assembly_item = response.item;
                    }
                    axios.get('{{route("inventory.create")}}', {
                        params: {
                            saveAndNew: 'on'
                        }
                    }).then(response => {
                        // console.log(1239, response);
                        ivn.number = response.data;
                        document.getElementById("modalFormInv").reset();
                    }).catch(error => console.log(error));

                }).fail(function (error) {
                    console.log('error', error);
                });

            }
        }
    });
    /// inventory model

  var expense_account = {!! $expense_account !!};

  function callSaveTemp() {
    @if(saveTempData() == 'true')
    setTimeout((function() {
      sales.saveTemp();
      // console.log(12);
    }), 4e4)
    @endif
  }

  var sales = new Vue({
    el: '#assembaly',
    data: {
      type: null,
      selected_assembly_item: null,
      showInvModal: false,
      assembly_item: [],
      temp_items: [],
      formula_items: [],
      assemlby_items: [{
        item: null
      }, ],
      otherBuild: [{
          item: null
        },
        {
          item: null
        },
        {
          item: null
        },
        {
          item: null
        },
      ],
      otherBuildIndex: 0,
      inventoryIndex: 0,
      description: null,
      date: null,
      code: "{{$code}}",
      name: null,
      inventoryItem: null,
      expense_account: expense_account,
      expenses: [{
          expense_account: null,
          description: null,
          amount: null
        },
        {
          expense_account: null,
          description: null,
          amount: null
        },
        {
          expense_account: null,
          description: null,
          amount: null
        },
      ],

      showMeasureModal: false,
      fieldErrors: [],
      selectedMetric: {},
      senddata: {},
      selectedMeasure: {},
      metricList:{!!json_encode(getMeasures())!!},

    },

    computed: {
      isError: function() {
        var isError = false;
        if (this.selected_assembly_item == null) {
          isError = true;
        }
        return isError;
      }
    },
    mounted: function() {
      @if(saveTempData() == 'true')
      axios.get("{{route('temp.assembly.getData')}}", {
          params: {
            type: 'assembly'
          }
        })
        .then(function(response) {
          // console.log('myrespo1', response);
          if (response.data) {
            if (response.data.form) {
              sales.date = response.data.form.date;
              sales.description = response.data.form.description;
              sales.code = response.data.form.number;
              sales.name = response.data.form.other_member_name;
            }
            if (response.data.items) {
              if (response.data.items.length > 0) {
                sales.assemlby_items = [];
                for (var r = 0; r < response.data.items.length; r++) {
                  sales.assemlby_items.push({
                    item: response.data.items[r]
                  });
                }
                for (var m = 1; m > response.data.items.length; m--) {
                  sales.assemlby_items.push({
                    item: null
                  });
                }
              }
            }
            if (response.data.otherBuild) {
              if (response.data.otherBuild.length > 0) {
                sales.otherBuild = [];
                for (var r = 0; r < response.data.otherBuild.length; r++) {
                  sales.otherBuild.push({
                    item: response.data.otherBuild[r]
                  });
                }
                for (var m = 4; m > response.data.otherBuild.length; m--) {
                  sales.otherBuild.push({
                    item: null
                  });
                }
              }
            }
            if (response.data.expenses) {
              if (response.data.expenses.length > 0) {
                sales.expenses = [];
                for (var r = 0; r < response.data.expenses.length; r++) {
                  sales.expenses.push({
                    expense_account: response.data.expenses[r].selected_account,
                    description: response.data.expenses[r].description,
                    amount: response.data.expenses[r].amount
                  });
                }
                for (var m = 4; m > response.data.expenses.length; m--) {
                  sales.expenses.push({
                    expense_account: null,
                    description: null,
                    amount: null
                  });
                }
              }
            }
            //begin formula item initialize
            if (response.data.asseItem) {
              sales.formula_items.push(response.data.asseItem);
              sales.selected_assembly_item = sales.formula_items[0];
            }

          }
        })
        .catch(function(error) {
          console.log(error);
        })
      @endif
      callSaveTemp();
    },
    methods: {
      handleSubmit(e) {
        this.$validator.validate().then(valid => {
          if (valid) {
            // alert(e.target);
            regForm(e.target);
          }
        });
      },

      addMeasure: function () {
          let senddata = _.clone(this.selectedMetric);
          senddata.measure = _.clone(this.selectedMeasure);
          var req = axios.post("{{route('measure.store')}}",senddata)
          .then(function (response) {
              if (response) {
                  if (response.data) {
                      // var measure_id = response.data.me.id;
                      invm.selectMeasure = response.data.me;
                      // console.log(444, response, measure_id);
                  }
              }
              sales.showMeasureModal = false;
              sales.fieldErrors = [];
              sales.selectedMetric = {};
              sales.selectedMeasure = {};

              axios.get("{{route('inventory.create')}}").then(function (response) {
                  invm.measureList = response.data;
                  sales.showInvModal = true;
              });
          })
          .catch(function (error) {
              axios.get("{{route('inventory.create')}}").then(function (response) {
                  invm.measureList = response.data;
                  sales.showInvModal = true;
              });

              sales.fieldErrors = error.response.data

          });

      },

      // begin item search

      onItemSearch: _.debounce((search, loading) => {
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'anyTable',
              'search_column': 'name',
              'table_name': 'items',
              keyword: search,
              'formula': 'formula',
              'limit_type': 'item'
            }
          })
          .then(function(response) {
            sales.formula_items = [];
            if (response.data.length > 0) {
              sales.formula_items = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      }, getDebounceTime()),


      // end item search
      // items serarch method

      onItemsSearch: _.debounce((search, loading) => {
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'items_search_assebley',
              'type': 'assembaly',
              keyword: search,
            }
          })
          .then(function(response) {
            sales.temp_items = [];
            if (response.data.length > 0) {
              sales.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          })
      }, getDebounceTime()),

      setIndex() {
        this.temp_items = [];
      },

      addNew(type = null, index) {
        this.temp_items = [];
        if (type != null) {
          if (type == 'inventory') {
            if (this.assemlby_items[index + 1] == undefined) {
              this.assemlby_items.push({
                item: null
              });
            }
          }
          if (type == 'otherBuilds') {
            if (this.otherBuild[index + 1] == undefined) {
              this.otherBuild.push({
                item: null
              });
            }
          }
          if (type == 'expense') {
            if (this.expenses[index + 1] == undefined) {
              this.expenses.push({
                expense_account: null,
                description: null,
                amount: null
              });
            }
          }



        }

      },
      deleteItem(type = null, index) {
        if (type != null) {
          console.log(type);
          if (type == 'inventory') {
            this.assemlby_items.splice(index, 1);
          }
          if (type == 'otherBuild') {
            this.otherBuild.splice(index, 1);
          }
          if (type == 'expense') {
            this.expenses.splice(index, 1);
          }

        }

      },

      addItems(type) {
        if (type != null) {
          if (type == "otherBuilds") {
            this.temp_items = [];
            this.otherBuild.push({
              item: null
            });
          }
          if (type == "inventory") {
            this.temp_items = [];
            this.assemlby_items.push({
              item: null
            });
          }
          if (type == "expense") {
            this.expenses.push({
              expense_account: null,
              description: null,
              amount: null
            });
          }
        }

      },
      saveTemp() {
        var url = "{{route('temp.assembly.store')}}";
        form_id = 'assembly-form';
        var data = $('#' + form_id).serialize();
        axios.post(url, data)
          .then(function(response) {
            // console.log('sss11', response);
            callSaveTemp();
          })
          .catch(function(error) {
            console.log(error);
            callSaveTemp();
          });
      },
      clearTemp() {
        axios.get("{{route('temp.clear')}}", {
            params: {
              type: 'assembly'
            }
          })
          .then(function(response) {
            // console.log('sss11', response);
          })
          .catch(function(error) {
            console.log(error);
          });
      },
      saveAndNew()
      {
          this.$validator.validate()
          .then(valid =>{
              if(valid)
              { 
                  var url="{{route('assembly.store')}}";
                  form_id='assembly-form';
                  var data= $('#'+form_id).serialize();
                  // console.log(444, data);
                  toggleBlock(true);
                  axios.post(url,data)
                  .then(function(response){
                          toggleBlock(0);
                          if(response.data.result==1)
                          {
                              $('#'+form_id).trigger('reset');
                              
                              toastr.success('',response.data.message); 
                              location.reload();
                          
                          }
                          else
                          {
                              var message="{{__('message.Warning')}}";
                              //$('#error-sound')[0].play();
                              toastr.warning('',message);
                          }
                  })
                  .catch(function(error){
                  toggleBlock(0);
                      console.log(error);
                      var message="{{__('message.Warning')}}";
                      //$('#error-sound')[0].play();
                      toastr.warning('',message);
                  });
              
              }
          })
      },
    }
  });
</script>


@endpush