@extends('layouts.factor-master')

@section('content')
<?php

$report = customeReportNew('assemblylist_index');
$_no = !in_array('no', $report);
$_code = !in_array('code', $report);
$_description = !in_array('description', $report);
$_formula_name = !in_array('formula_name', $report);
$_item = !in_array('item', $report);
$_measure = !in_array('measure', $report);
$_user = !in_array('user', $report);
 
$report_percent = customeReportNewPercent('assemblylist_index');
    $_no_percent= (array_key_exists('no___percent', $report_percent))?$report_percent['no___percent']:null;
    $_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_formula_name_percent= (array_key_exists('formula_name___percent', $report_percent))?$report_percent['formula_name___percent']:null;
    $_item_percent= (array_key_exists('item___percent', $report_percent))?$report_percent['item___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
 

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.AssemblyReport')</h3>

<table class="main-table">
    <tr>
      @if($from_date)
      <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
  
<table class="main-table">

    <tr class="bg">
    @if($_no)<td @if($_no_percent) width="{{$_no_percent}}%" @endif class="center" ><div> @lang('layout.No.') </div></td>@endif
    @if($_code)<td @if($_code_percent) width="{{$_code_percent}}%" @endif class="center" ><div> @lang('layout.Code') </div></td>@endif
    @if($_description)<td  @if($_description_percent) width="{{$_description_percent}}%" @endif class="center" ><div> @lang('layout.Description')</div></td>@endif
    @if($_formula_name)<td @if($_formula_name_percent) width="{{$_formula_name_percent}}%" @endif class="center" ><div> @lang('layout.FormulaName')</div></td>@endif
    @if($_item)<td @if($_item_percent) width="{{$_item_percent}}%" @endif class="center" ><div> @lang('layout.Item')</div></td>@endif
    @if($_measure)<td @if($_measure_percent) width="{{$_measure_percent}}%" @endif class="center" ><div> @lang('layout.Measure')</div></td>@endif
    @if($_user)<td @if($_user_percent) width="{{$_user_percent}}%" @endif class="center" ><div> @lang('layout.User')</div></td>@endif
  </tr>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
  @if($_no)<td class="center">{{++$count}}</td>@endif
  @if($_code)<td class="center">{{$record->Code}}</td>@endif
  @if($_description)<td class="center" style="@if($_description_percent) text-align: justify @endif">{{$record->Description}}</td>@endif
  @if($_formula_name)<td  class="center">{{$record->Name}}</td>@endif
  @if($_item)<td  class="center">{{$record->Item}}</td>@endif
  @if($_measure)<td  class="center">{{$record->Measure}}</td>@endif
  @if($_user)<td class="center">{{$record->User}}</td>@endif
</tr>
@endforeach
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection