@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AdvancePricingShow')
            </div>
            <div class="tools">
            </div> 
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th >
                            <i class="fa  fa-bars"></i> @lang('layout.Number')
                        </th>
                        <th >
                            <i ></i> @lang('layout.AdvancePricingType')
                        </th>

                        <th class="hidden-xs">
                            <i ></i> @lang('layout.PricingType')
                        </th>
                        <th class="hidden-xs">
                            <i ></i> @lang('layout.Type')
                        </th>
                     
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th >
                            <i></i> @lang('layout.Description')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>

                        <td>{{$advancePricing->id}}</td>
                        <td>{{__('type.' . $advancePricing->advance_pricing_type) }}</td>
                        <td>{{__('type.' . $advancePricing->pricing_type) }}</td>
                        <td>{{__('type.' . $advancePricing->type) }}</td>
                        <td>{{convertDate($advancePricing->date)}}</td>
                        <td>{{$advancePricing->description}}</td>
                      
                    </tr>
            
                    </tbody>
                </table>
            </div>

          

        </div>
    </div>
    <div class="row">


        <div class="tabbable tabbable-tabdrop">
                    <div class="">

                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>&nbsp;
                                        <span class="caption-subject bold uppercase">@lang('layout.Items') </span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="advance_pricing_details"/>
                                        <input type="hidden" name="id" value="{{$advancePricing->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="advance_pricing_details"/>
                                        <input type="hidden" name="id" value="{{$advancePricing->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="advancePricing">
                                        <thead>
                                        <tr>
                                          
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Unit/M')</th>
                                            <th>@lang('layout.SalePrice')</th>
                                            <th>@lang('layout.NewSalePrice')</th>

                                       
    
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
        </div>

    </div>


@endsection
@push('scripts')

    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#advancePricing').DataTable({
                ajax: {
                    url: '{{route("advancePricing.show",$advancePricing->id)}}',
                },
                pageLength:'{{getPageRows()}}',

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                     {data: 'number', name: 'number', orderable: false, searchable: false}, 
                    {
                        data: 'name', name: 'items.name'
                    },
                    {data: 'symbol', name: 'symbol', orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'sale_price_after_pricing', name: 'sale_price_after_pricing', orderable: false, searchable: false}




                ]
            });


        });
    </script>


@endpush
