@extends('layouts.factor-master')


@section('content')
<?php
$report = customeReport('invoice_detail');
$_item_name = in_array('item_name', $report);
$_symbol = in_array('symbol', $report);
$_purchase_date = in_array('purchase_date', $report);
$_sleep_day = in_array('sleep_day', $report);
$_quantity = in_array('quantity', $report);
$_price = in_array('price', $report);
$_purchase_rate = in_array('purchase_rate', $report);
$_income = in_array('income', $report);
$_total = in_array('total', $report);
?>





<h3 class="table-caption" style="text-align: center;">@lang('layout.AddvancePricingReport')</h3>

<table class="main-table">
    @if($info && $info !=[])

    <tr>
        <th>
            <i class="fa  fa-bars"></i> @lang('layout.Number')
        </th>
        <th>
            <i></i> @lang('layout.AdvancePricingType')
        </th>

        <th class="hidden-xs">
            <i></i> @lang('layout.PricingType')
        </th>
        <th class="hidden-xs">
            <i></i> @lang('layout.Type')
        </th>

        <th>
            <i class="fa fa-clock-o"></i> @lang('layout.Date')
        </th>
        <th>
            <i></i> @lang('layout.Description')
        </th>
    </tr>
    <tr>
        <td>{{$info->id}}</td>
        <td>{{__('type.' . $info->advance_pricing_type) }}</td>
        <td>{{__('type.' . $info->pricing_type) }}</td>
        <td>{{__('type.' . $info->type) }}</td>
        <td>{{convertDate($info->date)}}</td>
        <td>{{$info->description}}</td>

    </tr>
    @endif

</table>
<br>
<table class="main-table">
    <thead>
        <tr class="bg">

            <th class="center" >@lang('layout.Record') </th>
            <th class="center" >@lang('layout.SerialNum')</th>
            <th class="center" >@lang('layout.ItemName')</th>
            <th class="center" >@lang('layout.Unit/M')</th>
            <th class="center" >@lang('layout.SalePrice')</th>
            <th class="center" >@lang('layout.NewSalePrice')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <?php
        $old_item_rate = ($record->old_item_rate != 0)?$record->old_item_rate: $record->rate;
    ?>
    <tr>
        <td class="center">{{++$count}}</td>

        <td class="center">{{$record->number}}</td>
        <td class="center">{{$record->name}}</td>
        <td class="center">{{$record->symbol}}</td>
        <td class="center">{{$record->rate}}</td>
        <td class="center">
            @if($record->type =="currency")
            {{$record->amount+$old_item_rate}}
            @else
            {{(($record->amount/100)*$old_item_rate)+$old_item_rate}}
            @endif
        </td>
    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection