@extends('layouts.app')
@section('style')

<style>

</style>
@stop
@section('content')


<div class="row" id="app" v-cloak>

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AdvancePricingCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'advancePricing.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('menu.InventoryCategory')</label>
                                     <select class="list-style form-control" @change="changeCategory(this)" name="inventory_category_id">
                                            <option value="">@lang('layout.Select')</option>
                                            <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                                     </select>
                                </div>
                            </div> 
                        </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.AdvancePricingType')</label>
                                     <select name="advance_pricing_type" class="list-style form-control" 
                                     v-model="selected_advance_pricing_type" >
                                            <option value="up">@lang('layout.UpPrice')</option>
                                            <option value="down">@lang('layout.DownPrice')</option>
                                     </select>
                                </div>
                            </div> 
                        </div>       

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.PricingType')</label>
                                     <select name="pricing_type" class="list-style form-control" 
                                     v-model="selected_pricing_type" >
                                            <option value="add_new_price">@lang('layout.AddNewPrice')</option>
                                            <option value="add_to_old_price">@lang('layout.AddToOldPrice')</option>
                                            <option value="add_from_unit_cost">@lang('layout.AddFromUnitCost')</option>
                                            <option value="add_upper_cost">@lang('layout.UpperCost')</option>
                                            <option value="add_last_cost">@lang('layout.LastCost')</option>
                                     </select>
                                </div>
                            </div> 
                        </div>      

                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Type')</label>
                                     <select name="type" class="list-style form-control" 
                                     v-model="selected_type" >
                                            <option value="percent">%</option>
                                            <option value="currency">{{getHomeCurrency()['code']}}</option>
                                     </select>
                                </div>
                            </div> 
                        </div>

                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Quantity')</label>
                                    <input type="number" name="amount" class="form-control" v-model="amount">
                                </div>
                            </div> 
                        </div>

                        
                      </div>
                      <div class="row">
                          <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Description')</label>
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div> 
                        
                        <!-- <div class="col-lg-2 col-md-4 col-xs-12">
                          <div class="mt-element-ribbon bg-grey-steel">
                              <div class="ribbon ribbon-color-success uppercase">Alert</div>
                              <p class="ribbon-content">@lang('message.TranslateDescription')</p>
                          </div>
                      </div> -->

                            
                      </div>
                     <div class="row" style=" overflow-y: scroll; height:600px;">                   
                      <table class="table table-striped table-bordered table-hover">
                          <thead>
                              <tr style="background-color: rgb(174, 183, 178)">
                                        <th colspan="7">@lang('layout.SelectAll') </th>
                              </tr>
                              <tr style="background-color: rgb(174, 183, 178);">
                                  <th style="background-color: #6b716b;"><input type="checkbox" name="selectedItem" class="icheck" @change="selectAll(this)" v-model="selectedAll"> </th>
                                  <th>@lang('layout.Code') </th>
                                  <th>@lang('layout.ItemName') </th>
                                  <th class="hidden-xs">
                                       @lang('layout.Measure') </th>
                                  <th style="color: green;"> @lang('layout.Rate') </th>

                                  <th> @lang('layout.Quantity') </th>
                                  <th style="color: green;"> @lang('layout.NewPrice') </th>
                              </tr>
                          </thead>
                          <tbody >
                              <tr v-for="(item,index) in items">
                                  <input type="hidden" name="item[]" v-model="item.id">
                                  <td class="highlight" style="background-color: rgb(174, 183, 178);">
                                      <div class="success"></div>
                                      <input type="checkbox" @click="toggleCheck(index)" :checked="item.selected">
                                      <input type="hidden" name="selected_item[]" :value="item.selected">
                                      <input type="hidden" name="selected_item_rate[]" :value="item.old_item_rate">
                                  </td>
                                    <td class="highlight">
                                      <div class="success"></div>
                                      @{{item.number}} 
                                  </td>
                                  <td class="highlight">
                                      <div class="success"></div>
                                      <a href="javascript:;"> @{{item.name}} </a>
                                  </td>
                                  <td class="hidden-xs"> @{{item.measure}} </td>
                                  <td  class="hidden-xs">
                                     
                                     <span v-if="selected_pricing_type=='add_new_price'">@{{item.rate}}</span>
                                     <span v-if="selected_pricing_type=='add_from_unit_cost'">@{{item.cost}}</span>
                                     <span v-if="selected_pricing_type=='add_upper_cost'">@{{item.max_cost}}</span>
                                     <span v-if="selected_pricing_type=='add_last_cost'">@{{item.last_cost}}</span>
                                     <span v-if="selected_pricing_type=='add_to_old_price'">
                                        <span v-if="item.ad_type=='currency'">@{{item.old_item_rate+item.ad_amount}}</span>
                                        <span v-if="item.ad_type=='percent'">@{{item.old_item_rate+(item.old_item_rate*item.ad_amount)/100}}</span>
                                     </span>
                                  </td>
                                  <td> 
                                    <input type="number" name="amounts[]" class="form-control" :value="!item.selected?null:(Number(amount)+Number(item.amount))">
                                    </td>
                                    <td v-if="selected_pricing_type=='add_new_price'" class="hidden-xs">
                                      <input type="hidden" name="selected_item_cost[]" :value="item.rate">
                                      <span v-if="selected_type=='currency'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.rate)+(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.rate)-(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                      </span>
                                      <span v-if="selected_type=='percent'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.rate)+(Number(item.rate)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.rate)-(Number(item.rate)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                      </span>
                                    </td>
                                    <td v-if="selected_pricing_type=='add_from_unit_cost'" class="hidden-xs">
                                      <input type="hidden" name="selected_item_cost[]" :value="item.cost">
                                      <span v-if="selected_type=='currency'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.cost)+(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.cost)-(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                      </span>
                                      <span v-if="selected_type=='percent'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.cost)+(Number(item.cost)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.cost)-(Number(item.cost)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                      </span>
                                    </td>
                                    <td v-if="selected_pricing_type=='add_upper_cost'" class="hidden-xs">
                                      <input type="hidden" name="selected_item_cost[]" :value="item.max_cost">
                                      <span v-if="selected_type=='currency'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.max_cost)+(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.max_cost)-(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                      </span>
                                      <span v-if="selected_type=='percent'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.max_cost)+(Number(item.max_cost)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.max_cost)-(Number(item.max_cost)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                      </span>
                                    </td>
                                    <td v-if="selected_pricing_type=='add_last_cost'" class="hidden-xs">
                                      <input type="hidden" name="selected_item_cost[]" :value="item.last_cost">
                                      <span v-if="selected_type=='currency'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.last_cost)+(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.last_cost)-(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                      </span>
                                      <span v-if="selected_type=='percent'">
                                          <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.last_cost)+(Number(item.last_cost)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                          <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.last_cost)-(Number(item.last_cost)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                      </span>
                                    </td>
                                    <td v-if="selected_pricing_type=='add_to_old_price'" class="hidden-xs">
                                      <span v-if="selected_type=='currency'">
                                          <span v-if="item.ad_type=='currency'">
                                            <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.old_item_rate)+Number(item.ad_amount)+(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                            <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.old_item_rate)+Number(item.ad_amount)-(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                          </span>
                                          <span v-if="item.ad_type=='percent'">
                                              <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.old_item_rate)+(Number(item.old_item_rate)*Number(item.ad_amount))/100+(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                              <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.old_item_rate)+(Number(item.old_item_rate)*Number(item.ad_amount))/100-(!item.selected?null:(Number(amount)+Number(item.amount)))}}</span>
                                          </span>
                                      </span>
                                      <span v-if="selected_type=='percent'">
                                        <span v-if="item.ad_type=='currency'">
                                            <span v-if="selected_advance_pricing_type=='up'">@{{Number(item.old_item_rate)+Number(item.ad_amount)+((!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                            <span v-if="selected_advance_pricing_type=='down'">@{{Number(item.old_item_rate)+Number(item.ad_amount)-((!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                        </span>
                                        <span v-if="item.ad_type=='percent'">
                                            <span v-if="selected_advance_pricing_type=='up'">@{{(Number(item.old_item_rate)+(Number(item.old_item_rate)*Number(item.ad_amount))/100)+((item.old_item_rate+(item.old_item_rate*item.ad_amount)/100)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                            <span v-if="selected_advance_pricing_type=='down'">@{{(Number(item.old_item_rate)+(Number(item.old_item_rate)*Number(item.ad_amount))/100)-((item.old_item_rate+(item.old_item_rate*item.ad_amount)/100)*(!item.selected?null:(Number(amount)+Number(item.amount))))/100}}</span>
                                        </span>
                                          
                                      </span>
                                    </td>

                                        <!-- <span v-if="item.ad_type=='currency'">@{{item.rate+item.ad_amount}}</span>
                                        <span v-if="item.ad_type=='percent'">@{{(item.rate+(item.rate*item.ad_amount)/100)}}</span> -->
                              </tr>
                          </tbody>
                      </table>
                  </div>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('advancePricing.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">

  var inventory_category = {!! $inventory_category !!}
  var items = {!!$items!!}
  new Vue({
    el: '#app',
    data: {
      category:inventory_category,
      items:items,
      amount:0,
      selected_type:'percent',
      selectedAll:false,
      selected_advance_pricing_type:'up',
      selected_pricing_type:'add_new_price'

    },
    methods:
    {
      changeCategory(e)
      {
        var value=e.event.target.value;
        for(var i=0;i<this.items.length;i++)
        { 
           this.items[i].selected=null;
           if(this.items[i].inventory_category_id==value)
           {
              this.items[i].selected=true;
           }
          //  console.log('kk', this.items[i].old_item_rate);
        }
      },
      toggleCheck(index)
      {
        this.items[index].selected=!this.items[index].selected;
      },
      changeType()
      {
        // console.log('test 22',this.selected_type);
      },
      amountChange()
      {
        console.log('ssss');
      },
      selectAll(e)
      {
        
         for(var i=0;i<this.items.length;i++)
        { 
           if(this.selectedAll==true)
           {
             this.items[i].selected=true;
           }
           else
           {
               this.items[i].selected=false;
           }
         
        }
      }
    },
    created:function()
    {
        console.log('test 22',this.record);
    }

  });

</script>


@endpush