@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense_detail');
$_name=in_array('name', $report);
$_symbol=in_array('symbol', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_total=in_array('total', $report);
$_otherCost=in_array('otherCost', $report);

?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseDetail')</h3>
<table class="main-table">

<thead>
  <tr class="bg">
 <td><div class="center"> @lang('layout.Record')</div></td>

 <td><div class="center"> @lang('layout.Type')</div></td>
 <td><div class="center"> @lang('layout.TypeNumber')</div></td>
 <td><div class="center"> @lang('layout.Number')</div></td>
 <td><div class="center"> @lang('layout.Date')</div></td>
 <td><div class="center"> @lang('layout.Description')</div></td>
 <td><div class="center"> @lang('layout.Category')</div></td>
 <td><div class="center"> @lang('layout.ItemName')</div></td>
  <td><div class="center"> @lang('layout.Measure')</div></td>
 <td><div class="center"> @lang('layout.Quantity')</div></td>
 @foreach($itemExpenseCategory AS $rec)
<td><div class="center"> {{$rec->name}}</div></td>
 @endforeach
 @if($_total)<td><div class="center"> @lang('layout.Currency')</div></td>@endif
 @if($_total)<td><div class="center"> @lang('layout.Rate')</div></td>@endif
 @if($_total)<td><div class="center"> @lang('layout.Total')</div></td>@endif
 @if($_total)<td><div class="center"> @lang('layout.Total') {{Currency()->symbol}}</div></td>@endif


</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
$per_category=[];

?>
@foreach($data AS $record)

@if(is_array($record['expense_category_data']))
 
   @foreach($record['expense_category_data'][0] AS $rec)
    <?php
      $sub_total=0;
    ?>
    <tr>
    <td class="center">{{++$count}}</td>
    <td  class="center">{{__('layout.'.ucfirst($record['type']))}}</td>
    <td  class="center">{{$record['type_number']}}</td>
    <td  class="center">{{$record['number']}}</td>
    <td  class="center">{{convertDate($record['date'])}}</td>
    <td  class="center">{{$record['description']}}</td>
    <td  class="center">{{__('layout.'.ucfirst($rec['items']['category']))}}</td>
    <td  class="center">{{$rec['items']['name']}}</td>
    <td  class="center">{{$rec['items']['measure']}}</td>

    <td class="center">{{$rec['items']['qut_in']}}</td>

    @if(is_array($rec['itemExpenseCategory']))
       @foreach($rec['itemExpenseCategory'] AS $cat)
       
       <?php
       $t=$cat['amount'];
       if($rec['items']['category']=='perUnit')
       {
          $t=$t*$rec['items']['qut_in'];
       }
       else
       {
          $t=$t;
       }
       $sub_total+=$t;


        

       $total_home_currency+=$t/$record['rate'];

       if(array_key_exists($cat['name'], $per_category) && $t>0)
       {
        $per_category[$cat['name']]=$per_category[$cat['name']]+$t/$record['rate'];
      }
      else
      {
        if($t>0)
        {
          $per_category[$cat['name']]=$t/$record['rate'];
        }
      }

       ?>
        <td><div class="center"> {{$cat['amount']}}</div></td>
       @endforeach
    @endif  
    @if($_total)<td class="center">{{$record['currency']}}</td>@endif
    @if($_total)<td class="center">{{$record['rate']}}</td>@endif
    @if($_total)<td class="center">{{Currency()->format($sub_total,$record['currency'])}}</td>@endif
    @if($_total)<td class="center">{{Currency()->format($sub_total/$record['rate'],getHomeCurrency()["code"])}}</td>@endif


    </tr>
   @endforeach

@endif

@endforeach  
</table>

<table class="main-table">
<thead>
  <tr>
  <th>@lang('layout.Name')</th>
  <th>@lang('layout.Amount')</th>
</tr>
</thead>
<tbody>
  @foreach($per_category AS $key=>$value)
  <tr>

    <td>{{$key}}</td>
    <td>{{Currency()->format($value,getHomeCurrency()["code"])}}{{getHomeCurrency()["code"]}}</td>
  </tr>
  @endforeach

</tbody>

</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection
