@extends('layouts.app')

@section('content')



    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'item_expensePrice'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                                <label class="control-label ">@lang('layout.Type') </label>
                                <select name="report_type" class="form-control">
									<option value="simple" selected>@lang('layout.Simple')</option>
									<option value="detail">@lang('layout.Details')</option>
                                </select>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off"
                                               name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off"
                                               name="to_date">

                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.AdvancePricingList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('advansePricing-export')

                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>

                    @endpermission
                    @permission('advansePricing-create')
                    <a href="{{route('advancePricingCode.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="itemExpense">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);

        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#itemExpense').DataTable({
                ajax: '{{route("advancePricingCode.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [[ 0, "{{getRowOrder()}}" ]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'number', name: 'item_expenses.number'},
                    {data: 'type', name: 'item_expenses.type', orderable: false, searchable: false},
                    {data: 'date', name: 'item_expenses.date', searchable: false},
                    {data: 'description', name: 'item_expenses.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush
