@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense_detail');
$_name=in_array('name', $report);
$_symbol=in_array('symbol', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_total=in_array('total', $report);
$_otherCost=in_array('otherCost', $report);

?>
<h3>
</h3>
<table class="main-table">
 @if($info && $info !=[])
 <tr>
  <td>
    <span>@lang('layout.Number')</span>:
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Type')</span>:
    <span>{{__('layout.'.ucfirst($info->type))}}</span>
  </td>
<td>
    <span>@lang('layout.Date')</span>:
    <span>{{convertDate($info->date)}}</span>
  </td>

 <td>
  <span>@lang('layout.Amount')</span>:
  <span>{{$info->total}}</span>
</td>
 <td>
  <span>@lang('layout.Currency')</span>:
  <span>{{$info->currency}}</span>
</td>
 <td>
  <span>@lang('layout.Description')</span>:
  <span>{{$info->description}}</span>
</td>

</tr>
@endif
</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.AdvancePricingShow')</h3>


<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" ><div > @lang('layout.Record')</div></td>

 <td class="center" ><div > @lang('layout.ItemName')</div></td>
  <td class="center" ><div > @lang('layout.Measure')</div></td>
 <td class="center" ><div > @lang('layout.Quantity')</div></td>
 <td class="center" ><div > @lang('layout.Category')</div></td>
 @if($_total)<td class="center" ><div > @lang('layout.Amount')</div></td>@endif
 @if($_total)<td class="center" ><div > @lang('layout.Total')</div></td>@endif
 <td class="center" ><div > @lang('layout.User')</div></td>


</tr>
</thead>
<?php
$count = 0;
$total = 0;
?>
@foreach($data AS $record)
<?php
$total_r = 0;
$cost = 0;
$currency = $record->currency;
if($record->category == 'total'){
	$total += $record->total;
	$total_r = $record->total;
	$cost = ($record->total / $record->quantity);
}else{
	$total += ($record->total * $record->quantity);
	$total_r = ($record->total * $record->quantity);
	$cost = $record->total;
}
?>
<tr>
<td class="center">{{++$count}}</td>
<td  class="center">{{$record->item_name}}</td>
<td  class="center">{{$record->measure_name}}</td>
<td  class="center">{{$record->quantity}}</td>
<td  class="center">{{__('layout.'.ucfirst($record->category))}}</td>
@if($_total)<td class="center">{{myRound($cost)}}</td>@endif
@if($_total)<td class="center">{{myRound($total_r)}}</td>@endif
<td class="center">{{$record->user}}</td>


</tr>
@endforeach  
</table>

<br/>

<table class="main-table">

<thead>
  <tr class="bg">
 @if($total)<td><div class="center"> @lang('layout.Total')</div></td>
 <td><div class="center">{{myRound($total)}}   {{$currency}}</div></td>@endif
</tr>
</thead>
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection