@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop
@section('content')
@include('inventories.cmodal')  

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('layout.AdvancePricingCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>
            <div id="itemexpense" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'advancePricingCode.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class=" col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Type')</label>
                                    <select name="type" class="form-control" v-model="selected_type">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="expiared" selected>@lang('layout.ExpiarModelItem')</option>
                                        <option value="all">@lang('layout.All')</option>
                                    </select>
                                </div>

                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Category')</label>
									
									<v-select label="name" v-model="selected_item_category"
											  :options="inventoryCategory"
											  @input="itemCategoryChange()"></v-select>
									<input type="hidden" name="inventory_category_id" :value="(!selected_item_category)?null:selected_item_category.id">
                                                        
                                </div>
								
                                <div class="col-md-4">  
                                    <label class="control-label ">@lang('layout.ItemName')</label>
									<v-select label="name" v-model="selectedItem" :options="temps_items" @search="onItemSearch" @input="numberChange"></v-select>
									<input type="hidden" id="item_id" name="inventory_id" :value="(!selectedItem)?null:selectedItem.id"> 
                                </div>
								
                                <div class="col-md-2" v-if="selected_type!=null && selected_type!=''">
                                    <br>
                                    <button type="button" @click="searchType" class="btn btn-info"><i
                                                class="fa fa-search"></i>@lang('layout.Search')</button>
                                </div>
                            </div>
                            <!-- div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.CostType')</label>
                                    <select name="cost_type" class="form-control" v-model="selected_cost_type">
                                        <option value="posting">@lang('layout.Posting')</option>
                                    </select>


                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="currency"
                                              v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>

                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Rate')</label>

                                    <input type="number" name="currency_rate" name="rate"
                                           v-model="!selected_currency?0:selected_currency.rate" class="form-control"
                                           :class="{'has-error':rate<=0}">
                                </div>

                            </div -->
                            <!-- div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ExpenseType')</label>

                                            <select name="expense_type" v-model="selected_expense_type"
                                                    class="form-control">
                                                <option value="writeCheck">@lang('layout.Writecheck')</option>
                                                <option value="bill">@lang('layout.Bill')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Vendor')</label>

                                            <v-select label="name" :options="vendor"
                                                      v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="vendor"
                                                   :value="!selected_vendor?null:selected_vendor.id" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-if="selected_expense_type!='bill'">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>

                                            <v-select label="name" :options="approperiateBank"
                                                      v-model="selected_banks"></v-select>
                                            <input type="hidden" name="bank_account"
                                                   :value="(this.selected_banks==null)?null:selected_banks.id">
                                        </div>
                                    </div>
                                </div>
                            </div -->
                            <div class="row">
                                <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-10">
                                            <label class="control-label">@lang('layout.ExpenseCategory')</label>

                                            <v-select label="name" :options="expenseCategory"
                                                      v-model="selected_category"></v-select>
                                            <input type="hidden" name="expense_category_id"
                                                   :value="(this.selected_category==null)?null:selected_category.id">
                                        </div>
                                          <div class="col-md-2">
                                            <label class="control-label"></label>

                                             <button class="btn green" type=button id="show-cmodal"
                                             @click="showcModal = true">
                                             <i class="fa fa-plus"></i>
                                         </button>
                                        </div>
                                    </div>
                                </div -->
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>

                                            <input type="text" name="date" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>

                        <!-- bgin pay -->
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">


                                    <!-- tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                        <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>@lang('layout.Sub-Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ (Total-payeds).toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr -->
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ Total.toFixed(precision())}}</span>
                                            <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                        </td>
                                    </tr>
                                </table>

                            </div>

                            <!-- end total -->
                        </div>
                        <!-- end pay -->
                    </div>
                    <br>
                    <!-- begin items -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>@lang('layout.ItemName') </th>
                                <th>@lang('layout.Code') </th>
                                <th>@lang('layout.SiteName') </th>
                                <th>@lang('layout.Quantity') </th>
                                <th>@lang('layout.Measure') </th>

                                <th>@lang('layout.PurchaseCost') </th>

                                <th style="min-width: 100px">@lang('layout.ExpireDate') </th>
                                <th style="min-width: 100px">@lang('layout.Category') </th>
                                <th style="min-width: 100px"> @lang('layout.Amount')  </th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <input type="hidden" name="stock_id[]" :value="(!item.item)?null:item.item.stock_id">
                                <input type="hidden" name="item_inventory_id[]" :value="(!item.item)?null:item.item.inventory_id">
                                <input type="hidden" name="quantity[]" :value="(!item.item)?null:item.item.qut_in">
                                <td>@{{index+1}}</td>
                                <td>@{{(!item.item)?null:item.item.name}}</td>
                                <td>@{{(!item.item)?null:item.item.code}}</td>
                                <td>@{{(!item.item)?null:item.item.site_name}}</td>
                                <td>@{{(!item.item)?null:item.item.qut_in}}</td>
                                <td>@{{(!item.item)?null:item.item.measure}}</td>
                                <td>@{{myRound((!item.item)?null:item.item.cost)}}</td>
                                <td>
								<date_picker :name="'expire_date['+index+']'" v-model="(!item.item)?null:item.item.expire_date" placeholder="@lang('layout.ExpireDate')" ></date_picker>
								<input type="hidden" :name="'last_expire_date['+index+']'" :value="(!item.item)?null:item.item.last_expire_date">
								</td>
                                
                                <td>
                                    <select name="category[]" v-model="(!item.item)?null:item.item.category" class="form-control">
                                        <option value="total">@lang('layout.Total')</option>
                                        <option value="perUnit">@lang('layout.PerUnit')</option>
                                    </select>
                                    <input type="hidden" name="types[]" :value="(!item.item)?null:item.item.type">
                                </td>
								<td>
                                        <input type="number" class="form-control" v-model="(!item.item)?null:item.item.amount"
                                                :name="'item_amount['+index+']'" >
                                    </td>
                                <td>@{{myRound(itemExpenseTotal(index))}}</td>
								<td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>

                    </div>
                    <!-- end items -->

                    <div v-show="selected_expense_type=='bill'">
                        <hr>
                        <!-- begin payments -->
                        <!--table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" name="payment_id[]"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                 
                                      <span v-if="payment.item !=null">
                                         @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                           v-bind:value="payment.item.rate">
                                </td>
                                <td>
                                    <input type="text" name="payment_currency[]" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate).result"
                                               placeholder="@lang('layout.Total')" style="min-width: 100px" required/>
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table -->
                        <!-- end payments -->

                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" v-if="!isError"
                                onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('itemExpense.index')}}" class="btn default"><i
                                    class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>
                </div>


                {!! Form::close() !!}

                <!--Begin Modal -->
                {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                    {{ csrf_field() }}                                        
                    <cmodal :show="showcModal" @close="showcModal = false">
                        <h3 slot='cheader'>@lang('layout.CreateNewExpenseCategory')</h3>
                        <div slot="cbody">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description")</label>
                                            <textarea class="form-control" name="description" v-model="description">
                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <div slot="cfooter">
                            <button type="button" class="modal-default-button btn btn-success" @click="addExpenseCategory">
                                @lang('layout.Submit')
                            </button>
                        </div>
                    </cmodal>
                    {!! Form::close() !!}
                    <!--End Modal-->

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script type="text/javascript">
	

	
	
	
        Vue.component('v-select', VueSelect.VueSelect);

            var Modal = Vue.component('cmodal',
                {
                    template:'#cmodal-template',
                    props: ['show'],
                });

        var currency = {!! $currency !!};
        var banks = {!! $banks !!};
        var vendor = {!! $vendor !!};
        var expenseCategory = {!! $expenseCategory !!};
        var inventoryCategory = {!! $inventoryCategory !!};
        var vm = new Vue({
            el: '#itemexpense',
            data: {
                selected_type: 'expiared',
                selected_cost_type: 'posting',
                inventories: [],
                typeInfo: null,
                selected_expense_type: 'writeCheck',
                currency: currency,
                selected_currency: defaultCurrency(),
                banks: banks,
                vendor: vendor,
                date: 'date',
                selected_vendor: null,
                selected_banks: null,
                rate: 0,
                payments: [
                    {
                        items: banks,
                        item: null,
                    }
                ],
                inventoryCategory: inventoryCategory,
                selected_item_category: null,
				selectedItem: null,
                temps_items: null,
                expenseCategory: expenseCategory,
                selected_category: null,

                showcModal: false,
                errorMessage: '',
                fieldErrors: [],
                className: null,
                description: null,
                itemExpenseCategory:[]


            },
            computed: {
                isError: function () {
                    var isError = false;
                    var flag=false;
                       if (this.inventories.length < 1)
                       {
						   isError = true;
					   }
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {
						   // if (this.inventories[i].item)
                       // {
                         // flag=true;
                         // if(((this.inventories[i]['item']['rate'] <=0) ))
                         // {
                           // rate=this.inventories[i]['item']['rate'];
                           // new_rate=this.inventories[i]['item']['new_rate'];
                           // if(rate <=0 && new_rate <=0)
                           // {
                                // isError = true;
                           // }

                         // }
                       // }
                    // }
                    // if (this.selected_vendor == null) {
                        // isError = true;
                    // }
                    return isError;


                },
                Total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {

						if (this.inventories[i] && this.inventories[i] != null) {
						if (this.inventories[i].item != null && this.inventories[i].item.amount != null ) {
							var amount = 0;
							
							// var rate = (this.selected_currency) ? this.selected_currency.rate : 1;
							// var cost = this.inventories[i].item.cost * rate;
							
							if(this.inventories[i].item.category=='total')
							{
								amount=Number.parseFloat(this.inventories[i].item.amount)/Number.parseFloat(this.inventories[i].item.qut_in);
							}
							else
							{
								amount=(this.inventories[i].item.amount)*Number.parseFloat(this.inventories[i].item.qut_in);
							}
						
							sum+= Number.parseFloat(amount);
				 
                        }
                        }
						
                    }
                    return sum;

                },


                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },

                
                payeds: function () {

                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    this.selected_banks=null;
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            methods: {
                    //Function to add MemberCLass
                addExpenseCategory:function(){
                    axios.post("{{route('expenseCategory.store')}}",{
                        name:vm.className,
                        description:vm.description
                    })
                    .then(function(response){
                        
                        // location.reload();

                          var data = {id: response.data.id,name: response.data.name};
                        // vu.categories = response.data;
                        axios.get("{{route('expenseCategory.create')}}").then(function (response) {
                            
                            vm.className = null;
                             vm.description = null;
                            vm.expenseCategory     = response.data;
                        });


                    });
                    vm.showcModal = false;
                },

                numberChange() {
                    this.inventories = [];
                },
				itemCategoryChange() {
                        
                        if (vm.selected_item_category != null) {
							this.inventories = [];
                            let inventory_category_id = vm.selected_item_category.id;
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchSaleRoll',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
									vm.temps_items = [];
									if (response.data.length > 0) {
										vm.selectedItem = null;
										vm.temps_items = response.data;
										// console.log('pp',response.data);
									}
									loading(false);
								})
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },
					
					//ajax call to get items
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
						let inventory_category_id = (vm.selected_item_category != null) ? vm.selected_item_category.id : '';
                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    method_name: 'itemSearchSaleRoll',
                                    keyword: search,
									inventory_category_id: inventory_category_id,
                                },
                            })
                            .then(function (response) {
                                vm.temps_items = [];
                                if (response.data.length > 0) {
                                    vm.temps_items = response.data;
                                    console.log('pp',response.data);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
							

                    }, getDebounceTime()),

                    // end item search
				
                // search stock based on type purchase/build/opening
                searchType() {
					
					let inventory_category_id = (vm.selected_item_category != null) ? vm.selected_item_category.id : '';
					let selectedItem_id = (vm.selectedItem != null) ? vm.selectedItem.id : '';
                          
                    this.inventories = [];
                    if (selectedItem_id || inventory_category_id) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemExpenseSearchCode',
                                type: this.selected_type,
                                inventory_id: selectedItem_id,
                                category_id: inventory_category_id,
                            }
                        })
                            .then(function (response) {

                                if (response.data.length > 0) {
                                console.log('4321',response.data);

                                    if (response.data) {
                                        var myDataArray=response.data;
                                        for(var i=0;i<myDataArray.length;i++)
                                        {
                                           
                                            vm.inventories.push({item:myDataArray[i].myData});
                                        
                                        }


                                    }

                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }

                },
                // end search type


                // in here you can check and decide to allow duplicate bank for payment or not
                checkExistingPayment(index = null, name = '') {
                    var bank_temp = this.banks.slice();
                    var bank_temp1 = [];
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                            if (fined != -1) {
                                var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                            }
                        }
                    }
                    this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
                    //this.payments[index].items =bank_temp;


                },


                // generic function for adding item to list
                itemExpenseTotal(index) {
                    var sum = 0;
						if (this.inventories[index] && this.inventories[index] != null) {
						if (this.inventories[index].item != null && this.inventories[index].item.amount != null ) {
							var amount = 0;
							
							if(this.inventories[index].item.category=='total')
							{
								amount=Number.parseFloat(this.inventories[index].item.amount)/Number.parseFloat(this.inventories[index].item.qut_in);
							}
							else
							{
								amount=(this.inventories[index].item.amount)*Number.parseFloat(this.inventories[index].item.qut_in);
							}
						
							sum+= Number.parseFloat(amount);
				 
                        }
                        }
                    return sum;

                },

                // generic function for adding item to list
                addNew(type = null, index) {
                    this.temp_items = [];
                    if (type != null) {
                        // if (type == 'inventory') {
                            // if (this.inventories[index + 1] == undefined) {
                                // this.temp_items = [];
                                // this.inventories.push({item: null});
                            // }
                        // }
                        if (type == 'payment') {
                            if (this.payments[index + 1] == undefined) {
                                this.checkExistingPayment(index, '');
                                this.payments.push({
                                    items: this.banks,
                                    item: null,
                                });
                            }
                        }
                    }

                },

                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        console.log(type);
                        if (type == 'inventory') {
                            this.inventories.splice(index, 1);
                        }
                        if (type == 'payment') {
                            this.payments.splice(index, 1);
                        }
                    }

                },


            }
        });


    </script>
@endpush
 