@extends('layouts.app')
@section('style')
    <style>
     .modal-footer{
        border: 1px solid red !important;
        display: none;
     }
    </style>
@endsection
@section('content')
    @include('sales.modal')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="adjustmentRoll"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Category')</label>
                                                <v-select label="name" :options="category" v-model="selected_category"></v-select>
                                                <input type="hidden" name="category_id" :value="(!selected_category)?null:selected_category.id">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.GeneralAdjustmentReport')</label>
                                                <select class="form-control" name="general_report">
                                                    <option value="">@lang('layout.SelectType')</option>
                                                    <option value="details">@lang('layout.Details')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>     
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px;">
                                    <button type="submit" class="btn btn-success" @click="ok">
                                        @lang('layout.Submit')
                                    </button>
                                    <button type="button" class="btn btn-danger" @click="close">
                                        @lang('layout.Cancel')
                                    </button>
                                </div> 
                                {{Form::close()}}
                            </div>
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="adjustments_roll_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 15px !important;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>  
                                                </div>
                                            </div>
                                            <div class="margin-top-10">
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-top: 10px;">
                                    <button type="submit" class="btn btn-success" @click="ok">
                                        @lang('layout.Submit')
                                    </button>
                                    <button type="button" class="btn btn-danger" @click="close">
                                        @lang('layout.Cancel')
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </modal>
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="adjustmentRoll"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.Category')</label>
                            <v-select label="name" :options="category" v-model="selected_category"></v-select>
                            <input type="hidden" name="category_id" :value="(!selected_category)?null:selected_category.id">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.GeneralAdjustmentReport')</label>
                            <select class="form-control" name="general_report">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-top: 10px;">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success" @click="ok">
                            @lang('layout.Submit')
                        </button>
                        <button type="button" class="btn btn-danger" @click="close">
                            @lang('layout.Cancel')
                        </button>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.Adjustment')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('sales-export')
                    <button type="submit" id="excell_all" class="btn btn-success">
                        <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') 
                    </button>
                    <button type="button" class="btn btn-success" id="print_pdf_all">
                        <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') 
                    </button>
                    @endpermission
                    @permission('sales-create')
                    <a href="{{route('adjustment_roll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="adjustment">
                    <thead>
                        <tr>
                            <th>@lang('layout.ID')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.Category')</th>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- <div id="factor-obj" >
        @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>
        @endif
    </div> -->
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('adjustments_roll_index')!!};
        function factorPrint(id) {
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: "{{url('/')}}/salePrint/" + id,
                type: 'get',
                cache: false,
            }).done(function () {
                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
                $('#factor-obj').html(s);
                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
            .fail(function () {
                console.log("error");
            });
        }
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#adjustment').DataTable({
                ajax: '{{route("adjustment_roll.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'category', name: 'category'},
                    {data: 'name', name: 'name'},
                    {data: 'dates', name: 'dates'},
                    {data: 'username', name: 'users.name',orderable:false,searchable:false},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderable:false, searchable:false}

                ]
            });
            $('#btnPrint').click(function () {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,
                }).done(function () {
                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
                    $('#factor-obj').html(s);
                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                .fail(function () {
                    console.log("error");
                });
                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,
                }).done(function () {
                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
                    $('#factor-obj').html(s);
                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                .fail(function () {
                    console.log("error");
                });
            });
        });
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedMember: null,
                category: {!! $category  !!},
                selected_category: null,
                member: null,
                customReportData:[
                    {Name: '@lang("layout.ID")', column_name: 'adjustmentId',checkedColumn:(cust_rep.adjustmentId)?'checked':'',checkedColumn:(cust_rep.adjustmentId)?'checked':'',column_percentage:(cust_rep.adjustmentId___percent)?cust_rep.adjustmentId___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                    {Name: '@lang("layout.ReferenceNumber")', column_name: 'referenceNumber',checkedColumn:(cust_rep.referenceNumber)?'checked':'',checkedColumn:(cust_rep.referenceNumber)?'checked':'',column_percentage:(cust_rep.referenceNumber___percent)?cust_rep.referenceNumber___percent:''},
                    {Name: '@lang("layout.ChannelType")', column_name: 'channelType',checkedColumn:(cust_rep.channelType)?'checked':'',checkedColumn:(cust_rep.channelType)?'checked':'',column_percentage:(cust_rep.channelType___percent)?cust_rep.channelType___percent:''},
                    {Name: '@lang("layout.TotalAmount")', column_name: 'totalAmount',checkedColumn:(cust_rep.totalAmount)?'checked':'',checkedColumn:(cust_rep.totalAmount)?'checked':'',column_percentage:(cust_rep.totalAmount___percent)?cust_rep.totalAmount___percent:''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},

                    {Name: '@lang("layout.ItemName")', column_name: 'itemName',checkedColumn:(cust_rep.itemName)?'checked':'',checkedColumn:(cust_rep.itemName)?'checked':'',column_percentage:(cust_rep.itemName___percent)?cust_rep.itemName___percent:''},
                    {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                    {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                    {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                    {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                    {Name: '@lang("layout.OMeasureValue1")', column_name: 'oMeasureValue1',checkedColumn:(cust_rep.oMeasureValue1)?'checked':'',checkedColumn:(cust_rep.oMeasureValue1)?'checked':'',column_percentage:(cust_rep.oMeasureValue1___percent)?cust_rep.oMeasureValue1___percent:''},
                    {Name: '@lang("layout.OMeasureValue2")', column_name: 'oMeasureValue2',checkedColumn:(cust_rep.oMeasureValue2)?'checked':'',checkedColumn:(cust_rep.oMeasureValue2)?'checked':'',column_percentage:(cust_rep.oMeasureValue2___percent)?cust_rep.oMeasureValue2___percent:''},
                    {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
                    this.member ={!!$member!!}
                        //Your other code that launches the modal
                        this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        Vue.component('v-select', VueSelect.VueSelect)
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedMember: null,
                category: {!! $category  !!},
                selected_category: null,
                member: null,
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
                    this.member ={!!$member!!}
                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker({
                                altField: '#range-to-example-alt2',
                                altFormat: 'u',
                                initialValue: false,
                                observer: true,
                                format: 'YYYY/MM/DD',
                                autoClose: true,

                            });
                            from = $("#range-from-example2").persianDatepicker({
                                altField: '#range-from-example-alt2',
                                altFormat: 'u',
                                initialValue: false,
                                observer: true,
                                format: 'YYYY/MM/DD',
                                autoClose: true,

                            });
                        });
                    })
                }
            },
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>
@endpush