@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")

<div class="row">

  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewAdjustment') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>



    <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <!-- begin sale order modal -->

      <!-- end sale order modal -->

      <!-- BEGIN FORM-->
      {{Form::model($adjustment,['route' => ['adjustment_roll.update',$adjustment->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
            <!-- begin inputs -->
            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                    {{Form::number('ref_no',null,['class' => 'form-control' ,'step' => 'any','min' =>'0'])}}
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Date')</label>
                    {{Form::text('date',null,['class' => 'form-control date' ,'step' => 'any','min' =>'0','autocomplete'=>'off'])}}
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Account')</label>
                    <v-select label="name" v-model="selected_account" :options="accounts"></v-select>
                    <input type="hidden" name="account_id" :value="(selected_account)?selected_account.id:null">
                  </div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                    <div class="col-md-12">
                      <label class="control-label">@lang('layout.Category')</label>
                      <v-select label="name" :options="adjustmentCategory" v-model="selected_adjustment_category"></v-select>
                      <input type="hidden" name="category_id" :value="(!selected_adjustment_category)?null:selected_adjustment_category.id">
                    </div>
                </div>
              </div>
              <div class="col-lg-8 col-md-9 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Description')</label>
                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1)) !!}
                  </div>
                </div>
              </div>
            </div>
            <!-- end inputs -->
          </div>
          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
            <!-- begin total -->
            <div class="dashboard-stat2 ">
              <table class="dashboard-tabel" width="100%">
                @if(\Entrust::can('cost-create'))
                <tr>
                  <td>
                    <small>@lang('layout.Total') :</small>
                  </td>
                  <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                  </td>
                </tr>
                @endif
              </table>
            </div>
          </div>
        </div>


        <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
          <table id="table_content" class="table table-bordered table-responsive table-full-width .met">
            <thead>
              <tr>
                <th class="text-center" style="min-width: 8px;"> # </th>
                <th class="text-center" style="min-width: 150px;"> @lang('layout.ItemName')</th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.Code')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.Measure')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.Westage')</th>
                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Length')</th>
                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                <th class="text-center" style="min-width: 40px;"> @lang('layout.Width')</th>
                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                @if(getShowWing()!="false")
                <th style="min-width: 50px">@lang('layout.Wing') </th>
                @endif
                <th v-show="{{\Entrust::can('cost-create')}}" class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                <th v-show="{{\Entrust::can('cost-create')}}" class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                <th class="text-center" style="width: 10px;"></th>
              </tr>
            </thead>
            <tbody>
              <!--/row-->
              <tr v-for="(service,index) in inventories">
                <td>@{{index+1}}</td>
                <td>
                  <v-select label="name" v-model="service.selected_sub_item_name" :options="FormilaItemsName" @search="onItemSearchName" @click.native="change_name(index), addNew('inventory',index)" placeholder="@lang('layout.Name')" style=""></v-select>
                </td>
                <td>
                  <v-select label="name" v-model="service.item" :options="temp_itemes" @search="onItemSearchFormila" @click.native="addNew('inventory',index)" placeholder="@lang('layout.Code')" style=""></v-select>
                  <input type="hidden" id="item_id" name="m_stocks_in_id[]" :value="(!service.item)?null:service.item.id">
                  <input type="hidden" name="main_stock_id[]" :value="(!service.item)?null:service.item.main_stock_id">
                  <input type="hidden" name="item[]" :value="(!service.item)?null:service.item.items_id">
                  <input type="hidden" name="inventory_id_out[]" :value="(!service.item)?null:service.item.inventory_id">
                  <input type="hidden" name="inventory_site_id[]" :value="(!service.item)?null:service.item.inventory_site_id">
                </td>
                <td class="highlight">
                    <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChange(index)">
                        <option value="null">@lang('layout.Select')</option>
                        <span v-if="(service.item ==null)?false:true">
                            <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                @{{measure.measure_name}}
                            </option>
                        </span>
                    </select>
                    <input type="hidden" name="inventory_measure[]" :value="(!service.item)?null:service.item.measure.measure_id">
                </td>
                <td>
                  <input name="quantity[]" id="item_quantity" ref="OnHand" type="number" @input="change_qut(index)" :value="(!service.item)?null:service.item.OnHand" class="form-control" placeholder="@lang('layout.Quantity')">
                </td>
                <td>
                  <input name="lengths_out" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.item)?null:service.item.lengths" class="form-control" placeholder="@lang('layout.Length')">
                </td>

                <td>
                  @{{myRound((service.item==null)?null:OnhandQuantity(service.item, service.item.OnHand))}}
                  <input type="hidden" name="quantityall[]" readonly :value="(!service.item)?null:service.item.qut_temp" placeholder="@lang('layout.OnHand')" class='form-control'>
                </td>
                <td>
                  <input type="number" readonly :value="(!service.item)?null:service.item.widths" class="form-control" placeholder="@lang('layout.Width')">
                </td>
                <td v-show="showWhat('other_measure')=='yes'">
                    <div class="input-group">
                        <input type="number" name="other_measure[]"
                        class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(service.item==null)?null:service.item.o_measure">
                        <span class="input-group-addon">
                            @{{myRound((service.item==null)?null:service.item.other_measure)}}
                        </span>
                    </div>
                </td>
                <td v-show="showWhat('other_measure2')=='yes'">
                    <div class="input-group">
                        <input type="number" name="other_measure2[]" 
                        class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(service.item==null)?null:service.item.o_measure2">
                        <span class="input-group-addon">
                            @{{myRound((service.item==null)?null:service.item.other_measure2)}}
                        </span>
                    </div>
                </td>
                @if(getShowWing()!="false")
                <td>
                    <input :name="'khada['+index+']'" type="number" :value="(service.item==null)?null:service.item.khada" ref="khada" @input="setNewRate(index)"
                    oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                </td>
                @endif
                <td v-show="{{\Entrust::can('cost-create')}}">
                  <input name="cost[]" type="number" readonly :value="(!service.item)?null:service.item.per_price" ref="per_price" @input="setNewRate(index)" class="form-control" placeholder="@lang('layout.Price')">
                </td>

                <td v-show="{{\Entrust::can('cost-create')}}">
                  <input type="number" class="form-control inner_input" :value="(service.item==null)?null:(service.item.per_price)*((service.item==null)?null:service.item.OnHand)" placeholder="@lang('layout.Total')" disabled>
                </td>
                <td>
                  <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                </td>

              </tr>

            </tbody>
          </table>

          <hr>
          <!-- begin service -->

          <!-- end service -->
          <hr>
          <!-- begin payments -->

          <!-- end payments -->
        </div>
        <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addItems('adjustment')">@lang('layout.AddItem')
        </button>
        <div class="row">
          <div class="col-md-offset-3 col-md-9">
            <button v-if="!isError" type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
            <a href="{{route('adjustment_roll.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

          </div>
        </div>


      </div>

      {!! Form::close() !!}

    </div>
    <!-- END FORM-->
  </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
  Vue.component('v-select', VueSelect.VueSelect);

  var accounts = {!! $accounts !!};
  var adjustmentCategory = {!! $adjustmentCategory !!};
  var selected_item = {!!$selectedItems!!};
  var adjustment = {!!$adjustment!!};

  // end new member

  var v = new Vue({
    el: '#appInvoice',
    data: {
      temp_items: [],
      temp_itemes: [],
      adjustment: adjustment,
      FormilaItemsName: [],
      accounts: accounts,
      selected_account: null,
      selected_index: null,
      adjustmentCategory: adjustmentCategory,
      selected_adjustment_category: null,
      selected_item: selected_item,
      newCost: [
        null,
        null,
        null,
        null
      ],
      inventories: [],

    },
    computed: {


      // calculate subtotal
      subtotal: function() {
        var sum = 0;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item && this.inventories[i].item != null) {
            var quantity = this.inventories[i]['item']['OnHand'];
            var rate = this.inventories[i]['item']['per_price'];
            var new_rate = this.inventories[i]['item']['per_price'];
            // var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
            // var measure_unit=this.inventories[i]['item']['measure_unit'];
            if (new_rate != rate && quantity > 0) {
              sum += new_rate * quantity;
            } else {
              sum += new_rate * quantity;
              // sum +=quantity*((rate*smeasure_unit/measure_unit));
            }

          }

        }
        return sum;
      },

      // check payed amount

      // check data validation
      isError: function() {
        var isError = false;
        var flag = false;
        for (var i = 0; i < this.inventories.length; i++) {

          if (this.inventories[i].item) {
            flag = true;
            if (((this.inventories[i]['item']['per_price'] <= 0))) {
              rate = this.inventories[i]['item']['per_price'];
              new_rate = this.inventories[i]['item']['per_price'];
              if (rate <= 0 && new_rate <= 0) {
                isError = true;
              }
            }
          }
        }
        if (this.inventories.length == 0 || flag == false) {
          isError = true;
        }
        return isError;


      },
    },

    mounted: function() {
      // initialize the selected item
      for (var i = 0; i < this.selected_item.length; i++) {
        // console.log('ssssssss', this.selected_item[i]);
        this.inventories.push({
          item: this.selected_item[i],
          selected_sub_item_name: this.selected_item[i].main_item
        });

      }
      for (var m = 4; m > this.selected_item.length; m--) {
        this.inventories.push({
          item: null,
          selected_sub_item_name: null
        });
      }

      this.selected_account = _.find(this.accounts, (a) => a.id == this.adjustment.account_id);
      this.selected_adjustment_category = _.find(this.adjustmentCategory, (a) => a.id == this.adjustment.category_id);

    },

    methods: {
      // set new price
      setNewRate(index) {
        if (this.inventories[index].item) {
          this.inventories[index].item.per_price = this.$refs.per_price[index].value;
          this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          this.inventories[index].item.OnHand = this.$refs.OnHand[index].value;

          @if(getShowWing()!="false")
            this.inventories[index].item.khada = this.$refs.khada[index].value;
          @endif

        }

      },
      // calculate item price based on measure change
      measureChange(index) {

        if (this.inventories[index].item != null) {
          var item = this.inventories[index].item;
          // console.log(123, this.inventories[index].item);
          var temp = ((item.expenseCost * item.measure.measure_unit / item.measure_unit));
          result = Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.per_price = result;

          // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

        }
      },

      change_lengths(index) {
        if (this.inventories[index].item) {
          var per_qut_in = this.inventories[index].item.per_qut_in;
          var lengths = this.$refs.lengths[index].value;
          this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          // this.inventories[index].item.OnHand = (per_qut_in * lengths).toFixed(1);
        }
        // setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
      change_qut(index) {

        if (this.inventories[index].item) {
          var per_qut_in = this.inventories[index].item.per_qut_in;
          // console.log('dd', per_qut_in);
          var OnHand = this.$refs.OnHand[index].value;
          this.inventories[index].item.OnHand = this.$refs.OnHand[index].value;
          // this.inventories[index].item.lengths = (OnHand / per_qut_in).toFixed(1);
        }

        // setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
      // calculate item price based on measure change

      // detect member change and searh

      OnhandQuantity(item = null, quantity = null, edit_quantity = null) {
          if (item != null) {
              var result = 0;
              if (item.qut_temp) {
                  result = (item.qut_temp * item.measure_unit) / (item.measure.measure_unit) - quantity;
                  // console.log(123, (item.site.OnHand * item.measure_unit) / (item.measure.measure_unit), quantity);
              }
              if (edit_quantity != null) {
                  result += Number(edit_quantity);
              }
              return result;
          }
      },

      //ajax call to get items
      onItemSearch: _.debounce((search, loading) => {
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'itemSearchSale',
              keyword: search,
            }
          })
          .then(function(response) {
            v.temp_items = [];
            if (response.data.length > 0) {
              v.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),

      addItems(type) {
        if (type != null) {
          if (type == "adjustment") {
            this.temp_items = [];
            this.inventories.push({
              item: null,
              selected_sub_item_name: null
            });
          }

        }

      },

      // end item search

      // contract search

      //ajax call to get items code
      onItemSearchFormila: _.debounce((search, loading) => {
        if (v.inventories[v.selected_index].selected_sub_item_name) {
          item_id = v.inventories[v.selected_index].selected_sub_item_name.items_id;
          loading(true);
          axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'assemblySubList',
              keyword: search,
              item_id: item_id,
            }
          })
          .then(function(response) {
            if (response.data.length > 0) {
              v.temp_itemes = [];
              v.temp_items[v.selected_index] = [];
              v.temp_items[v.selected_index] = response.data;
              v.temp_itemes = response.data;
              // console.log('temp_items', v.temp_items[v.selected_index]);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
        }
      }, getDebounceTime()),


        //ajax call to get items code
        onItemSearchName: _.debounce((search, loading) => {
        item_id = '';
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'assemblySubListName',
              keyword: search,
              item_id: item_id,
            }
          })
          .then(function(response) {
            v.FormilaItemsName = [];
            if (response.data.length > 0) {
              v.FormilaItemsName = response.data;
              // console.log('FormilaItemsName', v.FormilaItemsName);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),


      //ajax call to get items code
      change_name(index) {
        if (v.inventories[index].selected_sub_item_name) {
        this.selected_index = index;
        item_id = '';
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'assemblySubList',
              item_id: v.inventories[index].selected_sub_item_name.items_id,
            }
          })
          .then(function(response) {
            if (response.data.length > 0) {
              v.temp_items[index] = [];
              v.temp_items[index] = response.data;
              v.inventories[index].item = null;
              // console.log('temp_items', v.temp_items[index]);
            }
          })
          .catch(function(error) {
            console.log(error);
          });
        }
      },

      // end contract search

      // generic function for adding item to list
      addNew(type = null, index) {
        this.selected_index = index;
        this.temp_itemes = this.temp_items[index];
        // this.temp_items = [];
        if (type != null) {
          if (type == 'inventory') {
            if (this.inventories[index + 1] == undefined) {
              // this.temp_items = [];
              this.inventories.push({
                item: null,
                selected_sub_item_name: null
              });
            }
          }


        }

      },

      // in here you can check and decide to allow duplicate bank for payment or not


      // delete item from list
      deleteItem(type = null, index) {
        if (type != null) {
          console.log(type);
          if (type == 'inventory') {
            this.inventories.splice(index, 1);
          }

        }

      },
      // submit the form

    },


  });
</script>



@endpush