@extends('layouts.report')
@section('content')

<?php 
$reportTitle = __('layout.AdjustmentReport');
?>
@include('layouts.report-header')
<?php
$report=customeReport('adjustment','detail');
?>
<table  style="width: 100%; margin-bottom: 10px;">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.ReferenceNumber')</span>:
    <span>{{$info->ref_no}}</span>
  </td>
  <td>
    <span>@lang('layout.Description')</span>:
    <span>{{$info->description}}</span>
  </td>
</tr>
@endif
</table>


<table class="main-table">
<thead>
  <tr class="bg"> 
  <td><div class="center"> @lang('layout.Record')</div></td>  
  <td style="display: <?=(!show('item_name',$report))?'none':'';?>" class="center">@lang('layout.ItemName')</td>
  <td style="display: <?=(!show('site',$report))?'none':'';?>" class="center">@lang('layout.Site')</td>
  <td style="display: <?=(!show('measure',$report))?'none':'';?>" class="center">@lang('layout.MeasureUnit')</td>
  <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">@lang('layout.Quantity')</td>
  @if(getOtherMeasure()=="true")
  <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">@lang('layout.OMeasureValue') 1</td>
  <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">@lang('layout.OMeasureValue') 2</td>
  @endif
  <td style="display: <?=(!show('currency',$report))?'none':'';?>" class="center">@lang('layout.Currency')</td>
  <td style="display: <?=(!show('price',$report))?'none':'';?>" class="center">@lang('layout.Price')</td>
  <td style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">@lang('layout.TotalAmount')</td>
</tr>
</thead>
<?php
$count = 0;
$total=0;
?>
@foreach($data AS $record)
<?php
$total+=$record->cost*$record->quantity;
?>
<td class="center">{{++$count}}</td>
<td style="display: <?=(!show('item_name',$report))?'none':'';?>" class="center">{{$record->item}}</td>
<td style="display: <?=(!show('site',$report))?'none':'';?>" class="center">{{$record->site}}</td>
<td style="display: <?=(!show('measure',$report))?'none':'';?>" class="center">{{$record->measure}}</td>
<td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->quantity}}</td>
@if(getOtherMeasure()=="true")
<td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->other_measure}}</td>
<td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->other_measure2}}</td>
@endif
<td style="display: <?=(!show('currency',$report))?'none':'';?>" class="center">{{getHomeCurrency()['code']}}</td>
<td style="display: <?=(!show('price',$report))?'none':'';?>" class="center">{{round($record->cost,2)}}</td>
<td style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">{{$record->cost*$record->quantity}}</td>

</tr>
@endforeach
<tr>
  <td class="center">{{++$count}}</td>
  <td class="center" colspan="2">@lang('layout.Total')</td>
  <td class="center" colspan="5">{{$total}}&nbsp;{{getHomeCurrency()['code']}}</td>
</tr> 
</tbody>
</table>

<table>
  <tr>

  </tr>
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection