@extends('layouts.factor-master')
  <?php 
  $reportTitle = __('layout.AdjustmentReport');
  ?>
@section('content')
  <?php
  $report=customeReport('adjustment','index');
  ?>
  <?php 
      $report = customeReportNew('adjustments_roll_index');
      $_adjustmentId = !in_array('adjustmentId', $report);
      $_date = !in_array('date', $report);
      $_description = !in_array('description', $report);
      $_referenceNumber = !in_array('referenceNumber', $report);
      $_channelType = !in_array('channelType', $report);
      $_totalAmount = !in_array('totalAmount', $report);
      $_user = !in_array('user', $report);

      $report_percent = customeReportNewPercent('adjustments_roll_index');
      $_adjustmentId_percent= (array_key_exists('adjustmentId___percent', $report_percent))?$report_percent['adjustmentId___percent']:null;
      $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
      $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
      $_referenceNumber_percent= (array_key_exists('referenceNumber___percent', $report_percent))?$report_percent['referenceNumber___percent']:null;
      $_channelType_percent= (array_key_exists('channelType___percent', $report_percent))?$report_percent['channelType___percent']:null;
      $_totalAmount_percent= (array_key_exists('totalAmount___percent', $report_percent))?$report_percent['totalAmount___percent']:null;
      $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
  ?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.AdjustmentReport')</h3>
  <table class="main-table">
    <tr>
      @if($from_date)
      <td>
        <span>@lang('layout.FromDate')</span>:
        <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
      </td>
      @endif
      @if($to_date)
      <td>
        <span>@lang('layout.ToDate')</span>:
        <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
      </td>
      @endif
    </tr>
  </table>
  <br>
  <table class="main-table">
    <thead>
      <tr class="bg">
        @if($_adjustmentId)
        <td class="center" @if($_adjustmentId_percent) width="{{$_adjustmentId_percent}}%" @endif><div >@lang('layout.ID')</div></td>
        @endif
        @if($_date)
        <td @if($_date_percent) width="{{$_date_percent}}%" @endif style="display: <?=(!show('date',$report))?'none':'';?>" class="center">@lang('layout.Date')</td>
        @endif
        @if($_description)
        <td @if($_description_percent) width="{{$_description_percent}}%" @endif style="display: <?=(!show('description',$report))?'none':'';?>" class="center">@lang('layout.Description')</td>
        @endif
        @if($_referenceNumber)
        <td @if($_referenceNumber_percent) width="{{$_referenceNumber_percent}}%" @endif style="display: <?=(!show('reference_number',$report))?'none':'';?>" class="center">@lang('layout.ReferenceNumber')</td>
        @endif
        @if($_channelType)
        @if(!$categories_names)
        <td @if($_channelType_percent) width="{{$_channelType_percent}}%" @endif style="display: <?=(!show('account',$report))?'none':'';?>" class="center">@lang('layout.Category')</td>
        @endif
        @endif
        <!--  <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">@lang('layout.Account')</td> -->
        <!-- <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">@lang('layout.Quantity')</td> -->
        @if($_totalAmount)
        @if(\Entrust::can('cost-create'))
        <td @if($_totalAmount_percent) width="{{$_totalAmount_percent}}%" @endif style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">@lang('layout.TotalAmount')</td>
        @endif
        @endif
        @if($_user)
        <td @if($_user_percent) width="{{$_user_percent}}%" @endif class="center">@lang('layout.User')</td>
        @endif
      </tr>
    </thead> 
    <?php
      $count = 0;
    ?>
    @foreach($data AS $record) 
      <tr>
        <!-- <td class="center">{{++$count}}</td> -->
        @if($_adjustmentId)
        <td class="center">{{$record->id}}</td>
        @endif
        @if($_date)
        <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{convertDate($record->date)}}</td>
        @endif
        @if($_description)
        <td style="display: <?=(!show('description',$report))?'none':'';?>" class="center">{{$record->description}}</td>
        @endif
        @if($_referenceNumber)
        <td style="display: <?=(!show('reference_number',$report))?'none':'';?>" class="center">{{$record->ref_no}}</td>
        @endif
        @if($_channelType)
        @if(!$categories_names)
        <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->category}}</td>
        @endif
        @endif
        <!-- <td style="display: <?=(!show('account',$report))?'none':'';?>" class="center">{{$record->name}}</td> -->
        <!-- <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->quantity}}</td> -->
        @if($_totalAmount)
        @if(\Entrust::can('cost-create'))
        <td style="display: <?=(!show('total_amount',$report))?'none':'';?>" class="center">{{$record->total}}</td>
        @endif
        @endif
        @if($_user)
        <td class="center">{{$record->username}}</td>
        @endif
      </tr>
    @endforeach   
  </table>
  <!--  signature -->
  <table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
          @endforeach
    </tr>
  </table>
  <!-- End signature -->
@endsection