@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'adjustment'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.Member')</label>
                            <v-select label="name" :options="member" v-model="selected_member" @search="onMemberSearch"></v-select>
                            <input type="hidden" name="member_id" :value="(!selected_member)?null:selected_member.id">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.Category')</label>

                            <v-select label="name" :options="category" v-model="selected_category"></v-select>
                            <input type="hidden" name="category_id" :value="(!selected_category)?null:selected_category.id">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.GeneralAdjustmentReport')</label>
                            <select class="form-control" name="general_report">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <!-- BEGIN TAB PORTLET-->

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.Adjustment')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('sales-export')

                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>

                    @endpermission
                    @permission('sales-create')
                    <a href="{{route('adjustment.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="adjustment">
                    <thead>
                    <tr>
                        <th>@lang('layout.ID')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- <div id="factor-obj" >
        @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif
            </div> -->



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#adjustment').DataTable({
                ajax: '{{route("adjustment.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'category', name: 'category',orderable:false,searchable:false},
                    {data: 'dates', name: 'adjustments.date'},
                    {data: 'username', name: 'users.name',orderable:false,searchable:false},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderable:false, searchable:false}

                ]
            });

        });
        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                category: {!! $category  !!},
                selected_category: null,
                member:[],
                selected_member:null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'members',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.member = [];
                            if (response.data.length > 0) {
                                vm.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });


        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>


@endpush
