@extends('layouts.factor-master')
@section('content')

<?php
$report=customeReport('adjustment_detail');
$_item_name=in_array('item_name', $report);
$_site=in_array('site', $report);
$_measure=in_array('measure', $report);
$_quantity=in_array('quantity', $report);
$_currency=in_array('currency', $report);
$_price=in_array('price', $report);
$_total_amount=in_array('total_amount', $report);
?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.GeneralAdjustmentReport')</h3>
<table class="main-table">

  <tr class="bg"> 
  <td><div class="center"> @lang('layout.Record')</div></td>  
  <td><div class="center"> @lang('layout.ReferenceNumber')</div></td>  
  <td><div class="center"> @lang('layout.Date')</div></td>  
  <td><div class="center"> @lang('layout.Description')</div></td>  
  <td><div class="center"> @lang('layout.Type')</div></td>  
  <td><div class="center"> @lang('layout.TypeNumber')</div></td>  
  <td><div class="center"> @lang('layout.MemberName')</div></td>  
  @if($_item_name)<td  class="center">@lang('layout.ItemName')</td>@endif
  @if($_site)<td  class="center">@lang('layout.Site')</td>@endif
  @if(searchByCodeLocation()=="true") <td  class="center">@lang('layout.Location')</td> @endif
  @if(getOtherMeasure()=="true")
  <th>@lang('layout.OMeasureValue1')</th>
  @endif
  @if(getOtherMeasure2()=="true")
  <th>@lang('layout.OMeasureValue2')</th>
  @endif
  @if($_measure)<td  class="center">@lang('layout.MeasureUnit')</td>@endif
  @if($_quantity)<td class="center">@lang('layout.Quantity')</td>@endif
  @if(\Entrust::can('cost-create'))
  @if($_price)<td class="center">@lang('layout.UnitCostAverage')</td>@endif
  @if($_total_amount)<td  class="center">@lang('layout.TotalAmount')</td>@endif
  @endif
  <td  class="center">@lang('layout.User')</td>
</tr>
<?php
$count = 0;
$total=0;
?>
@foreach($data AS $record)
<?php
$total+=$record->purchaseCost*$record->qty;
?>
<tr>
<td class="center">{{++$count}}</td>
<td class="center">{{$record->ref_no}}</td>
<td class="center">{{convertDate($record->date)}}</td>
<td class="center">{{$record->description}}</td>
<td class="center">@if($record->detail_type){{__('layout.'.ucfirst($record->detail_type))}}@endif</td>
<td class="center">{{adjustmentTransactionDetail($record->id)}}</td>
<td class="center">{{$record->member_name}}</td>
@if($_item_name)<td  class="center">{{$record->itemName}}</td>@endif
@if($_site)<td  class="center">{{$record->site}}</td>@endif
@if(searchByCodeLocation()=="true") <td  class="center">{{$record->location}}</td> @endif
@if(getOtherMeasure()=="true")<td  class="center">{{$record->other_measure}}</td>@endif
@if(getOtherMeasure2()=="true")<td  class="center">{{$record->other_measure2}}</td>@endif
@if($_measure)<td  class="center">{{$record->unit}}</td>@endif
@if($_quantity)<td  class="center">{{$record->qty}}</td>@endif
@if(\Entrust::can('cost-create'))
@if($_price)<td  class="center">{{myRound($record->purchaseCost)}}</td>@endif
@if($_total_amount)<td  class="center">{{myRound($record->purchaseCost*$record->qty)}}</td>@endif
@endif
<td  class="center">{{$record->username}}</td>

</tr>
@endforeach
@if(\Entrust::can('cost-create'))
<tr>
  <td class="center">{{++$count}}</td>
  <td class="center" colspan="2">@lang('layout.Total')</td>
  <td class="center" colspan="5">{{myRound($total)}}&nbsp;{{getHomeCurrency()[getCurrencyType()]}}</td>
</tr> 
@endif
</table>


<br>
<hr>
<table class="main-table">
  <tr>
    <td>#</td>
    <td>@lang('layout.ItemName')</td>
    <td>@lang('layout.MeasureUnit')</td>
    <td>@lang('layout.Total')</td>
  </tr>
  <?php
    $count = 0;

  ?>
  @foreach($total_data as $total_record)
  <tr>
    <td>{{++$count}}</td>
    <td>{{$total_record->itemName}}</td>
    <td>{{$total_record->unit}}</td>
    <td>{{$total_record->qty}}</td>
  </tr>
  @endforeach
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection

