@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
    <style>
    </style>
@stop
@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditAdjustment') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                {{Form::model($adjustment,['route' => ['adjustment.update',$adjustment->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                            <p style="color: red" class="text-center">@lang('layout.Note'): @lang('layout.AdjustmentNote')</p>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            {{Form::number('ref_no',null,['class' => 'form-control' ,'step' => 'any','min' =>'0'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date' ,'step' => 'any','min' =>'0','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" v-model="selected_account"
                                                      :options="accounts"></v-select>
                                            <input type="hidden" name="account_id"
                                                   :value="(selected_account)?selected_account.id:null">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <v-select label="name" :options="adjustmentCategory" v-model="selected_adjustment_category"></v-select>
                                            <input type="hidden" name="category_id" :value="(!selected_adjustment_category)?null:selected_adjustment_category.id">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1)) !!}
                                        </div>
                                    </div>
                                </div>
                                @if(systemConfig()[20] == 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.ContractName')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                        v-model="selectedContract" label="company_name"
                                                        @input="contractWagon()" :options="{{$contract}}">
                                                </v-select>
                                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.WagonNumber')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                        v-model="selectedWagon" label="name"
                                                        :options="wagon">
                                                </v-select>
                                                <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12" >
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                <div class="row" style="padding: 10px 20px;">
                                    <div class="dashboard-stat2 ">
                                        <table class="dashboard-tabel" width="100%">
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.Total') :</small>
                                                </td>
                                                <td class="text-right">
                                                    <span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 0px 0px 10px;">
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <v-select label="name" :options="member" v-model="selected_member" @search="onMemberSearch" placeholder="@lang('layout.SelectMember')"></v-select>
                                        <input type="hidden" name="member_id" :value="(!selected_member)?null:selected_member.id">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Type')</label>
                                        <select name="type" v-model="type" class="form-control">
                                            <option value="refund">@lang('layout.Refund')</option>
                                            <option value="purchase">@lang('layout.Purchase')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.TypeNumber')</label>
                                        <input type="number" name="type_number" v-model="type_number" class="form-control">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="margin-top: .5em;">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <br>
                                        <button type="button" class="btn btn-info" @click="searchType">
                                        <i class="fa fa-search"></i>@lang('layout.Search')</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                @if(searchByCodeLocation()=="true")
                                <th style="min-width: 110px;">@lang('layout.Location')</th>
                                @endif
                                @if(getSerailNumber() =="true")
                                <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                @endif
                                <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Westage')</th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue1')
                                </th>
                                <th v-show="showWhat('other_measure2')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue2')
                                </th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th v-show="{{\Entrust::can('cost-create')}}" class="text-center" style="min-width: 40px;"> @lang('layout.UnitCostAverage')</th>
                                <th v-show="{{\Entrust::can('cost-create')}}" class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                                <th style="min-width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td @click="addNew('inventory',index)">@{{index+1}}</td>
                                <td @click="addNew('inventory',index)" v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.inventory" :options="temp_items"
                                        @input="(editKey)?onItemload(index):''" @keyup.native="editKey = true" 
                                        @Click.native="addNew('inventory',index), editKey = true"
                                        @search="onItemSearch"></v-select>
                                    <input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">
                                </td>
                                @if(searchByCodeLocation()=="true")
                                <td class="highlight">
                                    <v-select label="name" @Click.native="addNew('inventory',index)" @input="locationItemload(index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                    <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                </td>
                                @endif
                                @if(getSerailNumber() =="true")
                                <td>
                                    @{{(!item.item)?null:item.item.number}}
                                </td>
                                @endif
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="from_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>

                                <td>
                                    <input type="number" name="quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="other_measure_amount[]"
                                           v-model.number="(item.item==null)?null:item.item.other_measure"
                                           class="form-control input-style input-number" placeholder="@lang('layout.OMeasureValue1')">
                                        <span class="input-group-addon">@{{myRound((item.item==null)?0:((item.item.site==null)?0:item.item.site.other_measure))}}</span> 
                                    </div>
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <div class="input-group">
                                        <input type="number" name="other_measure_amount2[]"
                                           v-model.number="(item.item==null)?null:item.item.other_measure2"
                                           class="form-control input-style input-number" placeholder="@lang('layout.OMeasureValue2')">
                                        <span class="input-group-addon">@{{myRound((item.item==null)?0:((item.item.site==null)?0:item.item.site.other_measure2))}}</span> 
                                    </div>
                                </td>
                                <td>

                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td class="highlight">


                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                :value="measure">
                                          @{{measure.measure_name}}
                                        </option> 
                                      </span>


                                    </select>
                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">


                                </td>

                                <td v-show="{{\Entrust::can('cost-create')}}" >
                                    <div class="input-group">
                                        <input type="number" name="cost[]" placeholder="@lang('layout.UnitCostAverage')"
                                               @click="addNew('inventory',index)"
                                               :value="(item.item==null)?null:((item.item.measure.measure_unit * item.item.cost) / item.item.measure_unit)" ref="in"
                                               @input="setNewRate('inventory',index)" class="form-control" readonly>
                                    </div>

                                </td>
                                <td v-show="{{\Entrust::can('cost-create')}}" >
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(item.item==null)?null:Number.parseFloat(item.item.quantity*((item.item.measure.measure_unit * item.item.cost) / item.item.measure_unit)).toFixed(precision())"
                                               placeholder="@lang('layout.Total')" disabled>

                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
                        <!-- begin service -->

                        <!-- end service -->
                        <hr>
                        <!-- begin payments -->

                        <!-- end payments -->
                    </div>
                    <button v-if="inventories.length <= 0 " type="button" class="btn default"
                            @click="addNew('inventory',0)">@lang('layout.AddItem')
                    </button>

                    <div class="row text-center" style="margin-top: 10px;">
                        <div class="col-lg-12 col-md-12">
                            <button v-if="!isError" type="button" onclick="regForm(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('adjustment.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>


                </div>

                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        var selected_item = {!!$selectedItems!!};
        var inventory_category = {!! $inventory_category !!};
        var accounts = {!! $accounts !!};
        var adjustment = {!! $adjustment !!};
        var adjustmentCategory = {!! $adjustmentCategory !!};
        var adjustmentTransactionDetail= {!! $adjustmentTransactionDetail !!};
        var wagon= {!! $wagon !!};
        var selected_member= {!! $selected_member !!};

        var v = new Vue({
            el: '#appInvoice',
            data: {
                temp_items: [],
                selected_item: selected_item,
                inventory_category: inventory_category,
                selected_index: 0,
                selected_iventory_category: null,
                selectedContract: null,
                editKey: false,
                wagon: wagon,
                wagonAll: wagon,
                selectedWagon: null,
                inventories: [],
                accounts: accounts,
                selected_account: null,
                adjustment: adjustment,
                category:'adjustment',
                adjustmentCategory:adjustmentCategory,
                selected_adjustment_category:null,
                type_number:null,
                type:'refund',
                member:[],
                selected_member:selected_member,
                adjustmentTransactionDetail:adjustmentTransactionDetail

            },
            computed: {

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['cost'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
								sum += quantity*((smeasure_unit * new_rate) / measure_unit);
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit));
                            }

                        }

                    }

                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['price'];
                                if (rate <= 0 && new_rate <= 0) {
                                    // isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
            },
            mounted: function () {
                // initialize the selected item
                if (this.adjustment) {
                    
                    this.category=this.adjustment.category;
                    if(this.adjustment.detail_type !='' && this.adjustment.detail_type !=null)
                    {
                        this.type=this.adjustment.detail_type;
                    }
                    
                    if(this.adjustment.contract_id !='' && this.adjustment.contract_id !=null)
                    {
                        this.selectedContract = _.find({!! $contract !!}, (a) => a.id == this.adjustment.contract_id);
                    }

                    if(this.adjustment.wagon_number !='' && this.adjustment.wagon_number !=null)
                    {
                        this.selectedWagon = _.find({!! $wagon !!}, (a) => a.name == this.adjustment.wagon_number);
                    }
                    
                    for (var i = 0; i < this.selected_item.length; i++) {

                        this.inventories.push({
                            item: this.selected_item[i],
                            inventory: this.selected_item[i],
                            location: this.selected_item[i].selectedLocation,
                            item_category: this.selected_item[i].item_category
                        });
                    }
                    for (var m = 4; m > this.selected_item.length; m--) {
                        this.inventories.push({item: null, location: null});
                    }
                    this.selected_account = _.find(this.accounts, (a) => a.id == this.adjustment.account_id);

                    this.selected_adjustment_category = _.find(this.adjustmentCategory, (a) => a.id == this.adjustment.category_id);

                    if(this.adjustmentTransactionDetail)
                    {
                        this.type_number=this.adjustmentTransactionDetail.type_number;
                    }
                }
            },
            methods:
                {
                     // search items based on type,type_number
                    searchType()
                    {
                        if(this.type && this.type_number)
                        {

                            axios.get("{{route('adjustment.item')}}", {
                                params: {
                                    type: this.type,
                                    type_number: this.type_number,
                                }
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                    v.inventories=[];
                                    for(var i=0;i<response.data.length;i++)
                                    {
                                        v.inventories.push({item:response.data[i], location: null,inventory:response.data[i]});
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                        }
                    },
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.price = this.$refs.in[index].value;
                            }
                        }

                    },
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change

                    //ajax call to get items
                    onMemberSearch(search, loading) {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'anyTable',
                                'search_column': 'name',
                                'table_name': 'members',
                                keyword: search,
                            }
                        })
                        .then(function (response) {
                            v.member = [];
                            if (response.data.length > 0) {
                                v.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                    },

                    // detect member change and searh

                    contractWagon() {
                        this.wagon = this.wagonAll;
                        if (this.selectedContract) {
                            // contract_id = this.inventories[index]['contract'].id;s
                            this.wagon = this.wagonAll.filter((wagon) => {
                                return this.selectedContract.id == wagon.contract_id;
                            });

                        }
                    },

                    // sale order change

                     onItemSearch: _.debounce((search, loading) => {

                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let contract_id = (v.selectedContract != undefined) ? v.selectedContract.id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                contract_id: contract_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let contract_id = (v.selectedContract != undefined) ? v.selectedContract.id : '';
                            let wagon_number = (v.selectedWagon != undefined) ? v.selectedWagon.name : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    v.inventories[index].location = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    // end item search

                    locationSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                        // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                        if (inventory_id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLocation',
                                    keyword: search,
                                    inventory_id: inventory_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['item']['locationList'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        } else {
                            loading(false);
                        }
                    }, getDebounceTime()),

                    locationItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].item != null && v.inventories[index].location != null) {
                            var inventory_id = v.inventories[index].item.id;
                            var location = v.inventories[index].location.name;

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemSiteByLocation',
                                        inventory_id: inventory_id,
                                        location: location
                                    }
                                })
                                .then(function(response) {
                                    // console.log(4444, response.data);
                                    if (response.data.item.length > 0) {
                                        v.inventories[index].item.site_list = response.data.item;
                                        v.inventories[index].item.site = response.data.selectItem;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })
                        }
                    },

                    // contract search

                    //ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                    },

                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                            let contract_id = (v.selectedContract != undefined) ? v.selectedContract.id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },


                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        v.selected_index = index;
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, location: null,inventory:null});
                                }
                            }


                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },
                    // submit the form

                },


        });

    </script>



@endpush