@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('adjustment');
    $_date = in_array('date', $report);
    $_description = in_array('description', $report);
    $_reference_number = in_array('reference_number', $report);
    $_member = in_array('member', $report);
    $_type = in_array('type', $report);
    $_type_number = in_array('type_number', $report);
    $_total_amount = in_array('total_amount', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.AdjustmentReport')</h3>
    @if($from_date || $to_date)
<table class="main-table">
    <tr>
      @if($from_date)
      <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
<br>
@endif
    @if($categories_names)
    <p>
        <span>@lang('layout.Category'):{{$categories_names}}</span>
    </p>
    @endif
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td class="center">
                <div class="center">@lang('layout.ID')</div>
            </td>
            @if($_date)
                <td class="center">@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center">@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center">@lang('layout.ReferenceNumber')</td>@endif
            @if(!$categories_names)
            <td class="center">@lang('layout.Category')</td>
            @endif
            @if($_member)
             <td class="center">@lang('layout.MemberName')</td>@endif
            @if($_type)
             <td class="center">@lang('layout.Type')</td>@endif
            @if($_type_number)
             <td class="center">@lang('layout.TypeNumber')</td>@endif
             @if(\Entrust::can('cost-create'))
            @if($_total_amount)
                <td class="center">@lang('layout.TotalAmount')</td>@endif
            @endif
            <td class="center">@lang('layout.User')</td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total=0;
        ?>
        @foreach($data AS $record)
        <?php
        $total+=$record->total;
        ?>
            <tr>
                <!-- <td class="center">{{++$count}}</td> -->
                <td class="center">{{$record->id}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if(!$categories_names)
                <td class="center">{{$record->category}}</td>
                @endif
                @if($_member)
                    <td class="center">{{$record->member_name}}</td>@endif
                @if($_type)
                    <td class="center">
                        @if(ucfirst($record->detail_type))
                        {{__('layout.'.ucfirst($record->detail_type))}}
                        @else

                        @endif
                    
                    </td>@endif
                @if($_type_number)
                    <td class="center">{{adjustmentTransactionDetail($record->id)}}</td>@endif
                    @if(\Entrust::can('cost-create'))
                @if($_total_amount)
                    <td class="center">{{$record->total}}</td>@endif
                    @endif
                    <td class="center">{{$record->username}}</td>
            </tr>
        @endforeach
    </table>
    <p>@lang('layout.Total'): {{$total}}  {{getHomeCurrency()[getCurrencyType()]}}  </p>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection