@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReportNew('adjustmentAndItemNoneCostReport_index');
    $_record  = !in_array('record', $report);
    $_id  = !in_array('id', $report);
    $_date  = !in_array('date', $report);
    $_description  = !in_array('description', $report);
    $_reference_number  = !in_array('reference_number', $report);
    $_category  = !in_array('category', $report);
    $_total_amount  = !in_array('total_amount', $report);
    $_user  = !in_array('user', $report);
    $_itemNoneCost  = !in_array('itemNoneCost', $report);
    

    $report_percent = customeReportNewPercent('adjustmentAndItemNoneCostReport_index');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_id_percent= (array_key_exists('id___percent', $report_percent))?$report_percent['id___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_category_percent= (array_key_exists('category___percent', $report_percent))?$report_percent['category___percent']:null;
    $_total_amount_percent= (array_key_exists('total_amount___percent', $report_percent))?$report_percent['total_amount___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_itemNoneCost_percent= (array_key_exists('itemNoneCost___percent', $report_percent))?$report_percent['itemNoneCost___percent']:null;
     

    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.AdjustmentAndItemNoneCostReport')</h3>

    <table class="main-table">
        <thead>
        <tr class="bg">
            @if($_id)
            <td class="center" @if($_id_percent) width="{{$_id_percent}}%" @endif>
                <div >@lang('layout.ID')</div>
            </td>
            @endif
            @if($_date)
                <td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center" @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif>@lang('layout.ReferenceNumber')</td>@endif
            @if($_category)
             <td class="center" @if($_category_percent) width="{{$_category_percent}}%" @endif>@lang('layout.Category')</td>@endif
             @if(\Entrust::can('cost-create'))
            @if($_total_amount)
            <td class="center" @if($_total_amount_percent) width="{{$_total_amount_percent}}%" @endif>@lang('layout.TotalAmount')</td>@endif
            @endif
            @if($_user)
            <td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</td>
            @endif
        </tr>
        </thead>
        <?php
        $count = 0;
        $totalAdj=0;
        ?>
        @foreach($dataAdjustment AS $record)
        <?php
        $totalAdj+=$record->total;
        ?>
            <tr>
                @if($_id)
                <td class="center">{{$record->id}}</td>
                @endif
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if($_category)
                    <td class="center">{{$record->category}}</td>@endif
                    @if(\Entrust::can('cost-create'))
                @if($_total_amount)
                    <td class="center">{{ myRound($record->total) }}  {{getHomeCurrency()[getCurrencyType()]}}   </td>@endif
                    @endif
                    @if($_user)
                    <td class="center">{{$record->username}}</td>
                    @endif
            </tr>
        @endforeach
    </table>
    <p>@lang('layout.Total'): {{myRound($totalAdj)}}  {{getHomeCurrency()[getCurrencyType()]}}    </p>

    @if($_itemNoneCost)
    <h3 class="table-caption" style="text-align: center;">@lang('layout.ItemNoneCostReport')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            @if($_record)
            <td class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif>
                <div >@lang('layout.Record')</div>
            </td>@endif
            @if($_id)
            <td class="center" @if($_id_percent) width="{{$_id_percent}}%" @endif>
                <div >@lang('layout.ID')</div>
            </td>@endif
            @if($_date)
                <td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center" style="@if($_description_percent) text-align: justify @endif" @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center" @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif>@lang('layout.ReferenceNumber')</td>@endif
            @if($_category)
             <td class="center" @if($_category_percent) width="{{$_category_percent}}%" @endif>@lang('layout.Category')</td>@endif
             @if(\Entrust::can('cost-create'))
             @if($_total_amount)
             <td class="center" @if($_total_amount_percent) width="{{$_total_amount_percent}}%" @endif>@lang('layout.TotalAmount')</td>
             @endif
             @endif
             @if($_user)
             <td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</td>
            @endif
            </tr>
        </thead>
        <?php
        $count = 0;
        $totalNon = 0;
        ?>
        @foreach($dataNoneCost AS $record)
            <?php
            $totalNon+=$record->total;
            ?>
            <tr>
                @if($_record)
                <td class="center">{{++$count}}</td>@endif
                @if($_id)
                <td class="center">{{$record->id}}</td>@endif
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if($_category)
                    <td class="center">{{$record->category}}</td>@endif
                    @if(\Entrust::can('cost-create'))
                    @if($_total_amount)
                    <td class="center">{{ myRound($record->total) }}  {{getHomeCurrency()[getCurrencyType()]}}  </td>
                    @endif
                    @endif
                     @if($_user)
                    <td class="center">{{$record->user}}</td>
                    @endif
               
            </tr>
        @endforeach
    </table>
    <p>@lang('layout.Total'): {{myRound($totalNon)}}  {{getHomeCurrency()[getCurrencyType()]}}</p>
    @endif
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection