@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AddToCodeDetail')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>   
                            <i class="fa  fa-bars"></i> @lang('layout.Number')
                        </th> 
                         <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                         <th>
                            <i class="fa fa-currency"></i> @lang('layout.Amount')
                        </th>
                         <th>
                            <i class="fa fa-currency"></i> @lang('layout.Currency')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Description')
                        </th>
                    </tr> 
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $addStock->number }}  </td>
                        <td class="hidden-xs"> {{ $addStock->date }}  </td>
                        <td class="hidden-xs"> {{ $addStock->amount }}  </td>
                        <td class="hidden-xs"> {{ $addStock->unit }}  </td>
                        <td class="hidden-xs"> {{ $addStock->description }}  </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.AddToCodeDetail')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="add_stock_details"/>
                           <input type="hidden" name="id" value="{{$addStock->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="add_stock_details"/>
                           <input type="hidden" name="id" value="{{$addStock->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Code')</th>
                            @if(getOtherMeasure()=="true")
                            <th>@lang('layout.OMeasureValue') 1</th>
                            <th>@lang('layout.OMeasureValue') 2</th>
                            @endif
                            <th>@lang('layout.MeasureUnit')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Total')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div> 
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
        $('#sales').DataTable({
            ajax:'{{route("add_stock_code.show",$addStock->id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                { data: 'item', name: 'items.name' },
                { data: 'code', name: 'code' },
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure', orderable:false,searchable:false },
                { data: 'other_measure2', name: 'other_measure2', orderable:false,searchable:false },
                @endif
                { data: 'measure', name: 'measure_units.measure' },
                { data: 'quantity', name: 'add_stock_details.quantity' },
                { data: 'unit', name: 'transactions.unit' },
                { data: 'amount', name: 'transactions.amount' },
        ]
        });

    });
</script>


@endpush 