@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")

<div class="row">

  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="icon-equalizer font-green-haze"></i>
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddToCodeEdit') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
        <a href="" class="collapse" data-original-title="" title=""> </a>
        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        <a href="" class="reload" data-original-title="" title=""> </a>
        <a href="" class="remove" data-original-title="" title=""> </a>
      </div>
    </div>



    <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
      <!-- begin sale order modal -->

      <!-- end sale order modal -->

      <!-- BEGIN FORM-->
      {{Form::model($addStock,['route' => ['add_stock_code.update',$addStock->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
      <div class="form-body">
        <div class="row">
          <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
            <!-- begin inputs -->
            <div class="row">
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Number')</label>
                    {{Form::number('number',null,['class' => 'form-control' ,'step' => 'any','min' =>'0'])}}
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Date')</label>
                    {{Form::text('date',null,['class' => 'form-control date' ,'step' => 'any','min' =>'0','autocomplete'=>'off'])}}
                  </div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-lg-8 col-md-9 col-sm-12 col-xs-12">
                <div class="form-group">
                  <div class="col-md-12">
                    <label class="control-label">@lang('layout.Description')</label>
                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1)) !!}
                  </div>
                </div>
              </div>
            </div>
            <!-- end inputs -->
          </div>
          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
            <!-- begin total -->
            <div class="dashboard-stat2 ">
              <table class="dashboard-tabel" width="100%">
                <tr>
                  <td>
                    <small>@lang('layout.Total') :</small>
                  </td>
                  <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                  </td>
                </tr>
              </table>
            </div>
          </div>
        </div>


        <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
          <table id="table_content" class="table table-bordered table-responsive table-full-width .met">
            <thead>
              <tr>
                <th class="text-center" style="min-width: 8px;"> # </th>
                <th class="text-center" style="min-width: 150px;"> @lang('layout.ItemName')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.Measure')</th>
                <th class="text-center" style="min-width: 60px;"> @lang('layout.Quantity')</th>
                <!-- <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.Length')</th> -->
                <th class="text-center hidden-print" style="min-width: 80px;"> @lang('layout.OnHand')</th>
                <th class="text-center" style="min-width: 80px;"> @lang('layout.Width')</th>
                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue') 1</th>
                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue') 2</th>
                <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                <th class="text-center" style="width: 10px;"></th>
              </tr>
            </thead>
            <tbody>
              <!--/row-->
              <tr v-for="(service,index) in inventories">
                <td>@{{index+1}}</td>
                <td>
                  <v-select label="name" v-model="service.item" :options="temp_items" @search="onItemSearchFormila" @click.native="addNew('inventory',index)" placeholder="@lang('layout.Code')" style=""></v-select>
                  <input type="hidden" id="item_id" name="m_stocks_in_id[]" :value="(!service.item)?null:service.item.id">
                  <input type="hidden" name="inventory_id[]" :value="(!service.item)?null:service.item.inventory_id">
                </td>

                <td>
                  <input :value="(!service.item)?null:service.item.Measure" class="form-control" placeholder="@lang('layout.Measure')">
                </td>
                <td>
                  <input name="quantity[]" id="item_quantity" ref="OnHand1" type="number" @input="change_qut(index)" :value="(!service.item)?null:service.item.OnHand1" class="form-control" placeholder="@lang('layout.Quantity')">
                </td>
                <!-- <td>
                  <input name="lengths_out" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.item)?null:service.item.lengths" class="form-control" placeholder="@lang('layout.Length')">
                </td> -->

                <td>
                  <input type="number" name="quantityall[]" :value="(!service.item)?null:service.item.OnHand" placeholder="@lang('layout.OnHand')" class='form-control'readonly />
                </td>
                <td>
                  <input type="number" name="width[]" class="form-control" v-model="(!service.item)?null:service.item.width" placeholder="@lang('layout.Width')">
                </td>
                <td v-show="showWhat('other_measure')=='yes'">
                  <input type="number" name="other_measure[]" v-model="(!service.item)?null:service.item.o_measure"
                        class="form-control input-style input-number " placeholder="@lang('layout.OMeasureValue') 1" >
                </td>
                <td v-show="showWhat('other_measure')=='yes'">
                  <input type="number" name="other_measure2[]" v-model="(!service.item)?null:service.item.o_measure2"
                        class="form-control input-style input-number " placeholder="@lang('layout.OMeasureValue') 2" >
                </td>
                <td>
                  <input name="cost[]" type="number" :value="(!service.item)?null:service.item.cost" ref="cost" @input="setNewRate(index)" class="form-control" placeholder="@lang('layout.Price')" readonly />
                </td>

                <td>
                  <input type="number" class="form-control inner_input" :value="(service.item==null)?null:(service.item.cost)*((service.item==null)?null:service.item.OnHand1)" placeholder="@lang('layout.Total')" disabled>
                </td>
                <td>
                  <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                </td>

              </tr>

            </tbody>
          </table>

          <hr>
          <!-- begin service -->

          <!-- end service -->
          <hr>
          <!-- begin payments -->

          <!-- end payments -->
        </div>
        <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addItems('addStock')">@lang('layout.AddItem')
        </button>
        <div class="row">
          <div class="col-md-offset-3 col-md-9">
            <button v-if="!isError" type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
            <a href="{{route('add_stock_code.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

          </div>
        </div>


      </div>

      {!! Form::close() !!}

    </div>
    <!-- END FORM-->
  </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
  Vue.component('v-select', VueSelect.VueSelect);

  var selected_item = {!!$selectedItems!!};
  var addStock = {!!$addStock!!};

  // end new member

  var v = new Vue({
    el: '#appInvoice',
    data: {
      temp_items: [],
      addStock: addStock,
      selected_account: null,
      selected_item: selected_item,
      newCost: [
        null,
        null,
        null,
        null
      ],
      inventories: [],

    },
    computed: {


      // calculate subtotal
      subtotal: function() {
        var sum = 0;
        for (var i = 0; i < this.inventories.length; i++) {
          if (this.inventories[i].item && this.inventories[i].item != null) {
            var quantity = this.inventories[i]['item']['OnHand1'];
            var rate = this.inventories[i]['item']['cost'];
            var new_rate = this.inventories[i]['item']['cost'];
            // var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
            // var measure_unit=this.inventories[i]['item']['measure_unit'];
            if (new_rate != rate && quantity > 0) {
              sum += new_rate * quantity;
            } else {
              sum += new_rate * quantity;
              // sum +=quantity*((rate*smeasure_unit/measure_unit));
            }

          }

        }
        return sum;
      },

      // check payed amount

      // check data validation
      isError: function() {
        var isError = false;
        var flag = false;
        for (var i = 0; i < this.inventories.length; i++) {

          if (this.inventories[i].item) {
            flag = true;
            if (((this.inventories[i]['item']['cost'] <= 0))) {
              rate = this.inventories[i]['item']['cost'];
              new_rate = this.inventories[i]['item']['cost'];
              @if(getAddItemWithZeroRate() != 'true')
              if (rate <= 0 && new_rate <= 0) {
                isError = true;
              }
              @endif
            }
          }
        }
        if (this.inventories.length == 0 || flag == false) {
          isError = true;
        }
        return isError;
      },
    },

    mounted: function() {
      // initialize the selected item
      for (var i = 0; i < this.selected_item.length; i++) {
        console.log('ssssssss', this.selected_item[i]);
        this.inventories.push({
          item: this.selected_item[i]
        });

      }
      for (var m = 4; m > this.selected_item.length; m--) {
        this.inventories.push({
          item: null
        });
      }


    },

    methods: {
      // set new price
      setNewRate(index) {
        if (this.inventories[index].item) {
          this.inventories[index].item.cost = this.$refs.cost[index].value;
          // this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          this.inventories[index].item.OnHand1 = this.$refs.OnHand1[index].value;

        }

      },
      // calculate item price based on measure change
      measureChange(index) {

        if (this.inventories[index].item != null) {
          var item = this.inventories[index].item;

          var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
          result = Number.parseFloat(temp).toFixed(precision());

          this.inventories[index].item.new_rate = result;

          // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

        }
      },

      change_lengths(index) {
        if (this.inventories[index].item) {
          var per_qut_in = this.inventories[index].item.per_qut_in;
          var lengths = this.$refs.lengths[index].value;
          this.inventories[index].item.lengths = this.$refs.lengths[index].value;
          // this.inventories[index].item.OnHand = (per_qut_in * lengths).toFixed(1);
        }
        // setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
      change_qut(index) {

        if (this.inventories[index].item) {
          var per_qut_in = this.inventories[index].item.per_qut_in;
          console.log('dd', per_qut_in);
          var OnHand = this.$refs.OnHand1[index].value;
          this.inventories[index].item.OnHand1 = this.$refs.OnHand1[index].value;
          // this.inventories[index].item.lengths = (OnHand / per_qut_in).toFixed(1);
        }

        // setTimeout(function(){ sales.deleteItem_roll(100); }, 30);
      },
      // calculate item price based on measure change

      // detect member change and searh



      //ajax call to get items
      onItemSearch: _.debounce((search, loading) => {
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'itemSearchSale',
              keyword: search,
            }
          })
          .then(function(response) {
            v.temp_items = [];
            if (response.data.length > 0) {
              v.temp_items = response.data;
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),

      addItems(type) {
        if (type != null) {
          if (type == "addStock") {
            this.temp_items = [];
            this.inventories.push({
              item: null
            });
          }

        }

      },

      // end item search

      // contract search


      //ajax call to get items code
      onItemSearchFormila: _.debounce((search, loading) => {
        item_id = '';
        loading(true);
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'getAssebmliesSubSite',
              keyword: search,
              item_id: item_id,
              onhand:'no'
            }
          })
          .then(function(response) {
            v.temp_items = [];
            if (response.data.length > 0) {
              v.temp_items = response.data;
              console.log('temp_items', v.temp_items);
            }
            loading(false);
          })
          .catch(function(error) {
            console.log(error);
          });
      }, getDebounceTime()),

      // end contract search

      // generic function for adding item to list
      addNew(type = null, index) {
        this.temp_items = [];
        if (type != null) {
          if (type == 'inventory') {
            if (this.inventories[index + 1] == undefined) {
              this.temp_items = [];
              this.inventories.push({
                item: null
              });
            }
          }


        }

      },

      // in here you can check and decide to allow duplicate bank for payment or not


      // delete item from list
      deleteItem(type = null, index) {
        if (type != null) {
          console.log(type);
          if (type == 'inventory') {
            this.inventories.splice(index, 1);
          }

        }

      },
      // submit the form

    },


  });
</script>



@endpush