
@extends('layouts.factor-master')
@section('content')

<h3></h3>

<table style="width: 100%; margin-bottom: 10px;">
  @if($info && $info !=[])

  <tr>
    <td>
      <span>@lang('layout.Number')</span>:
      <span>{{$info->number}}</span>
    </td>
    <td>
      <span>@lang('layout.Date')</span>:
      <span>{{convertDate($info->date)}}</span>
    </td>
    <td>
      <span>@lang('layout.Amount')</span>:
      <span>{{$info->amount}}</span>
    </td>
    <td>
      <span>@lang('layout.Description')</span>:
      <span>{{$info->description}}</span>
    </td>
  </tr>

  @endif
</table>

<table class="main-table">
  <thead>
    <tr class="bg">
      <td> @lang('layout.Record') </td>
      <th>@lang('layout.ItemName')</th>
      <th>@lang('layout.Code')</th>
      @if(getOtherMeasure()=="true")
      <th>@lang('layout.OMeasureValue') 1</th>
      <th>@lang('layout.OMeasureValue') 2</th>
      @endif
      <th>@lang('layout.MeasureUnit')</th>
      <th>@lang('layout.Quantity')</th>
      <th>@lang('layout.Currency')</th>
      <th>@lang('layout.Total')</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 0;
    $total = 0;
    ?>
    @foreach($data AS $record)
    <?php
    // $total+=$record->cost*$record->quantity;
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$record->item}}</td>
      <td class="center">{{$record->code}}</td>
      @if(getOtherMeasure()=="true")
      <td class="center">{{$record->other_measure}}</td>
      <td class="center">{{$record->other_measure2}}</td>
      @endif
      <td class="center">{{$record->measure}}</td>
      <td class="center">{{$record->quantity}}</td>
      <td class="center">{{getHomeCurrency()['code']}}</td>
      <td class="center">{{$record->amount}}</td>
    </tr>
    @endforeach
  </tbody>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->

@endsection